<?php 
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/
use \Workerman\Worker;
use \GatewayWorker\Gateway;
use \Workerman\Autoloader;
use app\common\model\bbfxshop\Chat;

require_once __DIR__ . '/../../vendor/autoload.php';

$set = Chat::getSet();
$context = [];
if(!empty($set['ssl_cert']) && !empty($set['ssl_certkey'])){
    $context = [
        'ssl'=>[
            'local_cert'        => ROOT_PATH.'public'.$set['ssl_cert'], // SSL证书文件（也可以是.crt文件）
            'local_pk'          => ROOT_PATH.'public'.$set['ssl_certkey'],   // 私钥文件
            'verify_peer'       => false,           // 关闭对等验证
            'allow_self_signed' => true,            // 允许自签名证书
        ]
    ];
}


$ip = gethostbyname(gethostname());
$socket = "websocket://".$ip.":".$set['port'];

// gateway 进程
$gateway = new Gateway($socket,$context);

if(!empty($context)){
    $gateway->transport = 'ssl';
}

// 设置名称，方便status时查看（多个站点开启需修改）
$gateway->name = 'BaiBianFenXiao';
// 设置进程数，一般两个进程就足够
$gateway->count = 2; 
// 分布式部署时请设置成内网ip（非127.0.0.1）
$gateway->lanIp = '127.0.0.1';
// 内部通讯起始端口。假如$gateway->count=2，起始端口为2300
// 则一般会使用2300 2301 2个端口作为内部通讯端口（多个站点开启需修改端口为2303及以上端口）
$gateway->startPort = 2300;
// 心跳间隔
$gateway->pingInterval = 10;
// 心跳数据
$gateway->pingData = '{"type":"ping"}';
// 服务注册地址（多个站点开启需修改端口）
$gateway->registerAddress = '127.0.0.1:1236';

/* 
// 当客户端连接上来时，设置连接的onWebSocketConnect，即在websocket握手时的回调
$gateway->onConnect = function($connection)
{
    $connection->onWebSocketConnect = function($connection , $http_header)
    {
        // 可以在这里判断连接来源是否合法，不合法就关掉连接
        // $_SERVER['HTTP_ORIGIN']标识来自哪个站点的页面发起的websocket链接
        if($_SERVER['HTTP_ORIGIN'] != 'http://chat.workerman.net')
        {
            $connection->close();
        }
        // onWebSocketConnect 里面$_GET $_SERVER是可用的
        // var_dump($_GET, $_SERVER);
    };
}; 
*/

// 如果不是在根目录启动，则运行runAll方法
if(!defined('GLOBAL_START'))
{
    Worker::runAll();
}

