<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\common\model\bbfxshop;
use think\Db;
use Ratchet\Client\Connector;
use React\EventLoop\Loop;
use React\Socket\Connector as SocketConnector;
use app\common\model\bbfxshop\AliyunOss;
use app\common\model\bbfxshop\User;

class Shuziren
{

    public static function getSet(){
        global $_W;
        $base = $_W['base'];
        if(empty($base)){
            $base = \app\common\model\bbfxshop\Common::getConfig(true);
        }

        return $base['shuziren'];
    }

    // 生成数字人视频
    public function create($user_id,$title,$text,$video_id,$voice_id){
        $config = self::getSet();

        if($config['status'] != 1){
            return __json(0,'未开启功能');
        }

        if(empty($text)){
            return __json(0,'文字内容不能为空');
        }
        if(mb_strlen($text, "utf8") > 1000){
            return __json(0,'最多1000字内容');
        }

        $user = User::getInfo($user_id);
        if(empty($user)){
            return __json(0,'用户信息错误');
        }
        if(!empty($config['levels'])){
            if(!in_array($user['level'],$config['levels']) || $user['is_distributor'] != 1 || $user['distributor_status'] != 1){
                return __json(0,'您无权限是用该功能！');
            }
        }

        $video_tpl = Db::name("bbfx_shuziren_video_tpl")->where(['id'=>$video_id,'user_id'=>$user_id])->find();
        if(empty($video_tpl) || empty($video_tpl['url'])){
            return __json(0,'视频内容不能为空');
        }

        $voice = Db::name("bbfx_shuziren_voice")->where(['id'=>$voice_id,'user_id'=>$user_id])->find();
        if(empty($voice) || empty($voice['voice_id'])){
            return __json(0,'音色ID不能为空');
        }


        $video_url = cdnurl($video_tpl['url']);

        $result = $this->createTextVoice($user_id,$voice['voice_id'],$text);
        if($result['code'] != 1){
            return $result;
        }

        $audio_url = cdnurl($result['data']['url']);

        $url = 'https://dashscope.aliyuncs.com/api/v1/services/aigc/image2video/video-synthesis/';
        $header = [
            'Authorization: Bearer '.$config['apikey'],
            'Content-Type: application/json',
            'X-DashScope-Async: enable'
        ];
        $data = [
            "model"=> $config['model'],
            "input"=> [
                "video_url"=> $video_url,
                "audio_url"=> $audio_url,
                "ref_image_url"=> ""
            ],
            "parameters"=> [
                "video_extension"=> true
            ]
        ];

        file_put_contents("szr222.txt",json_encode($data));

        $res = $this->request($url,'POST',$data,$header);

        file_put_contents("szr111.txt",json_encode($res));

        if(empty($res["output"]["task_id"])){
            $message = $res['message'];
            if(empty($message)){
                $message = '数字人生成失败';
            }
            return __json(0,$message);
        }

        $data = [
            'uniacid'=>UNIACID,
            'user_id'=>$user_id,
            'voice_id'=>$voice['id'],
            'video_id'=>$video_tpl['id'],
            'original_video'=>replaceSiteroot($video_url),
            'voice_url'=>replaceSiteroot($audio_url),
            'title'=>$title,
            'text'=>$text,
            'url'=>'',
            'task_id'=>$res["output"]["task_id"],
            'status'=>'PENDING',
            'createtime'=>time()
        ];

        Db::name("bbfx_shuziren_video")->insert($data);

        return __json(1,"视频生成中，请稍后");
    }

    public static function task(){
        $config = self::getSet();
        if($config['status'] != 1){
            return __json(0,'未开启功能');
        }

        $list = Db::name("bbfx_shuziren_video")->where(['uniacid'=>UNIACID,'status'=>['in',['PENDING','PRE-PROCESSING','RUNNING','POST-PROCESSING']]])->select();
        
        if(!empty($list)){

            $instance = new self();
            foreach ($list as $key => $value) {
                $result = $instance->getTaskInfo($value['task_id'],$config['apikey']);
                file_put_contents("szrtask111.txt",json_encode($result));
                if($result['data']['task_status'] != $value['status']){
                    $data = ['status'=> $result['data']['task_status']];
                    if($data['status'] == 'SUCCEEDED' || $data['status'] == 'FAILED' || $data['status'] == 'UNKNOWN'){
                        $data['completetime'] = time();
                    }
                    if($data['status'] == 'SUCCEEDED'){
                        $video_url = $result['data']['video_url'];
                        $videoData = file_get_contents($video_url);
                        $suffix = substr(strrchr($video_url,'.'),1);
                        $suffix = explode("?",$suffix)[0];
                        $filename = "/ai/video_".$value['id'].".".$suffix;
                        file_put_contents(ROOT_PATH."public".$filename, $videoData);

                        $data["url"] = $filename;

                        $result = AliyunOss::upload($data['url']);
                        if($result['code'] == 1){
                            $data["url"] = $result['data']['url'];
                        }
                    }
                    Db::name("bbfx_shuziren_video")->where(['id'=> $value['id']])->update($data);
                }
            }

        }
        
        return __json(1,'操作成功');
    }

    // 查询数字人视频列表
    public function getVideoList($user_id){
        $config = self::getSet();
        $list = Db::name("bbfx_shuziren_video")->where(['uniacid'=>UNIACID,'user_id'=>$user_id])->order("id desc")->select();

        $status_list = ['PENDING'=>'排队中','PRE-PROCESSING'=>'前置处理中','RUNNING'=>'处理中','POST-PROCESSING'=>'后置处理中','SUCCEEDED'=>'成功','FAILED'=>'失败','UNKNOWN'=>'作业不存在或状态未知'];

        foreach ($list as $key => &$value) {
            $value['url'] = cdnurl($value['url']);
            $value['status_text'] = $status_list[$value['status']];
            $value['createtime'] = date("Y-m-d H:i:s",$value['createtime']);
        }
        unset($value);
        
        return __json(1,'操作成功',['list'=>$list]);
    }
 

    // 创建音色
    public function createVoice($user_id,$voice_url,$title){

        $config = self::getSet();
        if($config['status'] != 1){
            return __json(0,"未开启功能");
        }
        $api_key = $config['apikey'];
        $voice_url = cdnurl($voice_url);
        if(empty($voice_url)){
            return __json(0,"音色文件不能为空");
        }
        if(!strstr($voice_url, '.mp3')){
            return __json(0,"请上传mp3格式音色文件");
        }
        if(empty($title)){
            return __json(0,"标题不能为空");
        }
        $url = "https://dashscope.aliyuncs.com/api/v1/services/audio/tts/customization";
        $headers = [
            'Authorization: Bearer '.$api_key,
            'Content-Type: application/json'
        ];

        $data = [
            "model"=> "voice-enrollment",
            "input"=> [
                "action"=> "create_voice",
                "target_model"=> "cosyvoice-v2",
                "prefix"=> "mp3",
                "url"=> $voice_url
            ]
        ];

        $result = $this->request($url,"POST",$data,$headers);
        if(!empty($result['output']['voice_id'])){

            $data = [
                'uniacid'=> UNIACID,
                'user_id'=>$user_id,
                'title'=>$title,
                'url'=>replaceSiteroot($voice_url),
                'voice_id'=>$result['output']['voice_id'],
                'apikey'=>md5($api_key),
                'status'=>'DEPLOYING',
                'createtime'=>time()
            ];

            Db::name("bbfx_shuziren_voice")->insert($data);

            return __json(1,"音色创建成功");
        }
        else{
            return __json(0,"音色创建失败");
        }
    }

    // 删除音色
    public function deleteVoice($id,$user_id=0){
        $config = self::getSet();
        $api_key = $config['apikey'];
        $where = ["id"=>$id,'apikey'=>md5($api_key)];
        if(!empty($user_id)){
            $where['user_id'] = $user_id;
        }
        $item = Db::name("bbfx_shuziren_voice")->where($where)->find();
        if(empty($item)){
            return __json(0,'音色数据不存在');
        }

        $url = "https://dashscope.aliyuncs.com/api/v1/services/audio/tts/customization";
        $headers = [
            'Authorization: Bearer '.$api_key,
            'Content-Type: application/json'
        ];

        $data = [
            "model"=> "voice-enrollment",
            "input"=> [
                "action"=> "delete_voice",
                "voice_id"=> $item['voice_id']
            ]
        ];

        $result = $this->request($url,"POST",$data,$headers);
        if(!empty($result['usage'])){
            
            Db::name("bbfx_shuziren_voice")->where(['id'=>$item['id']])->delete();

            return __json(1,'删除成功');
        }
        else{
            return __json(0,'删除失败');
        }
    }

    // 获取可用音色列表
    public function getVoiceList($user_id){
        $config = self::getSet();
        $api_key = $config['apikey'];
        $all = Db::name("bbfx_shuziren_voice")->where(["user_id"=>$user_id,'apikey'=>md5($api_key)])->order("id desc")->select();
        $list = [];
        foreach ($all as $key => $value) {
            $value['url'] = cdnurl($value['url']);
            if($value["status"] == 'OK'){
                // $list[] = $value;
            }
            else if($value['status'] == 'DEPLOYING'){
                $result = $this->queryVoice($value['voice_id'],$api_key);
                if(!empty($result['data']['status'])){
                    Db::name("bbfx_shuziren_voice")->where(['id'=>$value['id']])->update(['status'=>$result['data']['status']]);
                    if($result['data']['status'] == 'OK'){
                        $value['status'] = $result['data']['status'];
                        // $list[] = $value;
                    }
                }
            }
            $value['createtime'] = date("Y-m-d H:i:s",$value['createtime']);
            $list[] = $value;
        }

        return __json(1,'操作成功',['list'=>$list]);
    }

    // 查询指定音色
    public function queryVoice($voice_id,$api_key){
        $url = "https://dashscope.aliyuncs.com/api/v1/services/audio/tts/customization";
        $headers = [
            'Authorization: Bearer '.$api_key,
            'Content-Type: application/json'
        ];

        $data = [
            "model"=> "voice-enrollment",
            "input"=> [
                "action"=> "query_voice",
                "voice_id"=> $voice_id
            ]
        ];

        $result = $this->request($url,"POST",$data,$headers);
        if(!empty($result['output'])){
            return __json(1,'查询成功',['status'=>$result['output']['status']]);
        }
        else{
            return __json(0,'查询失败');
        }
    }

    // 根据文字生成语音
    public function createTextVoice($user_id,$voice_id,$text){
        $config = self::getSet();

        require ROOT_PATH.'extend/React/Promise/functions.php';

        $api_key = $config['apikey'];
        $websocket_url = 'wss://dashscope.aliyuncs.com/api-ws/v1/inference/'; // WebSocket服务器地址
        $filename = '/ai/voice_'.$user_id.'_'.time().'.mp3';
        $output_file = ROOT_PATH."public".$filename; // 输出文件路径
        // return __json(1,"操作成功",['url'=>'/ai/voice_83_1754639964.mp3']);
        if(!is_dir(ROOT_PATH."public/ai")) {
            mkdir(ROOT_PATH."public/ai");
        }

        $loop = Loop::get();

        if (file_exists($output_file)) {
            // 清空文件内容
            file_put_contents($output_file, '');
        }

        try {
            // 创建自定义的连接器
            $socketConnector = new SocketConnector($loop, [
                'tcp' => [
                    'bindto' => '0.0.0.0:0',
                ],
                'tls' => [
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                ],
            ]);

            $connector = new Connector($loop, $socketConnector);

            $headers = [
                'Authorization' => 'bearer ' . $api_key,
                'X-DashScope-DataInspection' => 'enable'
            ];

            $connector($websocket_url, [], $headers)->then(function ($conn) use ($loop,$text, $output_file,$voice_id) {
                // echo "连接到WebSocket服务器\n";

                // 生成任务ID
                $taskId = $this->generateVoiceTaskId();

                // 发送 run-task 指令
                $this->sendVoiceRunTaskMessage($conn, $taskId,$voice_id);

                // 定义发送 continue-task 指令的函数
                $sendContinueTask = function() use ($conn, $loop, $taskId,$text) {
                    // 待发送的文本
                    $texts = $this->getVoiceTexts($text);
                    // $texts = ["床前明月光", "疑是地上霜", "举头望明月", "低头思故乡"];
                    $continueTaskCount = 0;
                    foreach ($texts as $text) {
                        $continueTaskMessage = json_encode([
                            "header" => [
                                "action" => "continue-task",
                                "task_id" => $taskId,
                                "streaming" => "duplex"
                            ],
                            "payload" => [
                                "input" => [
                                    "text" => $text
                                ]
                            ]
                        ]);
                        // echo "准备发送continue-task指令: " . $continueTaskMessage . "\n";
                        $conn->send($continueTaskMessage);
                        $continueTaskCount++;
                    }
                    // echo "发送的continue-task指令个数为：" . $continueTaskCount . "\n";

                    // 发送 finish-task 指令
                    $this->sendVoiceFinishTaskMessage($conn, $taskId);
                };

                // 标记是否收到 task-started 事件
                $taskStarted = false;

                // 监听消息
                $conn->on('message', function($msg) use ($conn, $sendContinueTask, $loop, &$taskStarted, $taskId, $output_file) {
                    
                    if ($msg->isBinary()) {
                        file_put_contents("zl222.txt",$msg->getPayload());
                        // 写入二进制数据到本地文件
                        file_put_contents($output_file, $msg->getPayload(), FILE_APPEND);
                    } else {
                        // 处理非二进制消息
                        $response = json_decode($msg, true);

                        if (isset($response['header']['event'])) {
                            $this->handleVoiceEvent($conn, $response, $sendContinueTask, $loop, $taskId, $taskStarted);
                        } else {
                            // echo "未知的消息格式\n";
                        }
                    }
                });

                // 监听连接关闭
                $conn->on('close', function($code = null, $reason = null) {
                    // echo "连接已关闭\n";
                    if ($code !== null) {
                        // echo "关闭代码: " . $code . "\n";
                        // throw new \Exception("连接已关闭，关闭代码: ".$code);
                    }
                    if ($reason !== null) {
                        // echo "关闭原因：" . $reason . "\n";
                        // throw new \Exception("连接已关闭，关闭原因：".$reason);
                    }
                });
            }, function ($e) {
                // echo "无法连接：{$e->getMessage()}\n";
                throw new \Exception($e->getMessage());
            });

            $loop->run();

            $result = AliyunOss::upload($filename);
            if($result['code'] == 1){
                $filename = $result['data']['url'];
            }

            $result = __json(1,"操作成功",['url'=>$filename]);

        } catch (\Exception $e) {
            $result = __json(0,$e->getMessage());
        }

        return $result;
    }

    public function getVoiceTexts($text){

        if(mb_strlen($text, "utf8") <= 1800){
            
            return [$text];
        }

        $fh = ['。','；','！','？','.',';','?','!'];
        $list = mb_str_split($text);
        $num = 0;
        $text = '';
        $texts = [];
        
        foreach ($list as $key => $value) {
            if (!preg_match('/[\x{4e00}-\x{9fa5}]/u', $value)) {
                $ii = 1;
            }
            else{
                $ii = 2;
            }
            $s = $num + $ii;
            if(($s >= 1200 && $s <= 2000 && in_array($value, $fh)) || $key == count($list) -1) {
                $texts[] = $text.$value;
                $text = '';
                $num = 0;
            }
            else{
                $text .= $value;
                $num += $ii;
            }
        }

        return $texts;
    }

    public function generateVoiceTaskId(){
        return bin2hex(random_bytes(16));
    }

    /**
     * 发送 run-task 指令
     * @param $conn
     * @param $taskId
     */
    public function sendVoiceRunTaskMessage($conn, $taskId,$voice_id) {

        $config = self::getSet();
        $api_key = $config['apikey'];

        $runTaskMessage = json_encode([
            "header" => [
                "action" => "run-task",
                "task_id" => $taskId,
                "streaming" => "duplex"
            ],
            "payload" => [
                "task_group" => "audio",
                "task" => "tts",
                "function" => "SpeechSynthesizer",
                "model" => "cosyvoice-v2",
                "parameters" => [
                    "text_type" => "PlainText",
                    "voice" => $voice_id,
                    "format" => "mp3",
                    "sample_rate" => 22050,
                    "volume" => 50,
                    "rate" => 1,
                    "pitch" => 1
                ],
                "input" => (object) []
            ]
        ]);

        $voice = Db::name("bbfx_shuziren_voice")->where(['apikey'=>$api_key])->find();
        if(!empty($voice)){
            $runTaskMessage['payload']['parameters']['voice'] = $voice['voice_id'];
        }
        // echo "准备发送run-task指令: " . $runTaskMessage . "\n";
        $conn->send($runTaskMessage);
        // echo "run-task指令已发送\n";
    }

    /**
     * 发送 finish-task 指令
     * @param $conn
     * @param $taskId
     */
    public function sendVoiceFinishTaskMessage($conn, $taskId) {
        $finishTaskMessage = json_encode([
            "header" => [
                "action" => "finish-task",
                "task_id" => $taskId,
                "streaming" => "duplex"
            ],
            "payload" => [
                "input" => (object) []
            ]
        ]);
        // echo "准备发送finish-task指令: " . $finishTaskMessage . "\n";
        $conn->send($finishTaskMessage);
        // echo "finish-task指令已发送\n"; 
    }

    /**
     * 处理事件
     * @param $conn
     * @param $response
     * @param $sendContinueTask
     * @param $loop
     * @param $taskId
     * @param $taskStarted
     */
    public function handleVoiceEvent($conn, $response, $sendContinueTask, $loop, $taskId, &$taskStarted) {
        switch ($response['header']['event']) {
            case 'task-started':
                // echo "任务开始，发送continue-task指令...\n";
                $taskStarted = true;
                // 发送 continue-task 指令
                $sendContinueTask();
                break;
            case 'result-generated':
                // 忽略result-generated事件
                break;
            case 'task-finished':
                // echo "任务完成\n";
                $conn->close();
                break;
            case 'task-failed':
                // echo "任务失败\n";
                // echo "错误代码：" . $response['header']['error_code'] . "\n";
                // echo "错误信息：" . $response['header']['error_message'] . "\n";
                $conn->close();
                break;
            case 'error':
                // echo "错误：" . $response['payload']['message'] . "\n";
                break;
            default:
                // echo "未知事件：" . $response['header']['event'] . "\n";
                break;
        }

        // 如果任务已完成，关闭连接
        if ($response['header']['event'] == 'task-finished') {
            // 等待1秒以确保所有数据都已传输完毕
            $loop->addTimer(1, function() use ($conn) {
                $conn->close();
                // echo "客户端关闭连接\n";
            });
        }

        // 如果没有收到 task-started 事件，关闭连接
        if (!$taskStarted && in_array($response['header']['event'], ['task-failed', 'error'])) {
            $conn->close();
        }
    }

    public function getTaskInfo($task_id,$apikey){
        $config = self::getSet();
        $url = "https://dashscope.aliyuncs.com/api/v1/tasks/{$task_id}";
        $header = [
            'Authorization: Bearer Bearer '.$apikey,
            'Content-Type: application/json'
        ];
        $res = $this->request($url,'GET','',$header);
        

        $status = ['PENDING'=>'排队中','PRE-PROCESSING'=>'前置处理中','RUNNING'=>'处理中','POST-PROCESSING'=>'后置处理中','SUCCEEDED'=>'成功','FAILED'=>'失败','UNKNOWN'=>'作业不存在或状态未知'];

        // if(empty($res['output']['video_url'])){
        //     $message = $res['message'];
        //     if(empty($message)){
        //         $message = '数据查询失败';
        //         if($res['output']['task_status']){
        //             $message = $status[$res['output']['task_status']];
        //         }
        //     }
        //     return __json(0,$message);
        // }

        // echo "<pre>";
        // print_r($res);die; 
        
        return __json(1,'操作成功',$res['output']);
    }
    
    public function request($url,$method,$data,$headers){
        $ch = curl_init();
        // 设置cURL选项
        curl_setopt($ch, CURLOPT_URL, $url);
        if($method == "POST"){
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        }
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        // 执行cURL会话
        $response = curl_exec($ch);
        // 检查是否有错误发生
        if (curl_errno($ch)) {
            echo 'Curl error: ' . curl_error($ch);
        }
        // 关闭cURL资源
        curl_close($ch);
        if(is_string($response) && !empty($response)){
            $response1 = json_decode($response,true);
            if(!empty($response1)){
                $response = $response1;
            }
        }

        return $response;
    }
}