<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\common\model\bbfxshop;

use think\Model;
use think\Db;

class Shippingfee extends Model
{
    public static function getSet(){
        global $_W;
        $base = $_W['base'];
        if(empty($base)){
            $base = \app\common\model\bbfxshop\Common::getConfig(true);
        }
        
        return $base;
    }
    
    public static function calculateShippingFee($goods,$address_id,$total_price){
        // $address_id = 10;

        if(is_array($address_id)){
            $address = $address_id;
        }
        else{
            $address = Db::name("bbfx_user_address")->where(['id'=>$address_id])->find();
        }
        
        if(empty($address)){
            return 0;
        }
        
        $province = $address['province_name'];
        if(empty($province)){
            return 0;
        }
        
        $fee = 0;
        $is_identical_template = true;
        $tid = 0;
        $template = [];
        $goods_total = 0;
        $weight_total = 0;
        $volume_total = 0;
        $is_free_shipping_order_amount = false;
        foreach ($goods as $key => $item){
            
            $total = max(1,$item['total']);
            $weight = $total * $item['weight'];
            $volume = $total * $item['volume'];
            if(!empty($item['sku'])){
                $weight = $total * $item['sku']['weight'];
                $volume = $total * $item['sku']['volume'];
            }
            $goods_total += $total;
            $weight_total += $weight;
            $volume_total += $volume;
            
            $shippingfee_template_id = intval($item['shippingfee_template_id']);
            
            if($shippingfee_template_id > 0){
                if($tid == 0){
                    $tid = $shippingfee_template_id;
                }
                else{
                    if($tid != $shippingfee_template_id){
                        $is_identical_template = false;
                    }
                }
                
                $template = Db::name("bbfx_shippingfee_template")->where(['id'=>$item['shippingfee_template_id']])->find();
                
                if(!empty($template)){
                    $rules = iunserializer($template['rule']);
                    foreach ($rules as $k => $v){
                        $region = $v['region'];
                        $is_send = false;
                        if(!empty($region)){
                            foreach ($region as $k1 => $v1){
                                if(strstr($v1, $province)){
                                    $is_send = true;
                                }
                            }
                        }
                        else{
                            $is_send = true;
                        }
                        if(empty($is_send)){
                            continue;
                        }
                        
                        if($template['type'] == 1){
                            $value = $volume;
                        }
                        else if($template['type'] == 2){
                            $value = $total;
                        }
                        else{
                            $value = $weight;
                        }
                        
                        $fee += round($v['first_fee'],2);
                        if($value > $v['first'] && $v['continued'] > 0){
                            $fee += ceil(($value - $v['first']) / $v['continued']) * round($v['continued_fee'],2);
                        }
                        
                        if($v['free_shipping_order_amount'] > 0 && $total_price >= $v['free_shipping_order_amount']){
                            $is_free_shipping_order_amount = true;
                        }
                        
                        break;
                    }
                }
            }
        }
        
        if($is_identical_template){
            $fee = 0;
            $rules = iunserializer($template['rule']);
            foreach ($rules as $k => $v){
                $region = $v['region'];
                $is_send = false;
                if(!empty($region)){
                    foreach ($region as $k1 => $v1){
                        if(strstr($v1, $province)){
                            $is_send = true;
                        }
                    }
                }
                else{
                    $is_send = true;
                }
                
                if(empty($is_send)){
                    continue;
                }
                
                if($template['type'] == 1){
                    $value = $volume_total;
                }
                else if($template['type'] == 2){
                    $value = $goods_total;
                }
                else{
                    $value = $weight_total;
                }
                
                $fee = round($v['first_fee'],2);
                
                if($value > $v['first'] && $v['continued'] > 0){
                    $fee += ceil(($value - $v['first']) / $v['continued']) * round($v['continued_fee'],2);
                }
                
                break;
            }
        }
        
        if($is_free_shipping_order_amount){
            $fee = 0;
        }
        
        return $fee;
    }
}