<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\common\model\bbfxshop;

use think\Model;
use think\Db;
use app\common\model\bbfxshop\User;
use app\common\model\bbfxshop\Fenxiao;
use app\common\model\bbfxshop\ReturnMode;
use app\common\model\bbfxshop\Agent;
use app\common\model\bbfxshop\Message;
use app\common\model\bbfxshop\Card;
use app\common\model\bbfxshop\YiesMode; 
use app\common\model\bbfxshop\CumulativeFanhuan; 
use app\common\model\bbfxshop\CloudWarehouse; 
use app\common\model\bbfxshop\Ladderpush; 
use app\common\model\bbfxshop\Sconnection; 
use app\common\model\bbfxshop\Scoreshop; 
use app\common\model\bbfxshop\Goods; 
use app\common\model\bbfxshop\Yajin; 
use app\common\model\bbfxshop\Shipping;
use app\common\model\bbfxshop\Weixin;
use app\common\model\bbfxshop\Activity;
use app\common\model\QRcode;

class Order extends Model
{
     
    public static function payResult($order_no,$paytype=0,$params=[]){
        
        $order = Db::name("bbfx_pay_order")->where(['uniacid'=>UNIACID,'order_no'=>$order_no,'is_pay'=>0])->find();
	    if(!empty($order)){
	        $res = Db::name("bbfx_pay_order")->where(['id'=>$order['id']])->update(['is_pay'=>1]);
	        if(empty($res)){
	            return false;
	        }
	        $data = ['paytime'=>time(),'paytype'=>$paytype];
	        if($paytype == 1 && !empty($params['transaction_id'])){
	            $data['transaction_id'] = $params['transaction_id'];
	        }
	        if($paytype == 5 && !empty($params['trade_no'])){
	            $data['alipay_trade_no'] = $params['trade_no'];
	        }
	        Db::name("bbfx_pay_order")->where(['id'=>$order['id']])->update($data);
	        $order_type = intval($order['order_type']);
	        switch ($order_type) {
	            case 1:
	                self::goodsPayResult($order_no,$paytype);
	                break;
	            case 2:
	                self::rechargePayResult($order_no,$paytype);
	                break;
	            case 3:
	                Card::payResult($order_no,$paytype);
	                break;
	            case 4:
	                DepositRelease::payResult($order_no,$paytype);
	                break;
	            case 5:
	                Sconnection::payResult($order_no,$paytype);
	                break;
	            case 6:
	                Scoreshop::payResult($order_no,$paytype);
	                break;
	            case 7:
	                Yajin::payResult($order_no,$paytype);
	                break;
	            case 8:
	                Activity::baomingPayResult($order_no,$paytype);
	                break;
	        }
	        return true;
	    }
        else{
            return false;
        }
    }
    
    // 充值回调
    public static function rechargePayResult($order_no,$paytype=0){
        
        $order = Db::name("bbfx_recharge_order")->where(['uniacid'=>UNIACID,'order_no'=>$order_no])->find();
        if(empty($order)){
            return false;
        }
        
        $res = Db::name("bbfx_recharge_order")->where(['id'=>$order['id']])->update(['is_pay'=>1]);
        if(empty($res)){
            return false;
        }
        
        Db::name("bbfx_recharge_order")->where(['id'=>$order['id']])->update(['paytype'=>$paytype,'paytime'=>time()]);
        
        $actual_money = $order['actual_money'];
        if($order['type'] == 1){
            $result = User::setUserMoney($order['user_id'],$actual_money,1,7,"充值余额");
        }
        else if($order['type'] == 2){
            $result = User::setUserMoney($order['user_id'],$actual_money,2,8,"充值积分");
        }
        // 录入发货信息
        Shipping::upload($order['id'],2);
        
        if(!empty($result)){
            return true;
        }
        
        return true;
    }
    
    
    public static function goodsPayResult($order_no,$paytype=0){
        global $_W;
        $order = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'order_no'=>$order_no])->find();
        if(empty($order)){
            return false;
        }
        if($order['is_pay'] == 1){
            return false;
        }
        
        $res = Db::name("bbfx_order")->where(['id'=>$order['id']])->update(['is_pay'=>1]);
        if(empty($res)){
            return false;
        }

        $odata = ['status'=>1,'paytype'=>$paytype,'pay_time'=>time()];
        if($order['order_source'] == 8){
            $odata['status'] = 3;
            $odata['deliverytime'] = time();
            $odata['completetime'] = time();
        }
        $pay_order = Db::name("bbfx_pay_order")->where(['uniacid'=>UNIACID,'order_no'=>$order_no])->find();
        $pay_price = round($pay_order['price'] + $order['repurchase_currency'],2);
        if($pay_price < $order['price']){
            $odata['balance'] = round($order['price'] - $pay_price,2);
            User::setUserMoney($order['user_id'],-$odata['balance'],1,1,"商品支付",$order);
        }
        
        Db::name("bbfx_order")->where(['id'=>$order['id']])->update($odata);
        
        
        
        // 拼团订单回调
        if($order['order_source'] == 3){
            \app\common\model\bbfxshop\Pintuan::payResult($order['pintuan_order_id'],$order);
        }
        else{
            self::execute($order);
        }
    }
    
    public static function execute($order){
        global $_W;
        // 付款减库存
        $order_goods = Db::name("bbfx_order_goods")->where(['order_id'=>$order['id']])->select();
        foreach ($order_goods as $key => $item){
            $goods = iunserializer($item['goods_info']);
            $total = max(1,intval($item['total']));
            if($goods['type'] != 1 && $goods['stock_type'] == 2){
                Goods::setStock($item['goods_id'],intval($item['sku_id']),-$total,$order['user_id'],1,1,"用户下单",$item);
            }
            
            Goods::resetStock($order['uniacid'],$item['goods_id']);
            
            // 更新销量
            Db::name("bbfx_goods")->where(['id'=>$item['goods_id']])->setInc("sales_volume",$total);
            
            \app\common\model\bbfxshop\Paihangbang::jisuanRewardMmoney($item);
        }

        try {
            Fenxiao::settlement($order['id']);
        } 
        catch (\Exception $e) {}
        try {
            Agent::settlement($order['id']); 
        } 
        catch (\Exception $e) {}
        
        \app\common\model\bbfxshop\Strikeout::unfreezeCommission($order['user_id']);
        \app\common\model\bbfxshop\Txabonus::setAbonusPermission($order['id']);
        // 复购见单添加奖励权限
        \app\common\model\bbfxshop\RepurchaseJiandan::addRewardPermission($order['id']);
        // 复购见单结算
        \app\common\model\bbfxshop\RepurchaseJiandan::settlement($order['id']);
        // 计入资金池
        \app\common\model\bbfxshop\Capitalpool::addCapitalpoolMoney($order['id']);
        // 阶梯直推
        Ladderpush::settlement($order['id']);   
        // 分销升级
        \app\common\model\bbfxshop\FenxiaoUpgrade::upgrade($order['user_id']);
        // 云仓商品
        CloudWarehouse::settlement($order['id']); 
        // 设置佣金结束状态
        Fenxiao::setJiesuanStatus($order['id']);
        // 激活提现状态
        Fenxiao::tixianActivate($order['id']);
        // 直推业绩奖
        \app\common\model\bbfxshop\DirectpushAchievement::setDirectpushAchievementRewardCommission($order['user_id']);
        
        if(($order['order_type'] == 4 && $order['is_hexiao'] == 1) || $order['order_type'] == 2){
            // 股份分红增加份数
            \app\common\model\bbfxshop\Sabonus::addPart($order['id']);
            // 动态红包
            \app\common\model\bbfxshop\DynamicRedpacket::settlement($order['id']);
            // 321模式分销升级
            YiesMode::upgrade($order['user_id'],$order['id']);
            // 返还余额/积分
            ReturnMode::settlement($order['id']);  
            // 结算代理佣金
            Agent::setJiesuanCommission($order['id']);
            // 成为代理
            Agent::becomeAgent($order['user_id']);  
            // 累计返还
            CumulativeFanhuan::settlement($order['id']);  
            if(!empty($printer) && $printer['printer_type'] == 2 && $order['order_source'] != 3){
                // \app\common\model\bbfxshop\Printer::orderPrint($order['id']);
            }
        }

        // 结算佣金
        Fenxiao::setJiesuanCommission($order['id']);
        
        if($order['order_type'] == 1 || $order['order_type'] == 4){
            self::takeDelivery($order['id']);
        }
        else{
            /*
            // 股份分红增加份数
            \app\common\model\bbfxshop\Sabonus::addPart($order['id']);
            // 动态红包
            \app\common\model\bbfxshop\DynamicRedpacket::settlement($order['id']);
            // 321模式分销升级
            YiesMode::upgrade($order['user_id'],$order['id']);
            // 结算佣金
            Fenxiao::setJiesuanCommission($order['id']);
            // 返还余额/积分
            ReturnMode::settlement($order['id']);  
            // 结算代理佣金
            Agent::setJiesuanCommission($order['id']);
            // 成为代理
            Agent::becomeAgent($order['user_id']);  
            // 累计返还
            CumulativeFanhuan::settlement($order['id']);  
            // 分销升级
            \app\common\model\bbfxshop\FenxiaoUpgrade::upgrade($order['user_id']);
            
            if(!empty($printer) && $printer['printer_type'] == 2 && $order['order_source'] != 3){
                // \app\common\model\bbfxshop\Printer::orderPrint($order['id']);
            }
            */
        }
        
        self::give($order['id']);
        
        $printer = $_W['base']['printer'];
        if(!empty($printer) && $order['order_source'] != 3){
            \app\common\model\bbfxshop\Printer::orderPrint($order['id']);
        }

        // 生成合同
        \app\common\model\bbfxshop\Contract::createUserGoodsContract($order['id']);
        
        // 双轨模式管理升级
        \app\common\model\bbfxshop\DoubleTrack::upgrade($order['user_id']);

        // 贡献值结算
        \app\common\model\bbfxshop\Contribution::settlement($order);
        // Message::senduXiadanMsg($order['id']);
        
        // 用户下单短信通知(通知管理员)
        \app\common\model\bbfxshop\Sms::sendNewOrderNotice($order['id']);
        
        // 用户下单通知(通知管理员)
        Message::sendXiadanMsg($order['id']);
        
        $order_goods = Db::name("bbfx_order_goods")->where(['uniacid'=>$order['uniacid'],'order_id'=>$order['id']])->select();
        foreach ($order_goods as $key => $val){
            // 缺货提醒通知(通知管理员)
            Message::sendOutofstockMsg($val['goods_id']);
        }
    }

    // 检查订单是否能发货
    public static function checkFahuo($order,$type=0){
        if(empty($order)){
            return __json(0,"订单不存在");
        }
        if($order['is_pay'] != 1){
            return __json(0,"订单未支付");
        }
        if($order['refund_status'] == 0 || $order['refund_status'] == 1){
            return __json(0,"订单已申请售后");
        }
        if($order['gift_status'] === 0){
            return __json(0,"礼品订单暂时不能发货");
        }
        if($order['gift_status'] === 1 && $order['gift_user_id'] != $order['id']){
            return __json(0,"礼品订单不能发货");
        }
        if($order['pintuan_status'] == 0 && $order['pintuan_order_id'] > 0){
            return __json(0,"拼团中，不能发货");
        }

        if($type == 1){
            if($order['status'] > 1){
                return __json(0,"订单已发货");
            }
            if($order['order_type'] != 2 || $order['is_hexiao'] == 1){
                return __json(0,"不是发货订单");
            }
        }
        else{
            if(($order['order_type'] == 2 || $order['order_type'] == 4) && $order['is_hexiao'] == 1){
                return __json(0,"不是发货订单");
            }
            if($order['order_type'] == 2 && $order['status'] == 3){
                return __json(0,"订单已收货");
            }
            if($order['order_type'] != 2 && $order['status'] > 1){
                return __json(0,"订单已收货");
            }
        }

        return __json(1,"可发货");
    }
    
    // 赠送
    public static function give($id){
        $order = Db::name("bbfx_order")->where(['id'=>$id,'status'=>['>',0],'refund_status'=>['in',[-1,2]]])->find();
        if(empty($order)){
            return false;
        }
        
        $order_goods = Db::name("bbfx_order_goods")->where(['uniacid'=>UNIACID,'order_id'=>$order['id']])->select();
        if(empty($order_goods)){
            return false;
        }
        
        $user = Db::name("bbfx_user")->where(['id'=>$order['user_id'],'is_distributor'=>1,'distributor_status'=>1])->field("id,level")->find();
        if(empty($user)){
            return false;
        }
        $level = $user['level'];
        foreach ($order_goods as $key => $val){
            
            $goods = iunserializer($val['goods_info']);
            if($goods['is_give'] != 1){
                continue;
            }
            $total = max(1,intval($val['total']));
            $give = iunserializer($goods['give']);
            
            $money1 = floatval($give['level'.$level]['money1']);
            $give_number = floatval($give['level'.$level]['money2']) * $total;
            if($money1 > 0){
                $give_number = ($money1 / 100) * $val['price'];
            }
            if($give_number > 0){
                if($goods['give_type'] == 1){
                    User::setUserMoney($user['id'],$give_number,1,24,"复购赠送",$val);
                }
                else{
                    User::setUserMoney($user['id'],$give_number,2,24,"复购赠送",$val);
                }
            }
        }
    }
    
    // 发放卡密
    public static function receiveSerialNumber($order_goods){
        
        $num = 0;
        $serial_number_data = [];
        $total = max(1,intval($order_goods['total']));
        $serial_number_ok = Db::name("bbfx_serial_number")->where(['uniacid'=>UNIACID,'goods_id'=>$order_goods['goods_id'],'pid'=>$order_goods['id']])->count();
        $serial_number_ok = intval($serial_number_ok);
        if($serial_number_ok >= $total){
            return true;
        }
        
        while(true){
            $serial_number = Db::name("bbfx_serial_number")->where(['uniacid'=>UNIACID,'goods_id'=>$order_goods['goods_id'],'status'=>0,'oper'=>1])->find();
            if(!empty($serial_number)){
                $success = true;
                try {
                    Db::name("bbfx_serial_number")->where(['id'=>$serial_number['id']])->setDec("oper",1);
                    Db::name("bbfx_serial_number")->where(['id'=>$serial_number['id']])->update(['status'=>1,'pid'=>$order_goods['id']]);
                    $serial_number_data = $serial_number;
                } 
                catch (\Exception $e) {
                    $success = false;
                }
                
                if($success){
                    break;
                }
            }
            else{
                break;
            }
        }
        
        Goods::resetStock($order_goods['uniacid'],$order_goods['goods_id']);
        
        return $serial_number_data;
    }

    // 发货完成
    public static function sendGoods($order_id){
        // 上传发货信息
        Shipping::upload($order_id,1);
    }
    
    // 确认收货
    public static function takeDelivery($order_id){
        
        $order = Db::name("bbfx_order")->where(['id'=>$order_id,'status'=>['>',0]])->find();
        if($order['is_pay'] != 1){
            return __json(0,"订单未支付");
        }
        if($order['refund_status'] != -1 && $order['refund_status'] != 2){
            return __json(0,"订单已申请售后");
        }
        if(!in_array($order['order_type'],[1,2,4])){
            return __json(0,"订单类型错误");
        }
        if(($order['order_type'] == 4 || $order['order_type'] == 2) && $order['is_hexiao'] == 1){
            return __json(0,"核销订单不能确认收货");
        }
        if($order['status'] == 1 && $order['order_type'] == 2){
            return __json(0,"订单未发货");
        }
        if($order['status'] == 3){
            return __json(0,"订单已收货");
        }
        if($order['gift_status'] === 0){
            return __json(0,"礼品订单不可收货");
        }
        if($order['gift_status'] === 1 && $order['gift_user_id'] != $order['user_id']){
            return __json(0,"礼品订单不可收货");
        }
        
        try {
            Db::startTrans();// 开启事务
            $res = Db::name("bbfx_order")->where(['id'=>$order['id']])->update(['status'=>3]);
            if($res){
                if($order['order_type'] == 1){
                    $order_goods = Db::name("bbfx_order_goods")->where(['order_id'=>$order['id'],'uniacid'=>UNIACID])->select();
                    foreach ($order_goods as $key => $val){
                        $goods_info = iunserializer($val['goods_info']);
                        $serial_number_list = [];
                        if(!empty($goods_info['serial_number'])){
                            $serial_number_list = $goods_info['serial_number'];
                        }
                        $total = $val['total'];
                        $o_total = Db::name("bbfx_serial_number")->where(['uniacid'=>UNIACID,'goods_id'=>$val['goods_id'],'pid'=>$val['id']])->count();
                        $o_total = intval($o_total);
                        // file_put_contents("11188811.txt",json_encode($o_total));
                        $total = $total - $o_total;
                        if($total > 0){
                            for($i = 0;$i < $total;$i++){
                                $res = self::receiveSerialNumber($val);
                                
                                if(!empty($res)){
                                    if(is_array($res)){
                                        $serial_number_list[] = $res;
                                    }
                                }
                                else{
                                    throw new \Exception("【{$goods_info['title']}】库存不足");
                                }
                            }
                        }

                        $goods_info['serial_number'] = $serial_number_list;
                        Db::name("bbfx_order_goods")->where(['id'=>$val['id']])->update(['goods_info'=>iserializer($goods_info)]);
                    }
                    
                }
                
                if($order['status'] == 1){
                    // 发货完成
                    self::sendGoods($order['id']);
                }
                
                $result = __json(1,"操作成功");
            }
            else{
                 throw new \Exception("操作失败");
            }
            
            Db::commit();
        } 
        catch (\Exception $e) {
            Db::rollback();
            $result = __json(0,$e->getMessage());
        }
        
        if($result['code'] == 1){
            self::complete($order);
        }
        
        return $result;
    }
    
    // 订单完成
    public static function complete($order){
        global $_W;
        Db::name("bbfx_order")->where(['id'=>$order['id'],'status'=>3,'completetime'=>0])->update(['completetime'=>time()]);
        // 门店佣金
        \app\common\model\bbfxshop\Store::setCommission($order['id']);
        // 解除冻结金额
        \app\common\model\bbfxshop\Strikeout::unfreezeCommission($order['user_id']);
        // 计入资金池
        \app\common\model\bbfxshop\Capitalpool::addCapitalpoolMoney($order['id']);
        // 动态红包
        \app\common\model\bbfxshop\DynamicRedpacket::settlement($order['id']);
        // 股份分红增加份数
        \app\common\model\bbfxshop\Sabonus::addPart($order['id']);
        // 赠送优惠券
        \app\common\model\bbfxshop\Coupon::give($order['id']);
        // 321模式分销升级
        YiesMode::upgrade($order['user_id'],$order['id']);
        // 结算佣金
        Fenxiao::setJiesuanCommission($order['id']);
        // 分销升级
        \app\common\model\bbfxshop\FenxiaoUpgrade::upgrade($order['user_id']);
        // 返还余额/积分
        ReturnMode::settlement($order['id']);  
        // 结算代理佣金
        Agent::setJiesuanCommission($order['id']);
        // 成为代理
        Agent::becomeAgent($order['user_id']);  
        // 累计返还
        CumulativeFanhuan::settlement($order['id']);  
        // 商户订单结算
        if(class_exists('\app\common\model\bbfxshop\Merchant') && $order['mid'] > 0){
            $result = \app\common\model\bbfxshop\Merchant::settlementOrder($order['id']);
        }
        
        
        $printer = $_W['base']['printer'];
        if(!empty($printer) && $printer['printer_type'] == 3){
            // \app\common\model\bbfxshop\Printer::orderPrint($order['id']);
        }
    }

    public static function getHexiaoCode($order,$platform){
        
        $hxcode_list = Db::name("bbfx_order_goods_hxcode")->where(['uniacid'=>UNIACID,'order_id'=>$order['id']])->select();
        
        if(!empty($hxcode_list)){
            foreach ($hxcode_list as $key => &$val){
                
                if($platform == 'wxapp'){
                    if(!empty($val['hexiao_wxacode'])){
                        $val['hexiao_wxacode'] = cdnurl($val['hexiao_wxacode']);
                        continue;
                    }
                    if($order['mid'] > 0){
                        $result = Weixin::getUnlimitedQRCode("merchant/verification/index?{$val['hexiao_code']}", "hexiao_wxacode_{$order['uniacid']}_".$val['id'].".png");
                    }
                    else{
                        $result = Weixin::getUnlimitedQRCode("pagesS/order/detail?{$val['hexiao_code']}", "hexiao_wxacode_{$order['uniacid']}_".$val['id'].".png");
                    }
                    
                    if($result['code'] != 1){
                        __result($result);
                    }
                    $qrcode = cdnurl($result['data']['url']); 
                    Db::name("bbfx_order_goods_hxcode")->where("id",$val['id'])->update(['hexiao_wxacode'=>$result['data']['url']]);
                    $val['hexiao_wxacode'] = $qrcode;
                }
                else{
                    if(!empty($val['hexiao_qrcode'])){
                        $val['hexiao_qrcode'] = cdnurl($val['hexiao_qrcode']);
                        continue;
                    }
                    if($order['mid'] > 0){
                        $url = request()->domain()."/mobile/#/merchant/verification/index?code={$val['hexiao_code']}&i=".$order['uniacid'];
                    }
                    else{
                        $url = request()->domain()."/mobile/#/pagesS/order/detail?code={$val['hexiao_code']}&i=".$order['uniacid'];
                    }
                    $result = QRcode::create($url, "hexiao_qrcode_{$order['uniacid']}_".$val['id'].".png");
                    if($result['code'] != 1){
                        __result($result);
                    }
                    $qrcode = cdnurl($result['data']['url']); 
                    Db::name("bbfx_order_goods_hxcode")->where("id",$val['id'])->update(['hexiao_qrcode'=>$result['data']['url']]);
                    $val['hexiao_qrcode'] = $qrcode;
                }
            }
        }
        else{
            $hxcode_list = [];
        }
        
        return $hxcode_list;
    }

    // 线下支付审核
    public static function cashPay($id,$status,$mid=0){
        $where = ['uniacid'=>UNIACID,'id'=>$id];
        if($mid > 0){
            $where['mid'] = $mid;
        }
        $order = Db::name("bbfx_order")->where($where)->find();
        if(empty($order)){
            return __json(0,"订单不存在");
        }
        if($order['status'] == -1){
            return __json(0,"订单已取消");
        }
        if($order['cash_pay_shenhe'] == -1){
            return __json(0,"不是线下是否订单");
        }
        if($order['is_pay'] == 1){
            return __json(0,"订单已支付");
        }
        if($order['cash_pay_shenhe'] > 0){
            return __json(0,"订单已审核");
        }

        try {
            Db::startTrans();

            $res = Db::name("bbfx_order")->where(['id'=>$id,'cash_pay_shenhe'=>0])->update(['cash_pay_shenhe'=>$status]);
            if(empty($res)){
                throw new \Exception("订单审核失败");
            }

            if($status == 1){
                $res = self::payResult($order['order_no'],6);
                if(empty($res)){
                    throw new \Exception("订单支付失败");
                }
            }
            
            Db::commit();
            $result = __json(1,"操作成功");
        } catch (\Exception $e) {
            Db::rollback();
            $result = __json(0,$e->getMessage());
        }

        return $result;
    }

    public static function getOrderHexiaoStoreList($goods_ids){
        $where = ['uniacid'=>UNIACID,'status'=>1];

        $goods = Db::name("bbfx_goods")->where(['uniacid'=>UNIACID,'status'=>1,'type'=>['in',[2,4]],'id'=>['in',$goods_ids]])->field("id,mid,type,delivery_method,is_hexiao,hexiao_store_type")->select();
                
        $mid = 0;
        if(!empty($goods)){
            foreach ($goods as $k => $v){
                if($v['mid'] > 0){
                    $mid = $v['mid'];
                }
            }
        }
        
        $where['mid'] = $mid;

        $store_list = Db::name("bbfx_store")->where($where)->order("sort desc")->field("id,user_id,name,logo,realname,mobile,yy_time,province,city,area,address,lng,lat,is_reservation,score,introduction")->select();
            
        $list = [];   
        foreach ($store_list as $key => $val){
            $flag = true;
            foreach ($goods as $k => $v){
                if(($v['type'] == 2 && ($v['delivery_method'] == 2 || $v['delivery_method'] == 3)) || ($v['type'] == 4 && $v['is_hexiao'] == 1)){
                    
                    if($v['hexiao_store_type'] == 1){

                        $store_goods = Db::name("bbfx_store_goods")->where(['uniacid'=>UNIACID,'goods_id'=>$v['id'],'store_id'=>$val['id']])->find();
                        
                        if(empty($store_goods)){
                            $flag = false;
                        }
                    
                    }
                }
            }
            if($flag){
                $list[] = $val;
            }
        }

        return $list;
    }
    
    // 订单核销
    public static function hexiao($id,$store_id,$hx_id=0,$user_id=0,$mid=0,$store=[]){
        
        $where = ['uniacid'=>UNIACID,'is_hexiao'=>1,'id'=>$id];
        if(!empty($store)){
        //    $where['store_id'] =  $store['id'];
        }
        if(!empty($mid)){
            $where['mid'] =  $mid;
        }

        if(empty($store_id)){
            return __json(0,"请选择核销门店");
        }
       
        $order = Db::name("bbfx_order")->where($where)->find();
        if(empty($order)){
            return __json(0,"订单不存在");
        }
        if($order['status'] == -1){
            return __json(0,"订单已取消");
        }
        if($order['is_pay'] != 1){
            return __json(0,"订单未支付");
        }
        if($order['refund_status'] == 0 || $order['refund_status'] == 1){
            return __json(0,"订单已申请售后");
        }
        if(!(($order['order_type'] == 2 || $order['order_type'] == 4) && $order['is_hexiao'] == 1)){
            return __json(0,"不是核销订单");
        }
        if($order['status'] == 3){
            return __json(0,"订单已核销");
        }
        if($order['gift_status'] === 0){
            return __json(0,"礼品订单不可核销");
        }
        if($order['gift_status'] === 1 && $order['gift_user_id'] != $order['user_id']){
            return __json(0,"礼品订单不可核销");
        }
        
        if($order['order_source'] == 3 && $order['pintuan_status'] != 1){
            return __json(0,"拼团未完成");
        }

        if(!empty($user_id)){
            $user = Db::name("bbfx_user")->where(["id"=>$user_id])->field("id,nickname,avatar")->find();
        }

        // if($order['store_id'] == 0){
            $order_goods = Db::name("bbfx_order_goods")->where(['uniacid'=>UNIACID,'order_id'=>$order['id']])->field("id,goods_id")->select();
            $goods_ids = array_column($order_goods,"id");
            $store_list = self::getOrderHexiaoStoreList($goods_ids);
            if(empty($store_list)){
                return __json(0,"该订单不存在核销门店，请联系管理员");
            }
            $sids = array_column($store_list,"id");
            $store_list = array_skey($store_list,"id");
            if(!in_array($store_id,$sids)){
                return __json(0,"该订单不能在该门店核销，请重新选择门店核销");
            }
            $store = $store_list[$store_id];
        // }
        // else{
        //     if(!empty($store_id) && $store_id != $order['store_id']){
        //         return __json(0,"该门店无权限核销");
        //     }
        //     $store = Db::name("bbfx_store")->where("id",$order['store_id'])->field("id,user_id,name,logo,realname,mobile,yy_time,province,city,area,address,lng,lat,is_reservation,score,introduction")->find();
        // }

        if($order['is_hexiao_quantity'] == 1){
            if(!empty($user)){
                $hxcode = Db::name("bbfx_order_goods_hxcode")->where(['uniacid'=>UNIACID,'id'=>$hx_id,'order_id'=>$order['id']])->find();
                if(empty($hxcode)){
                    return __json(0,"核销码错误");
                }
                if($hxcode['status'] == 1){
                    return __json(0,"该核销码已核销");
                }
            }
            else{
                $hxcode = Db::name("bbfx_order_goods_hxcode")->where(['uniacid'=>UNIACID,'status'=>0,'order_id'=>$order['id']])->find();
                if(empty($hxcode)){

                    self::sendGoods($order['id']);
                    self::complete($order);

                    return __json(0,"该订单已完成核销");
                }
            }
        }
        else{
            if($order['hexiao_num'] <= 0){
                $res = Db::name("bbfx_order")->where("id",$order['id'])->update(['status'=>3]);
                if($res){
                    self::sendGoods($order['id']);
                    self::complete($order);
                    
                    return __json(1,"核销已完成");
                }
            }
        }
         
        // print_r($store);die;
        try {
            
            Db::startTrans();
            
            if($order['is_hexiao_quantity'] == 1){
                $res = Db::name("bbfx_order_goods_hxcode")->where("id",$hxcode['id'])->update(['status'=>1]);
                if(empty($res)){
                    throw new \Exception("核销已完成");
                }

                Db::name("bbfx_order_goods_hxcode")->where("id",$hxcode['id'])->update(["hexiao_uid"=>$user_id,'hexiao_time'=>time()]);

                $order['goods_info'] = iunserializer($order['goods_info']);
                
                $info = ['user'=>$user,'order'=>$order,'store'=>$store];
                
                $data = array(
                    "uniacid"=>$order['uniacid'],
                    "user_id"=>$user_id,
                    "order_id"=>$order['id'],
                    "store_id"=>intval($store['id']),
                    "info"=>iserializer($info),
                    "hexiao_total"=>$order['hexiao_total'],
                    "hexiao_num"=>$order['hexiao_num'] - 1,
                    "createtime"=>time()
                );
                
                Db::name("bbfx_order_hexiao_record")->insert($data);

                $hxcode = Db::name("bbfx_order_goods_hxcode")->where(['uniacid'=>UNIACID,'status'=>0,'order_id'=>$order['id']])->find();
                $odata = ['hexiao_time'=>time(),'status'=>1];
                if(empty($hxcode)){
                    $odata['status'] = 3;
                }
                if(!empty($user)){
                    $odata['hexiao_uid'] = $user['id'];
                }
                Db::name("bbfx_order")->where("id",$order['id'])->update($odata);
            }
            else{
                $res = Db::name("bbfx_order")->where("id",$order['id'])->setDec("hexiao_num",1);
                if(empty($res)){
                    throw new \Exception("核销已完成");
                }
                
                $order['goods_info'] = iunserializer($order['goods_info']);
                
                $info = ['user'=>$user,'order'=>$order,'store'=>$store];
                
                $data = array(
                    "uniacid"=>$order['uniacid'],
                    "user_id"=>$user_id,
                    "order_id"=>$order['id'],
                    "store_id"=>intval($store['id']),
                    "info"=>iserializer($info),
                    "hexiao_total"=>$order['hexiao_total'],
                    "hexiao_num"=>$order['hexiao_num'] - 1,
                    "createtime"=>time()
                );
                
                Db::name("bbfx_order_hexiao_record")->insert($data);
                $odata = ['hexiao_time'=>time(),'status'=>1];
                if(!empty($user)){
                    $odata['hexiao_uid'] = $user['id'];
                }
                if($order['hexiao_num'] == 1){
                    $odata['status'] = 3;
                }
                // if($order['store_id'] == 0){
                    $odata['store_id'] = $store['id'];
                    $odata['hexiao_store'] = iserializer($store);
                // }
                
                Db::name("bbfx_order")->where("id",$order['id'])->update($odata);
            }
            
            $result = __json(1,"核销成功");
            Db::commit();
        } 
        catch (\Exception $e) {
            Db::rollback();
            $result = __json(0,$e->getMessage());
        }
        
        if($result['code'] == 1 && $odata['status'] == 3){
            self::sendGoods($order['id']);
            self::complete($order);
        }
        
        return $result;
    }

    public static function initOrderSuppath(){
        $users = [];
        $list = Db::name("bbfx_order")->where(['id'=>['>',0]])->field("id,user_id")->select();
        if(!empty($list)){
            foreach($list as $key => $val){
                if(empty($users[$val['user_id']])){
                    $user = Db::name("bbfx_user")->where(['id'=>$val['user_id']])->field("id,sup_path")->find();
                    $users[$val['user_id']] = $user;
                    $sup_path = $user['sup_path'];
                }
                else{
                    $sup_path = $users[$val['user_id']]['sup_path'];
                }
                if(!empty($sup_path)){
                    Db::name("bbfx_order")->where(['id'=>$val['id']])->update(['sup_path'=>$sup_path]);
                }
            }
            
        }

        $list = Db::name("bbfx_scoreshop_order")->where(['id'=>['>',0]])->field("id,user_id")->select();
        if(!empty($list)){
            foreach($list as $key => $val){
                if(empty($users[$val['user_id']])){
                    $user = Db::name("bbfx_user")->where(['id'=>$val['user_id']])->field("id,sup_path")->find();
                    $users[$val['user_id']] = $user;
                    $sup_path = $user['sup_path'];
                }
                else{
                    $sup_path = $users[$val['user_id']]['sup_path'];
                }
                if(!empty($sup_path)){
                    Db::name("bbfx_scoreshop_order")->where(['id'=>$val['id']])->update(['sup_path'=>$sup_path]);
                }
            }
            
        }

        $list = Db::name("bbfx_member_card_order")->where(['id'=>['>',0]])->field("id,user_id")->select();
        if(!empty($list)){
            foreach($list as $key => $val){
                if(empty($users[$val['user_id']])){
                    $user = Db::name("bbfx_user")->where(['id'=>$val['user_id']])->field("id,sup_path")->find();
                    $users[$val['user_id']] = $user;
                    $sup_path = $user['sup_path'];
                }
                else{
                    $sup_path = $users[$val['user_id']]['sup_path'];
                }
                if(!empty($sup_path)){
                    Db::name("bbfx_member_card_order")->where(['id'=>$val['id']])->update(['sup_path'=>$sup_path]);
                }
            }
            
        }
    }
    
    public static function getAchievement($condition1=[],$condition2=[],$t=0){
        global $_W;
        $condition = ['o.uniacid'=>UNIACID,'o.is_pay'=>1,'o.refund_status'=>['in',[-1,2]]];
        
        if(!is_array($condition)){
            return 0;
        }
        
        $price = Db::name("bbfx_order_goods")->alias("og")->join("bbfx_order o","og.order_id = o.id")->where($condition)->where($condition1)->where($condition2)->sum("og.price");
        
        if($_W['base']['sachievement']['status'] == 1){
            $score = 0;
            try {
                $condition = ['o.uniacid'=>UNIACID,'o.refund_status'=>['in',[-1,2]]];
                $score = Db::name("bbfx_scoreshop_order_goods")->alias("og")->join("bbfx_scoreshop_order o","og.order_id = o.id")->where($condition)->where($condition1)->where($condition2)->sum("og.score");
            } 
            catch (\Exception $e) {}
            
            $price += $score;
        }
        
        $price = round($price,2);
        
        return $price;
    }
    
    // 订单退款
    public static function refund($order_id,$status,$type=0){
        
        $order = Db::name("bbfx_order")->where(['id'=>$order_id,'status'=>['>',0]])->find();
        $refund = Db::name("bbfx_order_refund")->where(['order_id'=>$order_id])->find();
        if(empty($order)){
            return __json(0,'订单不存在');
        }
        if(empty($refund)){
            return __json(0,'退款申请不存在');
        }
        if(!in_array($order['status'],[1,2,3])){
            return __json(0,'订单状态错误');
        }
        
        if($refund['status'] == 1){
            return __json(0,'订单已退款');
        }
        if($refund['status'] == 2 && $type != 1){
            return __json(0,'订单退款已拒绝');
        }
        
        if(!in_array($order['paytype'],[1,2,3,4,5])){
            return __json(0,'订单支付方式不可操作');
        }
        $order_refund_status = $refund['status'];
        
        try {
            Db::startTrans();
            
            $res = Db::name("bbfx_order_refund")->where(['id'=>$refund['id']])->update(['status'=>$status]);
            if(empty($res)){
                throw new \Exception("订单状态错误");
            }
            Db::name("bbfx_order_refund")->where(['id'=>$refund['id']])->update(['refundtime'=>time()]);
            if($status == 1){
                

                if($order['order_source'] != 7){
                    $repurchase_currency = floatval($order['repurchase_currency']);
                    if($repurchase_currency > 0){
                        $res = User::setUserMoney($order['user_id'],$repurchase_currency,4,4,"订单退款",$order);
                        if(empty($res)){
                            throw new \Exception("退款失败");
                        }
                    }
                }
                
                $balance = floatval($order['balance']);
                if($balance > 0){

                    $paylog = Db::name("bbfx_money_log")->where(['uniacid'=>UNIACID,'type'=>1,'item_type'=>1,'user_id'=>$order['user_id'],'item_id'=>$order['id']])->find();

                    if(!empty($paylog)){
                        $res = User::setUserMoney($order['user_id'],$balance,4,4,"订单退款",$order);
                        if(empty($res)){
                            throw new \Exception("退款失败");
                        }
                    }
                    
                }

                
                $price = round(floatval($order['price']) - $repurchase_currency - $balance,2);

                // throw new \Exception("退款失败：".$price);
                
                if($price > 0){
                    
                    $refund_fee = $refund['money'];
                    if($refund_fee > $price){
                        $refund_fee = $price;
                    }
                    
                    if($order['paytype'] == 1 && $order['order_source'] != 7){
                        $params = ['order_no'=>$order['order_no'],'out_refund_no'=>$refund['order_no'],'total_fee'=>$price,'refund_fee'=>$refund_fee,'platform'=>$order['platform']];
                        $res = \app\common\model\bbfxshop\Wxpay::refund($params);
                        if(empty($res) || $res['code'] != 1){
                            throw new \Exception($res['message']);
                        }
                    }
                    else if($order['paytype'] == 2){
                        $res = User::setUserMoney($order['user_id'],$refund_fee,1,4,"订单退款",$order);
                        if(empty($res)){
                            throw new \Exception("退款失败");
                        }
                    }
                    else if($order['paytype'] == 3 && $order['order_source'] != 7){
                        $res = User::setUserMoney($order['user_id'],$refund_fee,6,4,"订单退款",$order);
                        if(empty($res)){
                            throw new \Exception("退款失败");
                        }
                    }
                    else if($order['paytype'] == 4 && $order['order_source'] != 7){
                        $res = User::setUserMoney($order['user_id'],$refund_fee,4,4,"订单退款",$order);
                        if(empty($res)){
                            throw new \Exception("退款失败");
                        }
                    }
                    else if($order['paytype'] == 5 && $order['order_source'] != 7){
                        $params = ['order_no'=>$order['order_no'],'out_refund_no'=>$refund['order_no'],'refund_fee'=>$refund_fee,'refund_reason'=>$refund['content']];
                        $res = \app\common\model\bbfxshop\Alipay::refund($params);
                        if(empty($res) || $res['code'] != 1){
                            throw new \Exception($res['message']);
                        }
                    }
                }
                
                // 拼团订单
                if($order['order_source'] == 3){
                    \app\common\model\bbfxshop\Pintuan::refund($order);
                }
                
                // 返还库存
                $goods = iunserializer($order['goods_info']);
                
                $order_goods = Db::name("bbfx_order_goods")->where(['order_id'=>$order['id']])->select();
                foreach ($order_goods as $k => $v){
                    $total = $v['total'];
                    if($order['order_type'] == 2 || $order['order_type'] == 3 || $order['order_type'] == 4){
                        $result = Goods::setStock($v['goods_id'],intval($v['sku_id']),$total,$order['user_id'],1,2,"用户退款",$v);
                    }
                }
                
                $result = __json(1,"退款成功");
            }
            else{
                $result = __json(1,"操作成功");
            }
            
            Db::name("bbfx_order")->where(['id'=>$order['id']])->update(['refund_status'=>$status]);
            
            Db::commit();
        } 
        catch (\Exception $e) {
            Db::rollback();
            $result = __json(0,$e->getMessage());
        }
        
        if($result['code'] == 1 && $status == 1){
            Fenxiao::setRefundInvalidCommission($order['id']);
            CloudWarehouse::setRefundResetStock($order['id']);
        }
        
        return $result;
    }
    
    // 订单操作
    public static function orderAutoOper(){
        
        $orderset = Db::name("bbfx_base")->where(['uniacid'=>UNIACID])->value("orderset");
        $orderset = iunserializer($orderset);
        $auto_delivery = intval($orderset['auto_delivery']);
        $auto_close = intval($orderset['auto_close']);
        
        if($auto_delivery <= 0 && $auto_close <= 0){
            return false;
        }
        
        try {
            
            $res = Db::name("bbfx_base")->where(['uniacid'=>UNIACID])->setDec("order_oper",1);
            if($res){
                
                try {
                    
                    self::autoSelivery($orderset);
                    self::autoCloseOrder($orderset);
                    self::autoAfterSalesEnd($orderset);
                    
                } 
                catch (\Exception $e) {
                    
                }
            
                Db::name("bbfx_base")->where(['uniacid'=>UNIACID])->update(['order_oper'=>1]);
            }
            
        } catch (\Exception $e) {
            
            
        }
        
        return true;
        
    }
    
    // 订单售后期结束
    public static function autoAfterSalesEnd($orderset){
        if(empty($orderset)){
            $orderset = Db::name("bbfx_base")->where(['uniacid'=>UNIACID])->value("orderset");
            $orderset = iunserializer($orderset);
        }
        
        Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'status'=>3,'completetime'=>0,'is_asales_end'=>0])->update(['completetime'=>time()]);
        
        $after_sales_day = intval($orderset['after_sales_day']);
        if($after_sales_day < 0 || empty($after_sales_day)){
            $after_sales_day = 0;
        }
        
        $time = time() - $after_sales_day * 24 * 60 * 60;
        
        $list = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'status'=>3,'completetime'=>['<=',$time],'refund_status'=>['in',[-1,2]],'is_asales_end'=>0])->field("id")->select();
        if(empty($list)){
            return false;
        }
        
        foreach ($list as $key => $val){
            Db::name("bbfx_order")->where(['id'=>$val['id']])->update(['is_asales_end'=>1,'asales_end_time'=>time()]);
            // 结算佣金
            Fenxiao::setJiesuanCommission($val['id']);
        }
        
    }
    
    // 自动关闭订单
    public static function autoCloseOrder($orderset){
        
        if(empty($orderset)){
            $orderset = Db::name("bbfx_base")->where(['uniacid'=>UNIACID])->value("orderset");
            $orderset = iunserializer($orderset);
        }
        
        $auto_close = intval($orderset['auto_close']);
        
        if($auto_close <= 0){
            return false;
        }
        $closetime = time() - $auto_close*60*60;
        $order_list = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'status'=>0,'createtime'=>['<',$closetime]])->select();
        foreach ($order_list as $key => $val){
            self::closeOrder($val);
        }
        
        return true;
    }
    
    // 关闭订单
    public static function closeOrder($order_id){
        
        if(is_array($order_id)){
            $order = $order_id;
        }
        else{
            $order = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'status'=>0,'id'=>$order_id])->find();
        }
        
        if(empty($order)){
            return __json(0,"订单不存在或已关闭");
        }
        
        $res = Db::name("bbfx_order")->where("id",$order['id'])->update(['status'=>-1]);
        if($res){
            if($order['user_coupon_id'] > 0){
                $coupon = Db::name("bbfx_user_coupon")->where(["id"=>$order['user_coupon_id']])->find();
                if($coupon['type'] == 1){
                    Db::name("bbfx_user_coupon")->where(['id'=>$coupon['id']])->setInc("residue_money",$order['discount_coupon_price']);
                    if($coupon['status'] == 1){
                        Db::name("bbfx_user_coupon")->where("id",$coupon['id'])->update(['status'=>0]);
                    }
                }
                else{
                    Db::name("bbfx_user_coupon")->where("id",$order['user_coupon_id'])->update(['status'=>0]);
                }
            }
            
            $order_goods = Db::name("bbfx_order_goods")->where(['order_id'=>$order['id']])->select();
            foreach ($order_goods as $k => $v){
                $total = $v['total'];
                $goods = iunserializer($v['goods_info']);
                if($goods['stock_type'] == 1 && $goods['type'] != 1){
                    Goods::setStock($v['goods_id'],intval($v['sku_id']),$total,$order['user_id'],1,3,"订单关闭",$v);
                }
                Goods::resetStock($order['uniacid'],$v['id']);
            }
            
            $repurchase_currency = floatval($order['repurchase_currency']);
            if($repurchase_currency > 0){
                User::setUserMoney($order['user_id'],$repurchase_currency,4,25,"订单关闭退回",$order);
            }
            return __json(1,"关闭订单成功");
        }
        else{
            return __json(0,"关闭订单失败");
        }
    }
    
    // 自动收货
    public static function autoSelivery($orderset){
        if(empty($orderset)){
            $orderset = Db::name("bbfx_base")->where(['uniacid'=>UNIACID])->value("orderset");
            $orderset = iunserializer($orderset);
        }
        $auto_delivery = intval($orderset['auto_delivery']);
        
        if($auto_delivery <= 0){
            return false;
        }
        
        $deliverytime = time() - $auto_delivery*24*60*60;
        $order_list = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'status'=>2,'order_type'=>2,'is_hexiao'=>0,'deliverytime'=>['<',$deliverytime]])->field(['id'])->select();
        foreach ($order_list as $key => $val){
            self::takeDelivery($val['id']);
        }
        
        return true;
    }
    
    public static function calculateVipGoodsPrice($user,$goods,$levels = []){

        if(empty($levels)){
            $levels = Fenxiao::getLevels(1);
        }
        
        if(!is_array($user)){
            $user = User::getUser($user,false);
        }
        $total = max(1,$goods['total']);
        $goods_price = floatval($goods['price']);
        $vip_price = $goods_price;
        
        if($goods['is_nodiscount'] != 1){
            if($goods['is_leveldiscount_rule'] == 1){
                if($user['is_distributor'] == 1 && $user['distributor_status'] == 1){
                    $level_discount = iunserializer($goods['level_discount']);


                    $money1 = floatval($level_discount['level'.$user['level']]['money1']);
                    $money2 = floatval($level_discount['level'.$user['level']]['money2']);
                    if($money2 > 0){
                        $vip_price = $money2;
                    }
                    else{
                        if($money1 > 0 && $money1 <= 10){
                            $vip_price = ($money1 / 10) * $goods_price;
                        }
                    }
                    
                }
                
            }
            else{
                $discount = User::getUserDiscount($user,$levels);
                $vip_price = ($discount / 10) * $goods_price;
                
            }
           
            $card = Card::getUserCard($user['id']);
            if(!empty($card)){
                $discount = floatval($card['discount']);
                if($discount <= 0 || $discount > 10){
                    $discount = 10;
                }
                $card_vip_price = $discount / 10 * $goods_price;
                if($card_vip_price < $vip_price){
                    $vip_price = $card_vip_price;
                }
            }
        }
        
        return round($vip_price,2);
    }
    
    public static function calculateCouponGoodsPrice($goods,$coupon_id,$total_original_price,$coupon_money=-1){
        
        if(is_array($coupon_id)){
            $coupon = $coupon_id;
        }
        else{
            $coupon = Db::name("bbfx_user_coupon")->where(["id"=>$coupon_id])->where("status",0)->find();
        }
        
        
        if($coupon_money == -1){
            $coupon_money = floatval($coupon['money']);
        }
        $old_coupon_money = $coupon_money;
        
        $coupon_goods_ids = [];
        $goods_price = floatval($goods['price']);
        $total = max(1,intval($goods['total']));
        $max_money = ($goods_price * ($coupon['max_money'] / 100)) * $total;
        $flag = false;
        $is_user_coupon = true;
        if($coupon['condition_type'] == 1){
            $coupon_goods_ids = explode(",",$coupon['goods_ids']);
            if(in_array($goods['id'],$coupon_goods_ids)){
                $price = $goods_price * $total - $coupon_money;
                $coupon_money = 0;
            }
            else{
                $is_user_coupon = false;
            }
        }
        else if($coupon['condition_type'] == 2){
            if($total_original_price >= $coupon['mj_money']){
                $price = $goods_price * $total - $coupon_money;
                if($price <= 0){
                    $coupon_money = $coupon_money - $goods_price * $total;
                }
                else{
                    $coupon_money = 0;
                }
            }
        }
        else{
            $price = $goods_price * $total - $coupon_money;
            if($price <= 0){
                $coupon_money = $coupon_money - $goods_price * $total;
            }
            else{
                $coupon_money = 0;
            }
            
        }
        
        if($price < 0){
            $price = 0;
        }
        
        
        $discount_price = $goods_price * $total - $price;
        
        if($max_money > 0 && $discount_price > $max_money){
            $price = $goods_price * $total - $max_money;
            $coupon_money = $old_coupon_money - $max_money;
        }
        
        
        return ['price'=>round($price,2),'coupon_money'=>round($coupon_money,2),'is_user_coupon'=>$is_user_coupon];
    }
    
    public static function calculateMoney($goods,$user,$coupon_id = 0,$delivery_method=1,$address_id=0){
        // 总商品金额(折扣后价格)
        $total_price = 0;
        // 快递费
        $express_fee = 0;
        // 折扣金额
        $total_discount_price = 0;
        // 总商品原价金额
        $total_original_price = 0;
        $totalNum = 0;
        // 会员折扣
        $discount_vip_price = 0;
        $total_discount_vip_price = 0;
        // 优惠券
        $discount_coupon_price = 0;
        $total_discount_coupon_price = 0;
        
        $is_coupon = false;
        $coupon_money = 0;
        $coupon = Db::name("bbfx_user_coupon")->where(["id"=>$coupon_id,'user_id'=>$user['id'],'status'=>0])->find();
        if(!empty($coupon)){
            
            if($coupon['type'] == 1){
                $coupon['money'] = $coupon['residue_money'];
            }
            
            $coupon_money = floatval($coupon['money']);
        }
        
        $price_data = [];
        
        foreach ($goods as $key => $item){
            $total_original_price += max(1,intval($item['total'])) * floatval($item['price']);
        }
        
        $seckill_goods = [];
        $seckill_activity = Db::name("bbfx_seckill_activity")->where(['status'=>1,'starttime'=>['<',time()]])->where(['endtime'=>['>',time()]])->select();
        if(!empty($seckill_activity)){
            
            foreach ($seckill_activity as $key => $val){
                $seckill_goods_ids = explode(",",$val['seckill_goods_ids']);
                    
                $where = ["a.uniacid"=>UNIACID,"a.status"=>1,"a.id"=>['in',$seckill_goods_ids],'b.status'=>1];
                $seckill_goods_list = Db::name("bbfx_seckill_goods")->alias("a")->join("bbfx_goods b","a.goods_id = b.id")->where($where)->field("a.*,b.title,b.thumb,b.price as o_price")->order(['b.sort desc','b.id desc'])->select();
                foreach ($seckill_goods_list as $k => $v){
                    $v['seckill_activity_id'] = $val['id'];
                    $seckill_goods[$v['goods_id']] = $v;
                }
            }
        }
        foreach ($goods as $key => &$item){
            $result = CloudWarehouse::getJinhuoPrice($user,$item);
            if($result['code'] == 1){
                $CloudWarehouse_price = $result['data']['price'];
                $vip_price = self::calculateVipGoodsPrice($user,$item);
                if($CloudWarehouse_price < $vip_price){
                    $item['price'] = $CloudWarehouse_price;
                }
            }
        }
        unset($item);
        
        foreach ($goods as $key => $item){
            $total = max(1,intval($item['total']));
            $totalNum += $total;
    	    $goods_price = floatval($item['price']);
    	    $item['total_price'] = $total * $goods_price;
    	    $seckill_goods_id = 0;
            $seckill_activity_id = 0;
    	    
            $real_goods_price = $goods_price;
            $user_coupon_id = 0;
            $type = 0;
            $discount_coupon_price = 0;
            $discount_vip_price = 0;
            $plugin = iunserializer($item['plugin']);
            
            
            // 会员折扣
            if(!empty($seckill_goods[$item['id']])){
                if($seckill_goods[$item['id']]['type'] == 2){
                    $real_goods_price = $goods_price * (floatval($seckill_goods[$item['id']]['discount']) / 10) * $total;
                }
                else{
                    $real_goods_price = $seckill_goods[$item['id']]['price'] * $total;
                }
                
                $seckill_activity_id = $seckill_goods[$item['id']]['seckill_activity_id'];
                $seckill_goods_id = $seckill_goods[$item['id']]['id'];
                $type = 1;
            }
            else{
                $real_goods_price = self::calculateVipGoodsPrice($user,$item);
            }
            
            $price = $real_goods_price * $total;
            
            $discount_vip_price = max(0,($goods_price - $real_goods_price) * $total);
            
            $item['price'] = $real_goods_price;
            
            // 优惠券抵扣
            if(!empty($coupon) && (empty($plugin) || empty($plugin['coupon']) || (!empty($plugin) && !empty($plugin['coupon']) && $plugin['coupon']['is_nouse_coupon'] != 1))){
                
                if(empty($is_coupon)){
                    $result = self::calculateCouponGoodsPrice($item,$coupon,$total_original_price,$coupon_money);
                    $coupon_money = $result['coupon_money'];
                    $price = $result['price'];
                    
                    if($coupon['condition_type'] == 1){
                        if($price < $real_goods_price * $total){
                            $is_coupon = true;
                            $user_coupon_id = $coupon['id'];
                        }
                    }
                    
                    $discount_coupon_price = max(0,$real_goods_price * $total - $price);
                }
                else{
                    $price = $real_goods_price * $total;
                }
            }
            
            $item['total_price'] = $price;
            $discount_price = $discount_vip_price + $discount_coupon_price;
            
            $original_price = $goods_price * $total;
            
            $total_price += $price;
            $total_discount_price += $discount_price;
            
            // if($item['type'] == 2 && $delivery_method == 1){
            //     $express_fee += $item['express_fee'];
            // }
            
            
            $total_discount_vip_price += $discount_vip_price;
            $total_discount_coupon_price += $discount_coupon_price;
            
            $price_data[] = array(
                'price'=>round($price,2),
                'total_price'=>round($original_price,2),
                'discount_price'=>round($discount_price,2),
                'discount_vip_price'=>round($discount_vip_price,2),
                'discount_coupon_price'=>round($discount_coupon_price,2),
                'user_coupon_id'=>$user_coupon_id,
                'type'=>$type,
                'seckill_activity_id'=>$seckill_activity_id,
                'seckill_goods_id'=>$seckill_goods_id
            );
        }
        
        if($delivery_method == 1){
            $express_fee = \app\common\model\bbfxshop\Shippingfee::calculateShippingFee($goods,$address_id,$total_price);
        }
        
        // echo "<pre>";
        // print_r($price_data);die;
        // print_r($total_discount_price);die;
        $result = array(
            "express_fee"=>round($express_fee,2),
            "total_price"=>round($total_price,2),
            "original_price"=>round($total_original_price,2),
            "discount_price"=>round($total_discount_price,2),
            "discount_vip_price"=>round($total_discount_vip_price,2),
            "discount_coupon_price"=>round($total_discount_coupon_price,2),
            "price_data"=>$price_data,
            "totalNum"=>$totalNum
        );
        
        if(!empty($coupon)){
            $result['coupon'] = $coupon;
        }
        
        return $result;
    }
    
    public static function getOrderType($type){
        $list = ['1'=>'卡密商品','2'=>'实物商品','3'=>'核销商品','4'=>'虚拟商品'];
        
        if(empty($list[$type])){
            return "未知类型";
        }
        
        return $list[$type];
    }
    
    public static function getOrderStatus($order,$type=0){
        
        $status = $order['status'];
        $is_hexiao = $order['is_hexiao'];
        $refund_status = $order['refund_status'];

        if($order['cash_pay_shenhe'] >= 0){
            if($order['cash_pay_shenhe'] === 0){
                return "待审核";
            }
            else if($order['cash_pay_shenhe'] === 2){
                return "已驳回";
            }
        }
        
        if($order['order_source'] == 3 && $order['pintuan_status'] == 0 && $order['status'] == 1){
            return "拼团中";
        }
        
        $list = ['-1'=>'已关闭','0'=>'待支付','1'=>'待发货','2'=>'已发货','3'=>'已完成'];
        
        if($is_hexiao == 1){
            $list = ['-1'=>'已关闭','0'=>'待支付','1'=>'待核销','2'=>'待核销','3'=>'已完成'];
        } 
        
        if(($refund_status == 1 || $refund_status == 0) && $type == 0){
            return self::getOrderRefundStatus($refund_status);
        }
        
        if(empty($list[$status])){
            return "";
        }
        
        return $list[$status];
    }
    
    public static function getOrderRefundStatus($status){
        $list = ['-1'=>'未退款','0'=>'待审核','1'=>'已退款','2'=>'已拒绝'];
        
        if(empty($list[$status])){
            return "未知状态";
        }
        
        return $list[$status];
    }
    
    public static function getOrderPaytype($status){
        global $_W;
        $predeposit = $_W['base']['fenxiao']['texts']['predeposit'];
        if(empty($predeposit)){
            $predeposit = "预存款";
        }
        $repurchase_currency = $_W['base']['fenxiao']['texts']['repurchase_currency'];
        if(empty($repurchase_currency)){
            $repurchase_currency = "复购金";
        }
        
        $list = ['1'=>'微信支付','2'=>'余额支付','3'=>$predeposit."支付",'4'=>$repurchase_currency."支付",'5'=>'支付宝支付','6'=>'线下支付'];
        
        if(empty($list[$status])){
            return "";
        }
        
        return $list[$status];
    }
}
?>