<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\common\model\bbfxshop;

use think\Db;
use think\Model;
use app\common\model\bbfxshop\Weixin;


class Message extends Model
{
        //miniprogram_state：developer为开发版；trial为体验版；formal为正式版；
        public static $miniprogram_state = "formal";
        
        //获取小程序订阅消息模板ID列表
        public static function getWxappTemplateList(){
            
            $result = Weixin::getAccessToken();
            
            if($result['code'] != 1){
                return [];
            }
            $access_token = $result['data'];
            $api_url = "https://api.weixin.qq.com/wxaapi/newtmpl/gettemplate?access_token=".$access_token;
            
            $result = ihttp_get($api_url); 
            
            $result = json_decode($result['content'],true);
            
            if($result['errcode'] === 0){
                return $result['data'];
            }
            
            return [];
        }
        
        //微信公众模板消息ID
        public static function getTemplateList(){
            
            $result = Weixin::getWxAccessToken();
            
            if($result['code'] != 1){
                return [];
            }

            $access_token = $result['data'];
            
            $api_url = "https://api.weixin.qq.com/cgi-bin/template/get_all_private_template?access_token=".$access_token;
            
            $result = ihttp_get($api_url); 
            
            $result = json_decode($result['content'],true);
            
            if(!empty($result['template_list'])){
                return $result['template_list'];
            }
            
            return [];
        }
        
        public static function addTemplate($tid,$kidList,$sceneDesc = "测试"){
            $result = Weixin::getAccessToken();
            if($result['code'] != 1){
                return false;
            }
            $access_token = $result['data'];
            
            $api_url = "https://api.weixin.qq.com/wxaapi/newtmpl/addtemplate?access_token=".$access_token;
            
            $data = array(
                "tid"=>$tid,
                "kidList"=>$kidList,
                "sceneDesc"=>$sceneDesc
            );
            $data = urldecode(json_encode($data));
            $headers = array('Content-Type' => 'application/json');
            $result = ihttp_request($api_url,$data,$headers); 
            
            return json_decode($result['content'],true);
        }
        
        //用户下单通知(通知管理员)
        public static function sendXiadanMsg($order_id){
            global $_W;
            
            $base = $_W['base'];
            
            $subscribemsg = $base['subscribemsg'];
            $gzh_template_msg = $base['gzh_template_msg'];
            
            $order = Db::name("bbfx_order")->where(["uniacid"=>UNIACID,"id"=>$order_id,"is_pay"=>1])->find();
            
            if($base['is_subscribemsg'] != 1 || (empty($subscribemsg['xiadan_tid']['tid']) && empty($gzh_template_msg['xiadan_tid']['tid'])) || empty($base['admin']) || empty($order)){
                return false;
            }
            $goods_info = iunserializer($order['goods_info']);
            
            $goods_name = "";
            foreach ($goods_info as $key => $val){
                if($key == count($goods_info) - 1){
                    $goods_name .= $val['title'];
                }
                else{
                    $goods_name .= $val['title']."丨";
                }
            }
            $goods_name = mb_substr($goods_name,0,20);
            $data = array(
                "order_no"=>$order['order_no'],
                "goods_name"=>$goods_name,
                "num"=>1,
                "status"=>"支付成功",
                "price"=>$order['price'],
                "date"=>date("Y-m-d H:i:s",$order['createtime'])
            );
            
            $goods_info = iunserializer($order['goods_info']);
            $result = array();
            $admin = self::getAdmin($base);
            
            foreach ($admin as $key => $val){
                $tpl_data = self::replaceTplData("xiadan_tid",$data,$val['platform']);
                if($val['platform'] == 'GZH'){
                    if(empty($gzh_template_msg['xiadan_tid']['tid'])) continue;
                    
                    $data = [
                        'touser'=>$val['openid'],
                        'template_id'=>$gzh_template_msg['xiadan_tid']['tid'],
                        'url'=>request()->domain()."/mobile/#/pages/index/index?i=".UNIACID,
                        // 'miniprogram'=>[
                        //     'appid'=>'',
                        //     'pagepath'=>''
                        // ],
                        'data'=>$tpl_data
                    ];

                    $result[] = self::sendTemplateMessage($data); 
                }
                else{
                    if(empty($subscribemsg['xiadan_tid']['tid'])) continue;

                    $data = array(
                        "template_id"=>$subscribemsg['xiadan_tid']['tid'],
                        "touser"=>$val['openid'],
                        "page"=>"/pages/index/index",
                        "miniprogram_state"=>self::$miniprogram_state,
                        "data"=>$tpl_data
                    );

                    $res = self::sendMessage($data); 
                    if($res['errcode'] === 0){
                        self::setSubscribeNum($val['id'],$subscribemsg['xiadan_tid']['tid'],'xiadan_tid');
                    }
                    $result[] = $res;
                }
                
            }
            
            return $result;
        }
        
        //缺货提醒通知(通知管理员)
        public static function sendOutofstockMsg($goods_id){
            global $_W;
            
            $base = $_W['base'];
            
            $subscribemsg = $base['subscribemsg'];
            $gzh_template_msg = $base['gzh_template_msg'];
            
            $goods = Db::name("bbfx_goods")->where(["uniacid"=>UNIACID,"id"=>$goods_id])->find();
            
            $stock_remind_num = intval($base['stock_remind_num']);
            if($base['is_subscribemsg'] != 1 || $stock_remind_num <= 0 || (empty($subscribemsg['outofstock_tid']['tid']) && empty($gzh_template_msg['outofstock_tid']['tid'])) || empty($base['admin']) || empty($goods)){
                return false;
            }
           
            $admin = explode(",",$base['admin']);
            
            $result = array();
            
            if($goods['type'] == 1){
                $stock = Db::name("bbfx_serial_number")->where(["uniacid"=>UNIACID,"goods_id"=>$goods_id,"status"=>1])->count();
                $stock = $stock?$stock:0;
            }
            else{
                $stock = $goods['stock'];
            }
            
            if($stock > $stock_remind_num){
                return false;
            }
            
            $data = array(
                "goods_name"=>$goods['title'],
                "stock"=>$stock,
                "date"=>date("Y-m-d H:i:s")
            );
            
            $admin = self::getAdmin($base);
            
            foreach ($admin as $key => $val){
                $tpl_data = self::replaceTplData("outofstock_tid",$data,$val['platform']);
                if($val['platform'] == 'GZH'){
                    if(empty($gzh_template_msg['outofstock_tid']['tid'])) continue;
                    
                    $data = [
                        'touser'=>$val['openid'],
                        'template_id'=>$gzh_template_msg['outofstock_tid']['tid'],
                        'url'=>request()->domain()."/mobile/#/pages/index/index?i=".UNIACID,
                        // 'miniprogram'=>[
                        //     'appid'=>'',
                        //     'pagepath'=>''
                        // ],
                        'data'=>$tpl_data
                    ];

                    $result[] = self::sendTemplateMessage($data); 
                }
                else{
                    if(empty($subscribemsg['outofstock_tid']['tid'])) continue;

                    $data = array(
                        "template_id"=>$subscribemsg['outofstock_tid']['tid'],
                        "touser"=>$val['openid'],
                        "page"=>"/pages/index/index",
                        "miniprogram_state"=>self::$miniprogram_state,
                        "data"=>$tpl_data
                    );

                    $res = self::sendMessage($data); 
                    if($res['errcode'] === 0){
                        self::setSubscribeNum($val['id'],$subscribemsg['outofstock_tid']['tid'],'outofstock_tid');
                    }
                    $result[] = $res;
                }
                

            }
            
            return $result;
        }
        
        // 消息中心通知（通知用户）
        public static function sendMessageCenterNotice($id,$base=[]){
            global $_W;
            if(is_array($id)){
                $notice = $id;
            }
            else{
                $notice = Db::name("bbfx_notice")->where(['id'=>intval($id)])->find();
            }
            
            if(empty($notice) || empty($notice['content'])){
                return false;
            }
            
            if(empty($base)){
                $base = $_W['base'];
            }
            
            $subscribemsg = $base['subscribemsg'];
            $gzh_template_msg = $base['gzh_template_msg'];
            
            $user = Db::name("bbfx_user")->where(['id'=>$notice['user_id']])->field("id,nickname,avatar,openid,platform")->find();
            
            if((empty($subscribemsg['message_center_tid']['tid']) && empty($gzh_template_msg['message_center_tid']['tid'])) || empty($user) || !in_array($user['platform'],['WXAPP','GZH','wxapp'])){
                return false;
            }
            
            $data = array(
                "title"=>$notice['title'],
                "content"=>$notice['content'],
                "time"=>date("Y-m-d H:i:s")
            );
            
            $tpl_data = self::replaceTplData("message_center_tid",$data,$user['platform']);
            
            if($user['platform'] == 'GZH'){

                if(empty($gzh_template_msg['message_center_tid']['tid'])) return false;

                $data = [
                    'touser'=>$user['openid'],
                    'template_id'=>$gzh_template_msg['message_center_tid']['tid'],
                    'url'=>request()->domain()."/mobile/#/plugin/notice/index?i=".UNIACID,
                    // 'miniprogram'=>[
                    //     'appid'=>'',
                    //     'pagepath'=>''
                    // ],
                    'data'=>$tpl_data
                ];

                $result = self::sendTemplateMessage($data); 
            }
            else{

                if(empty($subscribemsg['message_center_tid']['tid'])) return false;

                $data = array(
                    "template_id"=>$subscribemsg['message_center_tid']['tid'],
                    "touser"=>$user['openid'],
                    "page"=>"/plugin/notice/index",
                    "miniprogram_state"=>self::$miniprogram_state,
                    "data"=>$tpl_data
                );

                $result = self::sendMessage($data); 

                if($result['errcode'] === 0){
                    self::setSubscribeNum($user['id'],$subscribemsg['message_center_tid']['tid'],'message_center_tid');
                }
            }
            
            return $result;
        }
        
        // 更新通知(通知用户)
        public static function sendUpdatenoticeMsg($user,$base = []){
            global $_W;
            
            if(empty($base)){
                $base = $_W['base'];
            }
            
            $subscribemsg = $base['subscribemsg'];
            $gzh_template_msg = $base['gzh_template_msg'];
            
            if((empty($subscribemsg['updatenotice_tid']['tid']) && empty($gzh_template_msg['updatenotice_tid']['tid'])) || empty($user)){
                return false;
            }
            
            $data = array(
                "date"=>date("Y-m-d H:i:s")
            );
            
            $tpl_data = self::replaceTplData("updatenotice_tid",$data,$user['platform']);

            if($user['platform'] == 'GZH'){

                if(empty($gzh_template_msg['updatenotice_tid']['tid'])) return false;

                $data = [
                    'touser'=>$user['openid'],
                    'template_id'=>$gzh_template_msg['updatenotice_tid']['tid'],
                    'url'=>request()->domain()."/mobile/#/pages/index/index?i=".UNIACID,
                    // 'miniprogram'=>[
                    //     'appid'=>'',
                    //     'pagepath'=>''
                    // ],
                    'data'=>$tpl_data
                ];

                $result = self::sendTemplateMessage($data); 
            }
            else{

                if(empty($subscribemsg['updatenotice_tid']['tid'])) return false;

                $data = array(
                    "template_id"=>$subscribemsg['updatenotice_tid']['tid'],
                    "touser"=>$user['openid'],
                    "page"=>"/pages/index/index",
                    "miniprogram_state"=>self::$miniprogram_state,
                    "data"=>$tpl_data
                );

                $result = self::sendMessage($data); 

                if($result['errcode'] === 0){
                    self::setSubscribeNum($user['id'],$subscribemsg['updatenotice_tid']['tid'],'updatenotice_tid');
                }
            }
            
            return $result;
        }
        
        // 发货通知(通知用户)
        public static function sendShippingnoticeMsg($order_id,$base = []){
            global $_W;
            
            if(empty($base)){
                $base = $_W['base'];
            }
            
            $subscribemsg = $base['subscribemsg'];
            $gzh_template_msg = $base['gzh_template_msg'];
            
            $order = Db::name("bbfx_order")->where(['id'=>$order_id,'status'=>['>=',2]])->find();
            $express = iunserializer($order['express']);
            
            if($base['is_subscribemsg'] != 1 || (empty($subscribemsg['shippingnotice_tid']['tid']) && empty($gzh_template_msg['shippingnotice_tid']['tid'])) || empty($order)){
                return false;
            }
            
            $user = User::getInfo($order['user_id']);
            if(empty($user) || !in_array($user['platform'],['WXAPP','GZH'])){
                return false;
            }
            
            if($order['deliver_type'] == 1){
                $order_goods = Db::name("bbfx_order_goods")->where(['uniacid'=>UNIACID,'order_id'=>$order['id']])->select();
            }
            else{
                $order_goods = Db::name("bbfx_order_goods")->where(['uniacid'=>UNIACID,'order_id'=>$order['id']])->select();
                $order_goods = array_skey($order_goods,"goods_id");
            }
            
            if(empty($express)){
                $goods = iunserializer($order_goods[0]['goods_info']);
                
                $goods_name = mb_substr($goods['title'],0,20);
                $data = array(
                    "order_no"=>$order['order_no'],
                    "goods_name"=>$goods_name,
                    "express"=>'',
                    "express_no"=>'',
                    "date"=>date("Y-m-d H:i:s"),
                    "createtime"=>date("Y-m-d H:i:s",$order['createtime'])
                );
                
                $tpl_data = self::replaceTplData("shippingnotice_tid",$data,$user['platform']);
                if($user['platform'] == 'GZH'){

                    if(empty($gzh_template_msg['shippingnotice_tid']['tid'])) return false;
                    
                    $data = [
                        'touser'=>$user['openid'],
                        'template_id'=>$gzh_template_msg['shippingnotice_tid']['tid'],
                        'url'=>request()->domain()."/mobile/#/pages/index/index?i=".UNIACID,
                        // 'miniprogram'=>[
                        //     'appid'=>'',
                        //     'pagepath'=>''
                        // ],
                        'data'=>$tpl_data
                    ];

                    $result = self::sendTemplateMessage($data); 
                }
                else{

                    if(empty($subscribemsg['shippingnotice_tid']['tid'])) return false;

                    $data = array(
                        "template_id"=>$subscribemsg['shippingnotice_tid']['tid'],
                        "touser"=>$user['openid'],
                        "page"=>"/pages/index/index",
                        "miniprogram_state"=>self::$miniprogram_state,
                        "data"=>$tpl_data
                    );

                    $result = self::sendMessage($data); 
                    if($result['errcode'] === 0){
                        self::setSubscribeNum($user['id'],$subscribemsg['shippingnotice_tid']['tid'],'shippingnotice_tid');
                    }
                }
                
            }
            else{
                $result = [];
                foreach ($express as $key => $val){
                    if($order['deliver_type'] == 1){
                        $goods = iunserializer($order_goods[0]['goods_info']);
                    }
                    else{
                        $goods = iunserializer($order_goods[$val['goods_id']]['goods_info']);
                    }
                    
                    $express_data = Db::name("bbfx_express")->where(['id'=>$val['express_id']])->find();
                    $goods_name = mb_substr($goods['title'],0,20);
                    $data = array(
                        "order_no"=>$order['order_no'],
                        "goods_name"=>$goods_name,
                        "express"=>$express_data['name'],
                        "express_no"=>$val['express_no'],
                        "date"=>date("Y-m-d H:i:s"),
                        "createtime"=>date("Y-m-d H:i:s",$order['createtime'])
                    );
                    
                    $tpl_data = self::replaceTplData("shippingnotice_tid",$data,$user['platform']);
                    if($user['platform'] == 'GZH'){
                        if(empty($gzh_template_msg['shippingnotice_tid']['tid'])) continue;
                        
                        $data = [
                            'touser'=>$user['openid'],
                            'template_id'=>$gzh_template_msg['shippingnotice_tid']['tid'],
                            'url'=>request()->domain()."/mobile/#/pages/index/index?i=".UNIACID,
                            // 'miniprogram'=>[
                            //     'appid'=>'',
                            //     'pagepath'=>''
                            // ],
                            'data'=>$tpl_data
                        ];

                        $result[] = self::sendTemplateMessage($data); 
                    }
                    else{
                        if(empty($subscribemsg['shippingnotice_tid']['tid'])) continue;

                        $data = array(
                            "template_id"=>$subscribemsg['shippingnotice_tid']['tid'],
                            "touser"=>$user['openid'],
                            "page"=>"/pages/index/index",
                            "miniprogram_state"=>self::$miniprogram_state,
                            "data"=>$tpl_data
                        );

                        $res = self::sendMessage($data); 
                        if($res['errcode'] === 0){
                            self::setSubscribeNum($user['id'],$subscribemsg['shippingnotice_tid']['tid'],'shippingnotice_tid');
                        }
                        $result[] = $res;
                    }
                    
                    
                }
            }
            
            return $result;
        }

        // 签到通知
        public static function sendSigninRemindMsg($record_id,$base = []){
            global $_W;
            
            if(empty($base)){
                $base = $_W['base'];
            }
            
            $subscribemsg = $base['subscribemsg'];
            $gzh_template_msg = $base['gzh_template_msg'];

            $record = Db::name("bbfx_signin_record")->where(['id'=>$record_id])->find();
            if(empty($record)){
                return false;
            }
            $user = Db::name("bbfx_user")->where(['id'=>$record['user_id']])->find();
            
            if((empty($subscribemsg['signin_remind_tid']['tid']) && empty($gzh_template_msg['signin_remind_tid']['tid'])) || empty($user) || !in_array($user['platform'],['WXAPP','GZH'])){
                return false;
            }
            
            $data = array(
                "name"=>$record['title'],
                "date"=>$record['date'],
                "continuity_signin_day"=>$user['continuity_signin_day'],
                "total_signin_day"=>$user['total_signin_day'],
                "signin_reward"=>$record['total']
            );
            
            $tpl_data = self::replaceTplData("signin_remind_tid",$data,$user['platform']);

            if($user['platform'] == 'GZH'){

                if(empty($gzh_template_msg['signin_remind_tid']['tid'])) return false;

                $data = [
                    'touser'=>$user['openid'],
                    'template_id'=>$gzh_template_msg['signin_remind_tid']['tid'],
                    'url'=>request()->domain()."/mobile/#/pages/index/index?i=".UNIACID,
                    // 'miniprogram'=>[
                    //     'appid'=>'',
                    //     'pagepath'=>''
                    // ],
                    'data'=>$tpl_data
                ];

                $result = self::sendTemplateMessage($data); 
            }
            else{

                if(empty($subscribemsg['signin_remind_tid']['tid'])) return false;

                $data = array(
                    "template_id"=>$subscribemsg['signin_remind_tid']['tid'],
                    "touser"=>$user['openid'],
                    "page"=>"/pages/index/index",
                    "miniprogram_state"=>self::$miniprogram_state,
                    "data"=>$tpl_data
                );

                $result = self::sendMessage($data); 

                if($result['errcode'] === 0){
                    self::setSubscribeNum($user['id'],$subscribemsg['signin_remind_tid']['tid'],'signin_remind_tid');
                }
            }

            return $result;
        }
        
        public static function getVariableList($tpl = ""){
            
            $data = array(
                "outofstock_tid"=>array(
                    array("val"=>"[[商品名称]]","title"=>"商品名称","key"=>"goods_name"),
                    array("val"=>"[[剩余库存]]","title"=>"剩余库存","key"=>"stock"),
                    array("val"=>"[[提醒时间]]","title"=>"提醒时间","key"=>"date")
                ),
                "xiadan_tid"=>array(
                    array("val"=>"[[订单编号]]","title"=>"订单编号","key"=>"order_no"),
                    array("val"=>"[[商品名称]]","title"=>"商品名称","key"=>"goods_name"),
                    array("val"=>"[[商品数量]]","title"=>"商品数量","key"=>"num"),
                    array("val"=>"[[订单状态]]","title"=>"订单状态","key"=>"status"),
                    array("val"=>"[[订单金额]]","title"=>"订单金额","key"=>"price"),
                    array("val"=>"[[下单时间]]","title"=>"下单时间","key"=>"date")
                ),
                "shippingnotice_tid"=>array(
                    array("val"=>"[[订单编号]]","title"=>"订单编号","key"=>"order_no"),
                    array("val"=>"[[商品名称]]","title"=>"商品名称","key"=>"goods_name"),
                    array("val"=>"[[物流公司]]","title"=>"物流公司","key"=>"express"),
                    array("val"=>"[[物流单号]]","title"=>"物流单号","key"=>"express_no"),
                    array("val"=>"[[发货时间]]","title"=>"发货时间","key"=>"date"),
                    array("val"=>"[[下单时间]]","title"=>"下单时间","key"=>"createtime")
                ),
                "updatenotice_tid"=>array(
                    array("val"=>"[[更新时间]]","title"=>"更新时间","key"=>"date")
                ),
                "signin_remind_tid"=>array(
                    array("val"=>"[[签到名称]]","title"=>"签到名称","key"=>"name"),
                    array("val"=>"[[签到日期]]","title"=>"签到日期","key"=>"date"),
                    array("val"=>"[[连续签到]]","title"=>"连续签到","key"=>"continuity_signin_day"),
                    array("val"=>"[[累计签到]]","title"=>"累计签到","key"=>"total_signin_day"),
                    array("val"=>"[[签到奖励]]","title"=>"签到奖励","key"=>"signin_reward"),
                ),
                "message_center_tid"=>array(
                    array("val"=>"[[通知标题]]","title"=>"通知标题","key"=>"title"),
                    array("val"=>"[[通知内容]]","title"=>"通知内容","key"=>"content"),
                    array("val"=>"[[通知时间]]","title"=>"通知时间","key"=>"time"), 
                ),
            );
            
            if(empty($tpl)){
                return $data;
            }
            
            return $data[$tpl];
        }
        
        // 替换数据
        public static function replaceTplData($tpl,$data,$platform='WXAPP'){
            global $_W;
            
            $base = $_W['base'];
            
            if($platform == 'GZH'){
                $subscribemsg = iunserializer($base['gzh_template_msg']);
            }
            else{
                $subscribemsg = iunserializer($base['subscribemsg']);
            }

            
            if(empty($subscribemsg[$tpl]) || empty($subscribemsg[$tpl]['content'])){
                return false;
            }
            
            $template_content = $subscribemsg[$tpl]['content'];
            $template_list = [];
            foreach ($template_content as $k => $v){
                $template_list[$v['key']] = array(
                    "value"=>$v['val']
                );
            }
            
            $variableList = self::getVariableList($tpl);
            
            
            foreach ($template_list as $k1 => &$v1){
                foreach ($variableList as $k2 => $v2){
                    $v1['value'] = str_replace($v2['val'],$data[$v2['key']],$v1['value']);
                }
            }
            unset($v1);
            
            return $template_list;
        }
        
        //发送小程序订阅消息
        public static function sendMessage($data){
            $result = Weixin::getAccessToken();
            if($result['code'] != 1){
                return false;
            }
            $access_token = $result['data'];
            $api_url = "https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token=".$access_token;
             
            $data = urldecode(json_encode($data));
            $result = ihttp_post($api_url,$data); 
            return json_decode($result['content'],true);
        }

        // 发送公众模板消息
        public static function sendTemplateMessage($data){
            $result = Weixin::getWxAccessToken();
            if($result['code'] != 1){
                return $result;
            }
            $access_token = $result['data'];
            $api_url = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=".$access_token;
            $data = urldecode(json_encode($data));
            $result = ihttp_post($api_url,$data); 
            $result = json_decode($result['content'],true);
            if($result['errcode'] === 0){
                return __json(1,'发送成功',$result);
            }
            else{
                return __json(0,$result['errmsg'],$result);
            }
        } 
        
        // 小程序统一消息（公众号消息）（已废弃）
        public static function sendUnifiedMessage($openid, $template_id, $template_data, $path = 'pages/index/index'){
            global $_W;
            $base = $_W['base'];
            $platform = $_W['platform'];
            
            $APPID = $platform['wxapp_AppId'];
            $SECRET = $platform['wxapp_AppSecret'];
            
            $result = Weixin::getAccessToken();
            if($result['code'] != 1){
                return false;
            }
            $access_token = $result['data']; 
            
            $message_data = array(
                'touser'=>$openid,
                'mp_template_msg'=>array(
                    'appid' => $base['wx_appid'],
                    'template_id' => $template_id,
                    'url' => $base['wx_domain'],
                    'miniprogram' => [
                        'appid' => $APPID,
                        'pagepath' => $path
                    ],
                    'data' => $template_data
                )
            );
            
            $url = "https://api.weixin.qq.com/cgi-bin/message/wxopen/template/uniform_send?access_token=" . $access_token;
            $message_data = urldecode(json_encode($message_data)); 
            $result = ihttp_post($url,$message_data);
            $result = json_decode($result['content'],true);
            
            return $result;
        }
        
        public static function getAdmin($base){
            global $_W;
            $base = $_W['base'];
            
            $admin = explode(",",$base['admin']);
            $user = Db::name("bbfx_user")->where(['id'=>['in',$admin],'platform'=>['in',['WXAPP','GZH']]])->field(['id','openid','platform'])->select();
            
            return $user;
        }

        public static function setSubscribeNum($user_id,$tid,$tid_name){
            $where = ['uniacid'=>UNIACID,'user_id'=>$user_id,'tid'=>$tid,'tid_name'=>$tid_name];

            try {
                Db::name("bbfx_user_wxapp_subscribe")->where($where)->setDec("num",1);
            } catch (\Exception $e) {
                return __json(0,$e->getMessage());
            }

            return __json(1,'操作成功');
        }
    }
?>