<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\common\model\bbfxshop;

use think\Model;
use think\Db;
use app\common\model\bbfxshop\User;
use app\common\model\bbfxshop\Coupon;
use app\common\model\bbfxshop\Fenxiao;

class Card extends Model
{
    public static function getSet(){
        global $_W;
        $base = $_W['base'];
        if(empty($base)){
            $base = \app\common\model\bbfxshop\Common::getConfig(true);
        }
        
        return $base;
    }
    
    public static function getType($type){
        $list = ['30'=>'月卡','90'=>'季卡','365'=>'年卡'];
        
        if(empty($list[$type])){
            return "未知状态";
        }
        
        return $list[$type];
    }
    
    public static function getUserCard($user_id){
        $card = Db::name("bbfx_member_card_order")->alias("a")->join("bbfx_member_card b","a.member_card_id = b.id")->where(['a.uniacid'=>UNIACID,'a.user_id'=>$user_id])->where(function($query){
        	$whereOr = [];
        	$whereOr['a.endtime'] = ['>',time()];
        	
        	$query->whereOr($whereOr);
        	$whereOr['a.endtime'] = -1;
        	$query->whereOr($whereOr);
        })->order("b.sort desc,b.id desc,a.id desc")->field("a.endtime,b.*")->find();
        
        if(empty($card)){
            return false;
        }
        
        return $card;
    }
    
    // 支付回调
    public static function payResult($order_no,$paytype=0){
        
        $order = Db::name("bbfx_member_card_order")->where(['uniacid'=>UNIACID,'order_no'=>$order_no])->find();
        if(empty($order)){
            return false;
        }
        
        $res = Db::name("bbfx_member_card_order")->where(['id'=>$order['id']])->update(['status'=>1]);
        if(empty($res)){
            return false;
        }
        
        Db::name("bbfx_member_card_order")->where(['id'=>$order['id']])->update(['paytype'=>$paytype,'paytime'=>time()]);
        
        $card = Db::name("bbfx_member_card")->where(['id'=>$order['member_card_id']])->find();
        if(!empty($card)){
            
            if($card['yx_day'] != -1){
                $endtime = time() + $card['yx_day'] * 86400;
            }
            else{
                $endtime = -1;
            }
            
            Db::name("bbfx_member_card_order")->where("id",$order['id'])->update(['endtime'=>$endtime]);
            
            $give = iunserializer($card['give']);
            $give_coupon = iunserializer($card['give_coupon']);
            $give_score = intval($card['give_score']);
            if(in_array(1,$give) && $give_score > 0){
                $result = User::setUserMoney($order['user_id'],$give_score,2,21,"会员卡赠送");
            }
            if(in_array(2,$give) && !empty($give_coupon)){
                foreach ($give_coupon as $key => $val){
                    Coupon::receive($val['id'],[$order['user_id']],2);
                }
            }
        }
        
        Fenxiao::setJiesuanStatus($order['id'],1);
        // 分销升级
        \app\common\model\bbfxshop\FenxiaoUpgrade::upgrade($order['user_id']);
        Fenxiao::setJiesuanCommission($order['id'],1);
        // 贡献值结算
        \app\common\model\bbfxshop\Contribution::settlement($order,1);
        // 录入发货信息
        \app\common\model\bbfxshop\Shipping::upload($order['id'],3);

        return true;
    }
    
    // 三级分销佣金
    public static function setOrdinaryCommission($user_id,$order,$levels=[]){
        
        $user = User::getInfo($user_id);
        if(empty($user)){
           return false; 
        }
        $config = self::getSet()['fenxiao'];
        $one_user = $user;
        $level = intval($config['level']);
        
        if($level <= 0){
            return false;
        }
        
        if(empty($levels)){
            $levels = Fenxiao::getLevels();
        }
        
        $commissionSets = self::getCommissionSet($order,$levels);
        
        $data = array(
            "uniacid"=>UNIACID,
            "order_id"=>$order['id'],
            "goods_id"=>$order['member_card_id'],
            "xd_uid"=>$order['user_id'],
            "order_type"=>1,
            "is_daozhang"=>0,
            "createtime"=>time()
        );
        
        $commissionSet = $commissionSets[$one_user['level']];
        $price = $order['price'];
        $commission_ok = 0;
        
        if($one_user){
            Db::name("bbfx_member_card_order")->where(["uniacid"=>UNIACID,"id"=>$order['id']])->update(["one_share"=>$one_user['id']]);
            $commission1 = floatval($commissionSet['commission1']);
            
            if($one_user['is_distributor'] != 1 || $one_user['distributor_status'] != 1){
                $commission1 = 0;
            }
            $commission_ok = $commission1;
            
            if($commission1 > 0){
               $data['user_id'] = $one_user['id'];
                $data['type'] = 1;
                $data['money'] = $commission1;
                $data['level'] = $one_user['level'];
                $is_existenceCommission = Fenxiao::is_existenceCommission1(['order_id'=>$data['order_id'],'type'=>$data['type'],'order_type'=>$data['order_type']]);
                if(empty($is_existenceCommission)){
                    Db::name("bbfx_fenxiao_order")->insert($data);
                }
            }
            else{
                $commission1 = 0;
            }
        }
        
        if($level >= 2 && $one_user['sup_uid']){
            $two_user = User::getInfo($one_user['sup_uid']);
            
            if(!empty($two_user)){
                Db::name("bbfx_member_card_order")->where(["uniacid"=>UNIACID,"id"=>$order['id']])->update(["two_share"=>$two_user['id']]);
                $commission2 = floatval($commissionSets[$two_user['level']]['commission2']);
                
                if($two_user['is_distributor'] != 1 || $two_user['distributor_status'] != 1){
                    $commission2 = 0;
                }
                
                if($config['level_jicha'] == 1){
                    if($commission2 - $commission_ok < 0){
                        $commission2 = 0;
                    }
                    else{
                        $commission2 = round($commission2 - $commission_ok,2);
                        $commission_ok = $commission2;
                    }
                }
                
                if($commission2 > 0){
                    $data['user_id'] = $two_user['id'];
                    $data['type'] = 2;
                    $data['money'] = $commission2;
                    $data['level'] = $two_user['level'];
                    $is_existenceCommission = Fenxiao::is_existenceCommission1(['order_id'=>$data['order_id'],'type'=>$data['type'],'order_type'=>$data['order_type']]);
                    if(empty($is_existenceCommission)){
                        Db::name("bbfx_fenxiao_order")->insert($data);
                    }
                }
                
            }
        }
        
        if($level >= 3 && $two_user['sup_uid']){
            $three_user = User::getInfo($two_user['sup_uid']);
            if(!empty($three_user)){
                $commission3 = floatval($commissionSets[$two_user['level']]['commission3']);
                Db::name("bbfx_member_card_order")->where(["uniacid"=>UNIACID,"id"=>$order['id']])->update(["three_share"=>$three_user['id']]);
                if($three_user['is_distributor'] != 1 || $three_user['distributor_status'] != 1){
                    $commission3 = 0;
                }
                
                if($config['level_jicha'] == 1){
                    if($commission3 - $commission_ok < 0){
                        $commission3 = 0;
                    }
                    else{
                        $commission3 = round($commission3 - $commission_ok,2);
                        $commission_ok = $commission3;
                    }
                }
                
                if($commission3 > 0){
                    $data['user_id'] = $three_user['id'];
                    $data['type'] = 3;
                    $data['money'] = $commission3;
                    $data['level'] = $three_user['level'];
                    $is_existenceCommission = Fenxiao::is_existenceCommission1(['order_id'=>$data['order_id'],'type'=>$data['type'],'order_type'=>$data['order_type']]);
                    if(empty($is_existenceCommission)){
                        Db::name("bbfx_fenxiao_order")->insert($data);
                    }
                }
                
            }
        }
    }
    
    // 获取会员卡提成配置
    public static function getCommissionSet($order,$levels){
        $data = [];
        $config = self::getSet()['fenxiao'];
        $price = floatval($order['price']);
        
        $card = iunserializer($order['info']);
        foreach ($levels as $key => $val){
            $commission1_set = iunserializer($card['commission1']);
            $commission2_set = iunserializer($card['commission2']);
            $commission3_set = iunserializer($card['commission3']);
            $total = 1;
            if($card['commission_rule'] == 1){
                $money1 = floatval($commission1_set['level']['money1']);
                $commission1 = floatval($commission1_set['level']['money2']) * $total;
                if($money1 > 0){
                    $commission1 = ($money1 / 100) * $price;
                }
                
                
                $money1 = floatval($commission2_set['level']['money1']);
                $commission2 = floatval($commission2_set['level']['money2']) * $total;
                if($money1 > 0){
                    $commission2 = ($money1 / 100) * $price;
                }
                
                $money1 = floatval($commission2_set['level']['money1']);
                $commission3 = floatval($commission2_set['level']['money2']) * $total;
                if($money1 > 0){
                    $commission3 = ($money1 / 100) * $price;
                }
            }
            else if($card['commission_rule'] == 2){
                $commission1 = floatval($commission1_set['grade']['level'.$val['id']]) * $total;
                $score_commission1 = floatval($commission1_set['grade']['score_level'.$val['id']]) * $total;
                if($score_commission1 > 0){
                    $commission1 = $score_commission1;
                }
                $commission2 = floatval($commission2_set['grade']['level'.$val['id']]) * $total;
                $commission3 = floatval($commission3_set['grade']['level'.$val['id']]) * $total;
            }
            else{
                $commission1 = (floatval($val['commission1']) / 100) * $price;
                $commission2 = (floatval($val['commission2']) / 100) * $price;
                $commission3 = (floatval($val['commission3']) / 100) * $price;
            }
            
            if($config['level'] <= 0) $commission1 = 0;
            if($config['level'] <= 1) $commission2 = 0;
            if($config['level'] <= 2) $commission3 = 0;
            
            $data[$val['id']] = array(
                "id"=>(int)$val['id'],
                "maxLevel"=>$val['maxLevel'],
                "commission1"=>$commission1, 
                "commission2"=>$commission2,
                "commission3"=>$commission3
            );
        }
        
        return $data;
    }
}