<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/
namespace app\common\model\bbfxshop;


// vendor('oss.autoload');
// require ROOT_PATH . "vendor/oss/autoload.php";
// require ROOT_PATH . "vendor/aliyun-oss-php/autoload.php";
use think\Db;
use aliyun\OSS\OssClient;
use aliyun\OSS\Core\OssException;

class AliyunOss
{
    protected static $config = [];
    
    public static function getSet(){
        global $_W;
        if(empty(self::$config)){
            $config = $_W['base']['data']['aliyun_oss'];
            self::$config = $config;
        }
        return self::$config;
    }
    // 设置存储空间的读写权限
    public static function putBucketAcl(){
        $config = self::getSet();
        $accessKeyId = $config['AccessKeyID'];
        $accessKeySecret = $config['AccessKeySecret'];
        $endpoint = "https://".$config['Endpoint'];
        $bucket= $config['BucketName'];
        $bucket = "dianwoshangcheng";
        
        // $acl = OssClient::OSS_ACL_TYPE_PRIVATE;// 私有
        $acl = OssClient::OSS_ACL_TYPE_PUBLIC_READ;// 公共读
        // $acl = OssClient::OSS_ACL_TYPE_PUBLIC_READ_WRITE;// 公共读写
        try {
            $ossClient = new OssClient($accessKeyId, $accessKeySecret, $endpoint);
            $res = $ossClient->putBucketAcl($bucket, $acl);
            $result = __json(1,'设置存储空间权限成功');
        } 
        catch (OssException $e) {
            $result = __json(0,$e->getMessage());
        }
        
        return $result;
    }
    // 创建Bucket名称
    public static function createBucket(){
        $config = self::getSet();
        $accessKeyId = $config['AccessKeyID'];
        $accessKeySecret = $config['AccessKeySecret'];
        $endpoint = "https://".$config['Endpoint'];
        $bucket= $config['BucketName'];
        // $bucket = "dianwoshangcheng";
        
        try {
            $ossClient = new OssClient($accessKeyId, $accessKeySecret, $endpoint);
            // return __json(0,'操作失败');
            $res = $ossClient->createBucket($bucket);
            $result = __json(1,'创建存储空间成功');
        } catch (OssException $e) {
            $result = __json(0,$e->getMessage());
        }
        // print_r($res);die;
        
        if($result['code'] == 1){
            self::putBucketAcl();
        }
        
        return $result;
    }
    
    // 删除文件
    public static function deleteObjects($files){
        $config = self::getSet();
        $accessKeyId = $config['AccessKeyID'];
        $accessKeySecret = $config['AccessKeySecret'];
        
        $endpoint = "https://".$config['Endpoint'];
        $bucket= $config['BucketName'];
        
        try {
           $ossClient = new OssClient($accessKeyId, $accessKeySecret, $endpoint, false);
           // 填写需要删除的多个文件完整路径。文件完整路径中不能包含Bucket名称。
        //   $objects = array();
        //   $objects[] = "exampleobjecta.txt";
        //   $objects[] = "exampledir/sampleobject.txt";
           $result = $ossClient->deleteObjects($bucket, $files);
        
        //   foreach ($result as $info){
        //       $obj = strval($info);
        //       printf("Delete ".$obj." : Success" . "\n");
        //   }
           
           $result = __json(1,'删除成功');
        } catch (OssException $e) {
           $result = __json(0,$e->getMessage());
        }        
    }
    
    public static function upload($file){
        $config = self::getSet();
        
        if($config['status'] != 1){
            return __json(0,'未开启云存储');   
        }
        
        $accessKeyId = $config['AccessKeyID'];
        $accessKeySecret = $config['AccessKeySecret'];
        
        $endpoint = "https://".$config['Endpoint'];
        $bucket= $config['BucketName'];
        
        // 填写Object完整路径，例如exampledir/exampleobject.txt。Object完整路径中不能包含Bucket名称。
        $arr = explode("/",$file);
        
        if(empty($arr[0])){
            unset($arr[0]);
            $object = implode("/",$arr);
        }
        else{
            $object = $file;
        }
        $filePath = ROOT_PATH."public".$file;
        try{
            $ossClient = new OssClient($accessKeyId, $accessKeySecret, $endpoint);
            $res = $ossClient->uploadFile($bucket, $object, $filePath);
            $fileurl = "https://".$config['BucketName'].".".$config['Endpoint'].$file;
            $result = __json(1,'上传成功',['url'=>$fileurl]);
        } catch(OssException $e) {
            $result = __json(0,$e->getMessage());
        }
        if($result['code'] == 1){
            $url = $config['BucketName'].".".$config['Endpoint'];
            Db::name("attachment")->where(['url'=>$file])->update(['oss_domain'=>$url]);
            if(file_exists($filePath)) {
                unlink($filePath);
            }
        }
        // echo "<pre>";
        // print_r($res);
        return $result;
    }
}