<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\common\model\bbfxshop;

use think\Model;
use think\Db;
use app\common\model\bbfxshop\User;
use app\common\model\bbfxshop\Order;

class Activity extends Model
{
    public static function getSet(){
        global $_W;
        $base = $_W['base'];
        if(empty($base)){
            $base = \app\common\model\bbfxshop\Common::getConfig(true);
        }
        
        return $base['activity'];
    }

    public static function baomingPayResult($order_no,$paytype=0){
        $order = Db::name("bbfx_activity_baoming")->where(['uniacid'=>UNIACID,'order_no'=>$order_no])->find();
        if(empty($order)){
            return __json(0,"未查询到订单");
        }
        
        $res = Db::name("bbfx_activity_baoming")->where(['id'=>$order['id']])->update(['is_pay'=>1]);
        if(empty($res)){
            return __json(0,"修改支付状态失败");
        }
        
        $odata = ['paytype'=>$paytype,'paytime'=>time()];
        $pay_order = Db::name("bbfx_pay_order")->where(['uniacid'=>UNIACID,'order_type'=>8,'order_no'=>$order_no])->find();
        if($pay_order['price'] < $order['price']){
            $odata['balance'] = round($order['baoming_fee'] - $pay_order['price'],2);
            User::setUserMoney($order['user_id'],-$odata['balance'],1,1,"报名支付",$order);
        }

        if($order['baoming_fee'] <= 0){
            $odata['jiesuan_status'] = 1;
            $odata['jiesuan_time'] = time();
        }
        
        Db::name("bbfx_activity_baoming")->where(['id'=>$order['id']])->update($odata);
        
        return __json(1,"操作成功");
    }
    public static function task(){
        
        try {
            self::jiesuan();
        } catch (\Exception $e) {
            return __json(0,$e->getMessage()." ".$e->getLine());
        }

        return __json(1,"操作成功");
    }
    
    public static function jiesuan(){
        $set = self::getSet();
        if($set['status'] != 1){
            return __json(0,"未开启活动");
        }
        
        $where = ['b.uniacid'=>UNIACID,'a.jiesuan_status'=>0,'a.is_pay'=>1,'a.baoming_fee'=>['>',0],'b.endtime'=>['<',time()]];
        $list = Db::name("bbfx_activity_baoming")->alias("a")->join("bbfx_activity_list b","a.activity_id=b.id","LEFT")->where($where)->field("a.*,b.pid as activity_user_id")->select();
        if(empty($list)){
            return __json(0,"没有待结算记录");
        }
        
        // echo "<pre>";
        // print_r($list);die;
        $remarks = "报名费结算";
        foreach($list as $k => $order){
            $res = Db::name("bbfx_activity_baoming")->where(['id'=>$order['id']])->update(['jiesuan_status'=>1]);
            if($res){
                Db::name("bbfx_activity_baoming")->where(['id'=>$order['id']])->update(['jiesuan_time'=>time()]);
                $money = round($order['baoming_fee'],2);
                if($money > 0){
                    User::setUserMoney($order['activity_user_id'],$money,1,44,$remarks,$order);
                }
            }
            
        }

        return __json(1,"操作成功");
    }

    public static function hexiao($params){
        $type = $params["type"];
        $baoming_id = $params["baoming_id"];
        $code = $params["code"];
        $user_id = $params["user_id"];
        if($type == 1){
            $baoming = Db::name("bbfx_activity_baoming")->where(['uniacid'=>UNIACID,'hexiao_code'=>$code])->find();
            if(empty($baoming)){
                return __json(0,"核销码错误");
            }
        }
        else{
            $baoming = Db::name("bbfx_activity_baoming")->where(['uniacid'=>UNIACID,'id'=>$baoming_id])->find();
            if(empty($baoming)){
                return __json(0,"报名记录不存在");
            }
        }

        $activity = Db::name("bbfx_activity_list")->where(['id'=>$baoming['activity_id']])->find();
        if(empty($activity)){
            return __json(0,"活动信息错误");
        }

        if(!empty($user_id) && $user_id != $activity['pid']){
            return __json(0,"活动信息错误");
        }

        if($baoming['hexiao_status'] == 1){
            return __json(0,"该报名记录已核销");
        }

        $res = Db::name("bbfx_activity_baoming")->where(['id'=>$baoming['id']])->update(['hexiao_status'=>1]);
        if($res){

            Db::name("bbfx_activity_baoming")->where(['id'=>$baoming['id']])->update(['hexiao_time'=>time()]);

            return __json(1,"核销成功");
        }
        else{
            return __json(0,"核销失败");
        }
    }
}