<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\common\model;

use think\Model;

class QRcode
{

    public static function create($text,$filename,$level='3',$size='8'){
        
        try {

            $path = ROOT_PATH.'public/data/qr';
            if(!file_exists($path)){
                mkdir($path); 
            }

            vendor('phpqrcode.phpqrcode');
            $errorCorrectionLevels = ['1'=>'L','2'=>'M','3'=>'Q','4'=>'H']; // 容错级别：L、M、Q、H
            $errorCorrectionLevel = $errorCorrectionLevels[$level];
            if(empty($errorCorrectionLevel)){
                $errorCorrectionLevel = "Q";
            }
            
            $matrixPointSize = "8"; // 点的大小：1到10
            if(empty($size)){
                $matrixPointSize = "8";
            }
            
            //实例化
            $qr = new \QRcode();
            
            $filename = "/data/qr/".$filename.".png";
            
            $qr::png($text, ROOT_PATH."public".$filename, $errorCorrectionLevel, $matrixPointSize);
            
            $result = __json(1,"操作成功",['url'=>$filename]);
        } 
        catch (\Exception $e) {
            $result = __json(0,$e->getMessage());
        }
        
        return $result;
    }
}