<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\user;

use app\api\controller\Base;
use think\Db;


class Cart extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\User;
    }

    public function index(){
        $params = $this->param();
        
        $merchant = Db::name("bbfx_merchant")->where(['is_shenhe'=>1,'status'=>1])->field("id,name,logo")->select();
        $where = ['uniacid'=>UNIACID,'user_id'=>$this->user['id']];
        $mids = [];
        if(!empty($merchant)){
            $mids = array_column($merchant,"id");
            $merchant = array_skey($merchant,"id");
        }
        $mids[] = 0;
        $where['mid'] = ['in',$mids];
        
        $carts = Db::name("bbfx_user_cart")->where($where)->order("mid asc,id desc")->select();
        
        $list = [];
        $total_price = 0;
        $mid = 0;
        foreach ($carts as $key => $val){
            $goods = Db::name("bbfx_goods")->where(['id'=>$val['goods_id'],'status'=>1])->field("id,title,thumb,stock,price,unit,o_price,is_spec,createtime")->find();
            if(!empty($goods)){
                $sku_id = intval($val['sku_id']);
                if($sku_id > 0){
                    $sku = Db::name("bbfx_goods_spec_sku")->where("id",$sku_id)->find();
                    if(empty($sku) || $goods['is_spec'] != 1){
                        continue;
                    }
                    $goods['stock'] = $sku['stock'];
                    $goods['price'] = $sku['price'];
                    $val['sku'] = $sku;
                }
                
                $goods['thumb'] = cdnurl($goods['thumb']);
                $val['goods'] = $goods;
                $total_price += $goods['price'] * $val['total'];
                
                if($mid != $val['mid']){
                    $val['merchant'] = $merchant[$val['mid']];
                    $val['merchant']['logo'] = cdnurl($val['merchant']['logo']);
                }
                
                $mid = $val['mid'];
                $list[] = $val; 
            }
        }
        
        __success("操作成功",['list'=>$list,'total_price'=>round($total_price,2)]);
    }
    
    public function add(){
        global $_W;
        $params = $this->param();
        
        $goods_id = intval($params['goods_id']);
        $sku_id = intval($params['sku_id']);
        $total = max(1,intval($params['total']));
        $goods = Db::name("bbfx_goods")->where(['id'=>$goods_id,'status'=>1])->find();
        if(empty($goods)){
            __error("商品不存在或已下架");
        }
        
        if($goods['type'] == 1 || $goods['type'] == 4){
            __error("虚拟商品不能加入购物车");
        }
        if($goods['type'] == 3){
            __error("核销商品不能加入购物车");
        }
        if($goods['type'] == 2 && $goods['delivery_method'] == 2 && $goods['hexiao_num'] > 1){
            __error("多次核销商品不可加入购物车");
        }
        $plugin = iunserializer($goods['plugin']);
        if($plugin['form']['status'] == 1){
            __error("商品已开启表单提交不可加入购物车");
        }
        
        $set = $_W['base'];
        
        $cw_goods = explode(",",(string)$set['cloud_warehouse']['cw_goods']);
        if($set['cloud_warehouse']['status'] == 1 && in_array($goods['id'],$cw_goods)){
            __error("云仓商品不能加入购物车");
        }
        
        $user = $this->user;
        $cart = Db::name("bbfx_user_cart")->where(['uniacid'=>UNIACID,'goods_id'=>$goods_id,'sku_id'=>$sku_id,'user_id'=>$user['id']])->find();
        
        if(empty($cart)){
            $data = array(
                "uniacid"=>UNIACID,
                "mid"=>$goods['mid'],
                "user_id"=>$user['id'],
                "goods_id"=>$goods_id,
                "sku_id"=>$sku_id,
                "total"=>$total
            );
            $res = Db::name("bbfx_user_cart")->insert($data);
        }
        else{
            $res = Db::name("bbfx_user_cart")->where(['id'=>$cart['id']])->setInc("total",$total);
        }
        
        if($res){
            __success("加入购物车成功");
        }
        else{
            __error("加入购物车失败");
        }
    }
    
    public function edit(){
        $params = $this->param();
        
        $id = intval($params['cart_id']);
        $sku_id = intval($params['sku_id']);
        $total = max(1,intval($params['total']));
        
        $user = $this->user;
        $cart = Db::name("bbfx_user_cart")->where(['uniacid'=>UNIACID,'id'=>$id,'user_id'=>$user['id']])->find();
        if(empty($cart)){
            __error("购物出数据不存在");
        }
        $goods = Db::name("bbfx_goods")->where(['id'=>$cart['goods_id'],'status'=>1])->find();
        if(empty($goods)){
            __error("商品不存在或已下架");
        }
        
        if($goods['type'] == 1 || $goods['type'] == 4){
            __error("虚拟商品不能加入购物车");
        }
        if($goods['type'] == 3){
            __error("核销商品不能加入购物车");
        }
        
        
        
        if($sku_id <= 0){
            $sku_id = $cart['sku_id'];
        }
        
        if($sku_id > 0){
            $sku = Db::name("bbfx_goods_spec_sku")->where("id",$sku_id)->find();
            if(empty($sku)){
                __error("规格不存在");
            }
            $stock = $sku['stock'];
        }
        else{
            $stock = $goods['stock'];
        }
        
        if($total > $stock){
            __error("库存不足");
        }
        
        $data = ['total'=>$total,'sku_id'=>$sku_id];
        
        $res = Db::name("bbfx_user_cart")->where("id",$cart['id'])->update($data);
        
        if($res){
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
    
    public function del(){
        $params = $this->param();
        
        $cart_ids = $params['cart_ids'];
        
        $user = $this->user;
        $res = Db::name("bbfx_user_cart")->where(['uniacid'=>UNIACID,'id'=>['in',$cart_ids],'user_id'=>$user['id']])->delete();
        
        if($res){
            __success("删除成功");
        }
        else{
            __error("删除失败");
        }
    }
}