<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\user;

use app\api\controller\Base;
use think\Db;


class Address extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\User;
    }
    
    public function list(){
        $params = $this->param();
        
        $list = Db::name("bbfx_user_address")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id']])->select();
        if(empty($list)){
            __error("暂无数据".$user['id']);
        }
        __success("操作成功",$list);
    }
    
    public function info(){
        $params = $this->param();
        $id = intval($params['id']);
        $info = Db::name("bbfx_user_address")->where(['id'=>$id])->find();
        if(empty($info)){
            __error("地址不存在");
        }
        __success("success",$info);
    }
    
    public function dinfo(){
        $params = $this->param();
        $id = intval($params['id']);
        $info = Db::name("bbfx_user_address")->where(['id'=>$id])->find();
        if(empty($info)){
            $info = Db::name("bbfx_user_address")->where(['user_id'=>$this->user['id'],'is_default'=>1])->find();
            if(empty($info)){
                $info = Db::name("bbfx_user_address")->where(['user_id'=>$this->user['id']])->find();
            }
        }
        if(empty($info)){
            __error("没有收货地址");
        }
        __success("success",$info);
    }
    
    public function del(){
        $params = $this->param();
        $id = intval($params['id']);
        $res = Db::name("bbfx_user_address")->where(['id'=>$id])->delete();
        if(empty($res)){
            __error("删除失败");
        }
        else{
            __success("删除成功");
        }
    }
    
    public function edit(){
        $params = $this->param();
        
        $user = $this->user;
        
        $id = intval($params['id']);
        $consignee = trim($params['consignee']);
        $phone = trim($params['phone']);
        $address = trim($params['address']);
        $region = $params['region'];
        $is_default = $params['is_default'];
        $is_default = (isset($is_default) && $is_default) ? '1' : '0';
        
        if(empty($consignee)){
            __error("请填写收货人");
        }
        if(empty($phone)){
            __error("请填写联系电话");
        }
        if(empty($region)){
            __error("请选择地区");
        }
        if(empty($address)){
            __error("请填写详细地址");
        }
        
        $data = array(
            "uniacid"=>UNIACID,
            "user_id"=>$user['id'],
            "is_default"=>$is_default,
            "consignee"=>$consignee,
            "phone"=>$phone,
            "province_name"=>$region[0],
            "city_name"=>$region[1],
            "area_name"=>$region[2],
            // "street_name"=>$region[3],
            "street_name"=>'',
            "address"=>$address
        );
        
        if(!empty($id)){
            $res = Db::name("bbfx_user_address")->where(['id'=>$id])->update($data);
        }
        else{
            
            $user_address = Db::name("bbfx_user_address")->where(['uniacid'=>UNIACID,'user_id'=>$user['id']])->find();
            if(empty($user_address)){
                $data['is_default'] = $is_default;
            }
            
            $id = Db::name("bbfx_user_address")->insertGetId($data);
            $res = $id;
        }
        
        if(empty($res)){
            __error("操作失败");
        }
        if($is_default == 1){
            Db::name("bbfx_user_address")->where(['user_id'=>$user['id'],'id'=>['neq',$id]])->update(['is_default'=>0]);
        }
        
        __success("操作成功");
    }
}