<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\smaterial;

use app\api\controller\Base;
use think\Db;

use function fast\e;

class Smaterial extends Base
{
    protected $noNeedLogin = ['*'];
    protected $noNeedRight = ['*'];

    public function getCategoryList(){
        $list = Db::name("bbfx_smaterial_category")->where(["uniacid"=>UNIACID,'pid'=>0])->order('sort desc')->select();
        foreach ($list as $key => &$val) {
    	    $val['image'] = cdnurl($val['image']);
    	    $val['level'] = 1;
    	    $child = Db::name("bbfx_smaterial_category")->where(["uniacid"=>UNIACID,'pid'=>$val['id']])->order('sort desc')->select();
    	    
    	    if(!empty($child)){
    	        foreach ($child as $k => &$v){
        	        $v['image'] = cdnurl($v['image']);
        	        $v['level'] = 2;
        	    }
        	    unset($v);
        	    
        	    $val['child'] = $child;
    	    }
    	}
    	unset($val);
      	
        __success('操作成功',['list'=>$list]);
    }

    public function getList(){
        $category_id = $this->param("category_id/d");
        $keyword = $this->param("keyword/s");
        $where = ['uniacid'=>UNIACID];
        if($category_id > 0){
            $where['category_id'] = $category_id;
        }
        if(!empty($keyword)){
            $where['title|content'] = ['like','%'.$keyword.'%'];
        }
        
        $list = Db::name("bbfx_smaterial_item")->where($where)->order("sort desc,id desc")->select();
        foreach ($list as $key => &$val) {
            $val['image'] = cdnurls(iunserializer($val['image']));
            $val['video'] = cdnurl($val['video']);
            $val['createtime'] = date('Y-m-d H:i:s',$val['createtime']);
            $val['category_name'] = Db::name("bbfx_smaterial_category")->where(['uniacid'=>UNIACID,'id'=>$val['category_id']])->value('title');
        }
        unset($val);
         
        __success("操作成功",['list'=>$list]);
    }

    public function detail(){
        $id = $this->param("id/d");
        $info = Db::name("bbfx_smaterial_item")->where(['id'=>$id])->find();
        if(!empty($info)){
            $info['image'] = cdnurls(iunserializer($info['image']));
            $info['video'] = cdnurl($info['video']);
            $info['createtime'] = date('Y-m-d H:i:s',$info['createtime']);
            __success("操作成功",['info'=>$info]);
        }
        else{
            __error("素材不存在");
        }
    }
}