<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\shuziren;

use app\api\controller\Base;
use think\Db;


class Shuziren extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];

    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Shuziren;
    }

    public function createVoice(){
        $title = $this->param("title/s");
        $voice_url = $this->param("voice_url/s");
        $result = $this->model->createVoice($this->user['id'],$voice_url,$title);
        __result($result);
    }

    public function deleteVoice(){
        $id = $this->param('id/d');
        $result = $this->model->deleteVoice($id,$this->user['id']);
        __result($result);
    }

    public function getVoiceList(){
        $result = $this->model->getVoiceList($this->user['id']);
        __result($result);
    }

    public function create(){
        $title = $this->param("title/s");
        $text = $this->param("text/s");
        $video_id = $this->param("video_id/d");
        $voice_id = $this->param("voice_id/d");
        $result = $this->model->create($this->user['id'],$title,$text,$video_id,$voice_id);
        __result($result);
    }

    public function getList(){
        $result = $this->model->getVideoList($this->user['id']);
        __result($result);
    }

    public function delVideo(){
        $id = $this->param('id/d');
        $item = Db::name("bbfx_shuziren_video")->where(['id'=>$id])->find();
        if(empty($item)){
            __error("数据不存在");
        }
        $res = Db::name("bbfx_shuziren_video")->where(['id'=>$id])->delete();
        if($res){
            $file = ROOT_PATH."public".replaceSiteroot($item['url']);
            unlink($file);
        }
        __success('操作成功');
    }

    public function createVideo(){
        $title = $this->param("title/s");
        $url = $this->param("url/s");

        if(empty($title)){
            __error("请输入视频标题");
        }
        if(empty($url)){
            __error("请上传视频");
        }
        if(!strstr($url, 'mp4') && !strstr($url, 'avi') && !strstr($url, 'mov')){
            __error("请上传mp4、avi、mov格式视频");
        }

        $data = [
            "uniacid"=>UNIACID,
            "user_id"=> $this->user["id"],
            "title"=>$title,
            "url"=> replaceSiteroot($url),
            "createtime"=>time()
        ];

        Db::name("bbfx_shuziren_video_tpl")->insert($data);

        __success("操作成功");
    }

    public function getVideoList(){
        $list = Db::name("bbfx_shuziren_video_tpl")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id']])->order('id desc')->select();
        foreach ($list as $k=>&$v){
            $v['createtime'] = date("Y-m-d H:i:s",$v['createtime']);
            $v['url'] = cdnurl($v['url']);
        }
        unset($v);
        __success("操作成功",['list'=>$list]);
    }

    public function deleteVideo(){
        $id = $this->param('id/d');
        $item = Db::name("bbfx_shuziren_video_tpl")->where(['id'=>$id])->find();
        if(empty($item)){
            __error("数据不存在");
        }
        $res = Db::name("bbfx_shuziren_video_tpl")->where(['id'=>$id])->delete();
        if($res){
            $file = ROOT_PATH."public".replaceSiteroot($item['url']);
            unlink($file);
        }
        __success('操作成功');
    }
}