<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\scoreshop;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;
use app\common\model\bbfxshop\Order as OrderModel;


class Order extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Scoreshop;
    }
    
    // 物流查询
    public function queryExpressDelivery(){
        $params = $this->param();
        
        $id = intval($params['id']);
        $user = $this->user;
        $order = Db::name("bbfx_scoreshop_order")->where(['id'=>$id,'user_id'=>$user['id']])->find();
        if(empty($order)){
            __error("订单不存在");
        }
        $express_no = $this->param("express_no/s");
        
        if($order['order_type'] == 2 && $order['delivery_method'] != 1){
            __error("不是快递订单");
        }
        if($order['status'] <= 1){
            __error("订单未发货");
        }
        
        $express = iunserializer($order['express']);
        $new_express_no = $express_no;
        if(!strstr($new_express_no, ':')){
            foreach ($express as $key => $val){
                if($val['express_no'] == $express_no && $val['express_name'] == '中通快递'){
                    $new_express_no = $express_no.":".mb_substr($order['delivery_mobile'], -4);
                }
            }
            unset($val);
        }
        
        $result = \app\common\model\bbfxshop\Delivery::queryExpressDelivery($new_express_no);
        if($result['code'] == 1){
            
            $res = $result['data'];
            foreach ($express as $key => &$val){
                if($val['express_no'] == $express_no){
                    $val['express_data'] = $res;
                }
            }
            unset($val);
            
            Db::name("bbfx_scoreshop_order")->where(['id'=>$order['id']])->update(['express'=>iserializer($express)]);
        }
        
        __result($result);
    }
    
    public function submit(){
        global $_W;
        $params = $this->param();
        $set = $_W['base'];
        
        $user = $this->user;
        freezeUserTips($user);
        $goods_id = intval($params['goods_id']);
        $address_id = intval($params['address_id']);
        $store_id = intval($params['store_id']);
        $total = intval($params['total']);
        
        $goods = Db::name("bbfx_scoreshop_goods")->where(['id'=>$goods_id,'status'=>1])->select();
        if(empty($goods)){
            __error("商品不存在或已下架");
        }
        
        $totals = [];
        $totals[$goods_id] = $total;
        
        
        try {
        	Db::startTrans();
        	
        	$order_type = 0;
        	
        	$goods_ids = [];
        	$score = 0;
        	$price = 0;
        	foreach ($goods as $key => &$item){
        	    $goods_ids[] = $item['id'];
        	    $order_type = $item['type'];
        	    
        	    $total = max(1,intval($totals[$item['id']]));
        	    $score += floatval($item['score']) * $total;
        	    $price += floatval($item['price']) * $total;
        	    $item['total'] = $total;
        	    
        	    
        	    $minbuy = max(1,intval($item['minbuy']));
                $maxbuy = intval($item['maxbuy']);
                $total_maxbuy = intval($item['total_maxbuy']);
                $daily_buy = intval($item['daily_buy']);
                $monthly_buy = intval($item['monthly_buy']); 
        	    if($total < $minbuy){
                    throw new \Exception("单次最低购买{$minbuy}{$item['unit']}【{$item['title']}】");
                }
                if($maxbuy > 0 && $total > $maxbuy){
                    throw new \Exception("单次最多购买{$maxbuy}{$item['unit']}【{$item['title']}】");
                }
                if($total_maxbuy > 0){
                    $user_total_maxbuy = Db::name("bbfx_scoreshop_order_goods")->alias("og")->join("bbfx_scoreshop_order o","o.id=og.order_id")->where(['o.uniacid'=>UNIACID,'o.user_id'=>$user['id'],'og.goods_id'=>$item['id']])->count();
                    $user_total_maxbuy = intval($user_total_maxbuy);
                    if(($user_total_maxbuy + $total) > $total_maxbuy){
                        throw new \Exception("最多可购买{$total_maxbuy}{$item['unit']}【{$item['title']}】");
                    }
                }
                if($daily_buy > 0){
                    $user_daily_buy = Db::name("bbfx_scoreshop_order_goods")->alias("og")->join("bbfx_scoreshop_order o","o.id=og.order_id")->where(['o.uniacid'=>UNIACID,'o.user_id'=>$user['id'],'og.goods_id'=>$item['id'],'o.createtime'=>['>',strtotime(date("Y-m-d 00:00:00"))],'o.status'=>['>=',0]])->count();
                    $user_daily_buy = intval($user_daily_buy);
                    if(($user_daily_buy + $total) > $daily_buy){
                        $buy_num = $daily_buy - $user_daily_buy;
                        if($buy_num == 0){
                            throw new \Exception("每日最多购买{$daily_buy}{$item['unit']}【{$item['title']}】");
                        }
                        else{
                            throw new \Exception("今日最多还可购买{$buy_num}{$item['unit']}【{$item['title']}】");
                        }
                    }
                }
                if($monthly_buy > 0){
                    $user_monthly_buy = Db::name("bbfx_scoreshop_order_goods")->alias("og")->join("bbfx_scoreshop_order o","o.id=og.order_id")->where(['o.uniacid'=>UNIACID,'o.user_id'=>$user['id'],'og.goods_id'=>$item['id'],'o.createtime'=>['>',strtotime(date("Y-m-01 00:00:00"))],'o.status'=>['>=',0]])->count();
                    $user_monthly_buy = intval($user_monthly_buy);
                    if(($user_monthly_buy + $total) > $monthly_buy){
                        $buy_num = $monthly_buy - $user_monthly_buy;
                        if($buy_num == 0){
                            throw new \Exception("每月最多购买{$monthly_buy}{$item['unit']}【{$item['title']}】");
                        }
                        else{
                            throw new \Exception("本月最多还可购买{$buy_num}{$item['unit']}【{$item['title']}】");
                        }
                    }
                }
                $levels = iunserializer($item['levels']);
                if(!empty($levels) && !in_array($user['level'],$levels)){
                    if(!empty($set['buylevel_tips'])){
                        throw new \Exception($set['buylevel_tips']);
                    }
                    else{
                        throw new \Exception("商品【{$item['title']}】当前等级不能购买");
                    }
                }
                
        	    
                if($item['type'] == 1){
                    $serial_number = Db::name("bbfx_scoreshop_serial_number")->where(["uniacid"=>UNIACID,'status'=>0,"goods_id"=>$item['id']])->select();
                    if(empty($serial_number) || count($serial_number) < $total){
                        throw new \Exception("库存不足【{$item['title']}】");
                    }
                }
                else{
                    if($item['stock'] <= 0){
                        throw new \Exception("库存不足【{$item['title']}】");
                    }
                    
                    $res = Db::name("bbfx_scoreshop_goods")->where(['id'=>$item['id']])->setDec('stock',$total);
                    if(empty($res)){
                        throw new \Exception("库存不足【{$item['title']}】");
                    }
                }
            }
            unset($val);
            
            $delivery_method = 0;
            $is_hexiao = 0;
            if($order_type == 2){
                $g_delivery_method = $goods[0]['delivery_method'];
                $delivery_method = intval($params['delivery_method']);
                $delivery_method_list = [];
                $arr = [];
                if($g_delivery_method == 1 || $g_delivery_method == 3){
                    $arr[] = 1;
                }
                if($g_delivery_method == 2 || $g_delivery_method == 3){
                    $arr[] = 2;
                }
                if(!in_array($delivery_method,$arr)){
                    $delivery_method = $arr[0];
                }
                
                if($delivery_method == 2){
                    $is_hexiao = 1;
                }
            }
            else if($order_type == 4 && $goods[0]['is_hexiao'] == 1){
                $delivery_method = 2;
                $is_hexiao = 1;
            }
            
            foreach ($goods as $key => $item){
                if($is_hexiao == 1 && $item['hexiao_store_type'] == 1){
                
                    $store_goods = Db::name("bbfx_scoreshop_store_goods")->where(['uniacid'=>UNIACID,'goods_id'=>$item['id'],'store_id'=>$store_id])->find();
                    if(empty($store_goods)){
                        throw new \Exception("商品不能在该门店下单【{$item['title']}】");
                    }
                
                }
            }
            
            $express_fee = 0;
            $original_price = $price;
            $discount_price = 0;
            if($score <= 0){
                throw new \Exception("商品积分错误");
            }
            
            if($score > $user['score']){
                throw new \Exception("积分不足");
            }
            
            $total_price = $price;
            
            if($delivery_method == 1){
                $express_fee = \app\common\model\bbfxshop\Shippingfee::calculateShippingFee($goods,$address_id,$price);
            }
            
            $total_price = $price + $express_fee;
            
            $order_no = date('YmdHis').random(8,true);  
            $remarks = $params['remarks'];
            $platform = $params['platform'];
            $order = array(
                "uniacid"=>UNIACID,
                "order_no"=>$order_no,
                'store_id'=>$store_id,
                "user_id"=>$user['id'],
                "order_type"=>$order_type,
                "paytype"=>2,
                "price"=>$total_price,
                "score"=>$score,
                "total_price"=>$price,
                "original_price"=>$original_price,
                "goods_info"=>iserializer($goods),
                "remarks"=>$remarks,
                'delivery_method'=>$delivery_method,
                'is_hexiao'=>$is_hexiao,
                'sup_path'=>$this->user['sup_path'],
                'platform'=>$platform,
                "createtime"=>time()
            );
            
            if($order_type == 2 && $delivery_method == 1){
                $address = Db::name("bbfx_user_address")->where(['id'=>$address_id])->find();
                if(empty($address)){
                    throw new \Exception("请选择收货地址");
                }
                
                $order['delivery_username'] = $address['consignee'];
                $order['delivery_mobile'] = $address['phone'];
                $order['delivery_province'] = $address['province_name'];
                $order['delivery_city'] = $address['city_name'];
                $order['delivery_area'] = $address['area_name'];
                $order['delivery_address'] = $address['address'];
                
                $order['express_fee'] = $express_fee;
                
            }
            else if(($order_type == 2 && $delivery_method == 2) || ($order_type == 4 && $is_hexiao == 1)){
                if(empty($params['hexiao_realname'])){
                    throw new \Exception("请输入姓名");
                }
                if(empty($params['hexiao_mobile'])){
                    throw new \Exception("请输入联系方式");
                }
                
                $store = Db::name("bbfx_store")->where(['id'=>$store_id,'uniacid'=>UNIACID])->field("id,name,logo,realname,mobile,province,city,area,address,lat,lng")->find();
                if(empty($store)){
                    throw new \Exception("请选择核销门店");
                }
                
                $order['hexiao_store'] = iserializer($store);
                $order['hexiao_realname'] = $params['hexiao_realname'];
                $order['hexiao_mobile'] = $params['hexiao_mobile'];
                $order['hexiao_total'] = max(1,$goods[0]['hexiao_num']);
                $order['hexiao_num'] = max(1,$goods[0]['hexiao_num']);
                $order['hexiao_code'] = random(8,true);
                Db::name("bbfx_user")->where(['id'=>$user['id']])->update(['hexiao_realname'=>$order['hexiao_realname'],'hexiao_mobile'=>$order['hexiao_mobile']]);
            }
            // throw new \Exception("创建订单失败0");
            $order_id = Db::name("bbfx_scoreshop_order")->insertGetId($order);
            if(empty($order_id)){
                throw new \Exception("创建订单失败1");
            }
            $order['id'] = $order_id;
            foreach ($goods as $key => $item){
                $total = max(1,intval($totals[$item['id']]));
                $order_goods = array(
                    "uniacid"=>UNIACID,
                    "order_id"=>$order_id,
                    "user_id"=>$user['id'],
                    "total"=>$total,
                    "price"=>$item['price']*$total,
                    "score"=>$item['score']*$total,
                    "total_price"=>$item['price']*$total,
                    "goods_id"=>$item['id'],
                    "goods_info"=>iserializer($item),
                    "createtime"=>time()
                );
                
                $res = Db::name("bbfx_scoreshop_order_goods")->insert($order_goods);
                if(empty($res)){
                    throw new \Exception("创建订单失败2");
                }
            }
        	
        	$is_pay = 0;
        	if($total_price == 0){
        	    $res = User::setUserMoney($order['user_id'],0-$order['score'],2,2,"商品兑换",$order);
            	if(empty($res)){
            	    throw new \Exception("积分不足，兑换失败");
            	}
                Db::name("bbfx_scoreshop_order")->where(['id'=>$order['id']])->update(['status'=>1,'pay_time'=>time()]);
                if($order['order_type'] == 4 || $order['order_type'] == 1){
                    $this->model->takeDelivery($order['id']);
                }
                $is_pay = 1;
        	}
        	
        	Db::commit();
        } catch (\Exception $e) {
        	Db::rollback();
        	$msg = $e->getMessage();
        	
        	__error($msg,$order);
        }
        
        __success("操作成功",["order_no"=>$order_no,'is_pay'=>$is_pay]);
        
    }
    
    public function close(){
        $params = $this->param();
        
        $id = intval($params['id']);
        $user = $this->user;
        $order = Db::name("bbfx_order")->where(['id'=>$id,'user_id'=>$user['id']])->find();
        if(empty($order)){
            __error("订单不存在");
        }
        
        if($order['is_pay'] == 1){
            __error("订单已支付");
        }
        
        if($order['status'] == -1){
            __error("订单已取消");
        }
        
        $res = $this->model->closeOrder($id);
        
        if($res['code'] == 1){
            __success("操作成功");
        }
        else{
            __error($res['message']);
        }
    }
    
    public function confirm(){
        $params = $this->param();
        
        $user = $this->user;
        
        $address_id = intval($params['address_id']);
        $goods_id = intval($params['goods_id']);
        $total = max(1,intval($params['total']));
        
        $goods = Db::name("bbfx_scoreshop_goods")->where(['id'=>$goods_id,'status'=>1])->select();
        if(empty($goods)){
            __error("商品不存在或已下架");
        }
        
        $totals = [];
        $totals[$goods_id] = $total;
        
        $total_fee = 0;
        $totalNum = 0;
        $total_score = 0;
        foreach ($goods as $key => &$item){
    	    $total = max(1,intval($totals[$item['id']]));
    	    $total_score = floatval($item['score'])*$total;
    	    $item['total'] = $total;
    	    $total_fee += floatval($item['price'])*$total;
    	    $totalNum += $total;
    	    $item['thumb'] = cdnurl($item['thumb']);
        }
        unset($val);
        
        
        $delivery_method_list = [];
        $delivery_method = 0;
        if($goods[0]['type'] == 2){
            $g_delivery_method = $goods[0]['delivery_method'];
            $delivery_method = intval($params['delivery_method']);
            $arr = [];
            if($g_delivery_method == 1 || $g_delivery_method == 3){
                $delivery_method_list[] = ['name'=>'快递配送','value'=>1];
                $arr[] = 1;
            }
            if($g_delivery_method == 2 || $g_delivery_method == 3){
                $delivery_method_list[] = ['name'=>'门店核销','value'=>2];
                $arr[] = 2;
            }
            if(!in_array($delivery_method,$arr)){
                $delivery_method = $arr[0];
            }
            if(empty($delivery_method)){
                $delivery_method = 1;
            }
        }
        else if($goods[0]['type'] == 4 && $goods[0]['is_hexiao'] == 1){
            $delivery_method = 2;
            $delivery_method_list[] = ['name'=>'门店核销','value'=>2];
        }
        
        
        
        $total_fee = round($total_fee,2);
        $total_score = round($total_score,2);
        $total_price = $total_fee;
        $express_fee = 0;
        $discount_price = 0;
        
        if($delivery_method == 1){
            $express_fee = \app\common\model\bbfxshop\Shippingfee::calculateShippingFee($goods,$address_id,$total_price);
        }
        
        $original_price = $total_fee;
        $total_fee = round($total_price + $express_fee,2);
        $total_score = round($total_score,0);
        
        
        $result = [
            'goods'=>$goods,
            'total_score'=>$total_score,
            'total_fee'=>$total_fee,
            'original_price'=>$original_price,
            'discount_price'=>$discount_price,
            'totalNum'=>$totalNum,
            'total_price'=>$total_price,
            'express_fee'=>$express_fee,
            'delivery_method_list'=>$delivery_method_list,
            'delivery_method'=>$delivery_method,
        ];
        
        __success("操作成功",$result);
    }
    
    public function detail(){
        $id = $this->param('id/d');
        
        $where = ['uniacid'=>UNIACID,'id'=>$id,'user_id'=>$this->user['id']];
        
        $order = Db::name("bbfx_scoreshop_order")->where($where)->find();
        if(empty($order)){
            __error("订单不存在");
        }
        
        if(($order['order_type'] == 2 || $order['order_type'] == 4) && $order['is_hexiao'] == 1 && $order['status'] == 3){
            $hexiao_user = Db::name("bbfx_user")->where("id",$order['hexiao_uid'])->field("id,nickname,avatar,level")->find();
            if(!empty($hexiao_user)){
                $hexiao_user['avatar'] = cdnurl($hexiao_user['avatar']);
                $order['hexiao_user'] = $hexiao_user;
            }
        }
        
        if($order['order_type'] == 2){
            $order['express'] = iunserializer($order['express']);
        }
        
        $goods_info = iunserializer($order['goods_info']);
        foreach ($goods_info as $key => &$val){
            $val['thumb'] = cdnurl($val['thumb']);
        }
        unset($val);
        $order['goods_info'] = $goods_info;
        $order['createtime'] = date("Y-m-d H:i:s",$order['createtime']);
        $order['pay_time'] = date("Y-m-d H:i:s",$order['pay_time']);
        $order['verify_time'] = date("Y-m-d H:i:s",$order['verify_time']);
        
        $order_goods = Db::name("bbfx_scoreshop_order_goods")->where(["uniacid"=>UNIACID,"order_id"=>$order['id']])->select();
        $order['is_virtual_fahuo'] = 0;        
        foreach($order_goods as $k => &$v){
            $goods_info = iunserializer($v['goods_info']);
            $goods_info['thumb'] = cdnurl($goods_info['thumb']);
            $v['goods'] = $goods_info;
            if($goods_info['type'] == 1 && $order['status'] >= 1){
                $serial_number = Db::name("bbfx_scoreshop_serial_number")->where(['uniacid'=>UNIACID,'pid'=>$v['id']])->select();
                if(!empty($serial_number)){
                    foreach($serial_number as $kk => &$vv){
                        $vv['val'] = trim($vv['val']);
                    }
                    unset($vv);
                    $v['serial_number'] = $serial_number;
                }
                else{
                    $v['serial_number'] = [];
                }
            }
            if($order['order_type'] == 4 && $order['is_hexiao'] != 1 && $order['is_pay'] == 1 && !empty($goods_info['fahuo_content'])){
                $order['is_virtual_fahuo'] = 1;
                $v['virtual_fahuo'] = $goods_info['fahuo_content'];
            }
        }
        unset($v);
        $order['order_goods'] = $order_goods;
                
        $order['paytypeText'] = $this->model->getOrderPaytype($order['paytype']);
        
        $order['statusText'] = $this->model->getOrderStatus($order);
        
        __success("操作成功",$order);
    }
    
    public function getHexiaoQrcode(){
        $id = $this->param("id/d");
        $platform = $this->param("platform/s");
        $order = Db::name("bbfx_scoreshop_order")->where(['id'=>$id,'user_id'=>$this->user['id']])->find();
        if(empty($order)){
            __error("订单不存在");
        }
        
        if($platform == 'wxapp'){
            
            $result = \app\common\model\bbfxshop\Weixin::getUnlimitedQRCode("pagesS/scoreshop/orderDetail?{$order['id']}", "hexiao_wxacode_scoreshop_{$order['uniacid']}_".$order['id'].".png");
            if($result['code'] != 1){
                __result($result);
            }
            $qrcode = cdnurl($result['data']['url']); 
            Db::name("bbfx_scoreshop_order")->where("id",$order['id'])->update(['hexiao_wxacode'=>$result['data']['url']]);
        }
        else{
            $url = request()->domain()."/mobile/#/pagesS/scoreshop/orderDetail?order_id={$order['id']}";
            $result = \app\common\model\QRcode::create($url, "hexiao_qrcode_scoreshop_{$order['uniacid']}_".$order['id'].".png");
            if($result['code'] != 1){
                __result($result);
            }
            $qrcode = cdnurl($result['data']['url']); 
            Db::name("bbfx_scoreshop_order")->where("id",$order['id'])->update(['hexiao_qrcode'=>$result['data']['url']]);
        }
        
        __success("操作成功",$qrcode."?".time());
    }
    
    public function deliveryGoods(){
        $params = $this->param();
        
        $id = intval($params['id']);
        $user = $this->user;
        $order = Db::name("bbfx_scoreshop_order")->where(['id'=>$id,'user_id'=>$user['id']])->find();
        if(empty($order)){
            __error("订单不存在");
        }
        
        if($order['status'] != 2){
            __error("订单错误");
        }
        
        $res = $this->model->takeDelivery($order['id']);
        
        if(!empty($res) && $res['errno'] == 0){
            __success("操作成功");
        }
        else{
            __error($res['message']);
        }
    }
    
    public function list(){
        $params = $this->param();
        
        $user = $this->user;
        
        $status = intval($params['status']);
        $where = ['uniacid'=>UNIACID,'user_id'=>$user['id']];
        if($status != -1){
            if($status == 4){
                $where['status'] = ['>',0];
                $where['refund_status'] = ['>=',0]; 
            }
            else{
                $where['status'] = $status;
            }
        }
        $list = Db::name("bbfx_scoreshop_order")->where($where)->order('id desc')->select();
        if($list){
            foreach($list as $key => &$val){
                
                $val['hexiao_store'] = iunserializer($val['hexiao_store']);
                $val['hexiao_store']['logo'] = cdnurl($val['hexiao_store']['logo']);
                
                $val['hexiao_wxacode'] = cdnurl($val['hexiao_wxacode']);
                $val['hexiao_qrcode'] = cdnurl($val['hexiao_qrcode']);
                
                $val['paytypeText'] = $this->model->getOrderPaytype($val['paytype']);;
                $val['statusText'] = $this->model->getOrderStatus($val);
                
                $val['goods_info'] = iunserializer($val['goods_info']);
                $order_goods = Db::name("bbfx_scoreshop_order_goods")->where(["uniacid"=>UNIACID,"order_id"=>$val['id']])->select();
                $val['is_virtual_fahuo'] = 0;
                foreach($order_goods as $k => &$v){
                    $goods_info = iunserializer($v['goods_info']);
                    $goods_info['thumb'] = cdnurl($goods_info['thumb']);
                    $v['goods'] = $goods_info;
                    if($goods_info['type'] == 1 && $val['status'] >= 1){
                        $serial_number = Db::name("bbfx_scoreshop_serial_number")->where(['uniacid'=>UNIACID,'pid'=>$v['id']])->select();
                        if(!empty($serial_number)){
                            foreach($serial_number as $kk => &$vv){
                                $vv['val'] = trim($vv['val']);
                            }
                            unset($vv);
                            $v['serial_number'] = $serial_number;
                        }
                        else{
                            $v['serial_number'] = [];
                        }
                    }
                    if($val['order_type'] == 4 && $val['is_hexiao'] != 1 && $val['is_pay'] == 1 && !empty($goods_info['fahuo_content'])){
                        $val['is_virtual_fahuo'] = 1;
                        $v['virtual_fahuo'] = $goods_info['fahuo_content'];
                    }
                }
                unset($v);
                $val['order_goods'] = $order_goods;
                $val['pay_time'] = date("Y-m-d H:i:s",$val['pay_time']);
                $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
                $val['express'] = iunserializer($val['express']);
            }
            unset($val);
            __success("操作成功",$list);
        }
        else{
            __error("未查询到订单");
        }
    }
    
    public function express(){
        $params = $this->param();
        
        $id = intval($params['id']);
        $current = intval($params['current']);
        
        $order = Db::name("bbfx_scoreshop_order")->where(['order_type'=>2,'uniacid'=>UNIACID,'user_id'=>$this->user['id'],'id'=>$id,'status'=>['>',0]])->find();
        if(empty($order)){
            __error("订单信息错误");
        }
        
        $access_token =\app\common\model\bbfxshop\Weixin::getAccessToken();
        
        $openid = $this->user['openid'];
        
        $order_goods = Db::name("bbfx_scoreshop_order_goods")->where(["uniacid"=>UNIACID,"order_id"=>$order['id']])->select();
         
        $goods_info = ['detail_list'=>[]];       
        foreach($order_goods as $key => $val){
            $goods = iunserializer($val['goods_info']);
            $goods['thumb'] = cdnurl($goods['thumb']);
            
            $goods_info['detail_list'][] = array(
                "goods_name"=>$goods['title'],
                "goods_img_url"=>$goods['thumb']
            );
        }
        
        $express = iunserializer($order['express']);
        
        if(empty($express[$current]) || empty($express[$current]['express_no'])){
            __error("物流信息错误");
        }
        
        $express_no = $express[$current]['express_no'];
        
        
        $data = array(
            "openid"=>$openid,
            "waybill_id"=>$express_no,
            "receiver_phone"=>$order['delivery_mobile'],
            "goods_info"=>$goods_info
        );
        
        $result = ihttp_request("https://api.weixin.qq.com/cgi-bin/express/delivery/open_msg/trace_waybill?access_token={$access_token}",$data);
        $result = json_decode($result['content'],true);
        if($result['errcode'] == 0){
            $express[$current]['waybill_token'] = $result['waybill_token'];
            
            Db::name("bbfx_scoreshop_order")->where(['id'=>$order['id']])->update(['express'=>iserializer($express)]);
            
            __success("操作成功",$result['waybill_token']);
        }
        __error($result['errmsg']);
    }
}