<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\order;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\Fenxiao;
use app\common\model\bbfxshop\User;
use app\common\model\bbfxshop\Agent;
use app\common\model\bbfxshop\CloudWarehouse;
use app\common\model\bbfxshop\Goods;
use app\common\model\bbfxshop\Weixin;
use app\common\model\QRcode;


class Order extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Order;
    }

    
    public function refundDetail(){
        $params = $this->param();
        
        $user = $this->user;
        $order_id = intval($params['order_id']);
        
        $order = Db::name("bbfx_order")->where(['id'=>$order_id,'is_pay'=>1,'user_id'=>$user['id']])->find();
        
        if(empty($order)){
            __error("订单不存在");
        }
        
        $order_refund = Db::name("bbfx_order_refund")->where(['order_id'=>$order['id']])->find();
        if(empty($order_refund)){
            __error("未查询到退款信息");
        }
        
        $order_goods = Db::name("bbfx_order_goods")->where(["uniacid"=>UNIACID,"order_id"=>$order['id']])->select();
        foreach($order_goods as $k => &$v){
            $goods_info = iunserializer($v['goods_info']);
            $goods_info['thumb'] = cdnurl($goods_info['thumb']);
            $v['goods'] = $goods_info;
        }
        unset($v);
        
        if($order_refund['createtime'] > strtotime(date("Y-01-01 00:00:00"))){
            $createtime = date("m/d H:i",$order_refund['createtime']);
        }
        else{
            $createtime = date("Y/m/d H:i",$order_refund['createtime']);
        }
        
        $steps = array(
            array('title'=>'提交申请','time'=>$createtime),
            array('title'=>'平台审核','time'=>''),
            array('title'=>'退款成功','time'=>''),
        );
        $order_refund['step'] = 0;
        if($order_refund['status'] > 0){
            if($order_refund['refundtime'] > strtotime(date("Y-01-01 00:00:00"))){
                $refundtime = date("m/d H:i",$order_refund['refundtime']);
            }
            else{
                $refundtime = date("Y/m/d H:i",$order_refund['refundtime']);
            }
            $steps[1]['time'] = $refundtime;
            $steps[2]['time'] = $refundtime;
            
            $order_refund['step'] = 2;
        }
        if($order_refund['status'] == 1){
            $steps[2]['title'] = '退款成功';
        }
        else if($order_refund['status'] == 2){
            $steps[2]['title'] = '退款失败';
        }
        $order_refund['createtime'] = date("Y-m-d H:i:s",$order_refund['createtime']);
        $order_refund['images'] = iunserializer($order_refund['images']);
        foreach ($order_refund['images'] as $key => &$val){
            $val = cdnurl($val);
        }
        unset($val);
        __success("操作成功",['order'=>$order,'steps'=>$steps,'order_goods'=>$order_goods,'refund'=>$order_refund]);
    }
    
    public function submitRefund(){
        global $_W;
        $params = $this->param();
        
        $user = $this->user;
        $order_id = intval($params['order_id']);
        $money = floatval($params['money']);
        $order = Db::name("bbfx_order")->where(['id'=>$order_id,'user_id'=>$user['id']])->find();
        if(empty($order)){
            __error("订单不存在");
        }
        
        if($order['is_pay'] != 1){
            __error("订单未支付");
        }
        
        if($order['refund_status'] != -1){
            __error("已提交申请");
        }
        
        if($order['is_asales_end'] == 1){
            __error("订单已过售后期");
        }
        
        if($order['order_source'] == 2 || $order['order_source'] == 4 || $order['order_source'] == 5 || $order['order_source'] == 6){
            __error("该类型的订单不可退款");
        }

        if($order['gift_status'] == 1){
            __error("该订单礼品已被领取不可退款");
        }
        
        $orderset = $_W['base']['orderset'];
        if($orderset['is_refund'] != 1 || empty($orderset['allow_refund_status']) || !in_array($order['status'],$orderset['allow_refund_status'])){
            __error("当前订单状态不允许退款");
        }
        
        if($money > $order['price']){
            __error("申请金额不得超出订单实付金额");
        }
        
        if($money <= 0){
            $money = $order['price'];
        }
        
        $order_no = date('YmdHis').random(8,true);
        
        $images = $params['images'];
        foreach ($images as $k => &$v){
            $v = replaceSiteroot($v);
        }
        unset($v);
        
        $data = array(
            "uniacid"=>UNIACID,
            "user_id"=>$user['id'],
            "order_no"=>$order_no,
            "money"=>$money,
            "order_id"=>$order_id,
            "content"=>trim($params['content']),
            "mobile"=>trim($params['mobile']),
            "images"=>iserializer($images),
            "createtime"=>time()
        );
        
        if(empty($data['content'])){
            __error("请填写退款原因");
        }
        if(empty($data['mobile'])){
            __error("请填写联系方式");
        }
        
        $res = Db::name("bbfx_order_refund")->insert($data);
        
        if($res){
            
            Db::name("bbfx_order")->where(['id'=>$order['id']])->update(['refund_status'=>0]);
            
            __success("提交成功，请等待审核！");
        }
        else{
            __error("提交申请失败！");
        }
    }
    
    public function close(){
        $params = $this->param();
        
        $id = intval($params['id']);
        $user = $this->user;
        $order = Db::name("bbfx_order")->where(['id'=>$id,'user_id'=>$user['id']])->find();
        if(empty($order)){
            __error("订单不存在");
        }
        
        if($order['is_pay'] == 1){
            __error("订单已支付");
        }
        
        if($order['status'] == -1){
            __error("订单已取消");
        }
        
        $res = $this->model->closeOrder($id);
        
        if($res['code'] == 1){
            __success("操作成功");
        }
        else{
            __error($res['message']);
        }
    }
    
    // 物流查询
    public function queryExpressDelivery(){
        $params = $this->param();
        
        $id = intval($params['id']);
        $user = $this->user;
        $order = Db::name("bbfx_order")->where(['id'=>$id,'user_id'=>$user['id']])->find();
        if(empty($order)){
            __error("订单不存在");
        }
        $express_no = $this->param("express_no/s");
        
        if($order['order_type'] == 2 && $order['delivery_method'] != 1){
            __error("不是快递订单");
        }
        if($order['status'] <= 1){
            __error("订单未发货");
        }
        
        $express = iunserializer($order['express']);
        $new_express_no = $express_no;
        if(!strstr($new_express_no, ':')){
            foreach ($express as $key => $val){
                if($val['express_no'] == $express_no && $val['express_name'] == '中通快递'){
                    $new_express_no = $express_no.":".mb_substr($order['delivery_mobile'], -4);
                }
            }
            unset($val);
        }
        
        $result = \app\common\model\bbfxshop\Delivery::queryExpressDelivery($new_express_no);
        if($result['code'] == 1){
            $res = $result['data'];
            foreach ($express as $key => &$val){
                if($val['express_no'] == $express_no){
                    $val['express_data'] = $res;
                }
            }
            unset($val);
            
            Db::name("bbfx_order")->where(['id'=>$order['id']])->update(['express'=>iserializer($express)]);
        }
        
        __result($result);
    }
    
    public function deliveryGoods(){
        $params = $this->param();
        
        $id = intval($params['id']);
        $user = $this->user;
        $order = Db::name("bbfx_order")->where(['id'=>$id,'user_id'=>$user['id']])->find();
        if(empty($order)){
            __error("订单不存在");
        }
        
        if($order['status'] != 2){
            __error("订单错误");
        }
        
        $res = $this->model->takeDelivery($order['id']);
        
        if(!empty($res) && $res['code'] == 1){
            __success("操作成功");
        }
        else{
            __error($res['message']);
        }
    }
    
    public function getHexiaoQrcode(){
        $id = $this->param("id/d");
        $platform = $this->param("platform/s");
        $order = Db::name("bbfx_order")->where(['id'=>$id,'user_id'=>$this->user['id']])->find();
        if(empty($order)){
            __error("订单不存在");
        }
        
        if($platform == 'wxapp'){
            
            if($order['mid'] > 0){
                $result = Weixin::getUnlimitedQRCode("merchant/verification/index?{$order['hexiao_code']}", "hexiao_wxacode_{$order['uniacid']}_".$order['id'].".png");
            }
            else{
                $result = Weixin::getUnlimitedQRCode("pagesS/order/detail?{$order['hexiao_code']}", "hexiao_wxacode_{$order['uniacid']}_".$order['id'].".png");
            }
            
            if($result['code'] != 1){
                __result($result);
            }
            $qrcode = cdnurl($result['data']['url']); 
            Db::name("bbfx_order")->where("id",$order['id'])->update(['hexiao_wxacode'=>$result['data']['url']]);
        }
        else{
            if($order['mid'] > 0){
                $url = request()->domain()."/mobile/#//merchant/verification/index?code={$order['hexiao_code']}&i=".$order['uniacid'];
            }
            else{
                $url = request()->domain()."/mobile/#/pagesS/order/detail?code={$order['hexiao_code']}&i=".$order['uniacid'];
            }
            $result = QRcode::create($url, "hexiao_qrcode_{$order['uniacid']}_".$order['id']);
            if($result['code'] != 1){
                __result($result);
            }
            $qrcode = cdnurl($result['data']['url']); 
            Db::name("bbfx_order")->where("id",$order['id'])->update(['hexiao_qrcode'=>$result['data']['url']]);
        }
        
        __success("操作成功",$qrcode."?".time());
    }
    
    public function list(){
        $params = $this->param();
        $platform = $params['platform'];
        $user = $this->user;
        
        $status = intval($params['status']);
        $where = ['uniacid'=>UNIACID,'user_id'=>$user['id'],'order_source'=>['<>',8]];
        if($status != -1){
            if($status == 4){
                $where['status'] = ['>',0];
                $where['refund_status'] = ['>=',0]; 
            }
            else{
                $where['status'] = $status;
            }
        }
        $list = Db::name("bbfx_order")->where($where)->order('id desc')->select();
        if(!empty($list)){
            foreach($list as $key => &$val){
                
                $val['paytypeText'] = $this->model->getOrderPaytype($val['paytype']);
                $val['statusText'] = $this->model->getOrderStatus($val);
                $val['hexiao_store'] = iunserializer($val['hexiao_store']);
                $val['hexiao_store']['logo'] = cdnurl($val['hexiao_store']['logo']);
                
                $order_goods = Db::name("bbfx_order_goods")->where(["uniacid"=>UNIACID,"order_id"=>$val['id']])->select();
                
                $val['is_virtual_fahuo'] = 0;
                $is_comment = 1;
                foreach($order_goods as $k => &$v){
                    $goods_info = iunserializer($v['goods_info']);
                    $goods_info['thumb'] = cdnurl($goods_info['thumb']);
                    $plugin = iunserializer($goods_info['plugin']);
                    
                    unset($goods_info['plugin']);
                    
                    if($val['order_type'] == 4 && $val['is_hexiao'] != 1 && $val['is_pay'] == 1 && !empty($plugin['virtual_goods']['fahuo_content'])){
                        $val['is_virtual_fahuo'] = 1;
                        $v['virtual_fahuo'] = $plugin['virtual_goods']['fahuo_content'];
                    }
                     
                    $v['goods'] = $goods_info;
                    if($goods_info['type'] == 1 && $val['status'] >= 1){
                        $serial_number = Db::name("bbfx_serial_number")->where(['uniacid'=>UNIACID,'pid'=>$v['id']])->select();
                        if(!empty($serial_number)){
                            foreach($serial_number as $kk => &$vv){
                                $vv['val'] = trim($vv['val']);
                            }
                            unset($vv);
                            $v['serial_number'] = $serial_number;
                        }
                        else{
                            $v['serial_number'] = [];
                        }
                    }
                    unset($v['goods_info']);
                    $comment = Db::name("bbfx_goods_comment")->where(['uniacid'=>UNIACID,'order_id'=>$val['id'],'goods_id'=>$v['goods_id']])->find();
                    if(empty($comment)){
                        $is_comment = 0;
                        $v['is_comment'] = 0;
                    }
                    else{
                        $v['is_comment'] = 1;
                    }

                    if($val['gift_status'] > -1){
                        if($platform == 'wxapp'){
                            $result = Weixin::getUnlimitedQRCode("plugin/gift/index?{$val['order_no']}", "gift_wxacode_".$val['order_no'].".png",1);
                        }
                        else{
                            $url = request()->domain()."/mobile/#/plugin/gift/index?order_no={$val['order_no']}&i=".UNIACID;
                            $result = QRcode::create($url, "gift_qrcode_".$val['order_no']);
                        }
                        $val['gift_qrcode'] = "";
                        if($result['code'] == 1){
                            $val['gift_qrcode'] = cdnurl($result['data']['url']);
                        }
                    }
                }
                unset($v);
                $val['is_comment'] = $is_comment;
                $val['order_goods'] = $order_goods;
                $val['pay_time'] = date("Y-m-d H:i:s",$val['pay_time']);
                $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
                $val['express'] = iunserializer($val['express']);
                $val['hexiao_wxacode'] = cdnurl($val['hexiao_wxacode']);
                $val['hexiao_qrcode'] = cdnurl($val['hexiao_qrcode']);
                unset($val['goods_info']);
            }
            unset($val);
            __success("操作成功",$list);
        }
        else{
            __error("未查询到订单");
        }
    }
    
    public function detail(){
        $id = $this->param('id/d');
        $platform = $this->param('platform/s');
        
        
        $where = ['uniacid'=>UNIACID,'id'=>$id,'user_id'=>$this->user['id']];
        
        $order = Db::name("bbfx_order")->where($where)->find();
        if(empty($order)){
            __error("订单不存在");
        }
        
        if(($order['order_type'] == 2 || $order['order_type'] == 4) && $order['is_hexiao'] == 1 && $order['status'] == 3){
            $hexiao_user = Db::name("bbfx_user")->where("id",$order['hexiao_uid'])->field("id,nickname,avatar,level")->find();
            if(!empty($hexiao_user)){
                $hexiao_user['avatar'] = cdnurl($hexiao_user['avatar']);
                $order['hexiao_user'] = $hexiao_user;
            }
            
        }
        $order['hexiao_store'] = iunserializer($order['hexiao_store']);
        
        if($order['order_type'] == 2){
            $order['express'] = iunserializer($order['express']);
        }
        
        $goods_info = iunserializer($order['goods_info']);
        foreach ($goods_info as $key => &$val){
            $val['thumb'] = cdnurl($val['thumb']);
            unset($val['plugin']);
        }
        unset($val);
        $order['goods_info'] = $goods_info;
        $order['createtime'] = date("Y-m-d H:i:s",$order['createtime']);
        $order['pay_time'] = date("Y-m-d H:i:s",$order['pay_time']);
        $order['verify_time'] = date("Y-m-d H:i:s",$order['hexiao_time']);
        $order['hexiao_time'] = date("Y-m-d H:i:s",$order['hexiao_time']);
        
        $order_goods = Db::name("bbfx_order_goods")->where(["uniacid"=>UNIACID,"order_id"=>$order['id']])->select();
        $order['is_virtual_fahuo'] = 0;
        $og_ids = [];
        $is_comment = 1;
        $goods_ids = [];
        foreach($order_goods as $k => &$v){
            $og_ids[] = $v['id'];
            $goods_ids[] = $v['goods_id'];
            $goods_info = iunserializer($v['goods_info']);
            $goods_info['thumb'] = cdnurl($goods_info['thumb']);
            $plugin = iunserializer($goods_info['plugin']);
                    
            unset($goods_info['plugin']);
            
            if($order['order_type'] == 4 && $order['is_hexiao'] != 1 && $order['is_pay'] == 1 && !empty($plugin['virtual_goods']['fahuo_content'])){
                $order['is_virtual_fahuo'] = 1;
                $v['virtual_fahuo'] = $plugin['virtual_goods']['fahuo_content'];
            }
            
            $v['goods'] = $goods_info;
            if($goods_info['type'] == 1 && $order['status'] >= 1){
                $serial_number = Db::name("bbfx_serial_number")->where(['uniacid'=>UNIACID,'pid'=>$v['id']])->select();
                if(!empty($serial_number)){
                    foreach($serial_number as $kk => &$vv){
                        $vv['val'] = trim($vv['val']);
                    }
                    unset($vv);
                    $v['serial_number'] = $serial_number;
                }
                else{
                    $v['serial_number'] = [];
                }
            }
            unset($v['goods_info']);
            $comment = Db::name("bbfx_goods_comment")->where(['uniacid'=>UNIACID,'order_id'=>$order['id'],'goods_id'=>$v['goods_id']])->find();
            if(empty($comment)){
                $is_comment = 0;
                $v['is_comment'] = 0;
            }
            else{
                $v['is_comment'] = 1;
            }
        }
        unset($v);
        $order['order_goods'] = $order_goods;
        $order['is_comment'] = $is_comment;

        $hexiao_store_list = [];
        if($order['is_hexiao'] == 1 && $order['store_id'] == 0){
            $hexiao_store_list = $this->model->getOrderHexiaoStoreList($goods_ids);
        }
        $order['hexiao_store_list'] = $hexiao_store_list;
                
        $order['paytypeText'] = $this->model->getOrderPaytype($order['paytype']);
        
        $order['statusText'] = $this->model->getOrderStatus($order);
        $order['hexiao_qrcode'] = cdnurl($order['hexiao_qrcode']);
        $order['hexiao_wxacode'] = cdnurl($order['hexiao_wxacode']);
        
        
        $order['give_balance'] = Db::name("bbfx_money_log")->where(['uniacid'=>UNIACID,'item_id'=>['in',$og_ids],'user_id'=>$order['user_id'],'type'=>1,'item_type'=>24])->sum("money");
        $order['give_score'] = Db::name("bbfx_money_log")->where(['uniacid'=>UNIACID,'item_id'=>['in',$og_ids],'user_id'=>$order['user_id'],'type'=>2,'item_type'=>24])->sum("money");
        $order['give_balance'] = round($order['give_balance'],2);
        $order['give_score'] = round($order['give_score'],2);
        
        $order['coupon_list'] = Db::name("bbfx_user_coupon")->where(['uniacid'=>UNIACID,'item_id'=>['in',$og_ids],'receive_type'=>3,'user_id'=>$order['user_id']])->select();
        $order['hx_list'] = $this->model->getHexiaoCode($order,$platform);

        __success("操作成功",$order);
    }
    
    public function express(){
        $params = $this->param();
        
        $id = intval($params['id']);
        $current = intval($params['current']);
        
        $order = Db::name("bbfx_order")->where(['order_type'=>2,'uniacid'=>UNIACID,'user_id'=>$this->user['id'],'id'=>$id,'status'=>['>',0]])->find();
        if(empty($order)){
            __error("订单信息错误");
        }
        
        $result = Weixin::getAccessToken();
        if($result['code'] != 1){
            __result($result);
        }
        $access_token = $result['data'];
        
        $openid = $this->user['openid'];
        
        $order_goods = Db::name("bbfx_order_goods")->where(["uniacid"=>UNIACID,"order_id"=>$order['id']])->select();
         
        $goods_info = ['detail_list'=>[]];       
        foreach($order_goods as $key => $val){
            $goods = iunserializer($val['goods_info']);
            $goods['thumb'] = cdnurl($goods['thumb']);
            
            $goods_info['detail_list'][] = array(
                "goods_name"=>$goods['title'],
                "goods_img_url"=>$goods['thumb']
            );
        }
        
        $express = iunserializer($order['express']);
        
        if(empty($express[$current]) || empty($express[$current]['express_no'])){
            __error("物流信息错误");
        }
        
        $express_no = $express[$current]['express_no'];
        
        
        $data = array(
            "openid"=>$openid,
            "waybill_id"=>$express_no,
            "receiver_phone"=>$order['delivery_mobile'],
            "goods_info"=>$goods_info
        );
        
        $result = ihttp_request("https://api.weixin.qq.com/cgi-bin/express/delivery/open_msg/trace_waybill?access_token={$access_token}",$data);
        $result = json_decode($result['content'],true);
        if($result['errcode'] == 0){
            $express[$current]['waybill_token'] = $result['waybill_token'];
            
            Db::name("bbfx_order")->where(['id'=>$order['id']])->update(['express'=>iserializer($express)]);
            
            __success("操作成功",$result['waybill_token']);
        }
        __error($result['errmsg']);
    }
    
    public function payComplete(){
        $params = $this->param();
        
        $openid = $_W['openid'];
        $paytype = intval($params['paytype']);
        $user = $this->user;
        $order_no = $params['order_no'];
        if($paytype == 2){
            $order = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'user_id'=>$user['id'],'order_no'=>$order_no])->find();
            if(empty($order)){
                __error("订单不存在");
            }
            if($order['is_pay'] == 1){
                __error("订单已支付");
            }
            
            if($user['balance'] < $order['price']){
                __error("余额不足");
            }
            
            $res = User::setUserMoney($user['id'],-$order['price'],1,1,"商品订单支付",$order);
            if(empty($res)){
                __error("余额不足");
            }
            
            $this->model->goodsPayResult($order_no,2);
        }
        else{
            __success("支付类型错误");
        }
        __success("支付成功");
    }
    
    public function pay(){
        $params = $this->param();
        
        $openid = $_W['openid'];
        
        $order_no = $params['order_no'];
        
        $user = $this->user;
        
        $order = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'user_id'=>$user['id'],'order_no'=>$order_no])->field(['id','order_no','price','is_pay','status','order_type','paytype'])->find();
        
        if(empty($order)){
            __error("订单不存在");
        }
        
        if($order['is_pay'] == 1){
            __error("订单已支付");
        }
        
        __success("操作成功",$order);
    }
    
    public function confirm(){
        global $_W;
        $params = $this->param();
        $set = $_W['base'];
        
        $user = $this->user;
        
        $goods_id = intval($params['goods_id']);
        $total = max(1,intval($params['total']));
        $coupon_id = intval($params['coupon_id']);
        $address_id = intval($params['address_id']);
        $sku_id = intval($params['sku_id']);
        if(!empty($params['cart_id'])){
            // 购物车
            $cart_id = explode(",",$params['cart_id']);
            $cart = Db::name("bbfx_user_cart")->where(['id'=>['in',$cart_id],'user_id'=>$user['id']])->select();
            if(empty($cart)){
                __error("购物车数据错误");
            }
            $goods_ids = [];
            foreach($cart as $key => $val){
                $goods_ids[] = $val['goods_id'];
            }
            $goods_list = Db::name("bbfx_goods")->where(['id'=>['in',$goods_ids],'status'=>1])->select();
            
            if(empty($goods_list)){
                __error("购物车商品信息错误");
            }
            
            $goods_list = array_skey($goods_list,"id");
            
            $goods = [];
            foreach($cart as $key => $val){
                if(empty($goods_list[$val['goods_id']])){
                    __error("购物车商品信息错误");
                }
                
                $info = $goods_list[$val['goods_id']];
                $info['total'] = $val['total'];
                if($info['is_spec'] == 1){
                    $sku = Db::name("bbfx_goods_spec_sku")->where(['id'=>$val['sku_id']])->find();
                    if(empty($sku)){
                        __error("请选择规格");
                    }
                    if(!empty($sku['thumb'])){
                        $info['thumb'] = cdnurl($sku['thumb']);
                    }
                    $info['sku'] = $sku;
                    $info['sku_id'] = $sku['id'];
                    $info['price'] = $sku['price'];
                    $info['sku_name'] = $sku['sku_name'];
                    
                }
                $goods[] = $info;
            }
            
        }
        else{
            $goods = Db::name("bbfx_goods")->where(['id'=>$goods_id,'status'=>1])->select();
            
            
            
            if($goods[0]['is_spec'] == 1){
                $sku = Db::name("bbfx_goods_spec_sku")->where(['id'=>$sku_id])->find();
                if(empty($sku)){
                    __error("请选择规格");
                }
                if(!empty($sku['thumb'])){
                    $goods[0]['thumb'] = cdnurl($sku['thumb']);
                }
                $goods[0]['sku'] = $sku;
                $goods[0]['sku_id'] = $sku['id'];
                $goods[0]['price'] = $sku['price'];
                $goods[0]['sku_name'] = $sku['sku_name'];
            }
            
            $goods[0]['total'] = $total;
            
        }
        
        if(empty($goods)){
            __error("商品不存在");
        }
        
        
        
        $delivery_method_list = [];
        $delivery_method = 0;
        if($goods[0]['type'] == 2){
            $g_delivery_method = $goods[0]['delivery_method'];
            $delivery_method = intval($params['delivery_method']);
            $arr = [];
            if($g_delivery_method == 1 || $g_delivery_method == 3){
                $delivery_method_list[] = ['name'=>'快递配送','value'=>1];
                $arr[] = 1;
            }
            if($g_delivery_method == 2 || $g_delivery_method == 3){
                $delivery_method_list[] = ['name'=>'门店核销','value'=>2];
                $arr[] = 2;
            }
            if(!in_array($delivery_method,$arr)){
                $delivery_method = $arr[0];
            }
            if(empty($delivery_method)){
                $delivery_method = 1;
            }
        }
        else if($goods[0]['type'] == 4 && $goods[0]['is_hexiao'] == 1){
            $delivery_method = 2;
            $delivery_method_list[] = ['name'=>'门店核销','value'=>2];
        }
        $is_gift_goods = 0;
        $hexiao_info_required = 0;
        $is_cloud_warehouse = 0;

        foreach($goods as $key => $val){
            $plugin =  iunserializer($val['plugin']);
            if($plugin['gift']['status'] == 1){
                $is_gift_goods = 1;
            }
            if($val['hexiao_info_required'] == 1){
                $hexiao_info_required = 1;
            }
            if($set['cloud_warehouse']['status'] == 1){
                $cw_goods = explode(",",(string)$set['cloud_warehouse']['cw_goods']);
                if(in_array($val['id'],$cw_goods)){
                    $is_cloud_warehouse = 1;
                }
            }
        }

        if($is_cloud_warehouse == 1){
            $delivery_method_list = [];
            $delivery_method = 0;
        }
         
        $result = $this->model->calculateMoney($goods,$user,$coupon_id,$delivery_method,$address_id);
        
        $total_fee = $result['total_price'];
        $total_price = $result['total_price'];
        $totalNum = $result['totalNum'];
        $express_fee = $result['express_fee'];
        $discount_price = $result['discount_price'];
        $original_price = $result['original_price'];
        $total_fee = round($total_price + $express_fee,2);
        foreach ($goods as $key => &$val){
            $val['thumb'] = cdnurl($val['thumb']);
        }
        unset($val);
        
        $order_repurchase_currency = 0;
        $repurchase_currency = floatval($user['repurchase_currency']);
        if($repurchase_currency > 0){
            if($total_fee > $repurchase_currency){
                $order_repurchase_currency = $repurchase_currency;
                $total_fee = round($total_fee - $repurchase_currency,2);
            }
            else{
                $order_repurchase_currency = $total_fee;
                $total_fee = 0;
            }
        }
        
        $plugin = iunserializer($goods[0]['plugin']);
        $form_list = [];
        if($plugin['form']['status'] == 1){
            $form_list = $plugin['form']['list'];
        }
        
        $data = array(
            'is_cloud_warehouse'=>$is_cloud_warehouse,
            'form_list'=>$form_list,
            'goods'=>$goods,
            'total_fee'=>$total_fee,
            'order_repurchase_currency'=>$order_repurchase_currency,
            'original_price'=>$original_price,
            'discount_price'=>$discount_price,
            'discount_vip_price'=>$result['discount_vip_price'],
            'discount_coupon_price'=>$result['discount_coupon_price'],
            'totalNum'=>$totalNum,
            'total_price'=>$total_price,
            'delivery_method_list'=>$delivery_method_list,
            'delivery_method'=>$delivery_method,
            'express_fee'=>$express_fee,
            'hexiao_info_required'=>$hexiao_info_required,
            'is_gift_goods'=>$is_gift_goods
        );
        if(!empty($result['coupon'])){
            $data['coupon'] = $result['coupon'];
        }
        
        __success("操作成功",$data);
    }
    
    public function check(){
        global $_W;
        $params = $this->param();
        $goods_id = intval($params['goods_id']);
        
        $goods = Db::name("bbfx_goods")->where(['id'=>$goods_id,'status'=>1])->find();
        if(empty($goods)){
            __error("商品不存在");
        }
        
        $user = $this->user;
        if($user['is_distributor'] != 1 || $user['distributor_status'] != 1){
            $user['level'] = -1;
        }
        $levels = iunserializer($goods['levels']);
        $set = $_W['base'];
        if(!empty($levels) && !in_array($user['level'],$levels)){
            if(!empty($set['buylevel_tips'])){
                __error($set['buylevel_tips']);
            }
            else{
                __error("商品【{$goods['title']}】当前等级不能购买");
            }
        }
        
        __success("操作成功");
    }
    
    public function submit(){
        global $_W;
        $set = $_W['base'];
        $params = $this->param();
        
        $user = $this->user;
        
        $goods_id = intval($params['goods_id']);
        $address_id = intval($params['address_id']);
        $total = max(1,intval($params['total']));
        $coupon_id = intval($params['coupon_id']);
        $sku_id = intval($params['sku_id']);
        $store_id = intval($params['store_id']);
        $form = $params['form_list'];
        User::checkStatus($user);
        
        if($set['fenxiao']['sup_user_buyorder'] == 1){
            if($user['sup_uid'] <= 0 && $user['first_sup_uid'] <= 0){
                $first_uid = Db::name("bbfx_user")->where(['uniacid'=>UNIACID])->order("id asc")->value("id");
                if($first_uid != $user['id']){
                    __error("您还没有推荐人，无法下单");
                }
            }
        }
        
        if(!empty($params['cart_id'])){
            // 购物车
            $cart_id = explode(",",$params['cart_id']);
            $cart = Db::name("bbfx_user_cart")->where(['id'=>['in',$cart_id],'user_id'=>$user['id']])->select();
            if(empty($cart)){
                __error("购物车数据错误");
            }
            $goods_ids = [];
            foreach($cart as $key => $val){
                $goods_ids[] = $val['goods_id'];
            }
            $goods_list = Db::name("bbfx_goods")->where(['id'=>['in',$goods_ids],'status'=>1])->select();
            
            if(empty($goods_list)){
                __error("购物车商品信息错误");
            }
            
            $goods_list = array_skey($goods_list,"id");
            
            $goods = [];
            foreach($cart as $key => $val){
                if(empty($goods_list[$val['goods_id']])){
                    __error("购物车商品信息错误");
                }
                
                $info = $goods_list[$val['goods_id']];
                $info['total'] = $val['total'];
                if($info['is_spec'] == 1){
                    $sku = Db::name("bbfx_goods_spec_sku")->where(['id'=>$val['sku_id']])->find();
                    if(empty($sku)){
                        __error("请选择规格");
                    }
                    if(!empty($sku['thumb'])){
                        $info['thumb'] = cdnurl($sku['thumb']);
                    }
                    $info['sku'] = $sku;
                    $info['sku_id'] = $sku['id'];
                    $info['price'] = $sku['price'];
                    $info['stock'] = $sku['stock'];
                    $info['sku_name'] = $sku['sku_name'];
                    $info['profit_amount'] = $sku['profit_amount'];
                    $info['cost_price'] = $sku['cost_price'];
                }
                $goods[] = $info;
            }
            
        }
        else{
            $goods = Db::name("bbfx_goods")->where(['id'=>$goods_id,'status'=>1])->select();
            if($goods[0]['is_spec'] == 1){
                $sku = Db::name("bbfx_goods_spec_sku")->where(['id'=>$sku_id])->find();
                if(empty($sku)){
                    __error("请选择规格");
                }
                if(!empty($sku['thumb'])){
                    $goods[0]['thumb'] = cdnurl($sku['thumb']);
                } 
                $goods[0]['sku'] = $sku;
                $goods[0]['sku_id'] = $sku['id'];
                $goods[0]['stock'] = $sku['stock'];
                $goods[0]['price'] = $sku['price'];
                $goods[0]['sku_name'] = $sku['sku_name'];
                $goods[0]['profit_amount'] = $sku['profit_amount'];
                $goods[0]['cost_price'] = $sku['cost_price'];
            }
            
            $goods[0]['total'] = $total;
        }
        
        if(!empty($form)){
            foreach ($form as $key => $val){
                if($val['required'] && empty($val['value'])){
                    __error("请填写".$val['label']);
                }
            }
        }
        
        if(empty($goods)){
            __error("商品不存在");
        }
        
        $levels = Fenxiao::getLevels(1);
        
        try {
        	Db::startTrans();
        	
        	$order_type = 0;
        	
        	$goods_ids = [];
        	
        	$is_cloud_warehouse = -1;
        	$cw_goods = explode(",",(string)$set['cloud_warehouse']['cw_goods']);
        	$profit_amount = 0;
        	$cost_price = 0;
        	$mid = 0;
        	$is_crazy = 0;
        	$is_super_maihuo = 0;
        	$is_repurchase_currency_pay = 0;
            $gift_status = -1;
            $is_hexiao_quantity = 0;
        	
        	foreach ($goods as $key => $item){
        	    $plugin = iunserializer($item['plugin']);
                $pay = $plugin['pay'];
                
                if(is_null($pay['weixin_pay'])){
                    $pay['weixin_pay'] = 1;
                }
                if(is_null($pay['balance_pay'])){
                    $pay['balance_pay'] = 1;
                }
                if(is_null($pay['repurchase_currency_pay'])){
                    $pay['repurchase_currency_pay'] = 1;
                }
                if(is_null($pay['zfb_pay'])){
                    $pay['zfb_pay'] = 1;
                }
                if($pay['weixin_pay'] != 1 && $pay['balance_pay'] != 1 && $pay['zfb_pay'] != 1 && $pay['repurchase_currency_pay'] == 1){
                    $is_repurchase_currency_pay = 1;
                }
                if($is_repurchase_currency_pay == 0 && $pay['repurchase_currency_pay'] != 1){
                    $is_repurchase_currency_pay = 2;
                }
                
                if($set['crazy']['status'] == 1){
                    $crazy = $plugin['crazy'];
                    if($crazy['status'] == 1 && intval($crazy['crazy_portion']) > 0){
                        $is_crazy = 1;
                        if($key != 0){
                            throw new \Exception("疯狂卖货模式商品不可与其他商品一起下单1");
                        }
                    }
                    else{
                        if($is_crazy == 1){
                            throw new \Exception("疯狂卖货模式商品不可与其他商品一起下单2");
                        }
                    }
                }
                
                if($set['super_maihuo']['status'] == 1){
                    $super_maihuo = $plugin['super_maihuo'];
                    if($super_maihuo['status'] == 1 && intval($super_maihuo['super_maihuo_portion']) > 0){
                        $is_super_maihuo = 1;
                        if($key != 0){
                            throw new \Exception("超级卖货模式商品不可与其他商品一起下单");
                        }
                    }
                    else{
                        if($is_super_maihuo == 1){
                            throw new \Exception("超级卖货模式商品不可与其他商品一起下单");
                        }
                    }
                }
                
        	    if($set['cloud_warehouse']['status'] == 1){
                    if(in_array($item['id'],$cw_goods)){
                        if($is_cloud_warehouse == 0){
                            throw new \Exception("云仓商品不能和其他商品一起下单");
                        }
                        $is_cloud_warehouse = 1;
                    }
                    else{
                        $is_cloud_warehouse = 0;
                    }
                }

                if($set['gift']['status'] == 1){
                    $gift = $plugin['gift'];
                    if($gift['status'] == 1){
                        $gift_status = 0;
                        if($key > 0){
                            throw new \Exception('礼品商品不能和其他商品一起下单');
                        }
                    }
                    else{
                        if($gift_status === 0){
                            throw new \Exception('礼品商品不能和其他商品一起下单');
                        }
                    }
                }
                if($gift_status === 0 && $is_cloud_warehouse == 1){
                    throw new \Exception('礼品商品不能绑定云仓商品');
                }
        	    
        	    if($mid == 0 && $item['mid'] > 0){
        	        $mid = $item['mid'];
        	        if($key != 0){
        	            throw new \Exception("商品不属于同一门店商品，不可下单");
        	        }
        	    }
        	    else{
        	        if($mid != $item['mid']){
        	            throw new \Exception("商品不属于同一门店商品，不可下单");
        	        }
        	    }

        	    $goods_ids[] = $item['id'];
        	    if($order_type == 0){
        	        $order_type = $item['type'];
        	    }
        	   
        	    if($item['type'] != $order_type){
        	        if($order_type == 1 || $order_type == 4){
        	            throw new \Exception("虚拟商品不能和其他类型商品通过购物车一起下单【{$item['title']}】");
        	        }
        	        else if($order_type == 2){
        	            throw new \Exception("实物商品不能和其他类型商品通过购物车一起下单【{$item['title']}】");
        	        }
        	        else if($order_type == 3){
        	            throw new \Exception("核销商品不能和其他类型商品通过购物车一起下单【{$item['title']}】");
        	        }
        	        else{
        	            throw new \Exception("未知商品类型不能和其他类型商品通过购物车一起下单【{$item['title']}】");
        	        }
        	    }
        	    $total = max(1,intval($item['total']));
        	    $profit_amount += $total * $item['profit_amount'];
        	    $cost_price += $total * $item['cost_price'];
        	    $result = CloudWarehouse::checkStock($user['id'],$total,$item['id']);
        	    if($result['code'] != 1){
        	        throw new \Exception($result['message']);
        	    }
        	    
                $minbuy = max(1,intval($item['minbuy']));
                $maxbuy = intval($item['maxbuy']);
                $total_maxbuy = intval($item['total_maxbuy']);
                $daily_buy = intval($item['daily_buy']);
                $monthly_buy = intval($item['monthly_buy']); 
                if($total < $minbuy){
                    throw new \Exception("单次最低购买{$minbuy}{$item['unit']}【{$item['title']}】");
                }
                if($maxbuy > 0 && $total > $maxbuy){
                    throw new \Exception("单次最多购买{$maxbuy}{$item['unit']}【{$item['title']}】");
                }
                if($total_maxbuy > 0){
                    $user_total_maxbuy = Db::name("bbfx_order_goods")->alias("og")->join("bbfx_order o","o.id=og.order_id")->where(['o.uniacid'=>UNIACID,'o.refund_status'=>['in',[-1,2]],'o.user_id'=>$user['id'],'og.goods_id'=>$item['id']])->count();
                    $user_total_maxbuy = intval($user_total_maxbuy);
                    if(($user_total_maxbuy + $total) > $total_maxbuy){
                        throw new \Exception("最多可购买{$total_maxbuy}{$item['unit']}【{$item['title']}】");
                    }
                }
                if($daily_buy > 0){
                    $user_daily_buy = Db::name("bbfx_order_goods")->alias("og")->join("bbfx_order o","o.id=og.order_id")->where(['o.uniacid'=>UNIACID,'o.refund_status'=>['in',[-1,2]],'o.user_id'=>$user['id'],'og.goods_id'=>$item['id'],'o.createtime'=>['>',strtotime(date("Y-m-d 00:00:00"))],'o.status'=>['>=',0]])->count();
                    $user_daily_buy = intval($user_daily_buy);
                    if(($user_daily_buy + $total) > $daily_buy){
                        $buy_num = $daily_buy - $user_daily_buy;
                        if($buy_num == 0){
                            throw new \Exception("每日最多购买{$daily_buy}{$item['unit']}【{$item['title']}】");
                        }
                        else{
                            throw new \Exception("今日最多还可购买{$buy_num}{$item['unit']}【{$item['title']}】");
                        }
                    }
                }
                if($monthly_buy > 0){
                    $user_monthly_buy = Db::name("bbfx_order_goods")->alias("og")->join("bbfx_order o","o.id=og.order_id")->where(['o.uniacid'=>UNIACID,'o.refund_status'=>['in',[-1,2]],'o.user_id'=>$user['id'],'og.goods_id'=>$item['id'],'o.createtime'=>['>',strtotime(date("Y-m-01 00:00:00"))],'o.status'=>['>=',0]])->count();
                    $user_monthly_buy = intval($user_monthly_buy);
                    if(($user_monthly_buy + $total) > $monthly_buy){
                        $buy_num = $monthly_buy - $user_monthly_buy;
                        if($buy_num == 0){
                            throw new \Exception("每月最多购买{$monthly_buy}{$item['unit']}【{$item['title']}】");
                        }
                        else{
                            throw new \Exception("本月最多还可购买{$buy_num}{$item['unit']}【{$item['title']}】");
                        }
                    }
                }
                $levels = iunserializer($item['levels']);
                if($user['is_distributor'] != 1 || $user['distributor_status'] != 1){
                    $user['level'] = -1;
                }
                if(!empty($levels) && !in_array($user['level'],$levels)){
                    if(!empty($set['buylevel_tips'])){
                        throw new \Exception($set['buylevel_tips']);
                    }
                    else{
                        throw new \Exception("商品【{$item['title']}】当前等级不能购买");
                    }
                }
        	    
                if($item['type'] == 1){
                    $serial_number = Db::name("bbfx_serial_number")->where(["uniacid"=>UNIACID,'status'=>0,"goods_id"=>$item['id']])->select();
                    if(empty($serial_number) || count($serial_number) < $total){
                        throw new \Exception("库存不足【{$item['title']}】");
                    }
                }
                else{
                    if($item['stock'] < $total){
                        throw new \Exception("库存不足【{$item['title']}】");
                    }
                }
                
            }
            
            $delivery_method = 0;
            $is_hexiao = 0;
            if($order_type == 2){
                $g_delivery_method = $goods[0]['delivery_method'];
                $delivery_method = intval($params['delivery_method']);
                $delivery_method_list = [];
                $arr = [];
                if($g_delivery_method == 1 || $g_delivery_method == 3){
                    $arr[] = 1;
                }
                if($g_delivery_method == 2 || $g_delivery_method == 3){
                    $arr[] = 2;
                }
                if(!in_array($delivery_method,$arr)){
                    $delivery_method = $arr[0];
                }
                
                if($delivery_method == 2){
                    $is_hexiao = 1;
                }
            }
            else if($order_type == 4 && $goods[0]['is_hexiao'] == 1){
                $delivery_method = 2;
                $is_hexiao = 1;
            }
            $hexiao_info_required = 0;
            foreach ($goods as $key => $item){
                if($item['hexiao_info_required'] == 1){
                    $hexiao_info_required = 1;
                }
                if($is_hexiao == 1){
                
                    if($item['hexiao_store_type'] == 1 && $store_id > 0){
                        $store_goods = Db::name("bbfx_store_goods")->where(['uniacid'=>UNIACID,'goods_id'=>$item['id'],'store_id'=>$store_id])->find();
                        if(empty($store_goods)){
                            throw new \Exception("商品不能在该门店下单【{$item['title']}】");
                        }
                    }
                    
                    if($is_hexiao_quantity == 0 && $item['is_hexiao_quantity'] == 1){
                        if($key > 0){
                            throw new \Exception("已开启核销数量不可和其他商品下单");
                        }
                        $is_hexiao_quantity = 1;
                    }
                    else{
                        if($is_hexiao_quantity == 1){
                            throw new \Exception("已开启核销数量不可和其他商品下单");
                        }
                    }
                }

            }
            
            $result = $this->model->calculateMoney($goods,$user,$coupon_id,$delivery_method,$address_id);
            
            
            // throw new \Exception("订单类型：".$order_type);
            
            $price = floatval($result['total_price']);
            $express_fee = floatval($result['express_fee']);
            $original_price = floatval($result['original_price']);
            $discount_price = floatval($result['discount_price']);
            if($price <= 0){
                $price = 0;
                // throw new \Exception("订单金额错误");
            }
            $total_price = $original_price;
            
            $order_no = date('YmdHis').random(8,true);  
            $remarks = $params['remarks'];
            $order = array(
                "uniacid"=>UNIACID,
                "mid"=>$mid,
                "order_no"=>$order_no,
                'store_id'=>$store_id,
                "user_id"=>$user['id'],
                "order_type"=>$order_type,
                "price"=>$price,
                "profit_amount"=>$profit_amount,
                "cost_price"=>$cost_price,
                "total_price"=>$original_price,
                "discount_vip_price"=>round($result['discount_vip_price'],2),
                "discount_coupon_price"=>round($result['discount_coupon_price'],2),
                "discount_price"=>$discount_price,
                "original_price"=>$original_price,
                "goods_info"=>iserializer($goods),
                'remarks'=>$remarks,
                'platform'=>$params['platform'],
                'is_cloud_warehouse'=>$is_cloud_warehouse,
                'delivery_method'=>$delivery_method,
                'is_hexiao'=>$is_hexiao,
                'is_crazy'=>$is_crazy,
                'is_super_maihuo'=>$is_super_maihuo,
                'gift_status'=>$gift_status,
                'is_hexiao_quantity'=>$is_hexiao_quantity,
                'sup_path'=>$this->user['sup_path'],
                "createtime"=>time()
            );
            $extend = []; 
            if(!empty($form)){
                $extend['form'] = $form;
            }
            $order['extend'] = iserializer($extend);
            if($is_cloud_warehouse == 1){
                $order['order_source'] = 8;
            }
            
            $price_data = $result['price_data'];
            
            if(!empty($result['coupon'])){
                $order['user_coupon_id'] = $result['coupon']['id'];
                if($result['coupon']['type'] == 1){
                    $res = Db::name("bbfx_user_coupon")->where(["id"=>$result['coupon']['id'],'user_id'=>$user['id'],'status'=>0])->setDec("residue_money",$result['discount_coupon_price']);
                    if($res){
                        $residue_money = Db::name("bbfx_user_coupon")->where(["id"=>$result['coupon']['id'],'status'=>0])->value("residue_money");
                        $residue_money = floatval($residue_money);
                        if($residue_money == 0){
                            Db::name("bbfx_user_coupon")->where(["id"=>$result['coupon']['id'],'user_id'=>$user['id'],'status'=>0])->update(['status'=>1]);
                        }
                    }
                }
                else{
                    $res = Db::name("bbfx_user_coupon")->where(["id"=>$result['coupon']['id'],'user_id'=>$user['id'],'status'=>0])->update(['status'=>1]);
                }
                
                if(empty($res)){
                    throw new \Exception("优惠券错误");
                }
            }
            
            if($order_type == 2 && $delivery_method == 1){

                if($gift_status == -1 && $is_cloud_warehouse != 1){
                    $address = Db::name("bbfx_user_address")->where(['id'=>$address_id])->find();
                    if(empty($address)){
                        throw new \Exception("请选择收货地址");
                    }
                    
                    $order['delivery_username'] = $address['consignee'];
                    $order['delivery_mobile'] = $address['phone'];
                    $order['delivery_province'] = $address['province_name'];
                    $order['delivery_city'] = $address['city_name'];
                    $order['delivery_area'] = $address['area_name'];
                    $order['delivery_street'] = $address['street_name'];
                    $order['delivery_address'] = $address['address'];
                }
                
                $order['express_fee'] = $express_fee;
                
                $order['price'] = $price + $express_fee;
                $order['total_price'] = $original_price + $express_fee;
            }
            else if(($order_type == 2 && $delivery_method == 2) || ($order_type == 4 && $is_hexiao == 1)){

                if($gift_status == -1 && $hexiao_info_required == 1 && $is_cloud_warehouse != 1){
                    if(empty($params['hexiao_realname'])){
                        throw new \Exception("请输入姓名");
                    }
                    if(empty($params['hexiao_mobile'])){
                        throw new \Exception("请输入联系方式");
                    }
                    $order['hexiao_realname'] = $params['hexiao_realname'];
                    $order['hexiao_mobile'] = $params['hexiao_mobile'];
                    Db::name("bbfx_user")->where(['id'=>$user['id']])->update(['hexiao_realname'=>$order['hexiao_realname'],'hexiao_mobile'=>$order['hexiao_mobile']]);
                }
                
                
                if($mid > 0){
                    // $store = Db::name("bbfx_store")->where(['id'=>$store_id,'mid'=>$mid,'uniacid'=>UNIACID])->field("id,name,logo,realname,mobile,province,city,area,address,lat,lng")->find();
                    $store = Db::name("bbfx_store")->where(['type'=>1,'main'=>1,'mid'=>$mid,'uniacid'=>UNIACID])->field("id,name,logo,realname,mobile,province,city,area,address,lat,lng")->find();
                    if(empty($store)){
                        throw new \Exception("请选择核销门店");
                    }
                }
                else{
                    
                    $store = Db::name("bbfx_store")->where(['id'=>$store_id,'type'=>0,'mid'=>0,'uniacid'=>UNIACID])->field("id,name,logo,realname,mobile,province,city,area,address,lat,lng")->find();
                    if(empty($store)){
                        // throw new \Exception("请选择核销门店");
                    }
                }
                
                
                $order['hexiao_total'] = max(1,$goods[0]['hexiao_num']);
                $order['hexiao_num'] = max(1,$goods[0]['hexiao_num']);
                $order['hexiao_code'] = random(9,true);
                if(empty($store)){
                    $order['hexiao_store'] = iserializer($store);
                }
            }
            
            
            $order_repurchase_currency = 0;
            if($is_repurchase_currency_pay === 0){
                $repurchase_currency = floatval($user['repurchase_currency']);
                if($repurchase_currency > 0){
                    if($order['price'] > $repurchase_currency){
                        $order_repurchase_currency = $repurchase_currency;
                    }
                    else{
                        $order_repurchase_currency = $order['price'];
                    }
                }
                $order['repurchase_currency'] = $order_repurchase_currency;
            }
            
            $order_id = Db::name("bbfx_order")->insertGetId($order);
            if(empty($order_id)){
                throw new \Exception("创建订单失败");
            }
            
            $order['id'] = $order_id;
            
            if($order_repurchase_currency > 0){
                $res = User::setUserMoney($user['id'],-$order_repurchase_currency,4,1,"商品支付",$order);
                if(empty($res)){
                    throw new \Exception("创建订单失败");
                }
            }
            
            
            foreach ($goods as $key => $item){
                $total = max(1,intval($item['total']));
                $profit_amount = $item['profit_amount'] * $total;
                $cost_price = $item['cost_price'] * $total;
                $order_goods = array(
                    "uniacid"=>UNIACID,
                    "mid"=>$mid,
                    "order_id"=>$order_id,
                    "user_id"=>$user['id'],
                    "total"=>$total,
                    "profit_amount"=>$profit_amount,
                    "cost_price"=>$cost_price,
                    "price"=>$price_data[$key]['price'],
                    "total_price"=>$price_data[$key]['total_price'],
                    "discount_price"=>$price_data[$key]['discount_price'],
                    "discount_vip_price"=>$price_data[$key]['discount_vip_price'],
                    "discount_coupon_price"=>$price_data[$key]['discount_coupon_price'],
                    "goods_id"=>$item['id'],
                    "upgrade_score"=>$item['upgrade_score'] * $total,
                    "goods_info"=>iserializer($item),
                    "createtime"=>time()
                );
                
                if(!empty($item['sku'])){
                    $order_goods['sku_id'] = $item['sku_id'];
                    $order_goods['sku_name'] = $item['sku_name'];
                    $order_goods['sku'] = iserializer($item['sku']);
                }
                
                if(!empty($price_data[$key]['user_coupon_id'])){
                    $order_goods['user_coupon_id'] = $price_data[$key]['user_coupon_id'];
                }
                
                if($price_data[$key]['type'] == 1){
                    $order_goods['type'] = 1;
                    $order_goods['seckill_activity_id'] = $price_data[$key]['seckill_activity_id'];
                    $order_goods['seckill_goods_id'] = $price_data[$key]['seckill_goods_id'];
                }
                
                $og_id = Db::name("bbfx_order_goods")->insertGetId($order_goods);
                if(empty($og_id)){
                    throw new \Exception("创建订单失败");
                }
                
                $order_goods['og_id'] = $og_id;
                
                if($item['stock_type'] == 1){
                    $result = Goods::setStock($item['id'],intval($item['sku_id']),-$total,$this->user['id'],1,1,"用户下单",$order_goods,false);
                    
                    if($result['code'] != 1){
                        throw new \Exception($result['message']."【{$item['title']}】");
                    }
                }

                if((($order_type == 2 && $delivery_method == 2) || ($order_type == 4 && $is_hexiao == 1)) && $is_hexiao_quantity == 1){
                    for ($i = 0;$i < $total;$i++){
                        $hxcode_data = [
                            "uniacid"=>UNIACID,
                            "order_id"=>$order_id,
                            "pid"=>$og_id,
                            "goods_id"=>$item['id'],
                            "hexiao_total"=>max(1,$item['hexiao_num']),
                            "hexiao_num"=>max(1,$item['hexiao_num']),
                            "hexiao_code"=>random(9,true),
                            "createtime"=>time()
                        ];
                        Db::name("bbfx_order_goods_hxcode")->insertGetId($hxcode_data);
                    }
                }
            }
        	
        	
        	Db::commit();
        } catch (\Exception $e) {
        	Db::rollback();
        	$msg = $e->getMessage();
        	
        	__error($msg);
        }
        
        if(!empty($params['cart_id'])){
            Db::name("bbfx_user_cart")->where(['id'=>['in',$cart_id],'user_id'=>$user['id']])->delete();
        }
        
        /*
        try {
            Fenxiao::settlement($order_id);
        } 
        catch (\Exception $e) {}
        try {
            Agent::settlement($order_id); 
        } 
        catch (\Exception $e) {}
        */
        try {
            $printer = $set['printer'];
            if(!empty($printer) && $printer['printer_type'] == 1){
                // \app\common\model\bbfxshop\Printer::orderPrint($order['id']);
            }
        } 
        catch (\Exception $e) {}
        
         
        __success("操作成功",["order_no"=>$order_no]);
        
    }
}