<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\notice;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;


class Notice extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Notice;
    }
    
    public function index(){
        
        $num0 = Db::name("bbfx_notice")->where(['uniacid'=>UNIACID,'type'=>0,'is_read'=>0,'user_id'=>$this->user['id']])->count();
        $notice_list = Db::name("bbfx_notice")->where(['uniacid'=>UNIACID,'type'=>0,'is_read'=>0,'user_id'=>0])->field("id")->select();
        foreach($notice_list as $key => $val){
            $log = Db::name("bbfx_notice_log")->where(['uniacid'=>UNIACID,'pid'=>$val['id'],'user_id'=>$this->user['id']])->count();
            if(empty($log)){
                $num0++;
            }
        }
        $num2 = Db::name("bbfx_notice")->where(['uniacid'=>UNIACID,'type'=>2,'is_read'=>0,'user_id'=>$this->user['id']])->count();
        $num3 = Db::name("bbfx_notice")->where(['uniacid'=>UNIACID,'type'=>3,'is_read'=>0,'user_id'=>$this->user['id']])->count();
        $num4 = Db::name("bbfx_notice")->where(['uniacid'=>UNIACID,'type'=>4,'is_read'=>0,'user_id'=>$this->user['id']])->count();
        $num5 = Db::name("bbfx_notice")->where(['uniacid'=>UNIACID,'type'=>5,'is_read'=>0,'user_id'=>$this->user['id']])->count();

        $message = [];
        $message['0'] = intval($num0);
        $message['2'] = intval($num2);
        $message['3'] = intval($num3);
        $message['4'] = intval($num4);
        $message['5'] = intval($num5);

        __success("操作成功",['message'=>$message]);
    }

    public function getList(){
        $type = $this->param("type/d");
        $page = max(1,$this->param("page/d"));
        $limit = 20;
        
        $where = ['uniacid'=>UNIACID,'type'=>$type];
        
        if($type != 0){
            $where['user_id'] = $this->user['id'];
        }
        else{
            $where['user_id'] = ['in',[0,$this->user['id']]];
        }

        if(in_array($type,[3,4,5])){
            Db::name("bbfx_notice")->where($where)->where(['is_read'=>0])->update(['is_read'=>1,'readtime'=>time()]);
        }
        
        $list = Db::name("bbfx_notice")->where($where)->field("id,type,user_id,title,link,is_read,readtime,extend,content,createtime")->order("createtime desc")->limit(($page-1)*$limit,$limit)->select();
        
        foreach ($list as $key => &$val){
            $val['extend'] = iunserializer($val['extend']);
            if($val['extend']['mobile']){
                $val['extend']['mobile'] = secret($val['extend']['mobile'], true, 3, 4);
            }
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
            if($val['type'] == 0 && $val['is_read'] == 0){
                $log = Db::name("bbfx_notice_log")->where(['uniacid'=>UNIACID,'pid'=>$val['id'],'user_id'=>$this->user['id']])->find();
                $val['is_read'] = 0;
                if(!empty($log)){
                   $val['is_read'] = 1; 
                   $val['readtime'] = $log['createtime']; 
                }
            }
            
            if($val['type'] == 1 || $val['type'] == 2){
                if(empty($val['link']) && !empty($val['content'])){
                    $val['link'] = "/plugin/notice/message?id=".$val['id'];
                }
            }
            else{
                $val['link'] = "/plugin/notice/message?id=".$val['id'];
            }
            // unset($val['content']);
        }
        unset($val);
        
        __success("操作成功",['list'=>$list]);
    }
    
    public function info(){
        $id = $this->param("id/d");
        
        $info = Db::name("bbfx_notice")->where(['id'=>$id])->find();
        if(empty($info)){
            __error("通知消息不存在");
        }
        
        __success("操作成功",['info'=>$info]);
    }
    
    public function read(){
        $id = $this->param("id/d");
        
        $info = Db::name("bbfx_notice")->where(['id'=>$id])->find();
        if(empty($info)){
            __error("通知消息不存在");
        }
        
        if($info['type'] != 0){
            if($info['user_id'] != $this->user['id']){
                __error("操作失败");
            }
            if($info['is_read'] == 1){
                __error("已读");
            }
            Db::name("bbfx_notice")->where(['id'=>$id])->update(['is_read'=>1,'readtime'=>time()]);
        }
        else{
            if($info['user_id'] > 0 && $info['user_id'] != $this->user['id']){
                __error("操作失败");
            }
            $log = Db::name("bbfx_notice_log")->where(['uniacid'=>UNIACID,'pid'=>$id,'user_id'=>$this->user['id']])->find();
            if(!empty($log)){
                __error("已读");
            }

            if($info['user_id'] > 0 && $info['user_id'] == $this->user['id']){
                Db::name("bbfx_notice")->where(['id'=>$id])->update(['is_read'=>1,'readtime'=>time()]);
            }

            $data = ['uniacid'=>UNIACID,'user_id'=>$this->user['id'],'pid'=>$id,'createtime'=>time()];
            
            Db::name("bbfx_notice_log")->insert($data);
        }
        
        __success("操作成功");
    }
}