<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\merchant;

use app\api\controller\Base;
use think\Db;


class Goods extends Base
{
    protected $noNeedLogin = ['*'];
    protected $noNeedRight = ['*'];

    public function getCategoryList(){
        $mid = $this->param("mid/d");
        $where = ['uniacid'=>UNIACID,'status'=>1,'is_shenhe'=>1,'yy_status'=>1,'id'=>$mid];
        $info = Db::name("bbfx_merchant")->where($where)->field("id,name,logo,realname,mobile,province,city,area,address,lat,lng,yy_time,introduction,detail_images,images,createtime")->find();
        if(empty($info)){
            __error('商户不存在');
        }
        $list = Db::name("bbfx_category")->where(["uniacid"=>UNIACID,"mid"=>$info['id'],"status"=>1])->order('sort desc,id desc')->select();

        __success("操作成功",['list'=>$list]);
    }

    public function getList(){
        $mid = $this->param("mid/d");
        $params = $this->param();
        
        \app\common\model\bbfxshop\Goods::resetStock(UNIACID);
        
        $pindex = max(1, intval($params["page"]));
        $psize = 12;
        $category_id = intval($params['category_id']);
        
        if($category_id){
            $category_ids = [$category_id];
            $child = Db::name("bbfx_category")->where(['pid'=>$category_id,'mid'=>$mid])->find();
            if(!empty($child)){
                $category_ids[] = $child['id'];
                $three_child = Db::name("bbfx_category")->where(['pid'=>$child['id'],'mid'=>$mid])->find();
                if(!empty($three_child)){
                    $category_ids[] = $three_child['id'];
                }
            }
            
            $where = ["a.uniacid"=>UNIACID,'a.status'=>1,'a.mid'=>$mid,'b.category_id'=>['in',$category_ids]];
            
            $list = Db::name("bbfx_goods")->alias("a")->join("bbfx_goods_category b","a.id=b.goods_id")->where($where)->field("a.id,a.title,a.subtitle,a.thumb,a.price,a.stock,a.type,a.o_price,a.minbuy,a.maxbuy,a.total_maxbuy,a.unit,a.sales_volume,a.virtual_sale,a.is_nodiscount,a.is_leveldiscount_rule,a.level_discount")->order('is_recommend asc,sort desc')->limit(($pindex - 1) * $psize,$psize)->select();
        }
        else{
            $where = ["uniacid"=>UNIACID,'status'=>1,'mid'=>$mid];
            
            $list = Db::name("bbfx_goods")->where($where)->field("id,title,subtitle,thumb,price,stock,type,o_price,minbuy,maxbuy,total_maxbuy,unit,sales_volume,virtual_sale,is_nodiscount,is_leveldiscount_rule,level_discount")->order('is_recommend asc,sort desc')->limit(($pindex - 1) * $psize,$psize)->select();
        }
        
        if(!empty($list)){
            foreach($list as $key=>&$val){
                
            	$val['thumb'] = cdnurl($val['thumb']);
            	
            	if($val['sales_volume'] == 0){
            	    $sales_volume = Db::name("bbfx_order_goods")->alias("og")->join("bbfx_order o","og.order_id=o.id","LEFT")->where(['o.uniacid'=>UNIACID,'o.order_source'=>['<>',6],'o.status'=>['>',0],'og.goods_id'=>$val['id']])->sum("og.total");
            	    $val['sales_volume'] = intval($sales_volume);
            	    
            	    if($val['sales_volume'] > 0){
            	        Db::name("bbfx_goods")->where(['id'=>$val['id']])->update(['sales_volume'=>$val['sales_volume']]);
            	    }
            	}
                $val['sales_volume'] = intval($val['sales_volume'] + $val['virtual_sale']);
                
                if($val['type'] == 1){
                    $stock = Db::name("bbfx_serial_number")->where(['uniacid'=>UNIACID,'goods_id'=>$val['id'],'status'=>0])->count();
                    $val['stock'] = $stock;
                }
            }
            unset($val);
            __success("操作成功",$list);
        }
        else{
            __error($pindex==1?"暂无商品数据~~":"没有数据了"); 
        }
    }


    public function list(){
        $page = max(1, intval($this->param('page/d')));
        $limit = 10;
        $category_id = intval($this->param('category_id/d'));
        $lat = $this->param("lat/f");
        $lng = $this->param("lng/f");
        $sort = $this->param("sort/d");
        $keyword = $this->param("keyword/s");
        $where = ['a.uniacid'=>UNIACID,'a.mid'=>['>',0],'a.status'=>1,'a.sh_status'=>1,'b.status'=>1,'b.is_shenhe'=>1];
        $fields = "a.id,a.score,a.title,a.subtitle,a.thumb,a.price,a.stock,a.type,a.o_price,a.minbuy,a.maxbuy,a.total_maxbuy,a.unit,a.sales_volume,a.virtual_sale,a.is_nodiscount,a.is_leveldiscount_rule,a.level_discount,b.name as merchant_name,b.province,b.city,b.area,b.address,b.lat,b.lng";
        
        if($category_id > 0){
            $where['b.category_id'] = ['like','%,'.$category_id.',%'];
        }

        if(!empty($keyword)){
            $where['a.title'] = ['like','%'.$keyword.'%'];
        }
        
        $list = Db::name("bbfx_goods")->alias("a")->join("bbfx_merchant b","a.mid=b.id","LEFT")->where($where)->field($fields)->order("a.id desc")->group("a.mid")->select();

        if(!empty($list)){
            foreach($list as $key=>&$val){
                $val['thumb'] = cdnurl($val['thumb']);
                
                if($val['sales_volume'] == 0){
                    $sales_volume = Db::name("bbfx_order_goods")->alias("og")->join("bbfx_order o","og.order_id=o.id","LEFT")->where(['o.uniacid'=>UNIACID,'o.order_source'=>['<>',6],'o.status'=>['>',0],'og.goods_id'=>$val['id']])->sum("og.total");
                    $val['sales_volume'] = intval($sales_volume);
                    
                    if($val['sales_volume'] > 0){
                        Db::name("bbfx_goods")->where(['id'=>$val['id']])->update(['sales_volume'=>$val['sales_volume']]);
                    }
                }
                $val['sales_volume'] = intval($val['sales_volume'] + $val['virtual_sale']);
                
                if($val['type'] == 1){
                    $stock = Db::name("bbfx_serial_number")->where(['uniacid'=>UNIACID,'goods_id'=>$val['id'],'status'=>0])->count();
                    $val['stock'] = $stock;
                }

                if(!empty($lng)&&!empty($lat)&&!empty($val['lng'])&&!empty($val['lat'])){
                    $distance = getdistance($lng,$lat,$val['lng'],$val['lat']);
                    $val['distanceText'] = $distance.'km';
                    $val['distance'] = $distance;
                }
                else{
                    $val['distance'] = 999999;
                    $val['distanceText'] = '';
                }
                $val['category_id'] = deid($val['category_id']);
            }
            unset($val);
        }
        else{
            $list = [];
        }

        if($sort == 1){
            $keys = array_column($list,'distance');
            array_multisort($keys,SORT_DESC,$list);
        }
        else if($sort == 2){
            $keys = array_column($list,'sales_volume');
            array_multisort($keys,SORT_DESC,$list);
        }
        else if($sort == 3){
            $keys = array_column($list,'score');
            array_multisort($keys,SORT_DESC,$list);
        }

        $list = array_slice($list, ($page-1)*$limit, $limit);

        __success("操作成功",['list'=>$list]);
    }
}