<?php


namespace app\api\controller\luckywheel;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;

class Prize extends Base
{
    protected $noNeedLogin = ['getList'];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Luckywheel;
    }
    
    public function getList(){
        $list = Db::name("bbfx_luckywheel_prize")->where(['uniacid'=>UNIACID,'status'=>1])->order("sort desc,id desc")->select();
        
        foreach ($list as &$val) {
            $val['image'] = cdnurl($val['image']);
        }
        
        __success("操作成功",['list'=>$list]);
    }
    
    public function luckdraw(){
        $result = $this->model->luckdraw($this->user['id']);
        __result($result);
    }
    
    public function getRecordList(){
        $list = Db::name("bbfx_luckywheel_prize_log")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id']])->order("id desc")->select();
        
        foreach ($list as &$val) {
            $val['prize'] = iunserializer($val['prize']);
            $val['prize']['image'] = cdnurl($val['prize']['image']);
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
        }
        
        __success("操作成功",['list'=>$list]);
    }
}