<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\form;

use app\api\controller\Base;
use think\Db;

class Form extends Base
{
    protected $noNeedLogin = ['info'];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Form;
    }

    public function info(){
        $id = $this->param("id/d");

        $form = Db::name("bbfx_form")->where(['id'=>$id,'uniacid'=>UNIACID])->find();
        if(empty($form)){
            __error("表单信息不存在");
        }
        if($form['status'] != 1){
            __error("表单已被禁用");
        }

        $form['image'] = cdnurl($form['image']);
        $form['content'] = iunserializer($form['content']);

        __success("操作成功",['info'=>$form]);
    }

    public function submit(){
        $id = $this->param("id/d");
        $content = $this->param("content/a");
        $set = $this->model->getSet();
        if($set['status'] != 1){
            __error("未开启表单功能");
        }
        $form = Db::name("bbfx_form")->where(['id'=>$id,'uniacid'=>UNIACID])->find();
        if(empty($form)){
            __error("表单信息不存在");
        }
        if($form['status'] != 1){
            __error("表单已被禁用");
        }

        if($form['is_repeat'] != 1){
            $log = Db::name("bbfx_form_record")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id'],'form_id'=>$form['id']])->find();
            if(!empty($log)){
                __error("已提交过表单，请勿重复提交");
            }
        }
        

        if(empty($content)){
            __error("请提交表单内容");
        }
        foreach ($content as $key => &$val){
            if($val['required'] && empty($val['value'])){
                if($val['type'] == 'image' || $val['type'] == 'images'){
                    __error("请上传".$val['label']);
                }
                else if($val['type'] == 'select' || $val['type'] == 'radio'){
                    __error("请选择".$val['label']);
                }
                else{
                    __error("请填写".$val['label']);
                }
            }
            if($val['type'] == 'image'){
                $val['value'] = replaceSiteroot($val['value']);
            }
            else if($val['type'] == 'images'){
                foreach($val['value'] as $k => &$v){
                    $v = replaceSiteroot($v);
                }
                unset($v);
            }
        } 
        unset($val);

        $data = [
            'uniacid'=>UNIACID,
            'user_id'=>$this->user['id'],
            'form_id'=>$form['id'],
            'content'=>iserializer($content),
            'info'=>iserializer($form),
            'createtime'=>time()
        ];

        try {
            
            Db::name("bbfx_form_record")->insert($data);

        } catch (\Exception $e) {
            __error($e->getMessage());
        }

        __success("操作成功");
    }
}