<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\fenxiao;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;


class Order extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Fenxiao;
    }
    
    public function list(){
        global $_W;
        $params = $this->param();
        
        $type = intval($params['type']);
        $base = $_W['base'];
        $texts = $base['fenxiao']['texts'];
        $page = max(1,intval($params['page']));
        $psize = 20;
        
        $where = ['uniacid'=>UNIACID,'money_type'=>['in',[1,3]],'user_id'=>$this->user['id'],'status'=>1];
        if($type >= 1){
            $title = $this->model->getTypeText($type);
        }
        else if($type == -1){
            $title = $texts['commission_total'];
        }
        else{
            $title = $texts['commission_order'];
        }
        
        if($type){
            if($type == 7){
                $where['type'] = ['in',[7,10,12]];
            }
            else if($type == -1){
                
                
                // $fenxiao_order_all = Db::name("bbfx_fenxiao_order")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id'],'order_id'=>['>',0]])->field("order_id")->select();
                
                $order_all = Db::name("bbfx_fenxiao_order")->alias("a")->join("bbfx_order b","a.order_id=b.id","LEFT")->where(['b.uniacid'=>UNIACID,'a.user_id'=>$this->user['id'],'b.status'=>['in',[1,2,3]],'b.refund_status'=>['in',[-1,2]]])->field("a.id")->select();
                
                $oids = array_column($order_all, 'id');
                $where['status'] = ['in',[0,1]];
                $where['id'] = ['in',$oids];
            }
            else{
                $where['type'] = $type;
            }
        }
        else{
            $where['type'] = ['in',[1,2,3]];
        }
        
        
        // $list = Db::name("bbfx_fenxiao_order")->alias("a")->join("bbfx_order_goods b","a.og_id=b.id")->join("bbfx_user c","b.user_id=c.id")->join("bbfx_order d","a.order_id=d.id")->where($where)->field("a.*,b.goods_info,b.total,b.price,c.nickname,c.avatar,d.order_no")->order('a.id desc')->select();
        // echo "<pre>";
        // print_r($where);die;
        $list = Db::name("bbfx_fenxiao_order")->where($where)->limit(($page-1)*$psize,$psize)->order("createtime desc")->select();
        
        if(empty($list)){
            $list = [];
        }
        
        $money_total = Db::name("bbfx_fenxiao_order")->where($where)->sum("money");
        foreach ($list as &$val){
            $val['typeText'] = $this->model->getTypeText($val['type'],$val['money_type']);
            
            if($val['order_type'] == 1){
                $order = Db::name("bbfx_member_card_order")->alias("o")->join("bbfx_user u","o.user_id=u.id")->where(['o.uniacid'=>UNIACID,'o.id'=>$val['order_id']])->field("o.info,u.nickname,u.avatar,o.order_no")->find();
                if(!empty($order)){
                    $info = iunserializer($order['info']);
                    $val['avatar'] = cdnurl($order['avatar']);
                    $val['nickname'] = $order['nickname'];
                    $val['order_no'] = $order['order_no'];
                    $val['info'] = $info;
                }
                $val['typeText'] = $val['typeText']."（会员卡佣金）";
            }
            else if($val['order_type'] == 2){
                $val['typeText'] = $val['typeText']."（预存款佣金）";
            }
            else{
                $order = Db::name("bbfx_order_goods")->alias("og")->join("bbfx_order o","og.order_id=o.id")->join("bbfx_user u","o.user_id=u.id")->where(['o.uniacid'=>UNIACID,'og.order_id'=>$val['order_id'],'og.id'=>$val['og_id']])->field("og.goods_info,og.total,og.price,u.nickname,u.avatar,o.order_no,o.remarks")->find();
            
                if(!empty($order)){
                    $goods_info = iunserializer($order['goods_info']);
                    $goods_info['thumb'] = cdnurl($goods_info['thumb']);
                    $val['avatar'] = cdnurl($order['avatar']);
                    $val['total'] = $order['total'];
                    $val['price'] = $order['price'];
                    $val['nickname'] = $order['nickname'];
                    $val['order_no'] = $order['order_no'];
                    $val['order_remarks'] = $order['remarks'];
                    $val['goods_info'] = $goods_info;
                }
            }
            
            if($val['money_type'] == 2){
                $val['moneyText'] = "+".floatval($val['money']).$base['texts']['score_unit'];
            }
            else{
                $val['moneyText'] = "+".floatval($val['money']).$texts['yuan'];
            }
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
            
        }
        unset($val);
        
        __success("success",array("list"=>$list,"title"=>$title,'money_total'=>round($money_total,2)));
    }
}