<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\contract;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;


class Contract extends Base
{
    protected $noNeedLogin = [];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Contract;
    }
    
    public function getSignContract(){
        $record = Db::name("bbfx_contract_record")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id'],'status'=>0,'signing_type'=>0])->order("id asc")->find();
        if(empty($record)){
            __error("未有需强制签署的合同");
        }
        $record['content'] = cdnurl($record['content']);
        __success("操作成功",$record);
    }
    public function info(){
        $id = $this->param("id/d");
        $record = Db::name("bbfx_contract_record")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id'],'status'=>0,'id'=>$id])->order("id asc")->find();
        if(empty($record)){
            __error("合同不存在");
        }
        $record['content'] = cdnurl($record['content']);
        __success("操作成功",$record);
    }
    public function getList(){
        $list = Db::name("bbfx_contract_record")->where(['uniacid'=>UNIACID,'user_id'=>$this->user['id']])->order("id desc")->select();
        foreach ($list as $key => &$val){
            $val['content'] = cdnurl($val['content']);
            $val['createtime'] = date('Y-m-d H:i:s',$val['createtime']);
            $val['signingtime'] = date('Y-m-d H:i:s',$val['signingtime']);
        }
        unset($val);
        __success("操作成功",$list);
    }
    public function signContract(){
        $params = $this->param(['id/d','sign_img/s']);
        $result = $this->model->signContract($params['id'],$params['sign_img']);
        if($result['code'] == 1){
            __success("签署成功");
        }
        else{
            __error($result['message']);
        }
    }
}