<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller\card;

use app\api\controller\Base;
use think\Db;
use app\common\model\bbfxshop\User;


class Card extends Base
{
    protected $noNeedLogin = ['getList'];
    protected $noNeedRight = ['*'];
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Card;
    }
    
    public function getList(){
        $where = array("uniacid"=>UNIACID);
        $list = Db::name("bbfx_member_card")->where($where)->order('sort asc,id asc')->select();
        
        if(empty($list)){
            __error("暂无会员卡");
        }
        
        $types = ['-1'=>'永久有效','30'=>'1个月','90'=>'3个月','365'=>'1年'];
        foreach ($list as $key => &$val){
            $val['type'] = $this->model->getType($val['yx_day']);
            if(!empty($types[$val['yx_day']])){
                $val['month'] = $types[$val['yx_day']];
            }
            else{
                if($val['yx_day']%30){
                    $val['month'] = intval($val['yx_day']/30)."月";
                }
                else{
                    $val['month'] = $val['yx_day']."天";
                }
            }
        }
        unset($val);
        __success("操作成功",['list'=>$list]);
    }
}