<?php

namespace app\api\controller\activity;

use app\api\controller\Base;
use think\Db;
use think\Cache;

class Manage extends Base
{
    protected $noNeedLogin = ['export'];
    protected $noNeedRight = ['*'];

    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Activity;
    }
    
    protected function export($id){
        // $t = $this->param("t/s");
        // $id = Cache::set("activity_".$t);
        // $id = intval($id);
        
        $where = ['a.uniacid'=>UNIACID,'a.activity_id'=>$id,'is_pay'=>1];
        
        $list = Db::name("bbfx_activity_baoming")->alias("a")->join("bbfx_user b","a.user_id=b.id","left")->where($where)->field("a.*,b.avatar,b.nickname")->order("a.id desc")->select();
        
        if(empty($list)){
            // return false;
        }
        $export_list = [];
        foreach ($list as $key => $val){
            $val['avatar'] = cdnurl($val['avatar']);
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
            $val['paytime'] = date("Y-m-d H:i:s",$val['paytime']);
            $export_list[] = [
                $val['realname'],
                $val['sex']==1?'男':'女',
                $val['mobile'],
                $val['baoming_fee'],
                $val['paytime']
            ];
        }
        
        $headArr = ["姓名","性别","手机号","报名费","报名时间"];
    	$result = \app\common\model\PhpOffice::excelExportFile("a-".$id."-".date("Y-m-d"),$headArr,$export_list);
    	
    	
    	return $result;
    }
    
    public function getList(){
        $list = Db::name("bbfx_activity_list")->where(['uniacid'=>UNIACID,'pid'=>$this->user['id']])->field("id,title,image,type,is_public,starttime,endtime,baoming_total,address,detail_address,lat,lng")->order("id desc")->select();
        
        foreach ($list as $key => &$val){
            $val['starttime'] = date("Y.m.d H:i",$val['starttime']);
            $val['endtime'] = date("Y.m.d H:i",$val['endtime']);
            $baoming_num = Db::name("bbfx_activity_baoming")->where(['uniacid'=>UNIACID,'activity_id'=>$val['id'],'is_pay'=>1])->count();
            $val['baoming_num'] = $baoming_num;
            $val['image'] = cdnurl($val['image']);
            $val['advert_image'] = cdnurl($val['advert_image']);
        }
        unset($val);
        
        __success("操作成功",['list'=>$list]);
    }
    
    public function getBaomingList(){
        $id = $this->param("id/d");
        $page = max(1,$this->param("page/d"));
        $limit = 20;
        
        $where = ['a.uniacid'=>UNIACID,'a.activity_id'=>$id,'is_pay'=>1];
        
        $list = Db::name("bbfx_activity_baoming")->alias("a")->join("bbfx_user b","a.user_id=b.id","left")->where($where)->field("a.*,b.avatar,b.nickname")->order("a.id desc")->limit(($page-1)*$limit,$limit)->select();
        $total = Db::name("bbfx_activity_baoming")->alias("a")->join("bbfx_user b","a.user_id=b.id","left")->where($where)->count();
        $activity = Db::name("bbfx_activity_list")->where(['id'=>$id,'pid'=>$this->user['id']])->find();
        $activity['image'] = cdnurl($activity['image']);
        foreach ($list as $key => &$val){
            $val['avatar'] = cdnurl($val['avatar']);
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
            $val['is_hexiao'] = $activity['is_hexiao'];
        }
        unset($val);
        
        $export_url = "";
        
        // $result = $this->export($id);
        // if(!empty($result) && !empty($result['url'])){
        //     $export_url = cdnurl($result['url']);
        // }

        

        __success("操作成功",['list'=>$list,'total'=>$total,'activity'=>$activity,'expsort_url'=>$export_url]);
    }
    
    public function detail(){
        $id = $this->param("id/d");
        $info = Db::name("bbfx_activity_list")->where(['id'=>$id,'pid'=>$this->user['id']])->find();
        if(empty($info)){
            __error("活动不存在");
        }
        
        $info['slide_images'] = cdnurls(iunserializer($info['slide_images']));
        $info['slide_videos'] = cdnurls(iunserializer($info['slide_videos']));
        $info['detail_images'] = cdnurls(iunserializer($info['detail_images']));
        $info['advert_image'] = cdnurl($info['advert_image']);
        $info['image'] = cdnurl($info['image']);
        $info['music'] = cdnurl($info['music']);
        $info['poster_image'] = cdnurl($info['poster_image']);
        $info['starttime'] = date("Y-m-d H:i:s",$info['starttime']);
        $info['endtime'] = date("Y-m-d H:i:s",$info['endtime']);
        $info['bm_stime'] = date("Y-m-d H:i:s",$info['bm_stime']);
        $info['bm_etime'] = date("Y-m-d H:i:s",$info['bm_etime']);
        
        __success("操作成功",['info'=>$info]);
    }
    
    public function del(){
        $id = $this->param("id/d");
        $info = Db::name("bbfx_activity_list")->where(['id'=>$id,'pid'=>$this->user['id']])->find();
        if(empty($info)){
            __error("活动不存在");
        }
        
        $res = Db::name("bbfx_activity_list")->where(['id'=>$id,'pid'=>$this->user['id']])->delete();
        if($res){
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }

    public function hexiao(){
        
        $params = $this->param(['type/d','baoming_id/d','code/s']);
        $params['user_id'] = $this->user['id'];
        $result = $this->model->hexiao($params);

        __result($result);
    }

    public function post(){
        $id = $this->param("id/d");

        $set = $this->model->getSet();
        if($set['status'] != 1){
            __error("未开启活动");
        }
        
        $params = $this->param(['title/s','image/s','type/d','is_public/d','is_hexiao/d','baoming_user_scroll/d','slide_images/a','slide_videos/a','goods_ids/a','starttime/s','endtime/s','bm_stime/s','bm_etime/s','baoming_total/d','detail_images/a','mobile/s','music/s','status/d','advert_image/s','virtual_baoming/d','baoming_fee/f','address/s','lat/f','lng/f','poster_image/s','detail_address/s']);
         
        $data = array(
            "uniacid"=>UNIACID,
            "pid"=>$this->user['id'],
            "slide_images"=>iserializer(replaceSiteroots($params['slide_images'])),
            "slide_videos"=>iserializer(replaceSiteroots($params['slide_videos'])),
            "detail_images"=>iserializer(replaceSiteroots($params['detail_images'])),
            "title"=>$params['title'],
            "starttime"=>strtotime($params['starttime']),
            "endtime"=>strtotime($params['endtime']),
            // "bm_stime"=>strtotime($params['bm_stime']),
            // "bm_etime"=>strtotime($params['bm_etime']),
            "baoming_total"=>$params['baoming_total'],
            "mobile"=>$params['mobile'],
            "music"=>replaceSiteroot($params['music']),
            "advert_image"=>replaceSiteroot($params['advert_image']),
            "poster_image"=>replaceSiteroot($params['poster_image']),
            "image"=>replaceSiteroot($params['image']),
            "status"=>$params['status'],
            "type"=>$params['type'],
            "is_public"=>$params['is_public'],
            "is_hexiao"=>$params['is_hexiao'],
            "baoming_user_scroll"=>$params['baoming_user_scroll'],
            "virtual_baoming"=>$params['virtual_baoming'],
            "baoming_fee"=>$params['baoming_fee'],
            // "address"=>$params['address'],
            // "detail_address"=>$params['detail_address'],
            // "lat"=>$params['lat'],
            // "lng"=>$params['lng'],
            "updatetime"=>time()
        );
        
        if(empty($data['title'])){
            __error("请填写活动标题");
        }
        if(empty($data['slide_images']) && empty($data['slide_videos'])){
            __error("请上传轮播图或视频");
        }
        if(empty($data['detail_images'])){
            __error("请上传详情图片");
        }
        if(empty($params['starttime'])){
            __error("请选择开始时间");
        }
        if(empty($params['endtime'])){
            __error("请选择结束时间");
        }
        if($params['baoming_total'] <= 0){
            __error("请填写报名人数");
        }
        if(empty($params['music'])){
            // __error("请上传活动背景音乐");
        }

        if($data['type'] == 1){
            if(empty($params['address'])){
                __error("请选择活动地址");
            }
            if(empty($params['lat']) || empty($params['lng'])){
                __error("请选择定位活动地址");
            }
            $data['detail_address'] = $params['detail_address'];
            $data['address'] = $params['address'];
            $data['lat'] = $params['lat'];
            $data['lng'] = $params['lng'];
        }
        
        
        if(empty($params['bm_stime']) && !empty($params['bm_etime'])){
            __error("请选择报名开始时间");
        }
        if(!empty($params['bm_stime']) && empty($params['bm_etime'])){
            __error("请选择报名结束时间");
        }
        if(!empty($params['bm_stime']) && !empty($params['bm_etime'])){
            $data['bm_stime'] = strtotime($params['bm_stime']);
            $data['bm_etime'] = strtotime($params['bm_etime']);
            if($data['starttime'] > $data['endtime']){
                __error("活动结束时间必须大于活动开始时间");
            }
            if($data['bm_stime'] > $data['bm_etime']){
                __error("报名结束时间必须大于报名开始时间");
            }
            if($data['bm_stime'] > $data['starttime']){
                __error("报名开始时间必须小于活动开始时间");
            }
            if($data['bm_etime'] > $data['endtime']){
                __error("报名结束时间必须小于活动结束时间");
            }
        }
        
        
        $info = Db::name("bbfx_activity_list")->where(['id'=>$id,'pid'=>$this->user['id']])->find();

        if(!empty($info)){
            if($set['is_shenhe'] == 1){
                if($set['edit_shenhe'] == 1 || $info['sh_status'] == 2){
                    $data['sh_status'] = 0;
                }
            }
            else{
                if($info['sh_status'] != 1){
                    $data['sh_status'] = 1;
                    $data['sh_time'] = time();
                }
            }
            if($set['is_shenhe'] == 1 && $info['edit_shenhe'] == 1){
                $baoming = Db::name("bbfx_activity_baoming")->where(['activity_id'=>$info['id'],'is_pay'=>1])->find();
                if(!empty($baoming)){
                    __error("用户已开始报名，不可修改");
                }
            }
        }
        else{
            if($set['is_shenhe'] == 1){
                $data['sh_status'] = 0;
            }
            else{
                $data['sh_status'] = 1;
                $data['sh_time'] = time();
            }
        }

        if(empty($info)){

            $data['createtime'] = time();
            if($data['endtime'] < time()){
                __error("结束时间必须大于当前时间");
            }
            
            $res = Db::name("bbfx_activity_list")->insert($data);
        }
        else{
            $res = Db::name("bbfx_activity_list")->where(['id'=>$info['id']])->update($data);
        }
        
        if($res){
            __success("提交成功");
        }
        else{
            __error("操作失败");
        }
    }
}