<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\api\controller;

use app\api\controller\Base;
use think\Db;
use think\Cache;
use app\common\model\bbfxshop\Wxpay;
use app\common\model\bbfxshop\User;
use app\common\model\bbfxshop\Order;
use app\common\model\bbfxshop\CloudWarehouse;
use app\common\model\bbfxshop\Alipay;

class Pay extends Base
{ 
    protected $noNeedLogin = ['notify','alipayNotify','checkSubmit'];
    protected $noNeedRight = ['*'];
    
    public function checkSubmit(){
        $order_no = $this->param("order_no/s");
        
        
        if(empty($order_no)){
            __error("订单号错误");
        }
        
        Cache::set($order_no,time());
        
        __success('操作成功');
    }
    
    public function check(){
        $order_no = $this->param("order_no/s");
        if(empty($order_no)){
            __error("订单号错误");
        }
        
        $pay_order = Db::name("bbfx_pay_order")->where(['order_no'=>$order_no,'uniacid'=>UNIACID])->find();
        if(empty($pay_order)){
            __error("订单不存在");
        }
        
        if($pay_order['is_pay'] == 1){
            __success('操作成功',['is_pay'=>1]);
        }
        
        $u_time = Cache::get($order_no);
        if(time() - $u_time > 60){
            Cache::rm($order_no);
            __error("操作失败");
        }
        
        __success('操作成功',['is_pay'=>0]);
    }
    
    public function order(){
        global $_W;
        $params = $this->param();
        
        $order_type = intval($params['order_type']);
        $order_no = $params['order_no'];
        $user = $this->user;
        
        $is_wxpay = intval($_W['base']['is_wxpay']);
        $is_balancepay = intval($_W['base']['is_balancepay']);
        $is_deposit_release_pay = intval($_W['base']['deposit_release']['status']);
        $is_repurchase_currency_pay = 0;
        $is_alipay = intval($_W['base']['is_alipay']);
        $is_cashpay = intval($_W['base']['is_cashpay']);
        
        if($order_type == 1){
            $title = "商品支付";
            $order = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'user_id'=>$user['id'],'order_no'=>$order_no])->find();
            if(empty($order)){
                __error("订单不存在");
            }
            if($order['is_pay'] == 1){
                __error("订单已支付");
            }
            if($order['status'] == -1){
                __error("订单已关闭");
            }
            if($order['status'] != 0){
                __error("订单已支付");
            }
            $goods_info = iunserializer($order['goods_info']);
            if(!empty($goods_info)){
                $title = $goods_info[0]['title'];
            }
            else{
                $goods_info = [['thumb'=>'']];
            }
            $order_goods = Db::name("bbfx_order_goods")->alias("a")->join("bbfx_goods b","a.goods_id=b.id","left")->where(['a.order_id'=>$order['id']])->field("b.id,b.plugin")->select();
            foreach ($order_goods as $key => $val){
                $pay_set = iunserializer($val['plugin'])['pay'];
                
                if(!empty($pay_set)){
                    if(is_null($pay_set['weixin_pay'])) $pay_set['weixin_pay'] = 1;
                    if(is_null($pay_set['balance_pay'])) $pay_set['balance_pay'] = 1;
                    if(is_null($pay_set['repurchase_currency_pay'])) $pay_set['repurchase_currency_pay'] = 1;
                    if(is_null($pay_set['zfb_pay'])) $pay_set['zfb_pay'] = 1;
                    if(is_null($pay_set['cash_pay'])) $pay_set['cash_pay'] = 1;
                    if($pay_set['weixin_pay'] != 1){
                        $is_wxpay = 0;
                    }
                    if($pay_set['balance_pay'] != 1){
                        $is_balancepay = 0;
                    }
                    if($pay_set['deposit_release_pay'] != 1){
                        $is_deposit_release_pay = 0;
                    }
                    if($pay_set['zfb_pay'] != 1){
                        $is_alipay = 0;
                    }
                    if($pay_set['cash_pay'] != 1){
                        $is_cashpay = 0;
                    }
                    if($is_wxpay == 0 && $is_balancepay == 0 && $is_alipay == 0){
                        $is_repurchase_currency_pay = 0;
                        if($pay_set['repurchase_currency_pay'] == 1 && $_W['fenxiao']['is_repurchase_gold'] == 1){
                            $is_repurchase_currency_pay = 1;
                        }
                    }
                }
            }
            foreach ($goods_info as $key => &$val){
                $val['thumb'] = cdnurl($val['thumb']);
            }
            unset($val);
            
            $price = floatval($order['price']);
            $repurchase_currency = floatval($order['repurchase_currency']);
            if($repurchase_currency > 0){
                $price = round($price - $repurchase_currency,2);
            }
        }
        else if($order_type == 2){
            $title = "充值余额";
            $order = Db::name("bbfx_recharge_order")->where(['uniacid'=>UNIACID,'order_no'=>$order_no])->find();
            if(empty($order)){
                __error("订单不存在");
            }
            if($order['is_pay'] == 1){
                __error("订单已支付");
            }
            if($order['type'] == 2){
                $title = "充值积分";
            }
            $price = floatval($order['money']);
            $is_balancepay = 0;
            $is_deposit_release_pay = 0;
            $is_cashpay = 0;
        }
        else if($order_type == 3){
            $title = "购买会员卡";
            $order = Db::name("bbfx_member_card_order")->where(['uniacid'=>UNIACID,'order_no'=>$order_no])->find();
            if(empty($order)){
                __error("订单不存在");
            }
            if($order['status'] == 1){
                __error("订单已支付");
            }
            
            $price = floatval($order['price']);
            $is_cashpay = 0;
        }
        else if($order_type == 4){
            $title = $_W['base']['fenxiao']['texts']['predeposit']."充值";
            $order = Db::name("bbfx_deposit_release_order")->where(['uniacid'=>UNIACID,'order_no'=>$order_no])->find();
            if(empty($order)){
                __error("订单不存在");
            }
            if($order['status'] == 1){
                __error("订单已支付");
            }
            
            $price = floatval($order['money']);
            $is_deposit_release_pay = 0;
            $is_cashpay = 0;
            
            $deposit_paytype = $_W['base']['deposit_release']['deposit_paytype'];
            if(empty($deposit_paytype)){
                $is_wxpay = 0;
                $is_balancepay = 0;
                $is_alipay = 0;
            }
            else{
                if(!in_array(1,$deposit_paytype) && $is_wxpay == 1){
                    $is_wxpay = 0;
                }
                if(!in_array(2,$deposit_paytype) && $is_balancepay == 1){
                    $is_balancepay = 1;
                }
                if(!in_array(3,$deposit_paytype) && $is_alipay == 1){
                    $is_alipay = 1;
                }
            }
        }
        else if($order_type == 5){
            $order = Db::name("bbfx_sconnection_upgrade_order")->where(['uniacid'=>UNIACID,'order_no'=>$order_no])->find();
            if(empty($order)){
                __error("订单不存在");
            }
            if($order['status'] == 1){
                __error("订单已支付");
            }
            $title = $order['title'];
            $price = floatval($order['price']);
            $is_cashpay = 0;
        }
        else if($order_type == 6){
            $title = "积分商品支付";
            $order = Db::name("bbfx_scoreshop_order")->where(['uniacid'=>UNIACID,'user_id'=>$user['id'],'order_no'=>$order_no])->find();
            if(empty($order)){
                __error("订单不存在");
            }
            if($order['status'] == -1){
                __error("订单已关闭");
            }
            if($order['status'] != 0){
                __error("订单已支付");
            }
            $goods_info = iunserializer($order['goods_info']);
            if(!empty($goods_info)){
                $title = $goods_info[0]['title'];
            }
            
            foreach ($goods_info as $key => &$val){
                $val['thumb'] = cdnurl($val['thumb']);
            }
            unset($val);
            
            $price = floatval($order['price']);
            $is_cashpay = 0;
        }
        else if($order_type == 7){
            $title = "押金支付";
            $order = Db::name("bbfx_yajin_record")->where(['uniacid'=>UNIACID,'user_id'=>$user['id'],'order_no'=>$order_no])->find();
            if(empty($order)){
                __error("记录不存在");
            }
            if($order['status'] != 0){
                __error("押金已支付");
            }
            
            $price = floatval($order['money']);
            $is_cashpay = 0;
        }
        else if($order_type == 8){
            $title = "报名支付";
            $order = Db::name("bbfx_activity_baoming")->where(['uniacid'=>UNIACID,'user_id'=>$user['id'],'order_no'=>$order_no])->find();
            if(empty($order)){
                __error("记录不存在");
            }
            if($order['is_pay'] != 0){
                __error("报名已支付");
            }
            
            $price = floatval($order['baoming_fee']);
            $is_cashpay = 0;
        }
        else{
            __error("订单类型错误");
        }
        
        if($params['platform'] != 'wxapp' && $params['platform'] != 'GZH'){
            // $is_wxpay = 0;
        }
        
        if($params['platform'] == 'wxapp'){
            $is_alipay = 0;
        }
        
        $pay_list = array(
            array(
                'paytype'=>1,
                'icon'=>cdnurl('/assets/images/wxzf.png'),
                'title'=>'微信支付',
                'status'=>$is_wxpay
            ),
            array(
                'paytype'=>2,
                'icon'=>cdnurl('/assets/images/yezf.png'),
                'title'=>'余额支付',
                'status'=>$is_balancepay
            ),
            array(
                'paytype'=>3,
                'icon'=>cdnurl('/assets/images/yezf.png'),
                'title'=>$_W['base']['fenxiao']['texts']['predeposit'].'支付',
                'status'=>$is_deposit_release_pay
            ),
            array(
                'paytype'=>4,
                'icon'=>cdnurl('/assets/images/yezf.png'),
                'title'=>$_W['base']['fenxiao']['texts']['repurchase_currency'].'支付',
                'status'=>$is_repurchase_currency_pay
            ),
            array(
                'paytype'=>5,
                'icon'=>cdnurl('/assets/images/zfb.png'),
                'title'=>'支付宝支付',
                'status'=>$is_alipay
            ),
            array(
                'paytype'=>6,
                'icon'=>cdnurl('/assets/images/xxzf.png'),
                'title'=>'线下支付',
                'status'=>$is_cashpay
            )
        );
        
        $result = array(
            "title"=>$title,
            "price"=>$price,
            "order_no"=>$order_no,
            "order_id"=>$order['id'],
            "order_type"=>$order_type,
            "list"=>$pay_list
        );
        
        if($order_type == 1){
            $result['goods'] = $goods_info;
        }
        
        __success("操作成功",$result);
    }
    
    public function pay(){
        global $_W;
        $params = $this->param();
        
        $order_type = intval($params['order_type']);
        $paytype = max(1,intval($params['paytype']));
        $order_no = $params['order_no'];
        $dk_type = intval($params['dk_type']);
        $user = $this->user;
        
        if($order_type == 1){
            $title = "购买商品";
            $order = Db::name("bbfx_order")->where(['uniacid'=>UNIACID,'user_id'=>$user['id'],'order_no'=>$order_no])->find();
            if(!empty($order)){
                $goods_info = iunserializer($order['goods_info']);
                $title = $goods_info[0]['title'];
                
                foreach ($goods_info as $key => $item){
                    $result = CloudWarehouse::checkStock($user['id'],$item['total'],$item['id']);
            	    if($result['code'] != 1){
            	        __error($result['message']);
            	    }
                }
            }
            if($order['is_pay'] == 1){
                __error("订单已支付");
            }
            if($order['status'] == -1){
                __error("订单已关闭");
            }
            if($order['status'] != 0){
                __error("订单已支付");
            }
            if($order['cash_pay_shenhe'] >= 0){
                __error("已线下支付");
            }
            if($order['order_source'] == 3){
                $pintuan_order = Db::name("bbfx_pintuan_order")->where(['uniacid'=>UNIACID,'id'=>$order['pintuan_order_id']])->find();
                if(empty($pintuan_order)){
                    __error("拼团订单信息错误");
                }

                if($pintuan_order['status'] == 1 || $pintuan_order['status'] == 2){
                    __error("该拼团订单已结束，请重新下单支付");
                }
            }
            $price = floatval($order['price']);
            $repurchase_currency = floatval($order['repurchase_currency']);
            if($repurchase_currency > 0){
                $price = round($price - $repurchase_currency,2);
            }
            if($paytype == 1 && $dk_type == 1){
                if($price > $user['balance']){
                    $price = round($price - $user['balance'],2);
                }
                else{
                    $paytype = 2;
                }
            }
            if(empty($title)){
                $title = "购买商品";
            }
        }
        else if($order_type == 2){
            $title = "充值余额";
            $order = Db::name("bbfx_recharge_order")->where(['uniacid'=>UNIACID,'order_no'=>$order_no])->find();
            if($order['type'] == 2){
                $title = "充值积分";
            }
            if(empty($order)){
                __error("订单不存在");
            }
            if($order['is_pay'] == 1){
                __error("订单已支付");
            }
            if($order['type'] == 2){
                $title = "充值积分";
            }
            $price = floatval($order['money']);
        }
        else if($order_type == 3){
            $title = "购买会员卡";
            $order = Db::name("bbfx_member_card_order")->where(['uniacid'=>UNIACID,'order_no'=>$order_no])->find();
            if(empty($order)){
                __error("订单不存在");
            }
            if($order['status'] == 1){
                __error("订单已支付");
            }
            
            $price = floatval($order['price']);
        }
        else if($order_type == 4){
            $title = $_W['base']['fenxiao']['texts']['predeposit']."充值";
            $order = Db::name("bbfx_deposit_release_order")->where(['uniacid'=>UNIACID,'order_no'=>$order_no])->find();
            if(empty($order)){
                __error("订单不存在");
            }
            if($order['status'] == 1){
                __error("订单已支付");
            }
            
            $price = floatval($order['money']);
        }
        else if($order_type == 5){
            $order = Db::name("bbfx_sconnection_upgrade_order")->where(['uniacid'=>UNIACID,'order_no'=>$order_no])->find();
            if(empty($order)){
                __error("订单不存在");
            }
            if($order['status'] == 1){
                __error("订单已支付");
            }
            $title = $order['title'];
            $price = floatval($order['price']);
        }
        else if($order_type == 6){
            $title = "购买积分商品";
            $order = Db::name("bbfx_scoreshop_order")->where(['uniacid'=>UNIACID,'user_id'=>$user['id'],'order_no'=>$order_no])->find();
            if(empty($order)){
                __error("订单不存在");
            }
            if($order['status'] == -1){
                __error("订单已关闭");
            }
            if($order['status'] != 0){
                __error("订单已支付");
            }
            $goods_info = iunserializer($order['goods_info']);
            if(!empty($goods_info)){
                $title = $goods_info[0]['title'];
            }
            $price = floatval($order['price']);
            if($this->user['score'] < $order['score']){
                __error("您的积分不足");
            }
        }
        else if($order_type == 7){
            $title = "押金支付";
            $order = Db::name("bbfx_yajin_record")->where(['uniacid'=>UNIACID,'user_id'=>$user['id'],'order_no'=>$order_no])->find();
            if(empty($order)){
                __error("记录不存在");
            }
            if($order['status'] != 0){
                __error("押金已支付");
            }
            
            $price = floatval($order['money']);
        }
        else if($order_type == 8){
            $title = "报名支付";
            $order = Db::name("bbfx_activity_baoming")->where(['uniacid'=>UNIACID,'user_id'=>$user['id'],'order_no'=>$order_no])->find();
            if(empty($order)){
                __error("记录不存在");
            }
            if($order['is_pay'] != 0){
                __error("报名已支付");
            }
            
            $price = floatval($order['baoming_fee']);
            // if($paytype == 1 && $dk_type == 1){
            //     if($price > $user['balance']){
            //         $price = round($price - $user['balance'],2);
            //     }
            //     else{
            //         $paytype = 2;
            //     }
            // }
        }
        else{
            __error("订单类型错误");
        }
        
        if(empty($order)){
            __error("订单信息错误");
        }
        
		$openid = $this->param('openid/s');
		if($params['platform'] == 'GZH' && $_W['base']['is_gzh_login'] == 1){
	        $openid = $user['openid'];
	    }
	    if(empty($openid) && $params['platform'] == 'wxapp' && $user['platform'] == 'WXAPP'){
	        $openid = $user['openid'];
	    }
	    
        $pay_order = Db::name("bbfx_pay_order")->where(['order_no'=>$order_no,'uniacid'=>UNIACID])->find();
		if(empty($pay_order)){
		    $data = array(
		        "uniacid"=>UNIACID,
		        "openid"=>$openid,
		        "order_no"=>$order_no,
		        "price"=>$price,
		        "order_type"=>$order_type,
		        "platform"=>$params['platform'],
		        "createtime"=>time()
		    );
            $res = Db::name("bbfx_pay_order")->insert($data);
		    if(empty($res)){
		        __error("创建支付订单失败");
		    }
		}
		else{


		    if($pay_order['is_pay'] == 1){
		        __error("订单已支付");
		    }

            $pdata = ["platform"=>$params['platform']];
            if($paytype == 1 && $dk_type == 1 && $order_type == 1 && $pay_order['price'] != $price){
                $pdata['price'] = $price;
                $order_no = date('YmdHis').random(8,true);  
                $pdata['order_no'] = $order_no;

                Db::name("bbfx_order")->where(['id'=>$order['id']])->update(['order_no'=>$order_no]);
            }

		    Db::name("bbfx_pay_order")->where(['id'=>$pay_order['id']])->update($pdata);
		}
		
		if($price <= 0 && $paytype != 6){
		    $paytype = 2;
		}
		
		if($paytype == 1){
		    
		    $pay_data = array(
    			'out_trade_no' => $order_no,
    			'fee' => floatval($price),
    			'title' => $title,
    			'openid'=>$openid,
		        "profit_sharing"=>"N",
    			'type'=>$params['platform']
    		);
    		if($order['is_fenzhang'] == 1){
		        $pay_data['profit_sharing'] = "Y";
		    }
    		$result = Wxpay::pay($pay_data);
    		if ($result['code'] != 1) {
    			__result($result);
    		}
    		
            $pay_data = $result['data'];
            $pay_data['order_no'] = $order_no;

    		__success( '操作成功', $pay_data);
		}
		else if($paytype == 2){
		    
		    if($_W['base']['is_pay_password'] == 1){
		        $pay_password = Db::name("bbfx_user")->where("id",$user['id'])->value("pay_password");
    		    if($pay_password !== md5($params['pay_password'])){
    		        __error("支付密码错误");
    		    }
		    }
		    
		    
		    if(!in_array($order_type,[1,3,4,5,6,7,8])){
                __error("不支持该支付方式");
            }
            
            if($user['balance'] < $price){
                __error("余额不足".$user['balance']);
            }
		    
		    if($price > 0){
		        $res = User::setUserMoney($user['id'],-$price,1,1,$title,$order);
                if(empty($res)){
                    __error("余额不足");
                }
		    }

            echo toJsonen(__json(1,'支付成功'));

            bbfx_finish_request();
            
            Order::payResult($order_no,2);
            
            // __success("支付成功");
		}
		else if($paytype == 3){
		    
		    if($_W['base']['is_pay_password'] == 1){
		        $pay_password = Db::name("bbfx_user")->where("id",$this->user['id'])->value("pay_password");
    		    if($pay_password !== md5($params['pay_password'])){
    		        __error("支付密码错误");
    		    }
		    }
		    
		    if(!in_array($order_type,[1,3,5,7,8])){
                __error("不支持该支付方式");
            }
            
            if($user['deposit_money'] < $price){
                __error($_W['base']['fenxiao']['texts']['predeposit']."不足");
            }
		    
		    if($price > 0){
		        $res = User::setUserMoney($user['id'],-$price,6,1,$title,$order);
                if(empty($res)){
                    __error($_W['base']['fenxiao']['texts']['predeposit']."不足");
                }
		    }

            echo toJsonen(__json(1,'支付成功'));

            bbfx_finish_request();
            
            Order::payResult($order_no,3);
            
            // __success("支付成功");
		}
		else if($paytype == 4){
		    if($_W['base']['is_pay_password'] == 1){
		        $pay_password = Db::name("bbfx_user")->where("id",$this->user['id'])->value("pay_password");
    		    if($pay_password !== md5($params['pay_password'])){
    		        __error("支付密码错误");
    		    }
		    }
		    
		    if(!in_array($order_type,[1])){
                __error("不支持该支付方式");
            }
            
            if($user['repurchase_currency'] < $price){
                __error($_W['base']['fenxiao']['texts']['repurchase_currency']."不足");
            }
		    
		    if($price > 0){
		        $res = User::setUserMoney($user['id'],-$price,4,1,$title,$order);
                if(empty($res)){
                    __error($_W['base']['fenxiao']['texts']['repurchase_currency']."不足");
                }
		    }

            echo toJsonen(__json(1,'支付成功'));

            bbfx_finish_request();
            
            Order::payResult($order_no,4);
            
            // __success("支付成功");
		}
		else if($paytype == 5){
		    $pay_data = array(
    			'order_no' => $order_no,
    			'fee' => round($price,2),
    			'title' => $title,
    			'platform'=>$params['platform'],
    		);
    		
    		$result = Alipay::wapPay($pay_data);
    		
    		__result($result);
		}
		else if($paytype == 6){

		    // Order::payResult($order_no,6);

            if($order_type == 1){
                $res = Db::name("bbfx_order")->where(['id'=>$order['id'],'is_pay'=>0,'cash_pay_shenhe'=>-1])->update(['paytype'=>6,'cash_pay_shenhe'=>0]);
            }
            else{
                __error("暂不支持该支付方式");
            }

            if(empty($res)){
                __error("提交失败");
            }
            
            __success("提交成功");
		}
		else{
		    __error("不支持该支付方式");
		}
    }

    public function notify()
    {
        
        $params = Wxpay::payVerify();
        file_put_contents("pay111.txt",json_encode($params));
        if(empty($params)){
            echo array2xml(['return_code'=>'FAIL','return_msg'=>'数据不存在']);
    		exit();
        }
        $order_no = $params['out_trade_no'];
        
        echo array2xml(['return_code' => 'SUCCESS', 'return_msg' => 'OK']);
        
        bbfx_finish_request();

        Order::payResult($order_no,1,$params);
    }
    
    
    public function alipayNotify(){
        $params = $this->paramPost();
        
        if(empty($params['sign'])){
            echo "fail";die;
        }
        
        foreach ($params as $key => &$val){
            $val = htmlspecialchars_decode($val);
        }
        unset($val);
        
        file_put_contents("alipaynn1.txt",json_encode($params));
        
        
        $result = Alipay::payVerify($params);
        if($result['code'] == 1){

            echo "success";

            bbfx_finish_request();

            $order_no = $params['out_trade_no'];
            if($params['trade_status'] == 'TRADE_SUCCESS'){
                Order::payResult($order_no,5,$params);
            }
            
        }
        else{
            echo "fail";
        }
    }
    
    
}
