<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\sverify;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Product extends Base
{

    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Sverify;
    }
    
    public function getList(){
        
        $params = $this->param();
        
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):20;
        $where = ["uniacid"=>UNIACID];
        
        $list = Db::name("bbfx_sverify_product")->where($where)->order('id desc')->limit(($pindex - 1) * $psize,$psize)->select();
    	
    	foreach ($list as $key => &$val) {
    	    $val['image'] = cdnurl($val['image']);
    	    $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
    	    $val['code_num'] = Db::name("bbfx_sverify_product_code")->where(["uniacid"=>UNIACID,'product_id'=>$val['id']])->count();
    	}
    	unset($val);
    	
    	$total = Db::name("bbfx_sverify_product")->where($where)->count();
      	
        __success('操作成功',['total'=>$total,'list'=>$list]);
    }
    
    
    public function detail(){
        $params = $this->param();
        $id = intval($params['id']);
        
        $info = Db::name("bbfx_sverify_product")->where(['id'=>$id])->find();
        if(empty($info)){
            __error("产品不存在");
        }
        $info['image'] = cdnurl($info['image']);   
        $info['images'] = cdnurls(iunserializer($info['images']));   
        
        __success('操作成功',['info'=>$info]);
    }
    
    public function batchCreate(){
        $params = $this->param(['product_id/d','total/d']);
        $result = $this->model->batchCreate($params['product_id'],$params['total']);
        if($result['code'] == 1){
            \app\admin\model\AdminLog::record("","",['id'=>$params['product_id'],'total'=>$params['total']],"bbfx_sverify_product");
        }
        __result($result);
    }
    
    public function post(){
        $params = $this->param();
        $id = intval($params['id']);
        
        $item = Db::name("bbfx_sverify_product")->where(['id'=>$id])->find();
        
        $data = array(
        	"uniacid"=>UNIACID,
          	"name"=>$params['name'],
          	"image"=>replaceSiteroot($params['image']),
          	"images"=>iserializer(replaceSiteroots($params['images'])),
          	"number_prefix"=>$params['number_prefix'],
          	"number_digits"=>intval($params['number_digits']),
          	"query_first_tips"=>$params['query_first_tips'],
          	"query_success_tips"=>$params['query_success_tips'],
          	"query_fail_tips"=>$params['query_fail_tips'],
          	"status"=>intval($params['status'])
        );
        
        if($data['number_digits'] < 8){
            __error("编号位数不得小于8");
        }
        
      	if(!empty($item)){
            $res = Db::name("bbfx_sverify_product")->where(['id'=>$id])->update($data);
            $data['id'] = $id;
        }
      	else{
      	    $data['code'] = \fast\Random::uuid();
      	    $data['createtime'] = time();
            $res = Db::name("bbfx_sverify_product")->insertGetId($data);
            $data['id'] = $res;
        }
      	
      	if($res){
      	    
      	    \app\admin\model\AdminLog::record("","",$data,"bbfx_sverify_product");
      	    
        	__success("编辑成功");
        }
      	else{
        	__success("操作成功");
        }
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        $list = Db::name("bbfx_sverify_product")->where('id','in',$ids)->select();
        if(empty($list)){
            __error("删除的数据不存在");
        }
        $titles = array_column($list, 'name');
        
      	$res = Db::name("bbfx_sverify_product")->where('id','in',$ids)->delete();
      	if($res){
      	    
      	    \app\admin\model\AdminLog::record("删除扫码验真产品","扫码验真产品：".implode(",",$titles)."，扫码验真产品ID：".implode(",",$ids),$list);
      	    
        	__success("删除成功");
        }
    	else{
        	__error("删除失败");
        }
    }
}