<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\super_maihuo;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Config extends Base
{

    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\SuperMaihuo;
    }
    
    public function set(){
        $params = $this->param();
        
        $config = Db::name("bbfx_super_maihuo")->where(["uniacid"=>UNIACID])->find();
        
        $data = array(
            "uniacid"=>UNIACID,
            "status"=>intval($params['status']),
            "daozhang_type"=>intval($params['daozhang_type']),
            "repurchase_goods"=>intval($params['repurchase_goods']),
            "abonus_num"=>intval($params['abonus_num']),
            "abonus_money"=>max(0,round($params['abonus_money'],2)),
            "abonus_score"=>max(0,round($params['abonus_score'],2)),
            "sup_reward"=>max(0,round($params['sup_reward'],2)),
            "bg_color"=>trim($params['bg_color']),
        );
        
        if($data['status'] == 1){
            if($data['abonus_num'] <= 0){
                __error("请输入分红次数");
            }
            if($data['abonus_money'] <= 0){
                __error("请输入分红金额");
            }
            $repurchase_goods = Db::name("bbfx_goods")->where(['uniacid'=>UNIACID,'status'=>1,'id'=>$data['repurchase_goods']])->find();
            if(empty($repurchase_goods)){
                __error("请选择复购商品");
            }
            $plugin = iunserializer($repurchase_goods['plugin']);
            $super_maihuo = $plugin['super_maihuo'];
            if($super_maihuo['status'] != 1 || intval($super_maihuo['super_maihuo_portion']) <= 0){
                // __error("复购商品未开启疯狂卖货模式");
            }
        }
        
    	if(!empty($config)){
          	$res = Db::name("bbfx_super_maihuo")->where(["id"=>$config['id']])->update($data);;
        }
      	else{
        	$res = Db::name("bbfx_super_maihuo")->insert($data);
        }
        
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_super_maihuo");
            __success("编辑成功",$data);
        }
      	else{
      	    __success("操作成功",$data);
      	}
    }
}