<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\store;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Dealer extends Base
{
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Store;
    }
    
    public function getList(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):20;
        $where = ['uniacid'=>UNIACID,'is_dealer'=>1];
        
        $list = Db::name("bbfx_user")->where($where)->order("become_dealer_time desc")->field("id,nickname,avatar,level,is_distributor,distributor_status,is_dealer,dealer_store,dealer_store_reward,dealer_province,dealer_city,become_dealer_time,dealer_reward")->limit(($pindex - 1) * $psize,$psize)->select();
        foreach ($list as $key => &$val) {
            $val['dealer_store'] = deid($val['dealer_store'],true);
            $val['avatar'] = cdnurl($val['avatar']);
            $val['become_dealer_time'] = date("Y-m-d H:i:s",$val['become_dealer_time']);
            $val['dealer_reward_total'] = Db::name("bbfx_fenxiao_order")->where(['uniacid'=>UNIACID,'status'=>1,'user_id'=>$val['id'],'type'=>26])->sum('money');
        }
        unset($val);
        
        $total = Db::name("bbfx_user")->where($where)->count();
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function post(){
        $params = $this->paramPost(['id/d','y_id/d','dealer_province/s','dealer_city/s','dealer_reward/d','dealer_store/a','dealer_store_reward/d']);
        
        if($params['id'] <= 0){
            __error("请选择用户");
        }
        if(empty($params['dealer_city'])){
            // __error("请选择经销商管理城市名称");
        }
        
        $user = Db::name("bbfx_user")->where(['id'=>$params['id']])->find();
        if(empty($user)){
            __error("用户不存在");
        }

        $y_user = Db::name("bbfx_user")->where(['id'=>$params['y_id']])->find();
        
        if(!empty($params['dealer_province']) && !empty($params['dealer_city'])){
            $otheruser = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,"is_dealer"=>1,"dealer_province"=>$params['dealer_province'],"dealer_city"=>$params['dealer_city']])->find();
            if(!empty($otheruser) && (empty($y_user) || (!empty($y_user) && $otheruser['id'] != $y_user['id']))){
                __error("已存在该城市经销商");
            }
        }
        
        if(!empty($params['dealer_store'])){
            foreach($params['dealer_store'] as $k =>$sid){
                $otheruser = Db::name("bbfx_user")->where(['uniacid'=>UNIACID,"is_dealer"=>1,"dealer_store"=>['like','%,'.$sid.',%']])->find();
                if(!empty($otheruser) && (empty($y_user) || (!empty($y_user) && $otheruser['id'] != $y_user['id']))){
                    $store_name = Db::name("bbfx_store")->where(['id'=>$sid])->value("name");
                    __error("【".$store_name."】已被指定经销商");
                }
            }
            
        }
        
        $data = array(
            "is_dealer"=>1,
            // "dealer_province"=>$params['dealer_province'],
            // "dealer_city"=>$params['dealer_city'],
            "dealer_reward"=>max(0,$params['dealer_reward']),
            "dealer_store_reward"=>max(0,$params['dealer_store_reward']),
            "dealer_store"=>enid($params['dealer_store'])
        );

        if(!empty($params['dealer_province']) && !empty($params['dealer_city'])){
            $data['dealer_province'] = $params['dealer_province'];
            $data['dealer_city'] = $params['dealer_city'];
        }
        else{
            $data['dealer_province'] = '';
            $data['dealer_city'] = '';
        }
        
        if($user['is_dealer'] != 1){
            $data['become_dealer_time'] = time();
        }
        
        $res = Db::name("bbfx_user")->where(["id"=>$user['id']])->update($data);
        
        if($res){

            if(!empty($y_user) && $y_user['id'] != $user['id']){
                $data = [
                    'is_dealer'=>0,
                    'dealer_reward'=>0,
                    'dealer_store_reward'=>0,
                    'dealer_province'=>'',
                    'dealer_city'=>'',
                    'dealer_store'=>'',
                ];
                Db::name("bbfx_user")->where(["id"=>$y_user['id']])->update($data);
            }

            \app\admin\model\AdminLog::record("","",$data,"bbfx_user");
            __success("编辑成功");
        }
        else{
            __success("操作成功");
        }
        
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        $list = Db::name("bbfx_user")->where('id','in',$ids)->select();
        if(empty($list)){
            __error("删除的数据不存在");
        }
        $titles = array_column($list, 'nickname');
        
        
      	$res = Db::name("bbfx_user")->where('id','in',$ids)->update(['is_dealer'=>0]);
      	if($res){
      	    
      	    \app\admin\model\AdminLog::record("删除经销商","经销商：".implode(",",$titles)."，经销商ID：".implode(",",$ids),$list);
      	    
        	__success("删除成功");
        }
    	else{
        	__error("删除失败");
        }
    }
}