<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\seckill;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Index extends Base
{

    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Seckill;
    }
    
    public function getActivity(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):20;
        $where = ["uniacid"=>UNIACID];
        $list = Db::name("bbfx_seckill_activity")->where($where)->order("id desc")->limit(($pindex - 1) * $psize,$psize)->select();
      	foreach($list as $key => &$val){
    	    $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
    	    $val['starttime'] = date("Y-m-d H:i:s",$val['starttime']);
    	    $val['endtime'] = date("Y-m-d H:i:s",$val['endtime']);
        }
        unset($val);
        __success("操作成功",['total'=>count($list),'list'=>$list]);
    }
    
    public function getList(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):20;
        
        $where = ["uniacid"=>UNIACID];
        
        $keyword = trim($params['keyword']);
        if($keyword){
            $where['name'] = ['like','&'.$keyword.'&'];
        }
        
        
    	$list = Db::name("bbfx_seckill_activity")->where($where)->order("id desc")->limit(($pindex - 1) * $psize,$psize)->select();
      	foreach($list as $key => &$val){
    	    $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
    	    $val['starttime'] = date("Y-m-d H:i:s",$val['starttime']);
    	    $val['endtime'] = date("Y-m-d H:i:s",$val['endtime']);
        }
        unset($val);
    	$total = Db::name("bbfx_seckill_activity")->where($where)->count();
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    public function post(){
        $params = $this->param();
        
        $id = intval($params['id']);
        $goods = Db::name("bbfx_seckill_activity")->where(['id'=>$id])->find();
        
      	if(empty($params['name'])){
        	__error("请输入活动名称");
        }
        
        if(empty($params['starttime'])){
        	__error("请选择活动时间");
        }
        if(empty($params['endtime'])){
        	__error("请选择活动时间");
        }
        if(empty($params['seckill_goods_ids'])){
        	__error("请选择特价商品");
        }
        
    	$data = array(
        	"uniacid"=>UNIACID,
          	"name"=>$params['name'],
          	"seckill_goods_ids"=>$params['seckill_goods_ids'],
          	"status"=>intval($params['status']),
          	"starttime"=>strtotime($params['starttime']),
          	"endtime"=>strtotime($params['endtime']),
        );
        
        if($data['starttime'] >= $data['endtime']){
            __error("请选择有效限时特价时间");
        }
        if($data['endtime'] < time()){
            __error("限时特价结束时间必须大于当前时间");
        }
        
        if(!empty($goods)){
            $res = Db::name("bbfx_seckill_activity")->where(["id"=>$goods['id']])->update($data);
            $data['id'] = $goods['id'];
        }
      	else{
          	$data['createtime'] = time();
            $res = Db::name("bbfx_seckill_activity")->insertGetId($data);
            $data['id'] = $res;
        }
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_seckill_activity");
            __success("编辑成功");
        }
        else{
            __success("操作成功");
        }
    }
    public function detail(){
        $params = $this->param();
        
        $id = intval($params['id']);
        $activity = Db::name("bbfx_seckill_activity")->where(['id'=>$id])->find();
        
        if(!empty($activity)){
            $activity['starttime'] = date("Y-m-d H:i:s",$activity['starttime']);
    	    $activity['endtime'] = date("Y-m-d H:i:s",$activity['endtime']);
            __success("操作成功",$activity);
        }
        else{
            __error("限时特价不存在");
        }
    }
    
    public function status(){
        $params = $this->param();
        
        $id = intval($params['id']);
        $status = intval($params['status']);
        $res = Db::name("bbfx_seckill_activity")->where(["id"=>$id])->update(["status"=>$status]);
        if($res){
            \app\admin\model\AdminLog::record("","",["id"=>$id,"status"=>$status],"bbfx_seckill_activity");
            __success("操作成功");
        }
        else{
            __success("操作成功");
        }
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        
      	$res = Db::name("bbfx_seckill_activity")->where('id','in',$ids)->delete();
      	if($res){
      	    \app\admin\model\AdminLog::record("","",["id"=>implode(",",$ids)],"bbfx_seckill_activity");
        	__success("删除成功");
        }
    	else{
        	__error("删除失败");
        }
    }
}