<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\returns;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Index extends Base
{
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\ReturnMode;
    }
    
    public function getList(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        
        $where = array("a.uniacid"=>UNIACID);
        
        $keyword = trim($params['keyword']);
        $startTime = trim($params['startTime']);
        $endTime = trim($params['endTime']);
        
        $type = max(1,intval($params['type']));
        if(!empty($keyword)){
            
            if($type == 1){
                $where['b.nickname'] = ['like',"%".$keyword."%"];
            }
            else if($type == 2){
                $where['b.realname'] = ['like',"%".$keyword."%"];
            }
            else if($type == 3){
                $where['b.mobile'] = $keyword;
            }
            else if($type == 4){
                $where['a.user_id'] = intval($keyword);
            }
            else if($type == 5){
                $where['a.order_id'] = intval($keyword);
            }
        }
        
        $whereTime = [];
        if($startTime){
            $startTime = strtotime($startTime." 00:00:00");
            $where .= " and a.createtime >= :startTime";
            $where['a.createtime'] = ['>=',$startTime];
        }
        
        if($endTime){
            $endTime = strtotime($endTime." 23:59:59");
            $whereTime['a.createtime'] = ['<=',$endTime];
        }
        
        $list = Db::name("bbfx_return_item")->alias("a")->join("bbfx_user b","a.user_id=b.id")->where($where)->where($whereTime)->field('a.*,b.avatar,b.nickname')->order('a.createtime desc')->limit(($pindex - 1) * $psize,$psize)->select();
    	
    	foreach($list as $key=>&$val){
    	    $val['avatar'] = cdnurl($val['avatar']);
    	    $val['createtime'] = date("Y.m.d H:i",$val['createtime']);
    	    $val['statusText'] = "返还中";
    	    if($val['status'] == 1){
    	        $val['statusText'] = "已完成";
    	        $total_ok = $val['total'];
    	    }
    	    else{
                $total_ok = Db::name("bbfx_return_log")->where(['uniacid'=>UNIACID,'user_id'=>$val['user_id'],'pid'=>$val['id']])->sum('money');
    	        $total_ok = round($total_ok,2);
    	    }
    	    
    	    $val['total_ok'] = $total_ok;
    	}
    	unset($val);
    	
        $total = Db::name("bbfx_return_item")->alias("a")->join("bbfx_user b","a.user_id=b.id")->where($where)->where($whereTime)->count();
    	$total = intval($total);
    	
    	__success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function getLog(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        $pid = intval($params['pid']);
        $where = array("a.uniacid"=>UNIACID);
        
        if($pid > 0){
            $where['a.pid'] = $pid;
        }
        
        
        $list = Db::name("bbfx_return_log")->alias("a")->join("bbfx_user b","a.user_id=b.id")->where($where)->field('a.*,b.avatar,b.nickname')->order('a.createtime desc')->limit(($pindex - 1) * $psize,$psize)->select();
        
        if(empty($list)){
            $list = [];
        }
        
        foreach ($list as $key => &$val){
            $val['avatar'] = cdnurl($val['avatar']);
            $val['createtime'] = date("Y.m.d H:i",$val['createtime']);
        }
        unset($val);
        
        $total = Db::name("bbfx_return_log")->alias("a")->join("bbfx_user b","a.user_id=b.id")->where($where)->count();
        $total = intval($total);
        
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
}