<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\pintuan;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Order extends Base
{

    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Pintuan;
    }
    
    // 强制操作
    public function force(){
        $params = $this->param(['id/d','status/d']);
        
        $pintuan_order = Db::name("bbfx_pintuan_order")->where(['uniacid'=>UNIACID,'status'=>0,'id'=>$params['id']])->find();
        if(empty($pintuan_order)){
            __error("拼团已结束");
        }
        
        if($params['status'] == 1){
            $result = $this->model->success($pintuan_order);
        }
        else{
            $result = $this->model->fail($pintuan_order);
        }
        
        if(empty($result)){
            __error("强制操作失败");
        }
        
        __success("操作成功"); 
    }
    
    public function getList(){
        $params = $this->param(['status/d','id/d','page/d','limit/d']);
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):20;
        
        $where = ['uniacid'=>UNIACID,'status'=>['>=',0]];
        if($params['id'] > 0){
            $where['pintuan_goods_id'] = $params['id'];
        }
        if($params['status'] != -1){
            $where['status'] = intval($params['status']);
        }
        
        $list = Db::name("bbfx_pintuan_order")->where($where)->order("createtime desc")->limit(($pindex - 1) * $psize,$psize)->select();
        
        foreach ($list as $key => &$val){
            
            $goods = iunserializer($val['goods']);
            $goods['thumb'] = cdnurl($goods['thumb']);
            if(!empty($goods['sku'])){
                $goods['sku']['thumb'] = cdnurl($goods['sku']['thumb']);
            }
            $val['goods'] = $goods;
            
            $user_list = Db::name("bbfx_order")->alias("a")->join("bbfx_user b","a.user_id=b.id")->where(['a.uniacid'=>UNIACID,'a.pintuan_order_id'=>$val['id'],'a.is_pay'=>1])->order("a.id asc")->field("a.createtime,a.pintuan_status,a.rebate_pintuan_status,a.user_id,b.avatar,b.nickname")->select();
            
            if($val['status'] == 0){
                $time = $val['endtime'] - time();
                $h =  $time / (60*60);
                $m = ($time - $h * 60 * 60) / 60;
                $s = $time - $h * 60 * 60 - $m * 60;
                $endtime = "{$h}小时{$m}分{$s}秒";
            }
            else{
                $endtime = "";
            }
            
            $val['endtime'] = $endtime;
            $val['progress'] = count($user_list)."/".$val['total'];
            $val['createtime'] = date("Y.m.d H:i",$val['createtime']);
            
            foreach ($user_list as $k => &$v){
                $v['avatar'] = cdnurl($v['avatar']);
                $v['nickname'] = $v['nickname'];
                $v['pt_createtime'] = date("Y.m.d H:i",$v['createtime']);
                
                if($k == 0){
                    $val['tz_nickname'] = $v['nickname'];
                    $val['tz_avatar'] = $v['avatar'];
                }
            }
            unset($v);
            $val['user_list'] = $user_list;
        }
        unset($val);
        
        $total = Db::name("bbfx_pintuan_order")->where(['status'=>['>=',0]])->where($where)->count();
        
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
}