<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\order;

use app\admin\controller\bbfxshop\Base;
use think\Db;

use app\common\model\bbfxshop\Fenxiao;
use app\common\model\bbfxshop\User;
use app\common\model\bbfxshop\CloudWarehouse;
use app\common\model\bbfxshop\Goods;

class Create extends Base 
{
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Order;
    }

    public function confirm(){
        $params = $this->param();
        
        $coupon_id = $params['coupon_id'];
        $address = $params['address'];

        $user = User::getInfo($params['user_id']);
        if(empty($user)){
            __error("请选择下单用户");
        }

        $goods_all = $params['goods'];
        if(empty($goods_all)){
            __error("请选择下单商品");
        }
        
        $goods_ids = [];
        foreach($goods_all as $key => $val){
            $goods_ids[] = $val['id'];
        }
        $goods_list = Db::name("bbfx_goods")->where(['id'=>['in',$goods_ids],'status'=>1])->select();
        
        if(empty($goods_list)){
            __error("下单商品信息错误");
        }

        $goods_list = array_skey($goods_list,"id");
        $goods = [];
        foreach($goods_all as $key => $val){
            if(empty($goods_list[$val['id']])){
                __error("下单商品信息错误");
            }
            
            $info = $goods_list[$val['id']];
            $info['total'] = $val['total'];
            if($info['is_spec'] == 1){
                $sku = Db::name("bbfx_goods_spec_sku")->where(['id'=>$val['sku_id']])->find();
                if(empty($sku)){
                    __error("请选择规格");
                }
                if(!empty($sku['thumb'])){
                    $info['thumb'] = cdnurl($sku['thumb']);
                }
                $info['sku'] = $sku;
                $info['sku_id'] = $sku['id'];
                $info['price'] = $sku['price'];
                $info['sku_name'] = $sku['sku_name'];
                
            }
            $goods[] = $info;
        }
        
        if(empty($goods)){
            __error("下单商品信息错误");
        }
        
        
        
        $delivery_method_list = [];
        $delivery_method = 0;
        if($goods[0]['type'] == 2){
            $g_delivery_method = $goods[0]['delivery_method'];
            $delivery_method = intval($params['delivery_method']);
            $arr = [];
            if($g_delivery_method == 1 || $g_delivery_method == 3){
                $delivery_method_list[] = ['name'=>'快递配送','value'=>1];
                $arr[] = 1;
            }
            if($g_delivery_method == 2 || $g_delivery_method == 3){
                $delivery_method_list[] = ['name'=>'门店核销','value'=>2];
                $arr[] = 2;
            }
            if(!in_array($delivery_method,$arr)){
                $delivery_method = $arr[0];
            }
            if(empty($delivery_method)){
                $delivery_method = 1;
            }
        }
        else if($goods[0]['type'] == 4 && $goods[0]['is_hexiao'] == 1){
            $delivery_method = 2;
            $delivery_method_list[] = ['name'=>'门店核销','value'=>2];
        }
        $is_gift_goods = 0;
        $hexiao_info_required = 0;
        foreach($goods as $key => $val){
            $plugin =  iunserializer($val['plugin']);
            if($plugin['gift']['status'] == 1){
                $is_gift_goods = 1;
            }
            if($val['hexiao_info_required'] == 1){
                $hexiao_info_required = 1;
            }
        }
        
        $result = $this->model->calculateMoney($goods,$user,$coupon_id,$delivery_method,$address);
        
        $total_fee = $result['total_price'];
        $total_price = $result['total_price'];
        $totalNum = $result['totalNum'];
        $express_fee = $result['express_fee'];
        $discount_price = $result['discount_price'];
        $original_price = $result['original_price'];
        $total_fee = round($total_price + $express_fee,2);
        foreach ($goods as $key => &$val){
            $val['thumb'] = cdnurl($val['thumb']);
        }
        unset($val);
        
        $order_repurchase_currency = 0;
        $repurchase_currency = floatval($user['repurchase_currency']);
        if($repurchase_currency > 0){
            if($total_fee > $repurchase_currency){
                $order_repurchase_currency = $repurchase_currency;
                $total_fee = round($total_fee - $repurchase_currency,2);
            }
            else{
                $order_repurchase_currency = $total_fee;
                $total_fee = 0;
            }
        }
        
        $plugin = iunserializer($goods[0]['plugin']);
        $form_list = [];
        if($plugin['form']['status'] == 1){
            $form_list = $plugin['form']['list'];
        }
        
        $data = array(
            'form_list'=>$form_list,
            'goods'=>$goods,
            'total_fee'=>$total_fee,
            'order_repurchase_currency'=>$order_repurchase_currency,
            'original_price'=>$original_price,
            'discount_price'=>$discount_price,
            'discount_vip_price'=>$result['discount_vip_price'],
            'discount_coupon_price'=>$result['discount_coupon_price'],
            'totalNum'=>$totalNum,
            'total_price'=>$total_price,
            'delivery_method_list'=>$delivery_method_list,
            'delivery_method'=>$delivery_method,
            'express_fee'=>$express_fee,
            'hexiao_info_required'=>$hexiao_info_required,
            'is_gift_goods'=>$is_gift_goods
        );
        if(!empty($result['coupon'])){
            $data['coupon'] = $result['coupon'];
        }
        
        __success("操作成功",$data);
    }
    
    
    public function submit(){
        global $_W;
        $set = $_W['base'];
        $params = $this->param();
        
        $coupon_id = $params['coupon_id'];
        $address = $params['address'];
        $paytype = intval($params['paytype']);
        $user = User::getInfo($params['user_id']);
        if(empty($user)){
            __error("请选择下单用户");
        }

        $goods_all = $params['goods'];
        if(empty($goods_all)){
            __error("请选择下单商品");
        }
        
        $goods_ids = [];
        foreach($goods_all as $key => $val){
            $goods_ids[] = $val['id'];
        }
        $goods_list = Db::name("bbfx_goods")->where(['id'=>['in',$goods_ids],'status'=>1])->select();
        
        if(empty($goods_list)){
            __error("下单商品信息错误");
        }

        $goods_list = array_skey($goods_list,"id");
        $goods = [];
        foreach($goods_all as $key => $val){
            if(empty($goods_list[$val['id']])){
                __error("下单商品信息错误");
            }
            
            $info = $goods_list[$val['id']];
            $info['total'] = $val['total'];
            if($info['is_spec'] == 1){
                $sku = Db::name("bbfx_goods_spec_sku")->where(['id'=>$val['sku_id']])->find();
                if(empty($sku)){
                    __error("请选择规格");
                }
                if(!empty($sku['thumb'])){
                    $info['thumb'] = cdnurl($sku['thumb']);
                }
                $info['sku'] = $sku;
                $info['sku_id'] = $sku['id'];
                $info['price'] = $sku['price'];
                $info['sku_name'] = $sku['sku_name'];
                
            }
            $goods[] = $info;
        }
        
        if(empty($goods)){
            __error("下单商品信息错误");
        }

        if($paytype == 0){
            __error("请选择支付方式");
        }

        $store_id = intval($params['store_id']);
        $form = $params['form_list'];

        User::checkStatus($user);
        
        if($set['fenxiao']['sup_user_buyorder'] == 1){
            if($user['sup_uid'] <= 0 && $user['first_sup_uid'] <= 0){
                $first_uid = Db::name("bbfx_user")->where(['uniacid'=>UNIACID])->order("id asc")->value("id");
                if($first_uid != $user['id']){
                    __error("您还没有推荐人，无法下单");
                }
            }
        }
        
        if(!empty($form)){
            foreach ($form as $key => $val){
                if($val['required'] && empty($val['value'])){
                    __error("请填写".$val['label']);
                }
            }
        }
        
        if(empty($goods)){
            __error("下单商品信息错误");
        }
        
        $levels = Fenxiao::getLevels(1);
        
        try {
        	Db::startTrans();
        	
        	$order_type = 0;
        	
        	$goods_ids = [];
        	
        	$is_cloud_warehouse = -1;
        	$cw_goods = explode(",",(string)$set['cloud_warehouse']['cw_goods']);
        	$profit_amount = 0;
        	$cost_price = 0;
        	$mid = 0;
        	$is_crazy = 0;
        	$is_super_maihuo = 0;
        	$is_repurchase_currency_pay = 0;
            $gift_status = -1;
            $is_hexiao_quantity = 0;
        	
        	foreach ($goods as $key => $item){
        	    $plugin = iunserializer($item['plugin']);
                $pay = $plugin['pay'];
                
                if(is_null($pay['weixin_pay'])){
                    $pay['weixin_pay'] = 1;
                }
                if(is_null($pay['balance_pay'])){
                    $pay['balance_pay'] = 1;
                }
                if(is_null($pay['repurchase_currency_pay'])){
                    $pay['repurchase_currency_pay'] = 1;
                }
                if(is_null($pay['zfb_pay'])){
                    $pay['zfb_pay'] = 1;
                }
                if($pay['weixin_pay'] != 1 && $pay['balance_pay'] != 1 && $pay['zfb_pay'] != 1 && $pay['repurchase_currency_pay'] == 1){
                    $is_repurchase_currency_pay = 1;
                }
                if($is_repurchase_currency_pay == 0 && $pay['repurchase_currency_pay'] != 1){
                    $is_repurchase_currency_pay = 2;
                }

                if($set['crazy']['status'] == 1){
                    $crazy = $plugin['crazy'];
                    if($crazy['status'] == 1 && intval($crazy['crazy_portion']) > 0){
                        $is_crazy = 1;
                        if($key != 0){
                            throw new \Exception("疯狂卖货模式商品不可与其他商品一起下单");
                        }
                    }
                    else{
                        if($is_crazy == 1){
                            throw new \Exception("疯狂卖货模式商品不可与其他商品一起下单");
                        }
                    }
                }
                
                if($set['super_maihuo']['status'] == 1){
                    $super_maihuo = $plugin['super_maihuo'];
                    if($super_maihuo['status'] == 1 && intval($super_maihuo['super_maihuo_portion']) > 0){
                        $is_super_maihuo = 1;
                        if($key != 0){
                            throw new \Exception("超级卖货模式商品不可与其他商品一起下单");
                        }
                    }
                    else{
                        if($is_super_maihuo == 1){
                            throw new \Exception("超级卖货模式商品不可与其他商品一起下单");
                        }
                    }
                }
                
        	    if($set['cloud_warehouse']['status'] == 1){
                    if(in_array($goods['id'],$cw_goods)){
                        if($is_cloud_warehouse == 0){
                            throw new \Exception("云仓商品不能和其他商品一起下单");
                        }
                        $is_cloud_warehouse = 1;
                    }
                    else{
                        $is_cloud_warehouse = 0;
                    }
                }
        	    

                if($set['gift']['status'] == 1){
                    $gift = $plugin['gift'];
                    if($gift['status'] == 1){
                        $gift_status = 0;
                        if($key > 0){
                            throw new \Exception('礼品商品不能和其他商品一起下单');
                        }
                    }
                    else{
                        if($gift_status === 0){
                            throw new \Exception('礼品商品不能和其他商品一起下单');
                        }
                    }
                }
                if($gift_status === 0 && $is_cloud_warehouse == 1){
                    throw new \Exception('礼品商品不能绑定云仓商品');
                }
        	    
        	    if($mid == 0 && $item['mid'] > 0){
        	        $mid = $item['mid'];
        	        if($key != 0){
        	            throw new \Exception("商品不属于同一门店商品，不可下单");
        	        }
        	    }
        	    else{
        	        if($mid != $item['mid']){
        	            throw new \Exception("商品不属于同一门店商品，不可下单");
        	        }
        	    }

        	    $goods_ids[] = $item['id'];
        	    if($order_type == 0){
        	        $order_type = $item['type'];
        	    }
        	   
        	    if($item['type'] != $order_type){
        	        if($order_type == 1 || $order_type == 4){
        	            throw new \Exception("虚拟商品不能和其他类型商品通过购物车一起下单【{$item['title']}】");
        	        }
        	        else if($order_type == 2){
        	            throw new \Exception("实物商品不能和其他类型商品通过购物车一起下单【{$item['title']}】");
        	        }
        	        else if($order_type == 3){
        	            throw new \Exception("核销商品不能和其他类型商品通过购物车一起下单【{$item['title']}】");
        	        }
        	        else{
        	            throw new \Exception("未知商品类型不能和其他类型商品通过购物车一起下单【{$item['title']}】");
        	        }
        	    }
        	    $total = max(1,intval($item['total']));
        	    $profit_amount += $total * $item['profit_amount'];
        	    $cost_price += $total * $item['cost_price'];
        	    $result = CloudWarehouse::checkStock($user['id'],$total,$item['id']);
        	    if($result['code'] != 1){
        	        throw new \Exception($result['message']);
        	    }
        	    
                $minbuy = max(1,intval($item['minbuy']));
                $maxbuy = intval($item['maxbuy']);
                $total_maxbuy = intval($item['total_maxbuy']);
                $daily_buy = intval($item['daily_buy']);
                $monthly_buy = intval($item['monthly_buy']); 
                if($total < $minbuy){
                    throw new \Exception("单次最低购买{$minbuy}{$item['unit']}【{$item['title']}】");
                }
                if($maxbuy > 0 && $total > $maxbuy){
                    throw new \Exception("单次最多购买{$maxbuy}{$item['unit']}【{$item['title']}】");
                }
                if($total_maxbuy > 0){
                    $user_total_maxbuy = Db::name("bbfx_order_goods")->alias("og")->join("bbfx_order o","o.id=og.order_id")->where(['o.uniacid'=>UNIACID,'o.refund_status'=>['in',[-1,2]],'o.user_id'=>$user['id'],'og.goods_id'=>$item['id']])->count();
                    $user_total_maxbuy = intval($user_total_maxbuy);
                    if(($user_total_maxbuy + $total) > $total_maxbuy){
                        throw new \Exception("最多可购买{$total_maxbuy}{$item['unit']}【{$item['title']}】");
                    }
                }
                if($daily_buy > 0){
                    $user_daily_buy = Db::name("bbfx_order_goods")->alias("og")->join("bbfx_order o","o.id=og.order_id")->where(['o.uniacid'=>UNIACID,'o.refund_status'=>['in',[-1,2]],'o.user_id'=>$user['id'],'og.goods_id'=>$item['id'],'o.createtime'=>['>',strtotime(date("Y-m-d 00:00:00"))],'o.status'=>['>=',0]])->count();
                    $user_daily_buy = intval($user_daily_buy);
                    if(($user_daily_buy + $total) > $daily_buy){
                        $buy_num = $daily_buy - $user_daily_buy;
                        if($buy_num == 0){
                            throw new \Exception("每日最多购买{$daily_buy}{$item['unit']}【{$item['title']}】");
                        }
                        else{
                            throw new \Exception("今日最多还可购买{$buy_num}{$item['unit']}【{$item['title']}】");
                        }
                    }
                }
                if($monthly_buy > 0){
                    $user_monthly_buy = Db::name("bbfx_order_goods")->alias("og")->join("bbfx_order o","o.id=og.order_id")->where(['o.uniacid'=>UNIACID,'o.refund_status'=>['in',[-1,2]],'o.user_id'=>$user['id'],'og.goods_id'=>$item['id'],'o.createtime'=>['>',strtotime(date("Y-m-01 00:00:00"))],'o.status'=>['>=',0]])->count();
                    $user_monthly_buy = intval($user_monthly_buy);
                    if(($user_monthly_buy + $total) > $monthly_buy){
                        $buy_num = $monthly_buy - $user_monthly_buy;
                        if($buy_num == 0){
                            throw new \Exception("每月最多购买{$monthly_buy}{$item['unit']}【{$item['title']}】");
                        }
                        else{
                            throw new \Exception("本月最多还可购买{$buy_num}{$item['unit']}【{$item['title']}】");
                        }
                    }
                }
                $levels = iunserializer($item['levels']);
                if($user['is_distributor'] != 1 || $user['distributor_status'] != 1){
                    $user['level'] = -1;
                }
                if(!empty($levels) && !in_array($user['level'],$levels)){
                    if(!empty($set['buylevel_tips'])){
                        throw new \Exception($set['buylevel_tips']);
                    }
                    else{
                        throw new \Exception("商品【{$item['title']}】当前等级不能购买");
                    }
                }
        	    
                if($item['type'] == 1){
                    $serial_number = Db::name("bbfx_serial_number")->where(["uniacid"=>UNIACID,'status'=>0,"goods_id"=>$item['id']])->select();
                    if(empty($serial_number) || count($serial_number) < $total){
                        throw new \Exception("库存不足【{$item['title']}】");
                    }
                }
                else{
                    if($item['stock'] < $total){
                        throw new \Exception("库存不足【{$item['title']}】");
                    }
                }
                
            }
            
            $delivery_method = 0;
            $is_hexiao = 0;
            if($order_type == 2){
                $g_delivery_method = $goods[0]['delivery_method'];
                $delivery_method = intval($params['delivery_method']);
                $delivery_method_list = [];
                $arr = [];
                if($g_delivery_method == 1 || $g_delivery_method == 3){
                    $arr[] = 1;
                }
                if($g_delivery_method == 2 || $g_delivery_method == 3){
                    $arr[] = 2;
                }
                if(!in_array($delivery_method,$arr)){
                    $delivery_method = $arr[0];
                }
                
                if($delivery_method == 2){
                    $is_hexiao = 1;
                }
            }
            else if($order_type == 4 && $goods[0]['is_hexiao'] == 1){
                $delivery_method = 2;
                $is_hexiao = 1;
            }
            $hexiao_info_required = 0;
            foreach ($goods as $key => $item){
                if($item['hexiao_info_required'] == 1){
                    $hexiao_info_required = 1;
                }
                if($is_hexiao == 1){
                
                    if($item['hexiao_store_type'] == 1){
                        $store_goods = Db::name("bbfx_store_goods")->where(['uniacid'=>UNIACID,'goods_id'=>$item['id'],'store_id'=>$store_id])->find();
                        if(empty($store_goods)){
                            throw new \Exception("商品不能在该门店下单【{$item['title']}】");
                        }
                    }
                    
                    if($is_hexiao_quantity == 0 && $item['is_hexiao_quantity'] == 1){
                        if($key > 0){
                            throw new \Exception("已开启核销数量不可和其他商品下单");
                        }
                        $is_hexiao_quantity = 1;
                    }
                    else{
                        if($is_hexiao_quantity == 1){
                            throw new \Exception("已开启核销数量不可和其他商品下单");
                        }
                    }
                }

            }

            if($order_type == 2 && $delivery_method == 1 && $gift_status == -1){
                if(empty($address)){
                    throw new \Exception("请填写收货信息");
                }
                if(empty($address['consignee'])){
                    throw new \Exception("请填写收货人");
                }
                if(empty($address['phone'])){
                    throw new \Exception("请填写收货人电话");
                }
                if(empty($address['province_name'])){
                    throw new \Exception("请填写收货人地址");
                }  
            }
            
            $result = $this->model->calculateMoney($goods,$user,$coupon_id,$delivery_method,$address);
            
            
            // throw new \Exception("订单类型：".$order_type);
            
            $price = floatval($result['total_price']);
            $express_fee = floatval($result['express_fee']);
            $original_price = floatval($result['original_price']);
            $discount_price = floatval($result['discount_price']);
            if($price <= 0){
                $price = 0;
                // throw new \Exception("订单金额错误");
            }
            $total_price = $original_price;
            
            $order_no = date('YmdHis').random(8,true);  
            $remarks = $params['remarks'];
            $order = array(
                "uniacid"=>UNIACID,
                "mid"=>$mid,
                "order_no"=>$order_no,
                'store_id'=>$store_id,
                "user_id"=>$user['id'],
                "order_type"=>$order_type,
                'order_source'=>7,
                "price"=>$price,
                "profit_amount"=>$profit_amount,
                "cost_price"=>$cost_price,
                "total_price"=>$original_price,
                "discount_vip_price"=>round($result['discount_vip_price'],2),
                "discount_coupon_price"=>round($result['discount_coupon_price'],2),
                "discount_price"=>$discount_price,
                "original_price"=>$original_price,
                "goods_info"=>iserializer($goods),
                'remarks'=>$remarks,
                'platform'=>'H5',
                'is_cloud_warehouse'=>$is_cloud_warehouse,
                'delivery_method'=>$delivery_method,
                'is_hexiao'=>$is_hexiao,
                'is_crazy'=>$is_crazy,
                'is_super_maihuo'=>$is_super_maihuo,
                'gift_status'=>$gift_status,
                'is_hexiao_quantity'=>$is_hexiao_quantity,
                'sup_path'=>$user['sup_path'],
                "createtime"=>time()
            );
            $extend = []; 
            if(!empty($form)){
                $extend['form'] = $form;
            }
            $order['extend'] = iserializer($extend);
            
            $price_data = $result['price_data'];
            
            if(!empty($result['coupon'])){
                $order['user_coupon_id'] = $result['coupon']['id'];
                if($result['coupon']['type'] == 1){
                    $res = Db::name("bbfx_user_coupon")->where(["id"=>$result['coupon']['id'],'user_id'=>$user['id'],'status'=>0])->setDec("residue_money",$result['discount_coupon_price']);
                    if($res){
                        $residue_money = Db::name("bbfx_user_coupon")->where(["id"=>$result['coupon']['id'],'status'=>0])->value("residue_money");
                        $residue_money = floatval($residue_money);
                        if($residue_money == 0){
                            Db::name("bbfx_user_coupon")->where(["id"=>$result['coupon']['id'],'user_id'=>$user['id'],'status'=>0])->update(['status'=>1]);
                        }
                    }
                }
                else{
                    $res = Db::name("bbfx_user_coupon")->where(["id"=>$result['coupon']['id'],'user_id'=>$user['id'],'status'=>0])->update(['status'=>1]);
                }
                
                if(empty($res)){
                    throw new \Exception("优惠券错误");
                }
            }
            
            if($order_type == 2 && $delivery_method == 1){

                if($gift_status == -1){
                    if(empty($address)){
                        throw new \Exception("请填写收货信息");
                    }
                    if(empty($address['consignee'])){
                        throw new \Exception("请填写收货人");
                    }
                    if(empty($address['phone'])){
                        throw new \Exception("请填写收货人电话");
                    }
                    if(empty($address['province_name'])){
                        throw new \Exception("请填写收货人地址");
                    }
                    
                    $order['delivery_username'] = $address['consignee'];
                    $order['delivery_mobile'] = $address['phone'];
                    $order['delivery_province'] = $address['province_name'];
                    $order['delivery_city'] = $address['city_name'];
                    $order['delivery_area'] = $address['area_name'];
                    // $order['delivery_street'] = $address['street_name'];
                    $order['delivery_address'] = $address['address'];
                }
                
                $order['express_fee'] = $express_fee;
                
                $order['price'] = $price + $express_fee;
                $order['total_price'] = $original_price + $express_fee;
            }
            else if(($order_type == 2 && $delivery_method == 2) || ($order_type == 4 && $is_hexiao == 1)){

                if($gift_status == -1 && $hexiao_info_required == 1){
                    if(empty($params['hexiao_realname'])){
                        throw new \Exception("请输入姓名");
                    }
                    if(empty($params['hexiao_mobile'])){
                        throw new \Exception("请输入联系方式");
                    }
                    $order['hexiao_realname'] = $params['hexiao_realname'];
                    $order['hexiao_mobile'] = $params['hexiao_mobile'];
                    Db::name("bbfx_user")->where(['id'=>$user['id']])->update(['hexiao_realname'=>$order['hexiao_realname'],'hexiao_mobile'=>$order['hexiao_mobile']]);
                }
                
                
                if($mid > 0){
                    $store = Db::name("bbfx_store")->where(['id'=>$store_id,'mid'=>$mid,'uniacid'=>UNIACID])->field("id,name,logo,realname,mobile,province,city,area,address,lat,lng")->find();
                    if(empty($store)){
                        throw new \Exception("请选择核销门店");
                    }
                }
                else{
                    
                    $store = Db::name("bbfx_store")->where(['id'=>$store_id,'type'=>0,'mid'=>0,'uniacid'=>UNIACID])->field("id,name,logo,realname,mobile,province,city,area,address,lat,lng")->find();
                    if(empty($store)){
                        throw new \Exception("请选择核销门店");
                    }
                }
                
                $order['hexiao_store'] = iserializer($store);
                $order['hexiao_total'] = max(1,$goods[0]['hexiao_num']);
                $order['hexiao_num'] = max(1,$goods[0]['hexiao_num']);
                $order['hexiao_code'] = random(9,true);
                
            }
            
            
            $order_repurchase_currency = 0;
            if($is_repurchase_currency_pay === 0){
                $repurchase_currency = floatval($user['repurchase_currency']);
                if($repurchase_currency > 0){
                    if($order['price'] > $repurchase_currency){
                        $order_repurchase_currency = $repurchase_currency;
                    }
                    else{
                        $order_repurchase_currency = $order['price'];
                    }
                }
                $order['repurchase_currency'] = $order_repurchase_currency;
            }

            $real_price = $order['price'] - $order['repurchase_currency'];
            
            if($real_price > 0){
                if($paytype == 2 && $real_price > $user['balance']){
                    throw new \Exception("余额不足");
                }

                
            }
            
            $order_id = Db::name("bbfx_order")->insertGetId($order);
            if(empty($order_id)){
                throw new \Exception("创建订单失败");
            }
            
            $order['id'] = $order_id;

            
            if($order_repurchase_currency > 0){
                $res = User::setUserMoney($user['id'],-$order_repurchase_currency,4,1,"商品支付",$order);
                if(empty($res)){
                    throw new \Exception("创建订单失败");
                }
            }
            
            if($paytype == 2){
                $res = User::setUserMoney($user['id'],$real_price,1,1,"商品支付",$order);
                if(empty($res)){
                    throw new \Exception("余额不足");
                }
            }

            $pay_order = Db::name("bbfx_pay_order")->where(['order_no'=>$order_no,'uniacid'=>UNIACID])->find();
            if(empty($pay_order)){
                $pay_order = array(
                    "uniacid"=>UNIACID,
                    "openid"=>$user['openid'],
                    "order_no"=>$order_no,
                    "price"=>$real_price,
                    "order_type"=>1,
                    "platform"=>$user['platform'],
                    "createtime"=>time()
                );
                if($user['openid']){
                    $pay_order['openid'] = $user['openid'];
                }
                $res = Db::name("bbfx_pay_order")->insert($pay_order);
                if(empty($res)){
                    __error("创建支付订单失败");
                }
            }
            
            foreach ($goods as $key => $item){
                $total = max(1,intval($item['total']));
                $profit_amount = $item['profit_amount'] * $total;
                $cost_price = $item['cost_price'] * $total;
                $order_goods = array(
                    "uniacid"=>UNIACID,
                    "mid"=>$mid,
                    "order_id"=>$order_id,
                    "user_id"=>$user['id'],
                    "total"=>$total,
                    "profit_amount"=>$profit_amount,
                    "cost_price"=>$cost_price,
                    "price"=>$price_data[$key]['price'],
                    "total_price"=>$price_data[$key]['total_price'],
                    "discount_price"=>$price_data[$key]['discount_price'],
                    "discount_vip_price"=>$price_data[$key]['discount_vip_price'],
                    "discount_coupon_price"=>$price_data[$key]['discount_coupon_price'],
                    "goods_id"=>$item['id'],
                    "upgrade_score"=>$item['upgrade_score'] * $total,
                    "goods_info"=>iserializer($item),
                    "createtime"=>time()
                );
                
                if(!empty($item['sku'])){
                    $order_goods['sku_id'] = $item['sku_id'];
                    $order_goods['sku_name'] = $item['sku_name'];
                    $order_goods['sku'] = iserializer($item['sku']);
                }
                
                if(!empty($price_data[$key]['user_coupon_id'])){
                    $order_goods['user_coupon_id'] = $price_data[$key]['user_coupon_id'];
                }
                
                if($price_data[$key]['type'] == 1){
                    $order_goods['type'] = 1;
                    $order_goods['seckill_activity_id'] = $price_data[$key]['seckill_activity_id'];
                    $order_goods['seckill_goods_id'] = $price_data[$key]['seckill_goods_id'];
                }
                
                $og_id = Db::name("bbfx_order_goods")->insertGetId($order_goods);
                if(empty($og_id)){
                    throw new \Exception("创建订单失败");
                }
                
                $order_goods['og_id'] = $og_id;
                
                if($item['stock_type'] == 1){
                    $result = Goods::setStock($item['id'],intval($item['sku_id']),-$total,$user['id'],1,1,"用户下单",$order_goods,false);
                    
                    if($result['code'] != 1){
                        throw new \Exception($result['message']."【{$item['title']}】");
                    }
                }

                if((($order_type == 2 && $delivery_method == 2) || ($order_type == 4 && $is_hexiao == 1)) && $is_hexiao_quantity == 1){
                    for ($i = 0;$i < $total;$i++){
                        $hxcode_data = [
                            "uniacid"=>UNIACID,
                            "order_id"=>$order_id,
                            "pid"=>$og_id,
                            "goods_id"=>$item['id'],
                            "hexiao_total"=>max(1,$item['hexiao_num']),
                            "hexiao_num"=>max(1,$item['hexiao_num']),
                            "hexiao_code"=>random(9,true),
                            "createtime"=>time()
                        ];
                        Db::name("bbfx_order_goods_hxcode")->insertGetId($hxcode_data);
                    }
                }
            }
        	
        	
        	Db::commit();
        } catch (\Exception $e) {
        	Db::rollback();
        	$msg = $e->getMessage();
        	
        	__error($msg);
        }
        
        $this->model->payResult($order_no,$paytype);

        __success("操作成功",["order_no"=>$order_no]);
        
    }

    public function getGoodsDetail(){
        $goods_id = $this->param("goods_id/d");
        $goods = Db::name("bbfx_goods")->where(['uniacid'=>UNIACID,'status'=>1,'id'=>$goods_id])->find();
        if(empty($goods)){
            __error("商品信息错误");
        }

        if($goods['is_spec'] == 1){
            $suk_list = Db::name("bbfx_goods_spec_sku")->where(['uniacid'=>UNIACID,'goods_id'=>$goods['id']])->select();
            $goods['sku_list'] = $suk_list;
        }

        __success("操作成功",['goods'=>$goods]);
    }

    public function getStoreList(){
        $goods_ids = $this->param("goods_ids/s");
        $page = $this->param("page/d");
        $is_reservation = $this->param("is_reservation/d");
        $keyword = $this->param("keyword/s");
        $lat = $this->param("lat/f");
        $lng = $this->param("lng/f");
        $goods_type = $this->param("goods_type/d");
        $page = max(1,$page);
        $limit = 10;
        
        
        $list = [];
        if(!empty($goods_ids)){
            
            $where = ['uniacid'=>UNIACID,'status'=>1];
            
            if(!empty($keyword)){
                $where['name'] = ['like','%'.$keyword.'%'];
            }
            
            
            $goods_ids = explode(",",$goods_ids);
            if($goods_type == 1){
                $goods = Db::name("bbfx_scoreshop_goods")->where(['uniacid'=>UNIACID,'status'=>1,'type'=>['in',[2,4]],'id'=>['in',$goods_ids]])->field("id,type,delivery_method,is_hexiao,hexiao_store_type")->select();
                $where['mid'] = 0;
            }
            else if($goods_type == 2){
                $pintuan_goods = Db::name("bbfx_pintuan_goods")->where(['id'=>['in',$goods_ids]])->select();
                $goods_ids = array_column($pintuan_goods,"goods_id");
                $goods = Db::name("bbfx_goods")->where(['uniacid'=>UNIACID,'status'=>1,'type'=>['in',[2,4]],'id'=>['in',$goods_ids]])->field("id,type,delivery_method,is_hexiao,hexiao_store_type")->select();
                $where['mid'] = 0;
            }
            else{
                $goods = Db::name("bbfx_goods")->where(['uniacid'=>UNIACID,'status'=>1,'type'=>['in',[2,4]],'id'=>['in',$goods_ids]])->field("id,mid,type,delivery_method,is_hexiao,hexiao_store_type")->select();
                
                $mid = 0;
                if(!empty($goods)){
                    foreach ($goods as $k => $v){
                        if($v['mid'] > 0){
                            $mid = $v['mid'];
                        }
                    }
                }
                
                $where['mid'] = $mid;
            }
            
            
            
            $store_list = Db::name("bbfx_store")->where($where)->order("sort desc")->field("id,user_id,name,logo,realname,mobile,yy_time,province,city,area,address,lng,lat,is_reservation,score,introduction")->select();
            
            
            foreach ($store_list as $key => $val){
                $flag = true;
                foreach ($goods as $k => $v){
                    if(($v['type'] == 2 && ($v['delivery_method'] == 2 || $v['delivery_method'] == 3)) || ($v['type'] == 4 && $v['is_hexiao'] == 1)){
                        
                        if($v['hexiao_store_type'] == 1){
                            if($goods_type == 1){
                                $store_goods = Db::name("bbfx_scoreshop_store_goods")->where(['uniacid'=>UNIACID,'goods_id'=>$v['id'],'store_id'=>$val['id']])->find();
                            }
                            else{
                                $store_goods = Db::name("bbfx_store_goods")->where(['uniacid'=>UNIACID,'goods_id'=>$v['id'],'store_id'=>$val['id']])->find();
                            }
                            
                            if(empty($store_goods)){
                                $flag = false;
                            }
                        
                        }
                    }
                }
                if($flag){
                    $list[] = $val;
                }
            }
            $total = count($list);
        }
        else{
            
            $where = ['uniacid'=>UNIACID,'mid'=>0,'status'=>1,'is_reservation'=>$is_reservation];
            
            if(!empty($keyword)){
                $where['name'] = ['like','%'.$keyword.'%'];
            }
            
            $list = Db::name("bbfx_store")->where($where)->order("sort desc")->field("id,user_id,name,logo,realname,mobile,yy_time,province,city,area,address,lng,lat,is_reservation,score,introduction")->select();
            $total = Db::name("bbfx_store")->where($where)->count();
            
        }
        
        foreach ($list as $key => &$val){
            $val['logo'] = cdnurl($val['logo']);
            $distance = 9999999;
            if(!empty($lng) || !empty($lat) || !empty($val['lng']) || !empty($val['lat'])){
                $distance = getdistance($lng,$lat,$val['lng'],$val['lat']);
            }
            $val['distance'] = $distance;
            $val['distanceText'] = "";
            if($distance != 9999999){
                $val['distanceText'] = $distance."km";
            }
        }
        unset($val);
        
        $distances = array_column($list,'distance');
        array_multisort($distances,SORT_ASC,$list);
        
        $list = array_slice($list, ($page-1)*$limit, $limit);
        
        __success("操作成功",['list'=>$list,'total'=>$total]);
    }
}