<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\merchant;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Merchant extends Base
{

    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Merchant;
    }
    
    public function all(){
        
        $list = Db::name("bbfx_merchant")->where(['uniacid'=>UNIACID,'is_shenhe'=>1])->order("updatetime desc,id desc")->field("id,name,logo")->select();
        foreach ($list as $key => &$val) {
            $val['logo'] = cdnurl($val['logo']);
        }
        unset($val);
        
        __success("操作成功",['list'=>$list]);
    }
    
    public function getList(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):20;
        $status = intval($params["status"]);
        $keyword = trim($params['keyword']);
        
        $where = ['uniacid'=>UNIACID];
        
        if($status == 1){
            $where['sh_status'] = ['in',[1,2]];
        }
        else if($status == 2){
            $where['sh_status'] = 0;
        }
        
        if(!empty($keyword)){
            $where['name'] = ['like','%'.$keyword.'%'];
        }
        
        $list = Db::name("bbfx_merchant")->where($where)->order("updatetime desc,id desc")->limit(($pindex - 1) * $psize,$psize)->select();
        foreach ($list as $key => &$val) {
            
            if(!empty($val['sh_data'])){
                $sh_data = iunserializer($val['sh_data']);
                
                $new_data = [];
                foreach ($sh_data as $k => $v){
                    if(!empty($k) && is_string($k)){
                        $new_data[$k] = $v;
                    }
                }
                
                if(!empty($new_data)){
                    $val = array_merge($val,$new_data);
                }
            }
            
            $val['logo'] = cdnurl($val['logo']);
            $user = Db::name("bbfx_user")->where(['id'=>$val['user_id']])->field("id,nickname,avatar")->find();
            if(!empty($user)){
                $user['avatar'] = cdnurl($user['avatar']);
                $val['user'] = $user;
            }
        }
        unset($val);
        
        $total = Db::name("bbfx_merchant")->where($where)->count();
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function detail(){
        $id = $this->param("id/d");
        $info = $this->model->getInfo($id);
        
        if(!empty($info['sh_data'])){
            
            $sh_data = iunserializer($info['sh_data']);
            $new_data = [];
            foreach ($sh_data as $k => $v){
                if(!empty($k) && is_string($k)){
                    $new_data[$k] = $v;
                }
            }
            
            if(!empty($new_data)){
                $info = array_merge($info,$new_data);
                
                $info['region'] = [$info['province'],$info['city'],$info['area']];
                $info['logo'] = cdnurl($info['logo']);
                $info['images'] = cdnurls(iunserializer($info['images']));
                $info['category_id'] = deid($info['category_id']);
            }
        }
        
        if(!empty($info)){
            __success("操作成功",$info);
        }
        else{
            __error("商户不存在");
        }
    }
    
    public function shenhe(){
        $id = $this->param("id/d");
        $status = $this->param("status/d");
        $info = Db::name("bbfx_merchant")->where(["id"=>$id])->find();
        if(empty($info)){
            __error("商户不存在");
        }
        
        if($status != 1) $status = 2;
        
        $res = Db::name("bbfx_merchant")->where(["id"=>$info['id']])->update(['sh_status'=>$status]);
        if($res){
            
            $udata = ['sh_time'=>time()];
            
            if(!empty($info['sh_data']) && $status == 1){
                $sh_data = iunserializer($info['sh_data']);
                
                $new_data = [];
                foreach ($sh_data as $k => $v){
                    if(!empty($k) && is_string($k)){
                        $new_data[$k] = $v;
                    }
                }
                
                if(!empty($new_data)){
                    $udata = array_merge($udata,$new_data);
                }
                
                $udata['sh_data'] = '';
            }
            
            if($status == 1){
                $udata['is_shenhe'] = 1;
            }
            
            Db::name("bbfx_merchant")->where(["id"=>$info['id']])->update($udata);
            
            if($status == 1){
                $this->model->syncMainStore($info['id']);
            }
            
            \app\admin\model\AdminLog::record("","",['id'=>$info['id'],'sh_status'=>$status,'sh_time'=>time()],"bbfx_merchant");
            
            __success("操作成功");
        }
        else{
            __success("操作成功");
        }
    }

    public function getStoreList(){
        $mid = $this->param("mid/d");

        $list = Db::name("bbfx_store")->where(['uniacid'=>UNIACID,'type'=>1,'mid'=>$mid])->field("id,name")->select();

        __success("操作成功",['list'=>$list]);
    }
    
    public function post(){
        $params = $this->paramPost(['id/d','user_id/d','sup_uid/d','sup_commission/f','category_id/a','score/f','name/s','logo/s','realname/s','mobile/s','region/a','address/s','lng/f','lat/f','status/d','yy_status/d','yy_time/s','commission_rate/f','content/s','images/a','introduction/s','is_fenxiao/d','detail_images/a']);
        
        if($params['user_id'] <= 0){
            // __error("请选择商户管理员");
        }
        if(empty($params['name'])){
            __error("请输入商户名称");
        }
        if(empty($params['mobile'])){
            __error("请输入联系电话");
        }
        if(empty($params['region'])){
            __error("请选择商户区域");
        }
        if(empty($params['lng']) || empty($params['lng'])){
            __error("请在地图中选择商户地址");
        }
        if(empty($params['yy_time'])){
            __error("请输入营业时间");
        }
        
        $data = array(
            "uniacid"=>UNIACID,
            "user_id"=>$params['user_id'],
            "sup_uid"=>$params['sup_uid'],
            "sup_commission"=>max(0,$params['sup_commission']),
            "is_fenxiao"=>$params['is_fenxiao'],
            "category_id"=>enid($params['category_id']),
            "name"=>$params['name'],
            "logo"=>replaceSiteroot($params['logo']),
            "realname"=>$params['realname'],
            "mobile"=>$params['mobile'],
            "yy_time"=>$params['yy_time'],
            "province"=>$params['region'][0],
            "city"=>$params['region'][1],
            "area"=>$params['region'][2],
            "address"=>$params['address'],
            "lng"=>$params['lng'],
            "lat"=>$params['lat'],
            // "score"=>max(0,$params['score']),
            "status"=>$params['status'],
            "yy_status"=>$params['yy_status'],
            // "sh_status"=>$params['sh_status'],
            "content"=>$params['content'],
            "introduction"=>$params['introduction'],
            "commission_rate"=>$params['commission_rate'],
            "images"=>iserializer(replaceSiteroots($params['images'])),
            "detail_images"=>iserializer(replaceSiteroots($params['detail_images'])),
            "updatetime"=>time(),
        );
        
        $item = Db::name("bbfx_merchant")->where("id",$params['id'])->find();
        if(!empty($item)){
            $res = Db::name("bbfx_merchant")->where("id",$item['id'])->update($data);
            $data['id'] = $item['id'];
        }
        else{
            $data['is_shenhe'] = 1;
            $data['sh_status'] = 1;
            $data['sh_time'] = time();
            $data['createtime'] = time();
            $res = Db::name("bbfx_merchant")->insertGetId($data);
            $data['id'] = $res;
        }
        
        if($res){
            
            $this->model->syncMainStore($data['id']);
            
            \app\admin\model\AdminLog::record("","",$data,"bbfx_merchant");
            __success("编辑成功");
        }
        else{
            __success("操作成功");
        }
        
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        $list = Db::name("bbfx_merchant")->where('id','in',$ids)->select();
        if(empty($list)){
            __error("删除的数据不存在");
        }
        $titles = array_column($list, 'name');
        
        
      	$res = Db::name("bbfx_merchant")->where('id','in',$ids)->delete();
      	if($res){
      	    
      	    Db::name("bbfx_store")->where(["type"=>1,'mid'=>['in',$ids]])->find();
      	    
      	    \app\admin\model\AdminLog::record("删除商户","商户：".implode(",",$titles)."，商户ID：".implode(",",$ids),$list);
      	    
        	__success("删除成功");
        }
    	else{
        	__error("删除失败");
        }
    }
}