<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\merchant;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Category extends Base
{

    public function getList(){
        
        $params = $this->param();
        
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):20;
        $mid = intval($params['pid']);
        $where = ["uniacid"=>UNIACID,'mid'=>['>',0]];
        if($mid > 0){
            $where['mid'] = $mid;
        }
        $list = Db::name("bbfx_category")->where($where)->order('mid asc,sort desc')->limit(($pindex - 1) * $psize,$psize)->select();
    	$total = Db::name("bbfx_category")->where($where)->count();
    	foreach ($list as $key => &$val) {
    	    
    	    $val['merchant_name'] = Db::name("bbfx_merchant")->where(['id'=>$val['mid']])->value("name");
    	    
    	    $val['thumb'] = cdnurl($val['thumb']);
    	    $val['parent_name'] = "";
    	    if($val['pid'] > 0){
    	        $val['parent_name'] = Db::name("bbfx_category")->where(['id'=>$val['pid']])->value("titlte");
    	    }
    	}
    	unset($val);
      	
        __success('操作成功',['total'=>$total,'list'=>$list]);
    }

    public function getMerchantCategoryList(){
        $mid = $this->param("mid/d");
        $where = ["uniacid"=>UNIACID,'mid'=>$mid];
        $list = Db::name("bbfx_category")->where($where)->order('sort desc')->select();
        __success('操作成功',['list'=>$list]);
    }

    public function post(){
        $params = $this->param();
        $id = intval($params['id']);
        
        $item = Db::name("bbfx_category")->where(['id'=>$id,'mid'=>['>',0]])->find();
        
        $data = array(
        	"uniacid"=>UNIACID,
          	"mid"=>intval($params['mid']),
          	"pid"=>intval($params['pid']),
          	"title"=>$params['title'],
          	"status"=>$params['status'],
          	"thumb"=>$params['thumb'],
          	"sort"=>$params['sort']
        );
        if(empty($data['mid'])){
            __error("请选择商户");
        }
      	$data['thumb'] = replaceSiteroot($data['thumb']);
      	if(!empty($item)){
            $res = Db::name("bbfx_category")->where(['id'=>$id])->update($data);
            $data['id'] = $id;
        }
      	else{
            $res = Db::name("bbfx_category")->insertGetId($data);
            $data['id'] = $res;
        }
      	
      	if($res){
      	    
      	    \app\admin\model\AdminLog::record("","",$data,"bbfx_category");
      	    
        	__success("编辑成功");
        }
      	else{
        	__success("操作成功");
        }
    }
    
    public function status(){
        $params = $this->param();
        
        $id = intval($params['id']);
        $status = intval($params['status']);
        if($status != 1) $status = 0;
        $data = ["status"=>$status];
        $res = Db::name("bbfx_category")->where(['id'=>$id])->update($data);
        if($res){
            $data['id'];
            \app\admin\model\AdminLog::record("","",$data,"bbfx_category");
            __success("操作成功");
        }
        else{
            __error(0,"操作失败");
        }
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        $list = Db::name("bbfx_category")->where('id','in',$ids)->where(['mid'=>['>',0]])->select();
        if(empty($list)){
            __error("删除的数据不存在");
        }
        $titles = array_column($list, 'title');
        
      	$res = Db::name("bbfx_category")->where('id','in',$ids)->delete();
      	if($res){
      	    
      	    \app\admin\model\AdminLog::record("删除商户商品分类","商品分类：".implode(",",$titles)."，商户商品分类ID：".implode(",",$ids),$list);
      	    
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}