<?php


namespace app\admin\controller\bbfxshop\luckywheel;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Zhiding extends Base
{
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Luckywheel;
    }
    
    public function getList(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        
        $where = array("a.uniacid"=>UNIACID);
        
        $list = Db::name("bbfx_luckywheel_zhiding")->alias("a")->join("bbfx_user b","a.user_id=b.id","LEFT")->where($where)->field("a.*,b.uid,b.realname")->order('a.id desc')->limit(($pindex - 1) * $psize,$psize)->select();
        $total = Db::name("bbfx_luckywheel_zhiding")->alias("a")->join("bbfx_user b","a.user_id=b.id","LEFT")->where($where)->count();
        
        foreach ($list as $key => &$val){
            $prize = Db::name("bbfx_luckywheel_prize")->where(['id'=>$val['prize_id']])->find();
            if(!empty($prize)){
               $prize['image'] = cdnurl($prize['image']); 
               $val['prize'] = $prize;
            }
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
        }
        unset($val);
        
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function detail(){
        $params = $this->param();
        
        $info = Db::name("bbfx_luckywheel_zhiding")->where("id",$params['id'])->find();
        
        if(empty($info)){
            __error("数据不存在");
        }
        
        __success('操作成功',$info);
    }
    
    public function post(){
        $params = $this->param();
        $data = array(
            "uniacid"=>UNIACID,
            "user_id"=>$params['user_id'],
            "prize_id"=>$params['prize_id']
        );
        if(!empty($params['id'])){
            $res = Db::name("bbfx_luckywheel_zhiding")->where("id",$params['id'])->update($data);
            $data['id'] = $params['id'];
        }
        else{
            $data['createtime'] = time();
            $res = Db::name("bbfx_luckywheel_zhiding")->insertGetId($data);
            $data['id'] = $res;
        }
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_luckywheel_zhiding");
            __success("编辑成功");
        }
        else{
            __success("操作成功");
        }
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
      	$res = Db::name("bbfx_luckywheel_zhiding")->where('id','in',$ids)->delete();
      	if($res){
      	    \app\admin\model\AdminLog::record("","",['id'=>implode(",",$ids)],"bbfx_luckywheel_zhiding");
        	__success("删除成功");
        }
    	else{
        	__error("删除失败");
        }
    }
}