<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/


namespace app\admin\controller\bbfxshop\luckywheel;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Prize extends Base
{
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Luckywheel;
    }
    
    public function all(){
        $where = array("uniacid"=>UNIACID);
        
        $list = Db::name("bbfx_luckywheel_prize")->where($where)->order('sort desc,id desc')->select();
        
        __success("操作成功",['list'=>$list]);
    }
    
    public function getList(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        
        $where = array("uniacid"=>UNIACID);
        
        $list = Db::name("bbfx_luckywheel_prize")->where($where)->order('sort desc,id desc')->limit(($pindex - 1) * $psize,$psize)->select();
        $total = Db::name("bbfx_luckywheel_prize")->where($where)->count();
        
        foreach ($list as $key => &$val){
            $val['image'] = cdnurl($val['image']);
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
        }
        unset($val);
        
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function detail(){
        $params = $this->param();
        
        $info = Db::name("bbfx_luckywheel_prize")->where("id",$params['id'])->find();
        
        if(empty($info)){
            __error("数据不存在");
        }
        $info['image'] = cdnurl($info['image']);
        
        __success('操作成功',$info);
    }
    
    public function post(){
        $params = $this->param();
        $data = array(
            "uniacid"=>UNIACID,
            "type"=>$params['type'],
            "title"=>$params['title'],
            "image"=>replaceSiteroot($params['image']),
            "reward"=>$params['reward'],
            "probability"=>floatval($params['probability']),
            "status"=>intval($params['status']),
            "sort"=>intval($params['sort'])
        );
        if(!empty($params['id'])){
            $res = Db::name("bbfx_luckywheel_prize")->where("id",$params['id'])->update($data);
            $data['id'] = $params['id'];
        }
        else{
            $data['createtime'] = time();
            $res = Db::name("bbfx_luckywheel_prize")->insertGetId($data);
            $data['id'] = $res;
        }
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_luckywheel_prize");
            __success("编辑成功");
        }
        else{
            __success("操作成功");
        }
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
      	$res = Db::name("bbfx_luckywheel_prize")->where('id','in',$ids)->delete();
      	if($res){
      	    \app\admin\model\AdminLog::record("","",['id'=>implode(",",$ids)],"bbfx_luckywheel_prize");
        	__success("删除成功");
        }
    	else{
        	__error("删除失败");
        }
    }
}