<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\goods;

use app\admin\controller\bbfxshop\Base;
use think\Db;
use app\common\model\bbfxshop\Goods as GoodsModel;

class Serialnumber extends Base
{
    public function _initialize(){
        parent::_initialize();
    }
    
    public function list(){
        $params = $this->param();
        $goods_id = intval($params['goods_id']);
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):20;

        $where = ["b.uniacid"=>UNIACID,"a.goods_id"=>$goods_id,'a.status'=>0];
    
        $list = Db::name("bbfx_serial_number")->alias("a")->join("bbfx_goods b","a.goods_id=b.id")->where($where)->field('a.*,b.title')->order('a.id desc')->limit(($pindex - 1) * $psize,$psize)->select();
        
        $total = Db::name("bbfx_serial_number")->alias("a")->join("bbfx_goods b","a.goods_id=b.id")->where($where)->count();
        
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
    
    public function post(){
        $params = $this->param();
        $goods_id = intval($params['goods_id']);
        $serial_number = trim($params['serial_number']);
        if(empty($serial_number)){
            __error("请输入卡密");
        }
        
        $serial_number = explode(",",$serial_number);
        $data = array("uniacid"=>UNIACID,"goods_id"=>$goods_id);
        $stock = 0;
        foreach ($serial_number as $key => $val){
            if(!empty(trim($val))){
                $data['val'] = $val;
                try {
                    Db::name("bbfx_serial_number")->insert($data);
                    $stock++;
                } 
                catch (\Exception $e) {}
            }
        }
        $data = ["goods_id"=>$goods_id,'val'=>implode(",",$serial_number)];
        
        if($stock > 0){
            GoodsModel::setStock($goods_id,0,$stock,$this->auth->id,0,0,"管理员操作");
        }
        
        // 更新库存
        // GoodsModel::resetStock(UNIACID,$goods_id);
        
        \app\admin\model\AdminLog::record("商品管理-商品列表-添加卡密","卡密：".$data['val'],$data);
        
        __success("添加成功");
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        $list = Db::name("bbfx_serial_number")->where('id','in',$ids)->select();
        if(empty($list)){
            __error("删除的数据不存在");
        }
        $titles = array_column($list, 'val');
        
      	$res = Db::name("bbfx_serial_number")->where('id','in',$ids)->delete();
      	if($res){
      	    
      	    // 更新库存
      	    $goods_id = $list[0]['goods_id'];
            GoodsModel::resetStock(UNIACID,$goods_id);
      	    
      	    \app\admin\model\AdminLog::record("删除商品卡密","商品卡密：".implode(",",$titles),$list);
      	    
        	__success("删除成功");
        }
    	else{
        	__error("删除失败");
        }
    }
    
    
}