<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\form;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Record extends Base
{

    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Form;
    }

    public function getList(){
        $page = max(1,$this->param("page/d"));
        $limit = max(10,$this->param("limit/d"));
        $form_id = $this->param("form_id/d");
        $where = ["a.uniacid"=>UNIACID];
        $export = $this->param("export/d");
        if($form_id <= 0 && $export == 1){
            $form_id = Db::name("bbfx_form")->where(['uniacid'=>UNIACID])->order("id desc")->value("id");
        }
        if($form_id > 0){
            $where['a.form_id'] = $form_id;
        }

        $export_list = [];
        $headArr = ['ID'];
        if($export == 1){
            $pindex = 1;
            $psize = 999999;
            $form = Db::name("bbfx_form")->where(['uniacid'=>UNIACID,'id'=>$form_id])->find();
            $form_content = iunserializer($form['content']);

            foreach($form_content as $key => $val){
                $headArr[] = $val['label'];
            }
            $headArr[] = "提交时间";
        }
        $list = Db::name("bbfx_form_record")->alias("a")->join("bbfx_form b","a.form_id=b.id","LEFT")->join("bbfx_user c","a.user_id=c.id","LEFT")->where($where)->field("a.*,b.title,c.nickname,c.avatar")->order("a.id desc")->limit(($page-1)*$limit,$limit)->select();
        

        

        foreach ($list as $key1 => &$val1){
            $val1['createtime'] = date('Y-m-d H:i:s',$val1['createtime']);
            $val1['content'] = iunserializer($val1['content']);
            $val1['avatar'] = cdnurl($val1['avatar']);

            foreach($val1['content'] as $key => &$val){
                if($val['type'] == 'image'){
                    $val['value'] = cdnurl($val['value']);
                }
                else if($val['type'] == 'images'){
                    foreach($val['value'] as $k => &$v){
                        $v = cdnurl($v);
                    }
                    unset($v);
                }
            }
            unset($val);

            if($export == 1){
        	    $datas = [$val1['id']];
                foreach($val1['content'] as $key => &$val){
                    
                    if($val['type'] == 'image'){
                        $val['value'] = cdnurl($val['value']);
                        $datas[] = $val['value'];
                    }
                    else if($val['type'] == 'images'){
                        foreach($val['value'] as $k => &$v){
                            $v = cdnurl($v);
                        }
                        unset($v);
                        if(!empty($val['value'])){
                            $datas[] = implode(",",$val['value']);
                        }
                    }
                    else{
                        $datas[] = $val['value'];
                    }
                }
                $datas[] = $val1['createtime'];
        	    $export_list[] = $datas;
        	}
        }
        unset($val1);
        if($export == 1){
    	    $result = \app\common\model\PhpOffice::excelExport("form-".date("Y-m-d"),$headArr,$export_list);
    	}
        $total = Db::name("bbfx_form_record")->alias("a")->join("bbfx_form b","a.form_id=b.id","LEFT")->join("bbfx_user c","a.user_id=c.id","LEFT")->where($where)->count();
        
        __success("操作成功",['list'=>$list,'total'=>$total]);
    }
    
    public function detail(){
        $params = $this->param(['id/d']);
        $where = ["a.uniacid"=>UNIACID,'a.id'=>$params['id']];
        $info = Db::name("bbfx_form_record")->alias("a")->join("bbfx_form b","a.form_id=b.id","LEFT")->join("bbfx_user c","a.user_id=c.id","LEFT")->where($where)->field("a.*,b.title,c.nickname,c.avatar")->find();
        if(empty($info)){
            __error("数据不存在");
        }

        $info['content'] = iunserializer($info['content']);
        foreach($info['content'] as $key => &$val){
            if($val['type'] == 'image'){
                $val['value'] = cdnurl($val['value']);
            }
            else if($val['type'] == 'images'){
                foreach($val['value'] as $k => &$v){
                    $v = cdnurl($v);
                }
                unset($v);
            }
        }
        unset($val);

        __success("操作成功",['info'=>$info]);
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        
      	$res = Db::name("bbfx_form_record")->where('id','in',$ids)->delete();
      	if($res){
      	    \app\admin\model\AdminLog::record("","",['id'=>implode(",",$ids)],"bbfx_form_record");
        	__success("删除成功");
        }
    	else{
        	__error("删除失败");
        }
    }
}