<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\form;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Form extends Base
{

    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Form;
    }

    public function all(){
        $where = ["uniacid"=>UNIACID];
        $list = Db::name("bbfx_form")->where($where)->order("id desc")->select();
        foreach ($list as $key => &$val){
            $val['image'] = cdnurl($val['image']);
            $val['content'] = iunserializer($val['content']);
        }
        unset($val);
        __success("操作成功",['list'=>$list]);
    }

    public function getList(){
        $page = max(1,$this->param("page/d"));
        $limit = max(10,$this->param("limit/d"));
        $where = ["uniacid"=>UNIACID];
        $list = Db::name("bbfx_form")->where($where)->order("id desc")->limit(($page-1)*$limit,$limit)->select();
        
        foreach ($list as $key => &$val){
            $val['image'] = cdnurl($val['image']);
            $val['content'] = iunserializer($val['content']);
        }
        unset($val);

        $total = Db::name("bbfx_form")->where($where)->count();
        
        __success("操作成功",['list'=>$list,'total'=>$total]);
    }
    
    public function detail(){
        $params = $this->param(['id/d']);
        
        $info = Db::name("bbfx_form")->where("id",$params['id'])->find();
        if(empty($info)){
            __error("数据不存在");
        }

        $info['image'] = cdnurl($info['image']);
        $info['content'] = iunserializer($info['content']);

        
        __success("操作成功",['info'=>$info]);
    }
    
    public function post(){
        $params = $this->param(['id/d','title/s','content/a','image/s','status/d','is_repeat/d']);
        
        if(empty($params['title'])){
            __error("请输入表单标题");
        }
        if(empty($params['content'])){
            __error("请配置表单内容");
        }
        
        $data = array(
            "uniacid"=>UNIACID,
            "title"=>$params['title'],
            "content"=>iserializer($params['content']),
            "image"=>replaceSiteroot($params['image']),
            "status"=>$params['status'],
            "is_repeat"=>$params['is_repeat'],
        );
        
        if(empty($params['id'])){
            $data['createtime'] = time();
            $res = Db::name("bbfx_form")->insertGetId($data);
            $data['id'] = $res;
        }
        else{
            $res = Db::name("bbfx_form")->where("id",$params['id'])->update($data);
            $data['id'] = $params['id'];
        }
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_form");
            __success("编辑成功");
        }
        else{
            __success("操作成功");
        }
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        
      	$res = Db::name("bbfx_form")->where('id','in',$ids)->delete();
      	if($res){
      	    \app\admin\model\AdminLog::record("","",['id'=>implode(",",$ids)],"bbfx_form");
        	__success("删除成功");
        }
    	else{
        	__error("删除失败");
        }
    }
}