<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\fenxiao;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Poster extends Base
{
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Fenxiao;
    }
    
    public function detail(){
        $params = $this->param();
        
        $id = intval($params['id']);
        
        $info = Db::name("bbfx_fenxiao_poster")->where(['id'=>$id])->find();
        if(empty($info)){
           $info = ['id'=>'','jump_type'=>0,'name'=>'','content'=>'','status'=>1,'sort'=>0];
        }
        
        $content = iunserializer($info['content']);
        if(empty($content['bg'])){
            $content['bg'] = "";
        }
        if(empty($content['width'])){
            $content['width'] = 320;
        }
        if(empty($content['height'])){
            $content['height'] = 500;
        }
        if(empty($content['list'])){
            $content['list'] = array(
                array("type"=>"avatar","show"=>1,"content"=>request()->domain()."/assets/images/avatar.jpg?".time(),"align"=>"center","width"=>60,"height"=>60,"left"=>130,"top"=>30,"style"=>"circle"),
                array("type"=>"nickname","show"=>1,"content"=>"这是昵称","align"=>"center","width"=>0,"height"=>0,"left"=>0,"top"=>90,"fontSize"=>12,"color"=>"#000000","style"=>""),
                array("type"=>"qrcode","show"=>1,"content"=>request()->domain()."/assets/images/qrcode.png?".time(),"align"=>"center","width"=>120,"height"=>120,"left"=>100,"top"=>180,"style"=>""),
                array("type"=>"sup_code","show"=>1,"content"=>"推荐码：1001","align"=>"center","width"=>0,"height"=>0,"left"=>0,"top"=>120,"fontSize"=>12,"color"=>"#000000","style"=>""),
                array("type"=>"mobile","show"=>1,"content"=>"手机号：138****8888","align"=>"center","width"=>0,"height"=>0,"left"=>0,"top"=>150,"fontSize"=>12,"color"=>"#000000","style"=>"","show_intact"=>0),
            );
        }
        else{
            $content['list'][0]['content'] = request()->domain()."/assets/images/avatar.jpg?".time();
            $content['list'][2]['content'] = request()->domain()."/assets/images/qrcode.png?".time();
            if($content['list'][0]['show'] === null){
                $content['list'][0]['show'] = 1;
            }
            if($content['list'][1]['show'] === null){
                $content['list'][1]['show'] = 1;
            }
            if($content['list'][2]['show'] === null){
                $content['list'][2]['show'] = 1;
            }
            if($content['list'][4]['show_intact'] === null){
                $content['list'][4]['show_intact'] = 1;
            }
        }
        
        if(empty($content['list'][3])){
            $content['list'][3] = array("type"=>"sup_code","show"=>0,"content"=>"推荐码：1001","align"=>"center","width"=>0,"height"=>0,"left"=>0,"top"=>120,"fontSize"=>12,"color"=>"#000000","style"=>"");
        }
        if(empty($content['list'][4])){
            $content['list'][4] = array("type"=>"mobile","show"=>0,"content"=>"手机号：138****8888","align"=>"center","width"=>0,"height"=>0,"left"=>0,"top"=>150,"fontSize"=>12,"color"=>"#000000","style"=>"","show_intact"=>0);
        }
        
        if(strstr($content['bg'], 'poster-bg.png') || empty($content['bg'])){
            $content['bg'] = request()->domain()."/assets/images/poster-bg.png";
        }
        
        $content['bg'] = cdnurl($content['bg']);
        
        $info['content'] = $content;
        
        __success('操作成功',['info'=>$info]); 
    }
    
    public function list(){
        $params = $this->param();
        
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):20;
        $list = Db::name("bbfx_fenxiao_poster")->where(['uniacid'=>UNIACID])->order('id desc')->limit(($pindex-1)*$psize,$psize)->select();
    	
    	foreach ($list as $key => &$val){
    	    $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
    	}
      	 
      	__success("操作成功",['list'=>$list]);
    }
    
    public function post(){
        $params = $this->param();
        
        $content = $params['content'];
      	if(empty($params['name'])){
        	__error("请填写海报名称");
        }
        
        if(!is_array($content)){
            __error("海报内容错误");
        }
        $content['bg'] = replaceSiteroot($content['bg']);
        
        $id = $params['id'];
      
    	$data = array(
    	    "uniacid"=>UNIACID,
          	"name"=>$params['name'],
          	"jump_type"=>intval($params['jump_type']),
          	"status"=>intval($params['status']),
          	"sort"=>intval($params['sort']),
          	"content"=>iserializer($content)
        );
        
        if($id > 0){
            $res = Db::name("bbfx_fenxiao_poster")->where(["id"=>$id])->update($data);
            $data['id'] = $id;
        }
        else{
            $data['createtime'] = time();
            $res = Db::name("bbfx_fenxiao_poster")->insertGetId($data);
            $id = $res;
        }
      	
      	if($res){
      	    
      	    $data['id'] = $id;
      	    \app\admin\model\AdminLog::record("","",$data,"bbfx_fenxiao_poster");
      	    
        	__success("编辑成功");
        }
      	else{
        	__success("操作成功");
        }
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        
      	$res = Db::name("bbfx_fenxiao_poster")->where('id','in',$ids)->delete();
      	if($res){
      	    
      	    \app\admin\model\AdminLog::record("","",['id'=>$ids],"bbfx_fenxiao_poster");
      	    
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}