<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\diypage;

use app\admin\controller\bbfxshop\Base;
use think\Db;
use app\common\model\bbfxshop\Weixin;
use app\common\model\QRcode;

class Template extends Base
{
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Diypage;
    }
    
    protected function getTemplateList($category_id){
        $version = Db::name("bbfx")->value("version");
        $result = ihttp_get("http://www.baibianfenxiao.com/api/diypage/getList?category_id=".$category_id."&version=".$version);
        $result = json_decode($result['content'],true);
        $list = [];
        if($result['code'] == 1){
            $list = $result['data']['list'];
        }
        
        return $list;
    }
    
    public function getCategoryList(){
        $result = ihttp_get("http://www.baibianfenxiao.com/api/diypage/getCategoryList");
        $result = json_decode($result['content'],true);
        $list = [];
        if($result['code'] == 1){
            $list = $result['data']['list'];
        }
        __success("操作成功",['list'=>$list]);
    }
    
    public function getList(){
        $params = $this->param();
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        $where = [];
        $category_id = $this->param("category_id/d");
        // $list = Db::name("bbfx_diypage_template")->where($where)->field("id,title,image,type,createtime")->limit(($pindex - 1) * $psize,$psize)->select();
        $list = $this->getTemplateList($category_id);
        
        foreach ($list as $key => &$val){
            // $val['image'] = cdnurl($val['image']);
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
            $val['data'] = iunserializer($val['data']);
        }
        unset($val);
        
        $total = Db::name("bbfx_diypage_template")->where($where)->count();
        $total = count($list);
        
        __success("操作成功",['list'=>$list,'total'=>$total]);
    }
    
    public function detail(){
        $id = $this->param("id/d");
        $item = Db::name("bbfx_diypage_template")->where(['id'=>$id])->find();
        if(empty($item)){
            __error("模板不存在");
        }
        $item['image'] = cdnurl($item['image']);
        __success("操作成功",$item);
    }
    
    public function createData(){
        $diy_id = $this->param("diy_id/d");
        
        $diypage = Db::name("bbfx_diypage")->where(['id'=>$diy_id])->find();
        if(empty($diypage)){
            __error("DIY页面不存在");
        }
        
        $result = $this->model->getDiyTemplate($diypage['id']);
        if($result['code'] != 1){
            __result($result);
        }
        
        $data = iserializer($result['data']);
        
        __success("操作成功",['data'=>$data]);
    }
    
    public function post(){
        $params = $this->param(['title/s','image/s','diy_id/d']);
        $id = $this->param("id/d");
        $item = Db::name("bbfx_diypage_template")->where(['id'=>$id])->find();
        
        if(empty($item)){
            $diypage = Db::name("bbfx_diypage")->where(['id'=>$params['diy_id']])->find();
            if(empty($diypage)){
                __error("DIY页面不存在");
            }
        }
        
        __error("操作失败");
        $data = [
            "title"=>$params['title'],
            "image"=>replaceSiteroot($params['image'])
        ];
        
        
        if(!empty($item)){
            Db::name("bbfx_diypage_template")->where(['id'=>$item['id']])->update($data);
        }
        else{
            
            $result = $this->model->getDiyTemplate($diypage['id']);
            if($result['code'] != 1){
                __result($result);
            }
            $data['data'] = iserializer($result['data']);
            $data['type'] = $diypage['type'];
            $data['createtime'] = time();
            Db::name("bbfx_diypage_template")->insert($data);
        }
        
        __success("操作成功");
    }
    
    
    protected function initDiypageData($data){
        
        $data['navbar']['bg'] = $this->saveImage($data['navbar']['bg']);
        $data['navbar']['backIcon'] = $this->saveImage($data['navbar']['backIcon']);
        
        foreach ($data['tabBar']['list'] as $key => &$val){
            $v['iconPath'] = $this->saveImage($v['iconPath']);
            $v['selectedIconPath'] = $this->saveImage($v['selectedIconPath']);
        }
        unset($val);
        
        $list = $data['list'];
        
        foreach ($list as $key => &$val){
            if($val['name'] == 'slides'){
                foreach ($val['data'] as $k => &$v){
                    $v['thumb'] = $this->saveImage($v['thumb']);
                    $v['poster'] = $this->saveImage($v['poster']);
                }
                unset($v);
            }
            else if($val['name'] == 'searchSwiper'){
                foreach ($val['data']['list'] as $k => &$v){
                    $v['thumb'] = $this->saveImage($v['thumb']);
                    $v['poster'] = $this->saveImage($v['poster']);
                }
                unset($v);
                $val['data']['headBg'] = $this->saveImage($val['data']['headBg']);
            }
            else if($val['name'] == 'btn'){
                foreach ($val['data'] as $k => &$v){
                    $v['thumb'] = $this->saveImage($v['thumb']);
                    $v['levels'] = [];
                }
                unset($v);
            }
            else if($val['name'] == 'btn2' || $val['name'] == 'btn3'){
                foreach ($val['data']['list'] as $k => &$v){
                    $v['thumb'] = $this->saveImage($v['thumb']);
                    $v['levels'] = [];
                }
                unset($v);
                if($val['name'] == 'btn2'){
                    $val['data']['titles']['rightThumb'] = $this->saveImage($val['data']['titles']['rightThumb']);
                }
            }
            else if($val['name'] == 'pictures'){
                foreach ($val['data'] as $k => &$v){
                    $v['thumb'] = $this->saveImage($v['thumb']);
                }
                unset($v);
            }
            else if($val['name'] == 'hotZone'){
                $val['data']['thumb'] = $this->saveImage($val['data']['thumb']);
            }
            else if($val['name'] == 'titles'){
                $val['data']['leftThumb'] = $this->saveImage($val['data']['leftThumb']);
                $val['data']['rightThumb'] = $this->saveImage($val['data']['rightThumb']);
            }
            else if($val['name'] == 'editor'){
                
            }
            else if($val['name'] == 'listNav'){
                foreach ($val['data'] as $k => &$v){
                    $v['thumb'] = $this->saveImage($v['thumb']);
                    $v['moreIcon'] = $this->saveImage($v['moreIcon']);
                }
                unset($v);
            }
            else if($val['name'] == 'picturesWin'){
                foreach ($val['data'] as $k => &$v){
                    $v['thumb'] = $this->saveImage($v['thumb']);
                }
                unset($v);
            }
            else if($val['name'] == 'goodsGroup'){
                
                $goods = $val['data']['goods'];
                
                foreach ($goods as $k => &$v){
                    $v['thumb'] = $this->saveImage($v['thumb']);
                    if($val['style']['type'] == 4 && !empty($v['single_column_thumb'])){
                        $v['thumb'] = $this->saveImage($v['single_column_thumb']);
                    }
                } 
                unset($v);
                $val['data']['goods'] = $goods;
            }
            else if($val['name'] == 'seckill'){
                
                $seckill_activity = $val['data']['seckill_activity'];
                
                if(!empty($seckill_activity)){
                    $seckill_activity['downtime'] = intval($seckill_activity['endtime'] - time());
                    $goods_ids = explode(",",$seckill_activity['seckill_goods_ids']);
                    
                    $goods = $val['data']['goods'];
                    
                    foreach ($goods as $k => &$v){
                        $v['thumb'] = $this->saveImage($v['thumb']);
                    }
                    unset($v); 
                    
                    $val['data']['seckill_activity'] = $seckill_activity;
                }
                else{
                    $goods = [];
                }
                
                $val['data']['goods'] = $goods;
            }
            else if($val['name'] == 'seckill2'){
                
                $seckill_activity = $val['data']['seckill_activity'];
                
                if(!empty($seckill_activity)){
                    $seckill_activity['downtime'] = intval($seckill_activity['endtime'] - time());
                    $goods_ids = explode(",",$seckill_activity['seckill_goods_ids']);
                    
                    $goods = $val['data']['goods'];
                    
                    foreach ($goods as $k => &$v){
                        $v['thumb'] = $this->saveImage($v['thumb']);
                    }
                    unset($v); 
                    
                    $val['data']['seckill_activity'] = $seckill_activity;
                }
                else{
                    $goods = [];
                }
                
                $val['data']['goods'] = $goods;
                $val['data']['thumb'] = $this->saveImage($val['data']['thumb']);
            }
            else if($val['name'] == 'userHead'){
                $val['data']['level_icon'] = $this->saveImage($val['data']['level_icon']);
                $val['style']['bgImg1'] = $this->saveImage($val['style']['bgImg1']);
                $val['style']['bgImg2'] = $this->saveImage($val['style']['bgImg2']);
                $val['style']['bgImg3'] = $this->saveImage($val['style']['bgImg3']);
                $val['style']['bgImg4'] = $this->saveImage($val['style']['bgImg4']);
                $val['style']['bgImg5'] = $this->saveImage($val['style']['bgImg5']);
                $val['style']['bgImg6'] = $this->saveImage($val['style']['bgImg6']);
                $val['style']['balance_icon'] = $this->saveImage($val['style']['balance_icon']);
                $val['style']['score_icon'] = $this->saveImage($val['style']['score_icon']);
            }
            else if($val['name'] == 'searchMenu'){
                foreach ($val['data']['list'] as $k => &$v){
                    $v['headBg'] = $this->saveImage($v['headBg']);
                }
                unset($v);
                $val['data']['headBg'] = $this->saveImage($val['data']['headBg']);
            }
            else if($val['name'] == 'productFilter'){
                $category_list = $val['data']['category_list'];
                foreach ($category_list as $k => &$v){
                    $v['thumb'] = cdnurl($v['thumb']);
                }
                unset($v);
                $val['data']['category_list'] = $category_list;
                
                $goods = $val['data']['goods'];
                foreach ($goods as $k => &$v){
                    $v['thumb'] = $this->saveImage($v['thumb']);
                }
                unset($v);
                $val['data']['goods'] = $goods;
            }
            else if($val['name'] == 'newProduct'){
                $goods = $val['data']['goods'];
                foreach ($goods as $k => &$v){
                    $v['thumb'] = $this->saveImage($v['thumb']);
                }
                unset($v);
                $val['data']['goods'] = $goods;
            }
        }
        unset($val);
        
        $data['list'] = $list;
        // echo "<pre>";
        // print_r($data);die;
        
        return $data;
    }
    
    protected function saveImage($url){
        if(empty($url) || !is_string($url)){
            return $url;
        }
        
        $file = file_get_contents($this->domain1.$url);
        if(!empty($file)){
            $arr = explode("/",$url);
            unset($arr[count($arr)-1]);
            $tpl_path = ROOT_PATH."public".implode("/",$arr);
            if (!is_dir($tpl_path)) {
                mkdir($tpl_path, 0755, true);
            }
            $localFilePath = ROOT_PATH."public".$url;
            file_put_contents($localFilePath, $file);
        }
        
        return $url;
    }
    protected $domain1 = "";
    public function import(){
        $id = $this->param("id/d");
        $result = ihttp_get("http://www.baibianfenxiao.com/api/diypage/detail?id=".$id);
        $result = json_decode($result['content'],true);
        $template = [];
        $domain = "";
        if($result['code'] == 1){
            $template = $result['data']['info'];
            $domain = $result['data']['domain'];
        }
        if(empty($template)){
            __error("模板不存在");
        }
        
        $template_data = iunserializer($template['data']);
        if(empty($template_data)){
            __error("模板数据错误");
        }
        $this->domain1 = $domain;
        $template_data = $this->initDiypageData($template_data);
        
        $data = [
            "uniacid"=>UNIACID,
            "title"=>$template['title'],
            "data"=>iserializer($template_data),
            "type"=>$template['type'],
            "createtime"=>time()
        ];
        
        Db::name("bbfx_diypage")->insert($data);
        
        __success("操作成功");
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
      	$res = Db::name("bbfx_diypage_template")->where('id','in',$ids)->delete();
      	if($res){
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}