<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\deposit_release;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Config extends Base
{

    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\DepositRelease;
    }
    
    public function set(){
        $params = $this->param();
        
        $config = Db::name("bbfx_deposit_release")->where(["uniacid"=>UNIACID])->find();
        
        $release_currency = $params['release_currency'];
        
        $data = array(
            "uniacid"=>UNIACID,
            "status"=>$params['status'],
            "release_balance"=>intval($params['release_balance']),
            "release_score"=>intval($params['release_score']),
            "release_currency"=>iserializer($params['release_currency']),
            "deposit_paytype"=>iserializer($params['deposit_paytype']),
            "release_limit"=>intval($params['release_limit']),
            "release_time_type"=>intval($params['release_time_type']),
            "withdrawal"=>iserializer($params['withdrawal']),
        );
        
        if($data['status'] == 1){
            if(empty($release_currency)){
                __error("请选择释放币种");
            }
            
            if($data['release_limit'] < 0){
                __error("释放额度必须大于0");
            }
            
            if($config['status'] == 0){
                $data['release_month'] = date("Y-m");
            }
        }
        
    	if(!empty($config)){
          	$res = Db::name("bbfx_deposit_release")->where(["id"=>$config['id']])->update($data);;
        }
      	else{
        	$res = Db::name("bbfx_deposit_release")->insert($data);
        }
        
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_deposit_release");
            __success("编辑成功",$data);
        }
      	else{
      	    __success("操作成功",$data);
      	}
    }
}