<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\cloud_warehouse;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class User extends Base
{
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\CloudWarehouse;
    }
    
    public function setStock(){
        $stock = $this->param("stock/d");
        $type = $this->param("type/d");
        $user_id = $this->param("user_id/d");
        $notes = $this->param("notes/s");
        
        $config = $this->model->getSet();
        $cw_goods = explode(",",(string)$config['cw_goods']);
        $goods_id = intval($cw_goods[0]);
        if($goods_id <= 0){
            __error("未设置云仓商品");
        }
        if($stock == 0){
            __error("请输入需要修改的库存");
        }
        
        if($type == 1){
            $title = "后台增加";
        }
        else{
            $stock = abs($stock);
            $stock = 0 - $stock;
            $title = "后台扣除";
        }
        
        $res = $this->model->setStock($user_id,$goods_id,$stock,1,0,$title,['notes'=>$notes]);
        if($res){
            
            $title = "云仓库存扣除";
            $content = "用户ID：{$user_id}，扣除库存：{$stock}";
            if($type == 1){
                $title = "云仓库存增加";
                $content = "用户ID：{$user_id}，增加库存：{$stock}";
            }
            
            \app\admin\model\AdminLog::record($title,$content,['notes'=>$notes]);
            
            __success("操作成功");
        }
        else{
            __success("变动失败");
            
        }
    }
    
    public function getStockRecord(){
        $params = $this->param(['page/d','limit/d','keyword/s','startTime/s','endTime/s','type/d']);
        $pindex = max(1, intval($params["page"]));
        $psize = intval($params["limit"])?intval($params["limit"]):10;
        
        
        $where = ["a.uniacid"=>UNIACID];
        
        $keyword = trim($params['keyword']);
        $startTime = trim($params['startTime']);
        $endTime = trim($params['endTime']);
        $type = max(1,intval($params['type']));
        
        if($keyword){
            if($type == 1){
                $where['b.nickname'] = ['like',"%".$keyword."%"];
            }
            else if($type == 2){
                $where['b.realname'] = ['like',"%".$keyword."%"];
            }
            else if($type == 3){
                $where['b.mobile'] = ['like',$keyword];
            }
            else if($type == 4){
                $where['b.id'] = intval($keyword);
            }
        }
        
        $whereTime = [];
        if($startTime){
            $startTime = strtotime($startTime." 00:00:00");
            $where['a.createtime'] = ['>=',$startTime];
        }
        
        if($endTime){
            $endTime = strtotime($endTime." 23:59:59");
            $whereTime['a.createtime'] = ['<=',$endTime];
        }
        
        $list = Db::name("bbfx_cloud_warehouse_stock_record")->alias("a")->join("bbfx_user b","a.user_id=b.id","LEFT")->where($where)->where($whereTime)->field("a.*,b.nickname,b.avatar")->order("a.createtime desc")->select();
        $total = Db::name("bbfx_cloud_warehouse_stock_record")->alias("a")->join("bbfx_user b","a.user_id=b.id","LEFT")->where($where)->where($whereTime)->count();
        
        foreach($list as $key=>&$val){
            $val['avatar'] = cdnurl($val['avatar']);
    	    $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
        }
        
        __success("操作成功",['total'=>$total,'list'=>$list]);
    }
}