<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\cloud_warehouse;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Config extends Base
{
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\CloudWarehouse;
    }
    
    public function set(){
        $params = $this->param();
        $config = Db::name("bbfx_cloud_warehouse")->where(["uniacid"=>UNIACID])->find();
        
        $data = array(
            "uniacid"=>UNIACID,
      	    "status"=>intval($params['status']),
      	    "cw_goods"=>trim($params['cw_goods']),
      	    "fanhuan_rate"=>intval($params['fanhuan_rate']),
      	    "fanhuan_currency"=>intval($params['fanhuan_currency']),
      	    "delayed_daozhang"=>intval($params['delayed_daozhang']),
      	    "level"=>intval($params['level']),
      	    "chuhuo_deduct_pingji"=>intval($params['chuhuo_deduct_pingji']),
        );

        if($data['status'] == 1){
            $cw_goods = Db::name("bbfx_goods")->where(['uniacid'=>UNIACID,'id'=>['in',$data['cw_goods']],'mid'=>['>',0]])->find();
            if(!empty($cw_goods)){
                __error("不能选择商家商品");
            }
        }
        
    	if(!empty($config)){
          	$res = Db::name("bbfx_cloud_warehouse")->where(["id"=>$config['id']])->update($data);
        }
      	else{
      	    $data['return_date'] = date("Y-m-d");
        	$res = Db::name("bbfx_cloud_warehouse")->insert($data);
        }
        
        \app\admin\model\AdminLog::record("","",$data,"bbfx_cloud_warehouse");
        
        __success("编辑成功",$data);
    }
}