<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\chat;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Config extends Base
{

    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Chat;
    }
    
    public function set(){
        $params = $this->param();
        
        $config = Db::name("bbfx_chat")->where(["uniacid"=>UNIACID])->find();
        
        $data = array(
            "uniacid"=>UNIACID,
            "status"=>$params['status'],
            "port"=>$params['port'],
            "ssl_cert"=>replaceSiteroot($params['ssl_cert']),
            "ssl_certkey"=>replaceSiteroot($params['ssl_certkey']),
            "kefu_uid"=>$params['kefu_uid'],
            "tip"=>$params['tip'],
        );

        if($data['status'] == 1){
            if (!function_exists('pcntl_alarm')) { 
                __error('pcntl_alarm函数已被禁用，请先解除禁用。');
            }
            if (!function_exists('pcntl_fork')) { 
                __error('pcntl_fork函数已被禁用，请先解除禁用。');
            }
            if (!function_exists('pcntl_wait')) { 
                __error('pcntl_wait函数已被禁用，请先解除禁用。');
            }
            if (!function_exists('pcntl_signal')) { 
                __error('pcntl_signal函数已被禁用，请先解除禁用。');
            }
            if (!function_exists('pcntl_signal_dispatch')) { 
                __error('pcntl_signal_dispatch函数已被禁用，请先解除禁用。');
            }
            if(empty($data['port'])){
                __error('请填写端口');
            }
            if(!empty($data['ssl_cert']) && (!strstr($data['ssl_cert'], '.pem') && !strstr($data['ssl_cert'], '.crt'))){
                __error('请上传pem或crt文件类型证书文件');
            }
            if(!empty($data['ssl_certkey']) && !strstr($data['ssl_certkey'], '.key')){
                __error('请上传key文件类型证书私钥文件');
            }

            $this->initDatabase();
        }
        
    	if(!empty($config)){
          	$res = Db::name("bbfx_chat")->where(["id"=>$config['id']])->update($data);;
        }
      	else{
        	$res = Db::name("bbfx_chat")->insert($data);
        }
        
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_chat");
            __success("编辑成功",$data);
        }
      	else{
      	    __success("操作成功",$data);
      	}
    }

    protected function initDatabase(){
        $database = file_get_contents(ROOT_PATH."application/database.php");
        if(!strstr($database, 'break_reconnect')){
            $break_reconnect = "'sql_explain'     => false,
    'break_reconnect'     => true,
            ";
            $database = str_replace("'sql_explain'     => false,",$break_reconnect,$database);
            file_put_contents(ROOT_PATH."application/database.php",$database);
        }
    }
    

    public function getServer(){
        
        $config = Db::name("bbfx_chat")->where(["uniacid"=>UNIACID])->find();
        if($config['status'] != 1){
            __error("请先开启聊天功能");
        }

        if (!function_exists('pcntl_alarm')) { 
            __error('pcntl_alarm函数已被禁用，请先解除禁用。');
        }
        if (!function_exists('pcntl_fork')) { 
            __error('pcntl_fork函数已被禁用，请先解除禁用。');
        }
        if (!function_exists('pcntl_wait')) { 
            __error('pcntl_wait函数已被禁用，请先解除禁用。');
        }
        if (!function_exists('pcntl_signal')) { 
            __error('pcntl_signal函数已被禁用，请先解除禁用。');
        }
        if (!function_exists('pcntl_signal_dispatch')) { 
            __error('pcntl_signal_dispatch函数已被禁用，请先解除禁用。');
        }
        if (!function_exists('exec')) { 
            __error('exec函数已被禁用，请先解除禁用。');
        }
        $port = intval($config['port']);
        if(empty($port)){
            __error('请填写端口');
        }

        $output = [];
        $result_code = -1;
        exec('netstat -tuln | grep '.$port, $output, $result_code);
        
        if($result_code !== 0){
            __error('执行检查端口是否被占用失败。');
        }

        foreach($output as $k => $val){
            if(strstr($val, ':'.$port)){
                __error('检查到端口已被占用，请更换端口或解除占用，若已启动服务请勿重复操作。');
            }
        }

        
        chdir(ROOT_PATH);
        $output = [];
        $result_code = -1;
        exec('php -v', $output, $result_code);
        if($result_code !== 0){
            __error('执行检查PHP版本失败。');
        }
        
        $command = "php server.php start";
        if(!strstr($output[0], 'PHP 7.2')){
            $command = "sudo /www/server/php/72/bin/php server.php start";
        }
        // print_r($command);die;
        $output = [];
        $result_code = -1;
        chdir(ROOT_PATH);
        exec($command, $output, $result_code);
        // print_r($command);die;
        if($result_code !== 0){
            __error('执行开启服务命令失败。');
        }

        $success = false;
        foreach($output as $k => $val){
            if(strstr($val, 'Start success')){
                $success = true;
            }
        }

        if(!$success){
           __error('开启服务失败。'); 
        }
        
        __success("操作成功");
    }

    public function stopServer(){
        
        $config = Db::name("bbfx_chat")->where(["uniacid"=>UNIACID])->find();
        if($config['status'] != 1){
            __error("请先开启聊天功能");
        }

        if (!function_exists('pcntl_alarm')) { 
            __error('pcntl_alarm函数已被禁用，请先解除禁用。');
        }
        if (!function_exists('pcntl_fork')) { 
            __error('pcntl_fork函数已被禁用，请先解除禁用。');
        }
        if (!function_exists('pcntl_wait')) { 
            __error('pcntl_wait函数已被禁用，请先解除禁用。');
        }
        if (!function_exists('pcntl_signal')) { 
            __error('pcntl_signal函数已被禁用，请先解除禁用。');
        }
        if (!function_exists('pcntl_signal_dispatch')) { 
            __error('pcntl_signal_dispatch函数已被禁用，请先解除禁用。');
        }
        if (!function_exists('exec')) { 
            __error('exec函数已被禁用，请先解除禁用。');
        }
        if(empty($config['port'])){
            __error('请填写端口');
        }

        $output = [];
        $result_code = -1;
        exec('netstat -tuln | grep 2000', $output, $result_code);
        if($result_code !== 0){
            __error('检查端口是否被占用失败。');
        }

        $success = false;
        foreach($output as $k => $val){
            if(strstr($val, ':'.$config['port'])){
                $success = true;
            }
        }

        if($success){
            $output = [];
            $result_code = -1;
            exec('php -v', $output, $result_code);
            if($result_code !== 0){
                __error('检查PHP版本失败。');
            }
            $path = ROOT_PATH;
            $command = "php {$path}server.php stop";
            if(!strstr($output[0], 'PHP 7.2')){
                $command = "sudo /www/server/php/72/bin/php {$path}server.php stop";
            }

            $output = [];
            $result_code = -1;
            exec($command, $output, $result_code);
            if($result_code !== 0){
                __error('执行关闭服务命令失败。');
            }

            $success = false;
            foreach($output as $k => $val){
                if(strstr($val, 'stop success')){
                    $success = true;
                }
            }

            if(!$success){
                __error('关闭服务失败。'); 
            }
        }
        __success("操作成功");
    }
}