<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\card;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Card extends Base
{
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Card;
    }
    
    public function getList(){
        $params = $this->param();
        
        $where = array("uniacid"=>UNIACID);
        
        $list = Db::name("bbfx_member_card")->where($where)->order('sort asc,id asc')->select();
        
        
        __success("操作成功",['list'=>$list]);
    }
    
    public function status(){
        $params = $this->param();
        
        $res = Db::name("bbfx_member_card")->where("id",$params['id'])->update(['status'=>$params['status']]);
        if($res){
            
            \app\admin\model\AdminLog::record("","",["id"=>$params['id'],'status'=>$params['status']],"bbfx_member_card");
            
            __success("操作成功");
        }
        else{
            __error("操作失败");
        }
    }
    
    public function detail(){
        $params = $this->param();
        
        $info = Db::name("bbfx_member_card")->where("id",$params['id'])->find();
        $levels = \app\common\model\bbfxshop\Fenxiao::getLevels();
        $result = ['levels'=>$levels];
        if(!empty($info)){
            $info['commission1'] = iunserializer($info['commission1']);
            if(empty($info['commission1'])){
                $info['commission1'] = [];
            }
            $info['commission2'] = iunserializer($info['commission2']);
            if(empty($info['commission2'])){
                $info['commission2'] = [];
            }
            $info['commission3'] = iunserializer($info['commission3']);
            if(empty($info['commission3'])){
                $info['commission3'] = [];
            }
            
            $info['give'] = iunserializer($info['give']);
            $info['give_coupon'] = iunserializer($info['give_coupon']);
            
            $commission1 = $info['commission1'];
            $commission2 = $info['commission2'];
            $commission3 = $info['commission3'];
        }
        else{
            $commission1 = [];
            $commission2 = [];
            $commission3 = [];
        }
        
        
        $grade1 = [];
        $grade2 = [];
        $grade3 = [];
        
        foreach ($levels as $key => $val){
            $grade1['level'.$val['id']] = (int)$commission1['grade']['level'.$val['id']];
            $grade2['level'.$val['id']] = (int)$commission2['grade']['level'.$val['id']];
            $grade3['level'.$val['id']] = (int)$commission3['grade']['level'.$val['id']];
        }
        if(empty($commission1)){
            $commission1 = ['level'=>['money1'=>'','money2'=>''],'grade'=>$grade1];
        }
        else{
            $commission1['grade'] = $grade1;
        }
        if(empty($commission2)){
            $commission2 = ['level'=>['money1'=>'','money2'=>''],'grade'=>$grade2];
        }
        else{
            $commission2['grade'] = $grade2;
        }
        if(empty($commission3)){
            $commission3 = ['level'=>['money1'=>'','money2'=>''],'grade'=>$grade3];
        }
        else{
            $commission3['grade'] = $grade3;
        }
        
        if(!empty($info)){
            $info['commission1'] = $commission1;
            $info['commission2'] = $commission2;
            $info['commission3'] = $commission3;
            
            $result['info'] = $info;
        }
        
        $result['commission1'] = $commission1;
        $result['commission2'] = $commission2;
        $result['commission3'] = $commission3;
        
        __success("操作成功",$result);
    }
    
    public function post(){
        $params = $this->param();
        $data = array(
            "uniacid"=>UNIACID,
            "name"=>$params['name'],
            "give"=>iserializer($params['give']),
            "give_score"=>intval($params['give_score']),
            "give_coupon"=>iserializer($params['give_coupon']),
            "price"=>floatval($params['price']),
            "yx_day"=>intval($params['yx_day']),
            "style"=>$params['style'],
            "status"=>intval($params['status']),
            "discount"=>round($params['discount'],1),
            "sort"=>intval($params['sort']),
            "content"=>htmlspecialchars_decode($this->param('content/h')),
            "is_fenxiao"=>intval($params['is_fenxiao']),
            "commission_rule"=>intval($params['commission_rule']),
            "commission1"=>iserializer($params['commission1']),
            "commission2"=>iserializer($params['commission2']),
            "commission3"=>iserializer($params['commission3']),
            "createtime"=>time()
        );
        
        if($data['discount'] <= 0 || $data['discount'] > 10){
            $data['discount'] = 10;
        }
        
        if($params['id']){
            $res = Db::name("bbfx_member_card")->where("id",$params['id'])->update($data);
            $data['id'] = $params['id'];
        }
        else{
            $data['createtime'] = time();
            $res = Db::name("bbfx_member_card")->insertGetId($data);
            $data['id'] = $res;
        }
        
        if($res){
            
            \app\admin\model\AdminLog::record("","",$data,"bbfx_member_card");
            
            __success("编辑成功");
        }
        else{
            __success("操作成功");
        }
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
      	$res = Db::name("bbfx_member_card")->where('id','in',$ids)->delete();
      	if($res){
      	    
      	    \app\admin\model\AdminLog::record("","",['id'=>implode(",",$ids)],"bbfx_member_card");
      	    
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }
}