<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\activity;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Activity extends Base
{

    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Activity;
    }

    public function getList(){
        $page = max(1,$this->param("page/d"));
        $limit = max(10,$this->param("limit/d"));

        $keyword = $this->param("keyword/s");
        $startTime = $this->param("startTime/s");
        $endTime = $this->param("endTime/s");

        $where = ['uniacid'=>UNIACID];
        if(!empty($keyword)){
            $where['title'] = ['like','%'.$keyword.'%'];
        }
        $whereTime = [];
        if($startTime){
            $startTime = strtotime($startTime." 00:00:00");
            $where['a.createtime'] = ['>=',$startTime];
        }
        
        if($endTime){
            $endTime = strtotime($endTime." 23:59:59");
            $whereTime['a.createtime'] = ['<=',$endTime];
        }

        $list = Db::name("bbfx_activity_list")->where($where)->where($whereTime)->field("id,pid,title,starttime,endtime,baoming_fee,bm_stime,bm_etime,status,sh_status,browse,baoming_total,updatetime")->order("updatetime desc")->limit(($page-1)*$limit,$limit)->select();
        
        foreach ($list as $key => &$val){
            $val['starttime'] = date("Y.m.d H:i",$val['starttime']);
            $val['endtime'] = date("Y.m.d H:i",$val['endtime']);
            $val['bm_stime'] = date("Y.m.d H:i",$val['bm_stime']);
            $val['bm_etime'] = date("Y.m.d H:i",$val['bm_etime']);
            $baoming_num = Db::name("bbfx_activity_baoming")->where(['uniacid'=>UNIACID,'activity_id'=>$val['id'],'is_pay'=>1])->count();
            $val['baoming_num'] = $baoming_num;
            if($val['pid']  > 0){
                $user = Db::name("bbfx_user")->where(['id'=>$val['pid']])->field("id,avatar,nickname")->find();
                if(!empty($user)){
                    $user['avatar'] = cdnurl($user['avatar']);
                    $val['user'] = $user;
                }
            }
        }
        unset($val);

        $total = Db::name("bbfx_activity_list")->where($where)->count();
        
        __success("操作成功",['list'=>$list,'total'=>$total]);
    }

    public function shenhe(){
        $id = $this->param("id/d");
        $status = $this->param("status/d");
        $info = Db::name("bbfx_activity_list")->where(["id"=>$id])->find();
        if(empty($info)){
            __error("商品不存在");
        }
        
        if($status != 1) $status = 2;
        
        $res = Db::name("bbfx_activity_list")->where(["id"=>$info['id']])->update(['sh_status'=>$status]);
        if($res){
            Db::name("bbfx_activity_list")->where(["id"=>$info['id']])->update(['sh_time'=>time()]);
            \app\admin\model\AdminLog::record("","",['id'=>$info['id'],'sh_status'=>$status,'sh_time'=>time()],"bbfx_activity_list");
            __success("操作成功");
        }
        else{
            __error("审核失败");
        }
    }
    
    public function detail(){
        $id = $this->param("id/d");
        $info = Db::name("bbfx_activity_list")->where(['id'=>$id])->find();
        if(empty($info)){
            __error("活动不存在");
        }
        
        $info['slide_images'] = cdnurls(iunserializer($info['slide_images']));
        $info['slide_videos'] = cdnurls(iunserializer($info['slide_videos']));
        $info['detail_images'] = cdnurls(iunserializer($info['detail_images']));
        $info['advert_image'] = cdnurl($info['advert_image']);
        $info['music'] = cdnurl($info['music']);
        $info['poster_image'] = cdnurl($info['poster_image']);
        $info['starttime'] = date("Y-m-d H:i:s",$info['starttime']);
        $info['endtime'] = date("Y-m-d H:i:s",$info['endtime']);
        $info['bm_stime'] = date("Y-m-d H:i:s",$info['bm_stime']);
        $info['bm_etime'] = date("Y-m-d H:i:s",$info['bm_etime']);
        
        __success("操作成功",['info'=>$info]);
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        
        $list = Db::name("bbfx_activity_list")->where('id','in',$ids)->select();
        if(empty($list)){
            __error("删除的数据不存在");
        }
        $titles = array_column($list, 'title');
        
      	$res = Db::name("bbfx_activity_list")->where('id','in',$ids)->delete();
      	if($res){
      	    
      	    \app\admin\model\AdminLog::record("删除活动","活动：".implode(",",$titles)."，活动ID：".implode(",",$ids),$list);
      	    
        	__success("删除成功");
        }
    	else{
        	__error("操作失败");
        }
    }

    public function post(){
        $id = $this->param("id/d");

        $set = $this->model->getSet();
        if($set['status'] != 1){
            __error("未开启活动");
        }
        
        $params = $this->param(['pid/d','title/s','type/d','is_public/d','is_hexiao/d','baoming_user_scroll/d','slide_images/a','slide_videos/a','goods_ids/a','starttime/s','endtime/s','bm_stime/s','bm_etime/s','baoming_total/d','detail_images/a','mobile/s','music/s','status/d','advert_image/s','virtual_baoming/d','baoming_fee/f','address/s','lat/f','lng/f','poster_image/s','detail_address/s']);
        
        $data = array(
            "uniacid"=>UNIACID,
            "pid"=>$params['pid'],
            "slide_images"=>iserializer(replaceSiteroots($params['slide_images'])),
            "slide_videos"=>iserializer(replaceSiteroots($params['slide_videos'])),
            "detail_images"=>iserializer(replaceSiteroots($params['detail_images'])),
            "title"=>$params['title'],
            "starttime"=>strtotime($params['starttime']),
            "endtime"=>strtotime($params['endtime']),
            "bm_stime"=>strtotime($params['bm_stime']),
            "bm_etime"=>strtotime($params['bm_etime']),
            "baoming_total"=>$params['baoming_total'],
            "mobile"=>$params['mobile'],
            "music"=>replaceSiteroot($params['music']),
            "advert_image"=>replaceSiteroot($params['advert_image']),
            "poster_image"=>replaceSiteroot($params['poster_image']),
            "status"=>$params['status'],
            "type"=>$params['type'],
            "is_public"=>$params['is_public'],
            "is_hexiao"=>$params['is_hexiao'],
            "baoming_user_scroll"=>$params['baoming_user_scroll'],
            "virtual_baoming"=>$params['virtual_baoming'],
            "baoming_fee"=>$params['baoming_fee'],
            "address"=>$params['address'],
            "detail_address"=>$params['detail_address'],
            "lat"=>$params['lat'],
            "lng"=>$params['lng'],
            "updatetime"=>time()
        );
        
        if(empty($data['title'])){
            __error("请填写活动标题");
        }
        if(empty($data['slide_images']) && empty($data['slide_videos'])){
            __error("请上传轮播图或视频");
        }
        if(empty($data['detail_images'])){
            __error("请上传详情图片");
        }
        if(empty($params['starttime'])){
            __error("请选择开始时间");
        }
        if(empty($params['endtime'])){
            __error("请选择结束时间");
        }
        if($params['baoming_total'] <= 0){
            __error("请填写报名人数");
        }
        if(empty($params['music'])){
            __error("请上传活动背景音乐");
        }
        if(empty($params['address'])){
            __error("请选择活动地址");
        }
        if(empty($params['lat']) || empty($params['lng'])){
            __error("请选择定位活动地址");
        }
        
        if($data['starttime'] > $data['endtime']){
            __error("活动结束时间必须大于活动开始时间");
        }
        if($data['bm_stime'] > $data['bm_etime']){
            __error("报名结束时间必须大于报名开始时间");
        }
        if($data['bm_stime'] > $data['starttime']){
            __error("报名开始时间必须小于活动开始时间");
        }
        if($data['bm_etime'] > $data['endtime']){
            __error("报名结束时间必须小于活动结束时间");
        }
        
        $info = Db::name("bbfx_activity_list")->where(['id'=>$id])->find();
        if(empty($info)){
            $data['createtime'] = time();
            if($data['endtime'] < time()){
                __error("结束时间必须大于当前时间");
            }
            $data['sh_status'] = 1;
            $data['sh_time'] = time();
            $res = Db::name("bbfx_activity_list")->insertGetId($data);
            $data['id'] = $res;
        }
        else{
            $res = Db::name("bbfx_activity_list")->where(['id'=>$info['id']])->update($data);
            $data['id'] = $info['id'];
        }
        
        if($res){

            \app\admin\model\AdminLog::record("","",$data,"bbfx_activity_list");

            __success("操作成功");
        }
        else{
            __success("操作成功");
        }
    } 
}