<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop\abonus;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Config extends Base
{
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Abonus;
    }
    
    public function set(){
        $params = $this->param();
        
        $config = Db::name("bbfx_fenxiao")->where(["uniacid"=>UNIACID])->find();

        $status = intval($params['status']);
        $transfer_num = intval($params['transfer_num']);
        
        $data = array(
            "uniacid"=>UNIACID,
            "is_abonus"=>intval($params['is_abonus']),
      	    "abonus_rule"=>intval($params['abonus_rule']),
      	    "is_abonus_gld"=>intval($params['is_abonus_gld']),
      	    "is_abonus_out_amount"=>intval($params['is_abonus_out_amount']),
      	    "settlement_abonus_stype"=>intval($params['settlement_abonus_stype']),
      	    "abonus"=>iserializer($params['abonus'])
        );
        
        $rule_list = $params['rule_list'];
        if($data['abonus_rule'] == 2){
            foreach ($rule_list as $key => $val){
                $single_purchase_money = intval($val['single_purchase_money']);
                $return_rate = intval($val['return_rate']);
                $abonus_rate = intval($val['abonus_rate']);
                if($single_purchase_money <= 0){
                    __error("请填写单笔消费金额");
                }
                if($return_rate <= 0){
                    __error("请填写分红总额");
                }
                if($abonus_rate <= 0){
                    __error("请填写每日分红");
                }
            }
        }
        
    	if(!empty($config)){
            $res = Db::name("bbfx_fenxiao")->where(["id"=>$config['id']])->update($data);
        }
      	else{
            $res = Db::name("bbfx_fenxiao")->insert($data);
        }
        
        if($data['abonus_rule'] == 2){
            $rule_all = Db::name("bbfx_fenxiao_abonus_rule")->where(['uniacid'=>UNIACID])->select();
            $rule_ok = [];
            foreach ($rule_list as $key => $val){
                $rule_id = intval($val['id']);
                $single_purchase_money = intval($val['single_purchase_money']);
                $return_rate = intval($val['return_rate']);
                $abonus_rate = intval($val['abonus_rate']);
                
                $rule_data = ['uniacid'=>UNIACID,'single_purchase_money'=>$single_purchase_money,'return_rate'=>$return_rate,'name'=>$val['name'],'abonus_rate'=>$abonus_rate];
                
                if($rule_id > 0){
                    $rule_ok[$rule_id] = true;
                    Db::name("bbfx_fenxiao_abonus_rule")->where(['id'=>$rule_id])->update($rule_data);
                }
                else{
                    Db::name("bbfx_fenxiao_abonus_rule")->insert($rule_data);
                }
            }
            
            foreach ($rule_all as $key => $val){
                if(empty($rule_ok[$val['id']])){
                    Db::name("bbfx_fenxiao_abonus_rule")->where(['id'=>$val['id']])->delete();
                }
            }
            $res = true;
        }
        
        if($res){
            
            \app\admin\model\AdminLog::record("","",$data,"bbfx_fenxiao");
            
            __success("编辑成功",$data);
        }
      	else{
      	    __success("操作成功",$data);
      	}
    }
}