<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop;

use app\admin\controller\bbfxshop\Base;
use think\Db;


class Slide extends Base
{
    
    public $model = null;
    public function _initialize(){
        parent::_initialize();
        $this->model = new \app\common\model\bbfxshop\Printer;
    }

    public function getList(){
        $page = max(1,$this->param("page/d"));
        $limit = max(10,$this->param("limit/d"));
        $where = ["uniacid"=>UNIACID];
        $list = Db::name("bbfx_slide")->where($where)->order("sort desc,id desc")->limit(($page-1)*$limit,$limit)->select();
        
        foreach ($list as $key => &$val){
            $val['image'] = cdnurl($val['image']);
            $val['link'] = iunserializer($val['link']);
        }
        unset($val);

        $total = Db::name("bbfx_slide")->where($where)->count();
        
        __success("操作成功",['list'=>$list,'total'=>$total]);
    }
    
    public function detail(){
        $params = $this->param(['id/d']);
        
        $info = Db::name("bbfx_slide")->where("id",$params['id'])->find();
        if(empty($info)){
            __error("数据不存在");
        }

        $info['image'] = cdnurl($info['image']);
        $info['link'] = iunserializer($info['link']);

        
        __success("操作成功",['info'=>$info]);
    }
    
    public function post(){
        $params = $this->param(['id/d','title/s','type/d','image/s','sort/d','link/a']);
        
        if(empty($params['title'])){
            __error("请输入标题");
        }
        if(empty($params['image'])){
            __error("请上传图片");
        }
        
        $data = array(
            "uniacid"=>UNIACID,
            "title"=>$params['title'],
            "type"=>$params['type'],
            "image"=>replaceSiteroot($params['image']),
            "sort"=>$params['sort'],
            "link"=>iserializer($params['link'])
        );
        
        if(empty($params['id'])){
            $res = Db::name("bbfx_slide")->insertGetId($data);
            $data['id'] = $res;
        }
        else{
            $res = Db::name("bbfx_slide")->where("id",$params['id'])->update($data);
            $data['id'] = $params['id'];
        }
        
        if($res){
            \app\admin\model\AdminLog::record("","",$data,"bbfx_slide");
            __success("编辑成功");
        }
        else{
            __success("操作成功");
        }
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        
      	$res = Db::name("bbfx_slide")->where('id','in',$ids)->delete();
      	if($res){
      	    \app\admin\model\AdminLog::record("","",['id'=>implode(",",$ids)],"bbfx_slide");
        	__success("删除成功");
        }
    	else{
        	__error("删除失败");
        }
    }
}