<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop;

use app\common\controller\Backend;
use think\Db;
use think\Cache;
use app\common\model\Upgrade;
use app\common\model\Config as ConfigModel;

class Site extends Backend
{
    public function getInfo(){
        $type = $this->param("type/d");
        $result = [];
        if($type == 1){
            // 激活授权
            $res = Upgrade::getVersion();
            if(!empty($res)){
                $expirestime = $res['expirestime'];
            }
            else{
                $expirestime = "";
            }
            // echo "<pre>";
            // print_r($res);die;
            $version_name = Db::name("bbfx")->value("version_name");

            $site = [
                'status'=>'未授权',
                'domain_name'=>$_SERVER['HTTP_HOST'],
                'version_name'=>$version_name,
                'expirestime'=>$expirestime,
            ];

            if(!empty($res)){
                $site['status'] = $res['site']['status_text'];
                $site['domain_name'] = $res['site']['domain_name'];
            }
            
            $result['new_version_name'] = $res['version_name'];
            $result['is_upgrade'] = $res['is_upgrade'];
            $result['site'] = $site;

            $buy_qrcode = "";
            $res = ihttp_get("https://www.baibianfenxiao.com/api/buy/qrcode");
            $res = toJsonde($res['content']);
            if($res['code'] == 1){
                $buy_qrcode = $res['data'];
            } 

            $result['buy_qrcode'] = $buy_qrcode;

        }
        else if($type == 2){
            // 后台登录页
            $list = Db::name("config")->where(['name'=>['in',['logo','login_bg','beian']]])->field("name,value")->select();
            $result = ['username'=>$this->auth->username];
            foreach($list as $key => $val){
                if($val['name'] == 'login_bg' || $val['name'] == 'logo'){
                    $val['value'] = cdnurl($val['value']);
                }
                $result[$val['name']] = $val['value'];
            }
        }
        else if($type == 3){
            // 微信公众号
            $result = Db::name("platform")->where(['id'=>UNIACID])->field("AppId,AppSecret")->find();
            if(empty($result)){
                __error("站点信息错误");
            }
        }
        else if($type == 10){
            // 微信公众号支付
            $result = Db::name("platform")->where(['id'=>UNIACID])->field("mch_id,paykey,cert,certkey,publickeyId")->find();
            if(empty($result)){
                __error("站点信息错误");
            }
        }
        else if($type == 4){
            // 微信小程序
            $result = Db::name("platform")->where(['id'=>UNIACID])->field("wxapp_AppId,wxapp_AppSecret,wxapp_upload_privateKey")->find();
            if(empty($result)){
                __error("站点信息错误");
            }
        }
        else if($type == 11){
            // 微信小程序支付
            $result = Db::name("platform")->where(['id'=>UNIACID])->field("wxapp_mch_id,wxapp_paykey,wxapp_cert,wxapp_certkey,wxapp_publickeyId")->find();
            if(empty($result)){
                __error("站点信息错误");
            }
        }
        else if($type == 5){
            // 微信服务商支付
            $result = Db::name("platform")->where(['id'=>UNIACID])->field("service_provider_status,service_provider_appid,service_provider_mchid,mch_id,wxapp_mch_id,service_provider_paykey,service_provider_cert,service_provider_certkey")->find();
            if(empty($result)){
                __error("站点信息错误");
            }
        }
        else if($type == 6){
            // 支付宝支付
            $result = Db::name("platform")->where(['id'=>UNIACID])->field("zfb_appid,zfb_privateKey,zfb_publickey_cert")->find();
            if(empty($result)){
                __error("站点信息错误");
            }
        }
        else if($type == 7){
            // 微信H5支付
            $result = Db::name("platform")->where(['id'=>UNIACID])->field("wap_AppId,wap_mch_id,wap_paykey,wap_cert,wap_certkey")->find();
            if(empty($result)){
                __error("站点信息错误");
            }
        }
        else if($type == 8){
            // 系统信息
            $result['os'] = php_uname(); // 服务器操作系统
            $result['server_software'] = $_SERVER['SERVER_SOFTWARE'];// 服务器环境
            $result['php_vesion'] = PHP_VERSION;// php版本
            $result['upload_max_filesize'] = @ini_get('file_uploads') ? ini_get('upload_max_filesize') : 'unknow';// 上传限制
            $result['gd_version'] = gd_info()[ 'GD Version' ];// GD（图形处理）版本
            $result['post_max_size'] = ini_get('post_max_size');// POST数据限制
            $result['max_file_uploads'] = ini_get('max_file_uploads');// 上传数量限制
            $result['max_execution_time'] = ini_get('max_execution_time'). "秒";// 最大执行时间
            $result['port'] = $_SERVER[ 'SERVER_PORT' ];// 端口
            $result['dns'] = $_SERVER[ 'HTTP_HOST' ]; // 服务器域名
            $result['memory_limit'] = ini_get('memory_limit');// 内存限制
            $result['ip'] = $_SERVER['SERVER_ADDR'];// 服务器IP
            $result['sockets'] = extension_loaded('sockets'); //是否支持sockets
            $result['openssl'] = extension_loaded('openssl'); //是否支持openssl
            $result['curl'] = function_exists('curl_init'); // 是否支持curl功能
            $result['fileinfo'] = extension_loaded('fileinfo'); //是否支持fileinfo
            $bbfx = Db::name("bbfx")->find();
            $result['name'] = "百变分销";
            $result['version_name'] = $bbfx['version_name'];
            $result['version'] = $bbfx['version'];
        }
        else if($type == 9){
            // 鸣谢
            $content = "";
            $result = ihttp_get("https://www.baibianfenxiao.com/api/article/mingxie");
            $result = toJsonde($result['content']);
            if($result['code'] == 1){
                $content = htmlspecialchars_decode($result['data']);
            }
            $result['content'] = $content;
        }
        else{
            __error("类型错误");
        }


        __success("操作成功",$result);
    }

    
    public function getRenewlog(){
        $renewlog = Upgrade::renewlog();

        if(empty($renewlog)){
            $renewlog = [];
        }

        __success("操作成功",['list'=>$renewlog]);
    }

    public function submit(){
        $type = $this->param("type/d");
        if($type == 2){
            $params = $this->param(['logo/s','login_bg/s','beian/s']);

            foreach($params as $key => $val){
                if($key == 'logo' || $key == 'login_bg'){
                    $val = replaceSiteroot($val);
                }
                Db::name("config")->where(['name'=>$key])->update(['value'=>$val]);
            }

            ConfigModel::refreshFile();
        }
        else if($type == 12){
            $password = $this->param("password/s");
            if(!empty($password)){
                if(!empty($password) && mb_strlen($password, 'UTF-8') < 6){
                    __error("密码长度不足，最低6位字符");
                }

                $salt = \fast\Random::alnum();
                $password = $this->auth->getEncryptPassword($password, $salt);

                Db::name("admin")->where(['id'=>$this->auth->id])->update(['salt'=>$salt,'password'=>$password]);
            }
        }
        else if($type == 3){
            $params = $this->param(['AppId/s','AppSecret/s']);
            Db::name("platform")->where(['id'=>UNIACID])->update($params);
        }
        else if($type == 10){
            $params = $this->param(['mch_id/s','paykey/s','cert/s','certkey/s','publickeyId/s']);
            $params['cert'] = cdnurl($params['cert']);
            $params['certkey'] = cdnurl($params['certkey']);
            Db::name("platform")->where(['id'=>UNIACID])->update($params);
        }
        else if($type == 4){
            $params = $this->param(['wxapp_AppId/s','wxapp_AppSecret/s','wxapp_upload_privateKey/s']);
            $params['wxapp_upload_privateKey'] = replaceSiteroot($params['wxapp_upload_privateKey']);
            Db::name("platform")->where(['id'=>UNIACID])->update($params);
        }
        else if($type == 11){
            $params = $this->param(['wxapp_mch_id/s','wxapp_paykey/s','wxapp_cert/s','wxapp_certkey/s','wxapp_publickeyId/s']);
            $params['wxapp_cert'] = cdnurl($params['wxapp_cert']);
            $params['wxapp_certkey'] = cdnurl($params['wxapp_certkey']);
            Db::name("platform")->where(['id'=>UNIACID])->update($params);
        }
        else if($type == 5){
            $params = $this->param(['service_provider_status/d','service_provider_appid/s','service_provider_mchid/s','mch_id/s','wxapp_mch_id/s','service_provider_paykey/s','service_provider_cert/s','service_provider_certkey/s']);
            $params['service_provider_cert'] = cdnurl($params['service_provider_cert']);
            $params['service_provider_certkey'] = cdnurl($params['service_provider_certkey']);
            Db::name("platform")->where(['id'=>UNIACID])->update($params);
        }
        else if($type == 6){
            $params = $this->param(['zfb_appid/d','zfb_privateKey/s','zfb_publickey_cert/s']);
            $params['zfb_publickey_cert'] = cdnurl($params['zfb_publickey_cert']);
            Db::name("platform")->where(['id'=>UNIACID])->update($params);
        }
        else if($type == 7){
            $params = $this->param(['wap_AppId/s','wap_mch_id/s','wap_paykey/s','wap_cert/s','wap_certkey/s']);
            $params['wap_cert'] = cdnurl($params['wap_cert']);
            $params['wap_certkey'] = cdnurl($params['wap_certkey']);
            Db::name("platform")->where(['id'=>UNIACID])->update($params);
        }
        else{
            __error("操作失败");
        }

        __success("操作成功");
    }


    public function xufei(){
        $code = $this->param("code/s");
        if(empty($code)){
            __error("请输入授权码");
        }
        
        $result = Upgrade::xufei($code);

        __result($result);
    }

    public function update(){
        Cache::set("is_download",false);
        $res = Upgrade::execute();
        if($res){
            __success("更新成功");
        }
        else{
            __error("更新失败");
        }
    }
    
    public function updateProgress(){
        $res = Upgrade::updateProgress();
        if($res['code'] == 1){
            __success("操作成功",$res['data']);
        }
        else{
            __error("操作失败");
        }
    }
    
    public function updatesql(){
        Upgrade::updateSql();
        __success("更新成功");
    }

    public function updateSuccessful(){
        Upgrade::updateSuccessful();
        $this->success("操作成功");
    }

    public function initupload(){
        
        unlink(ROOT_PATH."download/miniprogram-ci.zip");
        $filepath = download_file('https://baibian1.oss-cn-beijing.aliyuncs.com/miniprogram-ci.zip', ROOT_PATH."download/",'miniprogram-ci.zip');
        if(empty($filepath)){
            __error("加载失败");
        }

        $zip = new \ZipArchive();
        if(empty($zip->open($filepath))){
            unlink($filepath);
            __error("解压组件失败");
        }

        del_Dir(ROOT_PATH."extend/miniprogram-ci");
        
        $zip->extractTo(ROOT_PATH."extend/");
        $zip->close();
        
        unlink($filepath);

        __success("加载成功，请重新点击上传代码！");
    }

    public function uploadWxapp()
    {
        // 

        if (!file_exists('../extend/miniprogram-ci/node_modules/miniprogram-ci')) {
            __error(-2,"您还未加载上传小程序代码组件，是否加载？");
        }
        
        $result = $this->initWxappVersion();

        $platform = $result['platform'];
        $version_name = $result['version_name'];
         
        try {
            //校验是否已安装miniprogram-ci工具
            

            if (!function_exists('exec')) { 
                throw new \Exception('exec函数已被禁用，请先解除禁用。');
            }

            if(!file_exists(ROOT_PATH.'public'.$platform['wxapp_upload_privateKey'])){
                throw new \Exception('请先配置小程序代码上传密钥。');
            }

            exec('node -v', $output, $return_var);
            if ($return_var === 0) {
                // echo "Node.js is installed. Version: " . $output[0];
                
            } else {
                // echo "Node.js is not installed.";
                throw new \Exception("Node.js尚未安装。");
            }

            $privateKeyPath = "../public".$platform['wxapp_upload_privateKey'];
            
             
            //上传小程序代码
            $data = [
                'appid' => $platform['wxapp_AppId'],
                'privateKeyPath'=>$privateKeyPath,
                'version' => $version_name,
                'desc' => '',
            ];
            $json_data = json_encode($data);
            $command = 'node ../extend/miniprogram-ci/upload.js '.escapeshellarg($json_data).' 2>&1';
            $output=null;
            $retval = null;
            exec($command, $output, $retval);
            if ($retval) {
                $result = __json(0,$output);
            } else {
                $result = __json(1,"上传成功");
            }
 
        } catch (\Exception $e) {
            $result = __json(0,$e->getMessage());
        }
        
        __result($result);
    }
    
    // 下载小程序代码
    public function downloadWxapp(){
        
        $result = $this->initWxappVersion();
        
        $platform = $result['platform'];
        $version_name = $result['version_name'];
        
        $filepath = ROOT_PATH."public/wxapp/{$version_name}.zip";
        $zip_path = ROOT_PATH."public/wxapp/{$version_name}";
        
        $res = zipDirectory($zip_path,$filepath,$version_name);
        
        if($res['code'] != 1){
            __error($res['message']);
        }
        if(file_exists($filepath) && $file=fopen($filepath,"r")){
            Header("content-type:application/octet-stream");
            //声明文件类型，这里是为了让客户端下载它，而不是打开它，所以声明为未知二进制文件。否则客户端会根据其文件类型在线打开它。
            Header("content-Length:".filesize($filepath)); //声明文件的大小，告诉客户端这个文件的大小，否则客户端下载的时候看不到进度。
            Header("content-disposition:attachment;filename={$version_name}.zip");
            //声明文件名，这里就是告诉客户端它要下载的文件的名字，否则名字就会是你php文件的名字。
            echo fread($file,filesize($filepath)); 
            //这里就是将加载的文件echo出来，因此这个php文件不能出现其他任何的文字，就是说这里若是出现了任何其他的输出的话都会输出到客户端下载的文件里。
            fclose($file);
        }
        else{
            __error("操作失败");
        }
    }

    protected function initWxappVersion(){
        $version_name = Db::name("bbfx")->value("version_name");
        $admin = Db::name("admin")->where(['id'=>$this->auth->id])->find();
        if($admin['uniacid']){
            $platform = Db::name("platform")->where(['id'=>$admin['uniacid']])->find();
        }
        else{
            $platform = Db::name("platform")->where(['id'=>['>',0]])->order("id asc")->find();
        }
        $uniacid = $platform['id'];
        $domain = $_SERVER['HTTP_HOST'];
        if(empty($platform['wxapp_AppId'])){
            __error("未配置小程序APPID");
        }
        $site_name = Db::name("bbfx_base")->where(['uniacid'=>UNIACID])->value("title");
        
        $siteinfo = 'var siteinfo = {
	"uniacid": "'.$uniacid.'",
	"version": "'.$version_name.'",
	"siteroot": "https://'.$domain.'"
};
module.exports = siteinfo;   
        ';
        
        $res = file_put_contents(ROOT_PATH."public/wxapp/{$version_name}/siteinfo.js",$siteinfo);
        if(empty($res)){
            __error("操作失败");
        }

        $config = '{
  "description": "项目配置文件。",
  "packOptions": {
    "ignore": [],
    "include": []
  },
  "setting": {
    "urlCheck": false,
    "es6": false,
    "postcss": true,
    "minified": true,
    "newFeature": true,
    "bigPackageSizeSupport": true,
    "babelSetting": {
      "ignore": [],
      "disablePlugins": [],
      "outputPath": ""
    }
  },
  "compileType": "miniprogram",
  "libVersion": "3.2.5",
  "appid": "'.$platform['wxapp_AppId'].'",
  "projectname": "'.$site_name.'",
  "condition": {},
  "editorSetting": {
    "tabIndent": "insertSpaces",
    "tabSize": 2
  }
}';
        file_put_contents(ROOT_PATH."public/wxapp/{$version_name}/project.config.json",$config);

        // if(is_dir(ROOT_PATH."extend/miniprogram-ci/mp-weixin")){
        //     deleteDir(ROOT_PATH."extend/miniprogram-ci/mp-weixin");
        // }
        // copyDirectory(ROOT_PATH."public/wxapp/{$version_name}", ROOT_PATH."extend/miniprogram-ci/mp-weixin");

        return ['version_name'=>$version_name,'platform'=>$platform];
    }
}