<?php
/*
 本代码由 焕岱科技 创建
 技术支持 WX：15285007200
 严禁反编译、逆向等任何形式的侵权行为，违者将追究法律责任
*/

namespace app\admin\controller\bbfxshop;

use app\admin\controller\bbfxshop\Base;
use think\Db;
use think\Cache;

class Mode extends Base
{
    
    protected function getModeList(){
        $version = Db::name("bbfx")->value("version");
        $result = ihttp_get("http://www.baibianfenxiao.com/api/mode/getList?version=".$version);
        $result = json_decode($result['content'],true);
        $list = [];
        if($result['code'] == 1){
            $list = $result['data']['list'];
        }
        
        return $list;
    }
    public function getList(){
        $page = max(1,$this->param("page/d"));
        $limit = max(10,$this->param("limit/d"));
        
        $where = [];
        
        $list = $this->getModeList();
        
        foreach ($list as $key => &$val){
            $val['createtime'] = date("Y-m-d H:i:s",$val['createtime']);
        }
        unset($val);
        
        $total = Db::name("bbfx_diypage_template")->where($where)->count();
        $total = count($list);
        
        __success("操作成功",['list'=>$list,'total'=>$total]);
    }
    
    
    // 初始化模式
    public function initMode(){
        $id = $this->param("id/d");
        
        $result = ihttp_get("http://www.baibianfenxiao.com/api/mode/detail?id=".$id);
        $result = json_decode($result['content'],true);
        if($result['code'] == 1){
            $item = $result['data']['info'];
        }
        
        // $item = Db::name("bbfx_mode")->where(['id'=>$id])->find();
        if(empty($item)){
            __error("模式不存在");
        }
        
        $mode_urle = iunserializer($item['content']);
        if(empty($mode_urle)){
            __error("模式内容不存在");
        }
        
        foreach($mode_urle as $key => $val){
            if(!empty($val['table'])){
                Db::name($val['table'])->where(['uniacid'=>UNIACID])->delete();
                
                $table_data = $val['data'];
                foreach ($table_data as $k => &$v){
                    $v['uniacid'] = UNIACID;
                }
                unset($v);
                
                Db::name($val['table'])->insertAll($table_data);
            }
            
        }
        
        __success("操作成功");
    }
    
    public function addMode(){
        $content = [];
        $where = ['uniacid'=>UNIACID];
        $fields = "id,uniacid";
        
        // 三三复制
        $item = Db::name("bbfx_pyramid")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_pyramid','data'=>[$item]];
        
        // 超级卖货模式
        $item = Db::name("bbfx_super_maihuo")->where($where)->field($fields.",abonus_money",true)->find();
        $content[] = ['table'=>'bbfx_super_maihuo','data'=>[$item]];
        
        // 排行榜
        $item = Db::name("bbfx_paihangbang")->where($where)->field($fields.",reward_buy_money,reward_buy_ok,bg_image",true)->find();
        $content[] = ['table'=>'bbfx_paihangbang','data'=>[$item]];
        
        // 资金池
        $item = Db::name("bbfx_capitalpool")->where($where)->field($fields.",abonus_money,capital_settlement_finally_order",true)->find();
        $content[] = ['table'=>'bbfx_capitalpool','data'=>[$item]];
        
        // 提现分红
        $item = Db::name("bbfx_txabonus")->where($where)->field($fields.",team_subsidy",true)->find();
        $content[] = ['table'=>'bbfx_txabonus','data'=>[$item]];
        
        // 内缩平级奖
        $item = Db::name("bbfx_npingji")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_npingji','data'=>[$item]];
        
        // 超级人脉模式
        $item = Db::name("bbfx_sconnection")->where($where)->field($fields.",wu_apply_user,apply_upgrade_bg",true)->find();
        $content[] = ['table'=>'bbfx_sconnection','data'=>[$item]];
        
        // 疯狂卖货模式
        $item = Db::name("bbfx_crazy")->where($where)->field($fields.",repurchase_goods",true)->find();
        $content[] = ['table'=>'bbfx_crazy','data'=>[$item]];
        
        // 阶梯平级奖
        $item = Db::name("bbfx_ladderpingji")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_ladderpingji','data'=>[$item]];
        
        // 超越奖
        $item = Db::name("bbfx_chaoyue")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_chaoyue','data'=>[$item]];
        
        // 云仓商品
        $item = Db::name("bbfx_cloud_warehouse")->where($where)->field($fields.",cw_goods",true)->find();
        $content[] = ['table'=>'bbfx_cloud_warehouse','data'=>[$item]];
        
        // 累计返还
        $item = Db::name("bbfx_cumulative_fanhuan")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_cumulative_fanhuan','data'=>[$item]];
        
        // 双轨模式
        $item = Db::name("bbfx_double_track")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_double_track','data'=>[$item]];
        $items = Db::name("bbfx_double_track_level")->where($where)->field($fields,true)->select();
        $content[] = ['table'=>'bbfx_double_track_level','data'=>$items];
        
        // 区域代理
        $item = Db::name("bbfx_agent")->where($where)->field($fields.",xy_content",true)->find();
        $content[] = ['table'=>'bbfx_agent','data'=>[$item]];
        
        // 预存释放
        $item = Db::name("bbfx_deposit_release")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_deposit_release','data'=>[$item]];
        
        // 股份加权分红
        $item = Db::name("bbfx_sabonus")->where($where)->field($fields.",sdate,abonus_money",true)->find();
        $content[] = ['table'=>'bbfx_sabonus','data'=>[$item]];
        
        // 直推团队奖
        $item = Db::name("bbfx_directpush_team")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_directpush_team','data'=>[$item]];
        
        // 排队免单
        $item = Db::name("bbfx_queue_mode")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_queue_mode','data'=>[$item]];
        
        // 返还奖
        $item = Db::name("bbfx_return")->where($where)->field($fields.",return_date,oper_time,oper",true)->find();
        $content[] = ['table'=>'bbfx_return','data'=>[$item]];
        $items = Db::name("bbfx_return_rule")->where($where)->field($fields,true)->select();
        $content[] = ['table'=>'bbfx_return_rule','data'=>$items];
        
        // 常规加权分红
        $items = Db::name("bbfx_fenxiao_abonus_rule")->where($where)->field($fields,true)->select();
        $content[] = ['table'=>'bbfx_fenxiao_abonus_rule','data'=>$items];
        
        // 百变分销
        $item = Db::name("bbfx_fenxiao")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_fenxiao','data'=>[$item]];
        $items = Db::name("bbfx_fenxiao_level")->where($where)->field($fields,true)->select();
        $content[] = ['table'=>'bbfx_fenxiao_level','data'=>$items];
        
        // 押金
        $item = Db::name("bbfx_yajin")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_yajin','data'=>[$item]];

        // 贡献值
        $item = Db::name("bbfx_contribution")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_contribution','data'=>[$item]];

        // 复购见单模式
        $item = Db::name("bbfx_repurchase_jiandan")->where($where)->field($fields.",repurchase_goods",true)->find();
        $content[] = ['table'=>'bbfx_repurchase_jiandan','data'=>[$item]];
        
        $content = iserializer($content);
        
        __success("操作成功",['content'=>$content]);
    }
    
    public function detail(){
        $id = $this->param("id/d");
        $item = Db::name("bbfx_mode")->where(['id'=>$id])->find();
        if(empty($item)){
            __error("模式不存在");
        }
        
        $item['content'] = iunserializer($item['content']);
        
        __success("操作成功",['info'=>$item]);
    }
    
    public function post(){
        $params = $this->param(['name/s','sdesc/h','content/a','sort/d']);
        $id = $this->param("id/d");
        
        if(empty($params['name'])){
            __error("请输入模式名称");
        }
        if(empty($params['content'])){
            // __error("请设置模式内容");
        }
        
        $content = [];
        $where = ['uniacid'=>UNIACID];
        $fields = "id,uniacid";
        
        // 三三复制
        $item = Db::name("bbfx_pyramid")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_pyramid','data'=>[$item]];
        
        // 超级卖货模式
        $item = Db::name("bbfx_super_maihuo")->where($where)->field($fields.",abonus_money",true)->find();
        $content[] = ['table'=>'bbfx_super_maihuo','data'=>[$item]];
        
        // 排行榜
        $item = Db::name("bbfx_paihangbang")->where($where)->field($fields.",reward_buy_money,reward_buy_ok,bg_image",true)->find();
        $content[] = ['table'=>'bbfx_paihangbang','data'=>[$item]];
        
        // 资金池
        $item = Db::name("bbfx_capitalpool")->where($where)->field($fields.",abonus_money,capital_settlement_finally_order",true)->find();
        $content[] = ['table'=>'bbfx_capitalpool','data'=>[$item]];
        
        // 提现分红
        $item = Db::name("bbfx_txabonus")->where($where)->field($fields.",team_subsidy",true)->find();
        $content[] = ['table'=>'bbfx_txabonus','data'=>[$item]];
        
        // 内缩平级奖
        $item = Db::name("bbfx_npingji")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_npingji','data'=>[$item]];
        
        // 超级人脉模式
        $item = Db::name("bbfx_sconnection")->where($where)->field($fields.",wu_apply_user,apply_upgrade_bg",true)->find();
        $content[] = ['table'=>'bbfx_sconnection','data'=>[$item]];
        
        // 疯狂卖货模式
        $item = Db::name("bbfx_crazy")->where($where)->field($fields.",repurchase_goods",true)->find();
        $content[] = ['table'=>'bbfx_crazy','data'=>[$item]];
        
        // 阶梯平级奖
        $item = Db::name("bbfx_ladderpingji")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_ladderpingji','data'=>[$item]];
        
        // 超越奖
        $item = Db::name("bbfx_chaoyue")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_chaoyue','data'=>[$item]];
        
        // 云仓商品
        $item = Db::name("bbfx_cloud_warehouse")->where($where)->field($fields.",cw_goods",true)->find();
        $content[] = ['table'=>'bbfx_cloud_warehouse','data'=>[$item]];
        
        // 累计返还
        $item = Db::name("bbfx_cumulative_fanhuan")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_cumulative_fanhuan','data'=>[$item]];
        
        // 双轨模式
        $item = Db::name("bbfx_double_track")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_double_track','data'=>[$item]];
        $items = Db::name("bbfx_double_track_level")->where($where)->field($fields,true)->select();
        $content[] = ['table'=>'bbfx_double_track_level','data'=>$items];
        
        // 区域代理
        $item = Db::name("bbfx_agent")->where($where)->field($fields.",xy_content",true)->find();
        $content[] = ['table'=>'bbfx_agent','data'=>[$item]];
        
        // 预存释放
        $item = Db::name("bbfx_deposit_release")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_deposit_release','data'=>[$item]];
        
        // 股份加权分红
        $item = Db::name("bbfx_sabonus")->where($where)->field($fields.",sdate,abonus_money",true)->find();
        $content[] = ['table'=>'bbfx_sabonus','data'=>[$item]];
        
        // 直推团队奖
        $item = Db::name("bbfx_directpush_team")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_directpush_team','data'=>[$item]];
        
        // 排队免单
        $item = Db::name("bbfx_queue_mode")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_queue_mode','data'=>[$item]];
        
        // 返还奖
        $item = Db::name("bbfx_return")->where($where)->field($fields.",return_date,oper_time,oper",true)->find();
        $content[] = ['table'=>'bbfx_return','data'=>[$item]];
        $items = Db::name("bbfx_return_rule")->where($where)->field($fields,true)->select();
        $content[] = ['table'=>'bbfx_return_rule','data'=>$items];
        
        // 常规加权分红
        $items = Db::name("bbfx_fenxiao_abonus_rule")->where($where)->field($fields,true)->select();
        $content[] = ['table'=>'bbfx_fenxiao_abonus_rule','data'=>$items];
        
        // 百变分销
        $item = Db::name("bbfx_fenxiao")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_fenxiao','data'=>[$item]];
        $items = Db::name("bbfx_fenxiao_level")->where($where)->field($fields,true)->select();
        $content[] = ['table'=>'bbfx_fenxiao_level','data'=>$items];
        
        // 押金
        $item = Db::name("bbfx_yajin")->where($where)->field($fields,true)->find();
        $content[] = ['table'=>'bbfx_yajin','data'=>[$item]];
        
        $data = [
            "name"=>$params['name'],
            "sdesc"=>htmlspecialchars_decode($params['sdesc']),
            "content"=>iserializer($content),
            "sort"=>$params['sort']
        ];
        
        $item = Db::name("bbfx_mode")->where(['id'=>$id])->find();
        if(empty($item)){
            $data['createtime'] = time();
            Db::name("bbfx_mode")->insert($data);
        }
        else{
            unset($data['content']);
            Db::name("bbfx_mode")->where(['id'=>$item['id']])->update($data);
        }
        
        __success("操作成功");
    }
    
    public function delete(){
        $params = $this->param();
        $ids = $params['id'];
        if(empty($ids)){
            __error("请选择需要删除的数据");
        }
        
        $ids = explode(",",$ids);
        
        foreach ($ids as $key => &$val){
            $val = intval($val);
        }
        unset($val);
        
        
      	$res = Db::name("bbfx_mode")->where('id','in',$ids)->delete();
      	if($res){
        	__success("删除成功");
        }
    	else{
        	__success("操作成功");
        }
    }
}